/**
 * SECTION:manager
 * @short_description: Allows managing Listaller applications
 * 
 * <para>This class allows managing installed applications as well as performing maintainance tasks to keep applications running. It also allows fetching applications from remote sources.</para>
 */
/**
 * LISTALLER_TYPE_MANAGER:
 * 
 * The type for <link linkend="ListallerManager"><type>ListallerManager</type></link>.
 */
/**
 * listaller_manager_filter_applications:
 * @self: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance
 */
/**
 * listaller_manager_find_applications_by_values:
 * @self: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance
 * @filter: (in): Filter, which is applied on the results 
 * @values: (in) (array length=values_length1): Null-terminated list of strings to search for 
 * @values_length1: length of the @values array
 * @appList: (out): ArrayList of AppItems to store the result, or NULL (all applications are also emitted in the &quot;application&quot; signal) 
 * 
 * Find applications which match the strings in values
 */
/**
 * listaller_manager_get_applications_by_fullname:
 * @self: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance
 */
/**
 * listaller_manager_get_application_by_idname:
 * @self: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance
 */
/**
 * listaller_manager_remove_application:
 * @self: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance
 */
/**
 * listaller_manager_refresh_appitem_data:
 * @self: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance
 */
/**
 * listaller_manager_get_application_filelist_as_string:
 * @self: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance
 */
/**
 * listaller_manager_get_app_ld_environment:
 * @self: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance
 * @app: (in): AppItem belonging to an Listaller-installed app 
 * 
 * Get the LD_LIBRARY_PATH environment for an application.
 */
/**
 * listaller_manager_refresh_repository_cache:
 * @self: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance
 * 
 * Update the 3rd-party remote application cache. This will allow querying for new updates.
 * 
 * Returns: TRUE if refresh was successful. 
 */
/**
 * listaller_manager_prepare_setup_for_app:
 * @self: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance
 */
/**
 * listaller_manager_new:
 * @shared_mode: (in): Whether we are in shared mode or not. 
 * 
 * Create a new Listaller application manager
 */
/**
 * ListallerManager:settings:
 */
/**
 * listaller_manager_get_settings:
 * @self: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerManager--settings"><type>"settings"</type></link> property.
 * 
 * Returns: the value of the <link linkend="ListallerManager--settings"><type>"settings"</type></link> property
 */
/**
 * listaller_manager_set_settings:
 * @self: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerManager--settings"><type>"settings"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerManager--settings"><type>"settings"</type></link> property to @value.
 */
/**
 * ListallerManager::status-changed:
 * @manager: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance that received the signal
 * @status: 
 */
/**
 * ListallerManager::application:
 * @manager: the <link linkend="ListallerManager"><type>ListallerManager</type></link> instance that received the signal
 * @appid: 
 */
/**
 * ListallerManager:
 * 
 * Allows managing Listaller applications
 * 
 * <para>This class allows managing installed applications as well as performing maintainance tasks to keep applications running. It also allows fetching applications from remote sources.</para>
 */
/**
 * ListallerManagerClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="LISTALLER-TYPE-MANAGER:CAPS"><literal>LISTALLER_TYPE_MANAGER</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
