## $Id: rules.mk,v 1.71 2004/09/01 03:41:14 flacoste Exp $

## Copyright (C) 2000-2001 Stichting LogReport Foundation LogReport@LogReport.org
## 
##     This program is free software; you can redistribute it and/or modify
##     it under the terms of the GNU General Public License as published by
##     the Free Software Foundation; either version 2 of the License, or
##     (at your option) any later version.
## 
##     This program is distributed in the hope that it will be useful,
##     but WITHOUT ANY WARRANTY; without even the implied warranty of
##     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##     GNU General Public License for more details.
## 
##     You should have received a copy of the GNU General Public License
##     along with this program (see COPYING); if not, check with
##     http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
##     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

## jade's -E flag. default is 200, we don't want to scroll the first and most
## interesting error off our screen though.
MAX_JADE_ERRORS=10

## used in superservice/script/Makefile.am, via *_DATA
convertorsdir = $(libexecdir)/$(PACKAGE)/convertors
pluginsdir = $(sysconfdir)/$(PACKAGE)/plugins
schemadir = $(datadir)/$(PACKAGE)/schemas
templatesdir = $(datadir)/$(PACKAGE)/templates

XML_DCL=$(top_srcdir)/all/lib/xml/xml.dcl

## Old suffix rules are portable between GNU make 
## and non GNU make
SUFFIXES = .pod .1 .7 .pm .3pm .dbx .xml .dia .eps .in

## beware: the Config module has a .in suffix

.pm.3pm:
	$(PERL2MAN3PM_RULE)

.pod.1:
	$(PERL2MAN1_RULE)

.pod.7:
	$(PERL2MAN7_RULE)

.in.1:
	$(PERL2MAN1_RULE)

.dia.eps:
	$(DIA2EPS_RULE)

.dia.png:
	$(DIA2PNG_RULE)

##
## there are different "solutions" on how to create man files for perl modules,
## containing :: in the filename.
## take a look at gelfand:/usr/local/src/MailTools/MailTools-1.15/Makefile 's 
## manifypods target.
## or see Message-ID: <14876.5087.303743.313283@lemming.engeast.baynetworks.com>
## on the GNU help-make mailing list.
##
## we can't use $< here to indicate the dependency, since some makes (e.g.
## /usr/ccs/bin/make as shipped with sparc-sun-solaris2.7) don't grok that.
## duh.
##
## we can't use pod2man's --name: its not supported in Perl 5.00503's pod2man
## (seems to be a 5.8.0 thing)
##PERL2MAN_RULE = \
## 	name=`echo $? | perl -ne '$$_ =~ s/\.in$$//; $$_ =~ s/\.pod$$//; tr/a-z/A-Z/; print'`; pod2man --center="LogReport's Lire Documentation" --release='Lire $(VERSION)' --name="$$name" $? > $@
##
## we should run podchecker(1) too, once we require a more recent perl

PERL2MAN1_RULE = \
	$(POD2MAN) --section=1 --center="LogReport's Lire Documentation" --release='Lire $(VERSION)' $? $@

PERL2MAN3PM_RULE = \
	$(POD2MAN) --section=3pm --center="LogReport's Lire Documentation" --release='Lire $(VERSION)' $? $@

PERL2MAN7_RULE = \
	$(POD2MAN) --section=7 --center="LogReport's Lire Documentation" --release='Lire $(VERSION)' $? $@

XML2HTML_RULE = \
	mysrc=`cd $(srcdir) && pwd`; \
	mytop=`cd $(top_srcdir) && pwd`; \
	outdir=`dirname $@`; \
	src=$$mysrc/`basename $<`; \
	$(mkinstalldirs) $$outdir && \
	cd $$outdir && \
	rm -f *.htm* && \
	epss=`for i in $^; do echo $$i; done | grep '\.eps$$'`; \
	for i in $$epss; do \
	    png=`basename $$i .eps`.png; \
	    $(PERL) $(top_builddir)/all/script/lr_gsconvert --resize=576,576 pngalpha $$i $$png; \
	done; \
	XML_CATALOG_FILES=$$mytop/catalog.xml $(XSLTPROC) --nonet --param 'graphic.default.extension' '"png"' $(DBKXSLHTML) $$src

HTML2TXT_RULE = \
XML_CATALOG_FILES=$(top_srcdir)/catalog.xml $(XSLTPROC) --nonet $(DBKXSLHTMLNOCHUNK) $< > tmp.html && \
$(LYNX) -nolist -dump tmp.html > $@ && \
rm tmp.html

## we need to run pdfjadetex three times gets pagenumbers in toc right
XML2PDF_RULE = \
	base=`basename $@ .pdf`; \
	epss=`for i in $^; do echo $$i; done | grep '\.eps$$'`; \
	pdfs=""; \
	for i in $$epss; do \
	    pdf=`basename $$i .eps`.pdf; \
	    $(PERL) $(top_builddir)/all/script/lr_gsconvert --resize=396,396 pdfwrite $$i $$pdf; \
	    pdfs="$$pdfs $$pdf"; \
	done; \
	$(JADE) -E$(MAX_JADE_ERRORS) -t tex -d $(DBKDSSSLPRINT) $(XML_DCL) $< && \
	i=0; \
	while test $$i -lt 3; do \
	    if $(PDFJADETEX) -interaction=batchmode $$base.tex > /dev/null; \
	    then \
		if grep 'undefined references\| [Rr]erun' $$base.log > /dev/null; \
		then  :;  else break; fi; \
	    else \
		grep '^! ' $$base.log; \
		exit 1; \
	    fi; \
        i=`expr $$i + 1`; \
	done; \
	rm -f $$base.log $$base.out $$base.aux $$base.tex $$pdfs

DIA2EPS_RULE = \
	$(DIA) --nosplash -e $@ $<

DIA2PNG_RULE = \
	$(DIA) --nosplash -e $@ $<

PERLMODULES_INSTALL_RULE = \
	@for p in $(perlmodules) ; do \
	    f="`echo $$p | sed -e 's|^.*/lib/||'`" ; \
	    d="`echo $$f | sed -e 's|\(^.*\)/.*|\1|'`" ; \
	    if test ! -d $(DESTDIR)$(LR_PERL5LIBDIR)/$$d; then \
		$(mkinstalldirs) $(DESTDIR)$(LR_PERL5LIBDIR)/$$d ; \
	    fi ; \
	    echo " $(INSTALL_DATA) $$p $(DESTDIR)$(LR_PERL5LIBDIR)/$$f"; \
	    $(INSTALL_DATA) $$p $(DESTDIR)$(LR_PERL5LIBDIR)/$$f ; \
	done

PERLMODULES_UNINSTALL_RULE = \
	@for p in $(perlmodules); do \
	  f="`echo $$p | sed -e 's|^.*/lib/||'`"; \
	  echo " rm -f $(DESTDIR)$(LR_PERL5LIBDIR)/$$f"; \
	  rm -f $(DESTDIR)$(DESTDIR)$(LR_PERL5LIBDIR)/$$f; \
	done

## Make sure that the first rule is all
all: all-redirect

check-local: check-xml

# We have to work with the fact that xmllint doesn't
# give an error when validation fails. It exits with
# non-zero status only when the file isn't well-formed

# We have to test for either srcdir/$f or $f : lire.xml
# exists in . only.
#
check-xml: $(XML_FILES)
	@if test -z "$(XML_FILES)"; \
	then \
	    echo No XML files to validate; \
	else \
	    for f in $(XML_FILES); \
	    do \
		echo -n Checking $$f...; \
                test -f $(srcdir)/$$f && file=$(srcdir)/$$f || file=$$f; \
		SGML_CATALOG_FILES="$(top_builddir)/catalog:$(top_srcdir)/all/lib/xml/dtd/catalog" $(XMLLINT) --catalogs --noout --valid $$file 2> xmllint.error; \
		if test -s xmllint.error; \
		then \
		    echo failed; \
		    cat xmllint.error; \
		    rm -f xmllint.error; \
		    exit 1; \
		else \
		    echo ok; \
		    rm -f xmllint.error; \
		fi; \
	    done; \
	fi

