package tests::ChartTypesLinesTest;

use strict;

use base qw/Lire::Test::PluginTestCase/;

use Lire::ChartTypes::Lines;
use Lire::Config::Build qw/ac_info/;
use Lire::Config::ChartSpec;
use Lire::Config::ExecutableSpec;
use Lire::PluginManager;
use Lire::ReportParser::ReportBuilder;
use Lire::Utils qw/tempdir/;

use File::Basename qw/dirname/;
use IO::Scalar;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'cfg'}{'ploticus_path'} = 
      new Lire::Config::ExecutableSpec( 'name' => 'ploticus_path' )->instance( 'value' => ac_info( 'PLOTICUS' ) );
    $self->{'cfg'}{'lr_chart_font'} = '';
    $self->{'chart_cfg'} = new Lire::Config::ChartSpec( 'name' => 'chart' )->instance();

    return;
}

sub create_plugin {
    return new Lire::ChartTypes::Lines();
}

sub properties_spec_file {
    return dirname( __FILE__ ) . "/../Lire/ChartTypes/ct_lines.xml";
}

sub registration_file {
    return dirname( __FILE__ ) . "/../Lire/ChartTypes/ct_lines_init";
}

sub set_up_subreport {
    my $self = $_[0];

    my $parser = new Lire::ReportParser::ReportBuilder();
    my $report = $parser->parsefile( dirname( __FILE__ ) . "/data/test-sqlite.xml" );
    $self->{'subreport'} = $report->subreport_by_id( 'top-files.0' );
}

sub test_get_vars {
    my $self = $_[0];

    $self->set_up_subreport();
    $self->test_registration_file();
    my $info = $self->{'subreport'}->table_info();
    $info->set_variables_indices();
    $self->{'chart_cfg'}->get( 'type' )->set_plugin( 'lines' );
    my $lines = Lire::PluginManager->get_plugin( 'chart_type', 'lines' );

    $self->{'chart_cfg'}->get( 'case_var' )->set( 'file' );

    my $props = $self->{'chart_cfg'}->get( 'type' )->get_properties();
    $props->get( 'y' )->set( 'request_total' );
    $self->assert_deep_equals( [$info->column_info_by_name( 'request_total' )],
                               $lines->get_vars( $self->{'chart_cfg'} ) );
    $props->get( 'x' )->set( 'request_ratio' );
    $self->assert_deep_equals( [$info->column_info_by_name( 'request_ratio' ),
                                $info->column_info_by_name( 'request_total' )],
                               $lines->get_vars( $self->{'chart_cfg'}  ) );
    $props->get( 'y2' )->set( 'request_ratio' );
    $self->assert_deep_equals( [$info->column_info_by_name( 'request_ratio' ),
                                $info->column_info_by_name( 'request_total' ),
                                $info->column_info_by_name( 'request_ratio' )],
                               $lines->get_vars( $self->{'chart_cfg'} ) );
}

sub test_write_parameters {
    my $self = $_[0];

    $self->set_up_subreport();
    my $fh = new IO::Scalar();
    my $buf = $fh->sref();
    $self->test_registration_file();
    my $info = $self->{'subreport'}->table_info();
    $info->set_variables_indices();
    $self->{'chart_cfg'}->get( 'type' )->set_plugin( 'lines' );
    my $lines = Lire::PluginManager->get_plugin( 'chart_type', 'lines' );

    $self->{'chart_cfg'}->get( 'case_var' )->set( 'file' );

    my $props = $self->{'chart_cfg'}->get( 'type' )->get_properties();
    $props->get( 'y' )->set( 'request_total' );
    $lines->write_parameters( $self->{'chart_cfg'}, $fh );
    my @lines = split /\n/, $$buf;
    $self->assert_str_equals( '#set x = 1', $lines[0] );
    $self->assert_str_equals( '#set cats = yes', $lines[-4] );
    $self->assert_str_equals( '#set stubvert = yes', $lines[-3] );
    $self->assert_str_equals( '#set legend = max+0.1 max', $lines[-2] );
    $self->assert_str_equals( '#set y = 2', $lines[-1] );

    $$buf = '';
    $props->get( 'x' )->set( 'request_ratio' );
    $props->get( 'y2' )->set( 'request_ratio' );
    $props->get( 'numbers' )->set( 1 );
    $lines->write_parameters( $self->{'chart_cfg'}, $fh );
    @lines = split /\n/, $$buf;
    $self->assert_str_equals( '#set cats = no', $lines[-5] );
    $self->assert_str_equals( '#set x = 2', $lines[-4] );
    $self->assert_str_equals( '#set y = 3', $lines[-3] );
    $self->assert_str_equals( '#set y2 = 4', $lines[-2] );
    $self->assert_str_equals( '#set numbers = yes', $lines[-1] );
}

sub test_write_chart {
    my $self = $_[0];

    $self->set_up_subreport();
    my $keep = $ENV{'KEEP_CHART'} || 0;
    $self->test_registration_file();
    $self->{'chart_cfg'}->get( 'name' )->set( 'lines' );
    $self->{'chart_cfg'}->get( 'title' )->set( $self->{'subreport'}->title() );
    $self->{'chart_cfg'}->get( 'case_var' )->set( 'file' );
    $self->{'chart_cfg'}->get( 'type' )->set_plugin( 'lines' );

    my $props = $self->{'chart_cfg'}->get( 'type' )->get_properties();
    $props->get( 'y' )->set( 'request_total' );
    $props->get( 'numbers' )->set( 1 );

    my $lines = Lire::PluginManager->get_plugin( 'chart_type', 'lines' );
    my $dir = tempdir( $self->name() . '_XXXXXX', CLEANUP => !$keep );
    my $chart = $lines->write_chart( $self->{'chart_cfg'}, 
                                     $self->{'subreport'},
                                     'outputdir' => $dir, 'format' => 'png' );
    $self->assert( -f $chart ? 1 : 0, "file '$chart' not created" );
    warn( "\nChart written in: $chart\n"  )
      if $keep;
}


1;
