type token =
  | VAR of (string)
  | VARLPAR of (string)
  | VARLBRA of (string)
  | STRING of (string)
  | INT of (int)
  | FLOAT of (float)
  | BOOL of (bool)
  | TIME of (int option list)
  | INTERVAL of (int option list * int option list)
  | OGG
  | VORBIS
  | VORBIS_CBR
  | VORBIS_ABR
  | THEORA
  | DIRAC
  | SPEEX
  | WAV
  | AACPLUS
  | MP3
  | EXTERNAL
  | EOF
  | BEGIN
  | END
  | GETS
  | TILD
  | DEF of (Doc.item * (string*string) list)
  | IF
  | THEN
  | ELSE
  | ELSIF
  | LPAR
  | RPAR
  | COMMA
  | SEQ
  | SEQSEQ
  | COLON
  | LBRA
  | RBRA
  | LCUR
  | RCUR
  | FUN
  | YIELDS
  | BIN0 of (string)
  | BIN1 of (string)
  | BIN2 of (string)
  | BIN3 of (string)
  | TIMES
  | MINUS
  | NOT
  | REF
  | GET
  | SET
  | PP_IFDEF
  | PP_ENDIF
  | PP_ENDL
  | PP_DEF
  | PP_INCLUDE of (string)
  | PP_COMMENT of (string list)

val program :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Lang_values.term
val interactive :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Lang_values.term
