/****************************************************************************
** $Id: rawCW.C 1379 2006-03-17 08:20:40Z karstenm $
**
*****************************************************************************/

#include <qwidget.h>
#include <qscrollbar.h> 
#include <qpainter.h>
#include <qsplitter.h> 
#include <qfile.h> 
#include <qfiledialog.h> 
#include <qtoolbutton.h> 
#include <qbuttongroup.h>
#include <qpixmap.h>
#include <qmainwindow.h>
#include <qmessagebox.h>
#include <cmath>

#include "rawCW.h"
//#include "xpm/color01.xpm"

RawCW::RawCW( QWidget *parent, const char *name, prefs *pr, int i, float *wert1, int pi, float *powerwert, float *fitres, float *se, double trpre, int *length, float *model, const char *version, QStringList fname, float *conditions, float *Sess, int bline, float **evres, float **evresSE, int length_ER, int width_ER, int cnd )
  : QWidget( parent, name ), i_m(i), version_m(version), wertneu(wert1),powerwert_m(powerwert), pi_m(pi),trpre_m(trpre), model_m(model) , fitresneu(fitres) , Sess_m(Sess)
{
  topLayout = new QVBoxLayout( this, 0 );


  /* rawpaint window */
  //  QSplitter *split = new QSplitter( this );

  //model = new ModellG( split, "Model", i, wert1, length, maxorder, modelptr, betalength );
  rpaint = new RawPaint( this, "RawPaint", pr, i, wert1, pi, powerwert, fitres, se, trpre, length, model, fname, conditions, Sess, bline, evres, evresSE, length_ER, width_ER, cnd );

  //  QScrollBar *sb = new QScrollBar ( this, "scroll" );
  sb = new QScrollBar ( 0, 0, 0, 0, 0, Horizontal, this, "scroll" );
  //  sb->setOrientation ( Horizontal );
  
  topLayout->addWidget( rpaint, 100 );
  topLayout->addWidget( sb, 1 );

  connect( sb, SIGNAL(valueChanged(int)), rpaint, SLOT(position(int)) );
  connect( rpaint, SIGNAL(neuZoom(int)), this, SLOT(changeScroll(int)) );
}

RawCW::~RawCW()
{
  //free(wertneu);
}

void RawCW::changeScroll( int zoom ) 
{
  int zo=0;
  if (zoom==1) {
    sb->setValue( 0 );
    sb->setSteps ( 0, 0 );
    sb->setRange ( 0, 0 );
  }
  else {
    zo = zoom;
    //  sb->setValue(zoom);
    //fprintf(stderr,"z: %d\n",zo);
    sb->setSteps( 100, 100 );
    sb->setRange ( 0, (int)(0.6*sqrt((double)zo)*i_m ));
    //sb->setRange ( 0, 0.45*i_m );
  }
}

void RawCW::print()
{
  QMessageBox::warning( this, "Warning",
  "Printing of time series and trial averages not yet implemented.\nContact the Lipsia group if necessary.");
  return;
  printer = new QPrinter;
  printer->setPrintProgram("lpr");
  if ( printer->setup(this) ) {               // printer dialog
    
    QPainter p;
    p.begin( printer );                     // paint on printer
    //    p.setFont( e->font() );
    QFontMetrics fm = p.fontMetrics();
    //QPaintDeviceMetrics metrics( printer ); // need width/height of printer surface
    
    p.drawText( 0, 40, tr("printed by \"vlview %1\"").arg(version_m) );
    //p.drawText( 0, 40, "printed by \"vlview \"" );
    
    //p.drawText(10,100,"sorry, please wait for a future version of vlview!");
    //      p.drawPicture( rpaint->pic );
    p.drawPixmap( 0,60, rpaint->cpm );
    //p.drawPixmap(0, 60, bild1->pm);
    //p.drawPixmap(0+bild1->pm.width(), 60, bild2->pm);
    //p.drawPixmap(0+bild1->pm.width()+bild2->pm.width(), 60, bild3->pm);
    //p.drawText(0, 80+bild3->pm.height(), tr("patient: \"%1\"").arg(pat_m));
    //p.fillRect(0,60+bild1->pm.height(),bild1->pm.width()+bild2->pm.width(),bild3->pm.height()-bild1->pm.height(), QColor(0,0,0));
    
    p.end();                                // send job to printer
    //    statusBar()->message( "Printing completed", 2000 );
    
  } else {
    //statusBar()->message( "Printing aborted", 2000 );
  }
}

void RawCW::saveTimelineTC()
{
  saveTimeline(wertneu);
}

void RawCW::saveTimelineFR()
{
  saveTimeline(fitresneu);
}

void RawCW::saveTimeline(float *wertneu11)
{
  FILE *fp1=NULL;
  QString fn = QFileDialog::getSaveFileName( QString::null, "*.txt", this );
  if ( !fn.isEmpty() ) {
    fp1 = fopen(fn,"w");
    if (fp1 != NULL) {
      fprintf(fp1,"% Time course generated by Lipsia\n");
      fprintf(fp1,"% Raw data voxel: %1.0f %1.0f %1.0f\n",model_m[3],model_m[4],model_m[5]);
      //fprintf(fp1,"% Anatomical voxel: %1.0f %1.0f %1.0f\n",model_m[0],model_m[1],model_m[2]);
      fprintf(fp1,"% \n");
      fprintf(fp1,"% \n");
      //for (int k=0;k<i_m;k++) fprintf(fp1,"  %5d    %6.0f\n",k,wertneu11[k]);
      for (int k=0;k<i_m;k++) fprintf(fp1,"%6.0f\n",wertneu11[k]);
    }
    fclose(fp1);
  } else {
    // the user cancelled the dialog
  }
}

void RawCW::savePowerspectrumTC()
{
  savePowerspectrum(powerwert_m);
}

void RawCW::savePowerspectrumFR()
{
  savePowerspectrum(Sess_m);
}

void RawCW::savePowerspectrum(float *powerwert11)
{
  double seconds=0;
  FILE *fp1=NULL;
  QString fn = QFileDialog::getSaveFileName( QString::null, "*.txt", this );
  if ( !fn.isEmpty() ) {
    fp1 = fopen(fn,"w");
    if (fp1 != NULL) {
      fprintf(fp1,"% Power spectrum generated by Lipsia\n");
      fprintf(fp1,"% Raw data voxel: %1.0f %1.0f %1.0f\n",model_m[3],model_m[4],model_m[5]);
      fprintf(fp1,"% Anatomical voxel: %1.0f %1.0f %1.0f\n",model_m[0],model_m[1],model_m[2]);
      fprintf(fp1,"% \n");
      fprintf(fp1,"%    Hz            Sec           Value     \n");
      fprintf(fp1,"% \n");
      for (int k=1;k<pi_m;k++) {
	seconds = trpre_m*2*(double)pi_m/(double)k/(double)1000.0;
	fprintf(fp1,"   %2.3f  %12.3f  %12.3f\n",1/seconds,seconds,powerwert11[k]); 
      }
    }
    fclose(fp1);
  } else {
    // the user cancelled the dialog
  }
}

