/*
 * Copyright (C) ST-Ericsson SA 2010
 *
 * Author: Rabin Vincent <rabin.vincent@stericsson.com>
 * License terms: GNU General Public License (GPL) version 2
 */

#ifndef __MACH_IRQS_DB5500_H
#define __MACH_IRQS_DB5500_H

#define IRQ_DB5500_MTU0			(IRQ_SHPI_START + 4)
#define IRQ_DB5500_SPI2			(IRQ_SHPI_START + 6)
#define IRQ_DB5500_PMU0			(IRQ_SHPI_START + 7)
#define IRQ_DB5500_SPI0			(IRQ_SHPI_START + 8)
#define IRQ_DB5500_RTT			(IRQ_SHPI_START + 9)
#define IRQ_DB5500_PKA			(IRQ_SHPI_START + 10)
#define IRQ_DB5500_UART0		(IRQ_SHPI_START + 11)
#define IRQ_DB5500_I2C3			(IRQ_SHPI_START + 12)
#define IRQ_DB5500_L2CC			(IRQ_SHPI_START + 13)
#define IRQ_DB5500_MSP0			(IRQ_SHPI_START + 14)
#define IRQ_DB5500_CRYP1		(IRQ_SHPI_START + 15)
#define IRQ_DB5500_PMU1			(IRQ_SHPI_START + 16)
#define IRQ_DB5500_MTU1			(IRQ_SHPI_START + 17)
#define IRQ_DB5500_RTC			(IRQ_SHPI_START + 18)
#define IRQ_DB5500_UART1		(IRQ_SHPI_START + 19)
#define IRQ_DB5500_USB_WAKEUP		(IRQ_SHPI_START + 20)
#define IRQ_DB5500_I2C0			(IRQ_SHPI_START + 21)
#define IRQ_DB5500_I2C1			(IRQ_SHPI_START + 22)
#define IRQ_DB5500_USBOTG		(IRQ_SHPI_START + 23)
#define IRQ_DB5500_DMA_SECURE		(IRQ_SHPI_START + 24)
#define IRQ_DB5500_DMA			(IRQ_SHPI_START + 25)
#define IRQ_DB5500_UART2		(IRQ_SHPI_START + 26)
#define IRQ_DB5500_ICN_PMU1		(IRQ_SHPI_START + 27)
#define IRQ_DB5500_ICN_PMU2		(IRQ_SHPI_START + 28)
#define IRQ_DB5500_UART3		(IRQ_SHPI_START + 29)
#define IRQ_DB5500_SPI3			(IRQ_SHPI_START + 30)
#define IRQ_DB5500_SDMMC4		(IRQ_SHPI_START + 31)
#define IRQ_DB5500_IRRC			(IRQ_SHPI_START + 33)
#define IRQ_DB5500_IRDA_FT		(IRQ_SHPI_START + 34)
#define IRQ_DB5500_IRDA_SD		(IRQ_SHPI_START + 35)
#define IRQ_DB5500_IRDA_FI		(IRQ_SHPI_START + 36)
#define IRQ_DB5500_IRDA_FD		(IRQ_SHPI_START + 37)
#define IRQ_DB5500_FSMC_CODEREADY	(IRQ_SHPI_START + 38)
#define IRQ_DB5500_FSMC_NANDWAIT	(IRQ_SHPI_START + 39)
#define IRQ_DB5500_AB5500		(IRQ_SHPI_START + 40)
#define IRQ_DB5500_SDMMC2		(IRQ_SHPI_START + 41)
#define IRQ_DB5500_SIA			(IRQ_SHPI_START + 42)
#define IRQ_DB5500_SIA2			(IRQ_SHPI_START + 43)
#define IRQ_DB5500_HVA			(IRQ_SHPI_START + 44)
#define IRQ_DB5500_HVA2			(IRQ_SHPI_START + 45)
#define IRQ_DB5500_PRCMU0		(IRQ_SHPI_START + 46)
#define IRQ_DB5500_PRCMU1		(IRQ_SHPI_START + 47)
#define IRQ_DB5500_DISP			(IRQ_SHPI_START + 48)
#define IRQ_DB5500_SDMMC1		(IRQ_SHPI_START + 50)
#define IRQ_DB5500_MSP1			(IRQ_SHPI_START + 52)
#define IRQ_DB5500_KBD			(IRQ_SHPI_START + 53)
#define IRQ_DB5500_I2C2			(IRQ_SHPI_START + 55)
#define IRQ_DB5500_B2R2			(IRQ_SHPI_START + 56)
#define IRQ_DB5500_CRYP0		(IRQ_SHPI_START + 57)
#define IRQ_DB5500_SDMMC3		(IRQ_SHPI_START + 59)
#define IRQ_DB5500_SDMMC0		(IRQ_SHPI_START + 60)
#define IRQ_DB5500_HSEM			(IRQ_SHPI_START + 61)
#define IRQ_DB5500_SBAG			(IRQ_SHPI_START + 63)
#define IRQ_DB5500_MODEM		(IRQ_SHPI_START + 65)
#define IRQ_DB5500_SPI1			(IRQ_SHPI_START + 96)
#define IRQ_DB5500_MSP2			(IRQ_SHPI_START + 98)
#define IRQ_DB5500_SRPTIMER		(IRQ_SHPI_START + 101)
#define IRQ_DB5500_CTI0			(IRQ_SHPI_START + 108)
#define IRQ_DB5500_CTI1			(IRQ_SHPI_START + 109)
#define IRQ_DB5500_ICN_ERR		(IRQ_SHPI_START + 110)
#define IRQ_DB5500_MALI_PPMMU		(IRQ_SHPI_START + 112)
#define IRQ_DB5500_MALI_PP		(IRQ_SHPI_START + 113)
#define IRQ_DB5500_MALI_GPMMU		(IRQ_SHPI_START + 114)
#define IRQ_DB5500_MALI_GP		(IRQ_SHPI_START + 115)
#define IRQ_DB5500_MALI			(IRQ_SHPI_START + 116)
#define IRQ_DB5500_PRCMU_SEM		(IRQ_SHPI_START + 118)
#define IRQ_DB5500_GPIO0		(IRQ_SHPI_START + 119)
#define IRQ_DB5500_GPIO1		(IRQ_SHPI_START + 120)
#define IRQ_DB5500_GPIO2		(IRQ_SHPI_START + 121)
#define IRQ_DB5500_GPIO3		(IRQ_SHPI_START + 122)
#define IRQ_DB5500_GPIO4		(IRQ_SHPI_START + 123)
#define IRQ_DB5500_GPIO5		(IRQ_SHPI_START + 124)
#define IRQ_DB5500_GPIO6		(IRQ_SHPI_START + 125)
#define IRQ_DB5500_GPIO7		(IRQ_SHPI_START + 126)

#ifdef CONFIG_UX500_SOC_DB5500

/*
 * After the GPIO ones we reserve a range of IRQ:s in which virtual
 * IRQ:s representing modem IRQ:s can be allocated
 */
#define IRQ_MODEM_EVENTS_BASE	IRQ_SOC_START
#define IRQ_MODEM_EVENTS_NBR	72
#define IRQ_MODEM_EVENTS_END	(IRQ_MODEM_EVENTS_BASE + IRQ_MODEM_EVENTS_NBR)

/* List of virtual IRQ:s that are allocated from the range above */
#define MBOX_PAIR0_VIRT_IRQ	(IRQ_MODEM_EVENTS_BASE + 43)
#define MBOX_PAIR1_VIRT_IRQ	(IRQ_MODEM_EVENTS_BASE + 45)
#define MBOX_PAIR2_VIRT_IRQ	(IRQ_MODEM_EVENTS_BASE + 41)

/*
 * We may have several SoCs, but only one will run at a
 * time, so the one with most IRQs will bump this ahead,
 * but the IRQ_SOC_START remains the same for either SoC.
 */
#if IRQ_SOC_END < IRQ_MODEM_EVENTS_END
#undef IRQ_SOC_END
#define IRQ_SOC_END		IRQ_MODEM_EVENTS_END
#endif

#endif /* CONFIG_UX500_SOC_DB5500 */

#endif
