/* Copyright (c) 2011, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include "mt9d113.h"

struct mt9d113_i2c_reg_conf const
	pll_tbl_settings[] = {
		{0x0014, 0x21F9 }, /*PLL control: BYPASS PLL = 8697*/
		{0x0010, 0x0115 }, /*PLL Dividers = 277*/
		{0x0012, 0x0F5  }, /*PLL P Dividers = 245*/
		{0x0014, 0x21FB }, /*PLL control: PLL_ENABLE on = 8699*/
		{0x0014, 0x20FB }, /*PLL control: SEL_LOCK_DET on = 8443*/
};

struct mt9d113_i2c_reg_conf const
	register_wizard_settings[] = {
		{0x098C, 0x2719},
		{0x0990, 0x005A},
		{0x098C, 0x271B},
		{0x0990, 0x01BE},
		{0x098C, 0x271D},
		{0x0990, 0x0131},
		{0x098C, 0x271F},
		{0x0990, 0x02BB},
		{0x098C, 0x2721},
		{0x0990, 0x0888},
		{0x098C, 0x272F},
		{0x0990, 0x003A},
		{0x098C, 0x2731},
		{0x0990, 0x00F6},
		{0x098C, 0x2733},
		{0x0990, 0x008B},
		{0x098C, 0x2735},
		{0x0990, 0x0521},
		{0x098C, 0x2737},
		{0x0990, 0x0888},
		{0x098C, 0x275F},
		{0x0990, 0x0194},
		{0x098C, 0x2761},
		{0x0990, 0x0014},
		{0x098C, 0xA765},
		{0x0990, 0x0044},
		{0x098C, 0xA24F},
		{0x0990, 0x0028},
		{0x098C, 0xA20E},
		{0x0990, 0x00A0},
		{0x098C, 0xA20C},
		{0x0990, 0x000E},
		{0x098C, 0x2222},
		{0x0990, 0x00A0},
		{0x098C, 0x2212},
		{0x0990, 0x01EE},
		{0x098C, 0xA408},
		{0x0990, 0x0026},
		{0x098C, 0xA409},
		{0x0990, 0x0029},
		{0x098C, 0xA40A},
		{0x0990, 0x002E},
		{0x098C, 0xA40B},
		{0x0990, 0x0031},
		{0x098C, 0x2411},
		{0x0990, 0x00A0},
		{0x098C, 0x2413},
		{0x0990, 0x00C0},
		{0x098C, 0x2415},
		{0x0990, 0x00A0},
		{0x098C, 0x2417},
		{0x0990, 0x00C0},
};

struct mt9d113_i2c_reg_conf const
	err_settings[] = {
		{0x3084, 0x240C},
		{0x3092, 0x0A4C},
		{0x3094, 0x4C4C},
		{0x3096, 0x4C54},
};

struct mt9d113_i2c_reg_conf const
	patch_settings[] = {
		{0x098C, 0x0415},    /* MCU_ADDRESS*/
		{0x0990, 0xF601},
		{0x0992, 0x42C1},
		{0x0994, 0x0326},
		{0x0996, 0x11F6},
		{0x0998, 0x0143},
		{0x099A, 0xC104},
		{0x099C, 0x260A},
		{0x099E, 0xCC04},
		{0x098C, 0x0425},
		{0x0990, 0x33BD},
		{0x0992, 0xA362},
		{0x0994, 0xBD04},
		{0x0996, 0x3339},
		{0x0998, 0xC6FF},
		{0x099A, 0xF701},
		{0x099C, 0x6439},
		{0x099E, 0xFE01},
		{0x098C, 0x0435},
		{0x0990, 0x6918},
		{0x0992, 0xCE03},
		{0x0994, 0x25CC},
		{0x0996, 0x0013},
		{0x0998, 0xBDC2},
		{0x099A, 0xB8CC},
		{0x099C, 0x0489},
		{0x099E, 0xFD03},
		{0x098C, 0x0445},
		{0x0990, 0x27CC},
		{0x0992, 0x0325},
		{0x0994, 0xFD01},
		{0x0996, 0x69FE},
		{0x0998, 0x02BD},
		{0x099A, 0x18CE},
		{0x099C, 0x0339},
		{0x099E, 0xCC00},
		{0x098C, 0x0455},
		{0x0990, 0x11BD},
		{0x0992, 0xC2B8},
		{0x0994, 0xCC04},
		{0x0996, 0xC8FD},
		{0x0998, 0x0347},
		{0x099A, 0xCC03},
		{0x099C, 0x39FD},
		{0x099E, 0x02BD},
		{0x098C, 0x0465},
		{0x0990, 0xDE00},
		{0x0992, 0x18CE},
		{0x0994, 0x00C2},
		{0x0996, 0xCC00},
		{0x0998, 0x37BD},
		{0x099A, 0xC2B8},
		{0x099C, 0xCC04},
		{0x099E, 0xEFDD},
		{0x098C, 0x0475},
		{0x0990, 0xE6CC},
		{0x0992, 0x00C2},
		{0x0994, 0xDD00},
		{0x0996, 0xC601},
		{0x0998, 0xF701},
		{0x099A, 0x64C6},
		{0x099C, 0x03F7},
		{0x099E, 0x0165},
		{0x098C, 0x0485},
		{0x0990, 0x7F01},
		{0x0992, 0x6639},
		{0x0994, 0x3C3C},
		{0x0996, 0x3C34},
		{0x0998, 0xCC32},
		{0x099A, 0x3EBD},
		{0x099C, 0xA558},
		{0x099E, 0x30ED},
		{0x098C, 0x0495},
		{0x0990, 0x04BD},
		{0x0992, 0xB2D7},
		{0x0994, 0x30E7},
		{0x0996, 0x06CC},
		{0x0998, 0x323E},
		{0x099A, 0xED00},
		{0x099C, 0xEC04},
		{0x099E, 0xBDA5},
		{0x098C, 0x04A5},
		{0x0990, 0x44CC},
		{0x0992, 0x3244},
		{0x0994, 0xBDA5},
		{0x0996, 0x585F},
		{0x0998, 0x30ED},
		{0x099A, 0x02CC},
		{0x099C, 0x3244},
		{0x099E, 0xED00},
		{0x098C, 0x04B5},
		{0x0990, 0xF601},
		{0x0992, 0xD54F},
		{0x0994, 0xEA03},
		{0x0996, 0xAA02},
		{0x0998, 0xBDA5},
		{0x099A, 0x4430},
		{0x099C, 0xE606},
		{0x099E, 0x3838},
		{0x098C, 0x04C5},
		{0x0990, 0x3831},
		{0x0992, 0x39BD},
		{0x0994, 0xD661},
		{0x0996, 0xF602},
		{0x0998, 0xF4C1},
		{0x099A, 0x0126},
		{0x099C, 0x0BFE},
		{0x099E, 0x02BD},
		{0x098C, 0x04D5},
		{0x0990, 0xEE10},
		{0x0992, 0xFC02},
		{0x0994, 0xF5AD},
		{0x0996, 0x0039},
		{0x0998, 0xF602},
		{0x099A, 0xF4C1},
		{0x099C, 0x0226},
		{0x099E, 0x0AFE},
		{0x098C, 0x04E5},
		{0x0990, 0x02BD},
		{0x0992, 0xEE10},
		{0x0994, 0xFC02},
		{0x0996, 0xF7AD},
		{0x0998, 0x0039},
		{0x099A, 0x3CBD},
		{0x099C, 0xB059},
		{0x099E, 0xCC00},
		{0x098C, 0x04F5},
		{0x0990, 0x28BD},
		{0x0992, 0xA558},
		{0x0994, 0x8300},
		{0x0996, 0x0027},
		{0x0998, 0x0BCC},
		{0x099A, 0x0026},
		{0x099C, 0x30ED},
		{0x099E, 0x00C6},
		{0x098C, 0x0505},
		{0x0990, 0x03BD},
		{0x0992, 0xA544},
		{0x0994, 0x3839},
		{0x098C, 0x2006},
		{0x0990, 0x0415},
		{0x098C, 0xA005},
		{0x0990, 0x0001},
};

struct mt9d113_i2c_reg_conf const
	eeprom_settings[] = {
		{0x3658, 0x0110},
		{0x365A, 0x1B6D},
		{0x365C, 0x01F2},
		{0x365E, 0xFBCD},
		{0x3660, 0x8C91},
		{0x3680, 0xB9ED},
		{0x3682, 0x0EE},
		{0x3684, 0x256F},
		{0x3686, 0x824F},
		{0x3688, 0xD293},
		{0x36A8, 0x5BF2},
		{0x36AA, 0x1711},
		{0x36AC, 0xA095},
		{0x36AE, 0x642C},
		{0x36B0, 0x0E38},
		{0x36D0, 0x88B0},
		{0x36D2, 0x2EB2},
		{0x36D4, 0x4C74},
		{0x36D6, 0x9F96},
		{0x36D8, 0x9557},
		{0x36F8, 0xCE51},
		{0x36FA, 0xB354},
		{0x36FC, 0x2817},
		{0x36FE, 0x14B8},
		{0x3700, 0xB019},
		{0x364E, 0x0710},
		{0x3650, 0x30ED},
		{0x3652, 0x03F2},
		{0x3654, 0xF12E},
		{0x3656, 0x8492},
		{0x3676, 0xD9AD},
		{0x3678, 0x88D0},
		{0x367A, 0x7DED},
		{0x367C, 0x3E31},
		{0x367E, 0x91B3},
		{0x369E, 0x7032},
		{0x36A0, 0x2791},
		{0x36A2, 0xBB55},
		{0x36A4, 0xAB32},
		{0x36A6, 0x1A58},
		{0x36C6, 0xB50F},
		{0x36C8, 0x0011},
		{0x36CA, 0x6DB4},
		{0x36CC, 0x96F5},
		{0x36CE, 0x9BB7},
		{0x36EE, 0x9353},
		{0x36F0, 0xDF74},
		{0x36F2, 0x04F8},
		{0x36F4, 0x0FD8},
		{0x36F6, 0xA87A},
		{0x3662, 0x0170},
		{0x3664, 0x6F0C},
		{0x3666, 0x0112},
		{0x3668, 0xCBAB},
		{0x366A, 0x9111},
		{0x368A, 0xB38D},
		{0x368C, 0xE96F},
		{0x368E, 0xCC0F},
		{0x3690, 0x5851},
		{0x3692, 0xFDD2},
		{0x36B2, 0x5F92},
		{0x36B4, 0x33B2},
		{0x36B6, 0x9815},
		{0x36B8, 0x86F5},
		{0x36BA, 0x0578},
		{0x36DA, 0xCD90},
		{0x36DC, 0x1131},
		{0x36DE, 0x5275},
		{0x36E0, 0xE855},
		{0x36E2, 0xD037},
		{0x3702, 0xAAD1},
		{0x3704, 0xEB75},
		{0x3706, 0x0CD7},
		{0x3708, 0x2C79},
		{0x370A, 0xE0B9},
		{0x366C, 0x0190},
		{0x366E, 0x1C8D},
		{0x3670, 0x0052},
		{0x3672, 0xD66E},
		{0x3674, 0xF511},
		{0x3694, 0xB54D},
		{0x3696, 0x6E4E},
		{0x3698, 0x142E},
		{0x369A, 0xC190},
		{0x369C, 0xA753},
		{0x36BC, 0x70F2},
		{0x36BE, 0x04F1},
		{0x36C0, 0xBD95},
		{0x36C2, 0x0CEE},
		{0x36C4, 0x1BF8},
		{0x36E4, 0x806F},
		{0x36E6, 0x1672},
		{0x36E8, 0x2DF4},
		{0x36EA, 0x8F16},
		{0x36EC, 0xF776},
		{0x370C, 0xAD73},
		{0x370E, 0xB534},
		{0x3710, 0x0D18},
		{0x3712, 0x6057},
		{0x3714, 0xBD1A},
		{0x3644, 0x0354},
		{0x3642, 0x0234},
		{0x3210, 0x01B8},
};

struct mt9d113_i2c_reg_conf const
	awb_settings[] = {
		{0x098C, 0x2306},
		{0x0990, 0x0180},
		{0x098C, 0x2308},
		{0x0990, 0xFF00},
		{0x098C, 0x230A},
		{0x0990, 0x0080},
		{0x098C, 0x230C},
		{0x0990, 0xFF66},
		{0x098C, 0x230E},
		{0x0990, 0x0180},
		{0x098C, 0x2310},
		{0x0990, 0xFFEE},
		{0x098C, 0x2312},
		{0x0990, 0xFFCD},
		{0x098C, 0x2314},
		{0x0990, 0xFECD},
		{0x098C, 0x2316},
		{0x0990, 0x019A},
		{0x098C, 0x2318},
		{0x0990, 0x0020},
		{0x098C, 0x231A},
		{0x0990, 0x0033},
		{0x098C, 0x231C},
		{0x0990, 0x0100},
		{0x098C, 0x231E},
		{0x0990, 0xFF9A},
		{0x098C, 0x2320},
		{0x0990, 0x0000},
		{0x098C, 0x2322},
		{0x0990, 0x004D},
		{0x098C, 0x2324},
		{0x0990, 0xFFCD},
		{0x098C, 0x2326},
		{0x0990, 0xFFB8},
		{0x098C, 0x2328},
		{0x0990, 0x004D},
		{0x098C, 0x232A},
		{0x0990, 0x0080},
		{0x098C, 0x232C},
		{0x0990, 0xFF66},
		{0x098C, 0x232E},
		{0x0990, 0x0008},
		{0x098C, 0x2330},
		{0x0990, 0xFFF7},
		{0x098C, 0xA363},
		{0x0990, 0x00D2},
		{0x098C, 0xA364},
		{0x0990, 0x00EE},
		{0x3244, 0x0328},
		{0x323E, 0xC22C},
};

struct mt9d113_i2c_reg_conf const
	low_light_setting[] = {
		{0x098C, 0x2B28},
		{0x0990, 0x35E8},
		{0x098C, 0x2B2A},
		{0x0990, 0xB3B0},
		{0x098C, 0xAB20},
		{0x0990, 0x004B},
		{0x098C, 0xAB24},
		{0x0990, 0x0000},
		{0x098C, 0xAB25},
		{0x0990, 0x00FF},
		{0x098C, 0xAB30},
		{0x0990, 0x00FF},
		{0x098C, 0xAB31},
		{0x0990, 0x00FF},
		{0x098C, 0xAB32},
		{0x0990, 0x00FF},
		{0x098C, 0xAB33},
		{0x0990, 0x0057},
		{0x098C, 0xAB34},
		{0x0990, 0x0080},
		{0x098C, 0xAB35},
		{0x0990, 0x00FF},
		{0x098C, 0xAB36},
		{0x0990, 0x0014},
		{0x098C, 0xAB37},
		{0x0990, 0x0003},
		{0x098C, 0x2B38},
		{0x0990, 0x32C8},
		{0x098C, 0x2B3A},
		{0x0990, 0x7918},
		{0x098C, 0x2B62},
		{0x0990, 0xFFFE},
		{0x098C, 0x2B64},
		{0x0990, 0xFFFF},
};

struct mt9d113_reg mt9d113_regs = {
		.pll_tbl = pll_tbl_settings,
		.pll_tbl_size = ARRAY_SIZE(
			pll_tbl_settings),
		.register_tbl = register_wizard_settings,
		.register_tbl_size = ARRAY_SIZE(
			register_wizard_settings),
		.err_tbl = err_settings,
		.err_tbl_size = ARRAY_SIZE(err_settings),
		.low_light_tbl = low_light_setting,
		.low_light_tbl_size = ARRAY_SIZE(low_light_setting),
		.awb_tbl = awb_settings,
		.awb_tbl_size = ARRAY_SIZE(awb_settings),
		.patch_tbl = patch_settings,
		.patch_tbl_size = ARRAY_SIZE(patch_settings),
		.eeprom_tbl = eeprom_settings,
		.eeprom_tbl_size = ARRAY_SIZE(eeprom_settings),
};



