/*
 * Copyright (C) 2009 Nokia
 * Copyright (C) 2009 Texas Instruments
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/module.h>
#include <linux/init.h>

#include "mux.h"

#ifdef CONFIG_OMAP_MUX

#define _OMAP3_MUXENTRY(M0, g, m0, m1, m2, m3, m4, m5, m6, m7)		\
{									\
	.reg_offset	= (OMAP3_CONTROL_PADCONF_##M0##_OFFSET),	\
	.gpio		= (g),						\
	.muxnames	= { m0, m1, m2, m3, m4, m5, m6, m7 },		\
}

#else

#define _OMAP3_MUXENTRY(M0, g, m0, m1, m2, m3, m4, m5, m6, m7)		\
{									\
	.reg_offset	= (OMAP3_CONTROL_PADCONF_##M0##_OFFSET),	\
	.gpio		= (g),						\
}

#endif

#define _OMAP3_BALLENTRY(M0, bb, bt)					\
{									\
	.reg_offset	= (OMAP3_CONTROL_PADCONF_##M0##_OFFSET),	\
	.balls		= { bb, bt },					\
}

/*
 * Superset of all mux modes for omap3
 */
static struct omap_mux __initdata omap3_muxmodes[] = {
	_OMAP3_MUXENTRY(CAM_D0, 99,
		"cam_d0", NULL, NULL, NULL,
		"gpio_99", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D1, 100,
		"cam_d1", NULL, NULL, NULL,
		"gpio_100", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D10, 109,
		"cam_d10", NULL, NULL, NULL,
		"gpio_109", "hw_dbg8", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D11, 110,
		"cam_d11", NULL, NULL, NULL,
		"gpio_110", "hw_dbg9", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D2, 101,
		"cam_d2", NULL, NULL, NULL,
		"gpio_101", "hw_dbg4", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D3, 102,
		"cam_d3", NULL, NULL, NULL,
		"gpio_102", "hw_dbg5", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D4, 103,
		"cam_d4", NULL, NULL, NULL,
		"gpio_103", "hw_dbg6", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D5, 104,
		"cam_d5", NULL, NULL, NULL,
		"gpio_104", "hw_dbg7", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D6, 105,
		"cam_d6", NULL, NULL, NULL,
		"gpio_105", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D7, 106,
		"cam_d7", NULL, NULL, NULL,
		"gpio_106", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D8, 107,
		"cam_d8", NULL, NULL, NULL,
		"gpio_107", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D9, 108,
		"cam_d9", NULL, NULL, NULL,
		"gpio_108", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_FLD, 98,
		"cam_fld", NULL, "cam_global_reset", NULL,
		"gpio_98", "hw_dbg3", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_HS, 94,
		"cam_hs", NULL, NULL, NULL,
		"gpio_94", "hw_dbg0", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_PCLK, 97,
		"cam_pclk", NULL, NULL, NULL,
		"gpio_97", "hw_dbg2", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_STROBE, 126,
		"cam_strobe", NULL, NULL, NULL,
		"gpio_126", "hw_dbg11", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_VS, 95,
		"cam_vs", NULL, NULL, NULL,
		"gpio_95", "hw_dbg1", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_WEN, 167,
		"cam_wen", NULL, "cam_shutter", NULL,
		"gpio_167", "hw_dbg10", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_XCLKA, 96,
		"cam_xclka", NULL, NULL, NULL,
		"gpio_96", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_XCLKB, 111,
		"cam_xclkb", NULL, NULL, NULL,
		"gpio_111", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CSI2_DX0, 112,
		"csi2_dx0", NULL, NULL, NULL,
		"gpio_112", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CSI2_DX1, 114,
		"csi2_dx1", NULL, NULL, NULL,
		"gpio_114", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CSI2_DY0, 113,
		"csi2_dy0", NULL, NULL, NULL,
		"gpio_113", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CSI2_DY1, 115,
		"csi2_dy1", NULL, NULL, NULL,
		"gpio_115", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_ACBIAS, 69,
		"dss_acbias", NULL, NULL, NULL,
		"gpio_69", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA0, 70,
		"dss_data0", NULL, "uart1_cts", NULL,
		"gpio_70", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA1, 71,
		"dss_data1", NULL, "uart1_rts", NULL,
		"gpio_71", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA10, 80,
		"dss_data10", NULL, NULL, NULL,
		"gpio_80", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA11, 81,
		"dss_data11", NULL, NULL, NULL,
		"gpio_81", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA12, 82,
		"dss_data12", NULL, NULL, NULL,
		"gpio_82", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA13, 83,
		"dss_data13", NULL, NULL, NULL,
		"gpio_83", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA14, 84,
		"dss_data14", NULL, NULL, NULL,
		"gpio_84", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA15, 85,
		"dss_data15", NULL, NULL, NULL,
		"gpio_85", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA16, 86,
		"dss_data16", NULL, NULL, NULL,
		"gpio_86", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA17, 87,
		"dss_data17", NULL, NULL, NULL,
		"gpio_87", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA18, 88,
		"dss_data18", NULL, "mcspi3_clk", "dss_data0",
		"gpio_88", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA19, 89,
		"dss_data19", NULL, "mcspi3_simo", "dss_data1",
		"gpio_89", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA20, 90,
		"dss_data20", NULL, "mcspi3_somi", "dss_data2",
		"gpio_90", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA21, 91,
		"dss_data21", NULL, "mcspi3_cs0", "dss_data3",
		"gpio_91", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA22, 92,
		"dss_data22", NULL, "mcspi3_cs1", "dss_data4",
		"gpio_92", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA23, 93,
		"dss_data23", NULL, NULL, "dss_data5",
		"gpio_93", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA2, 72,
		"dss_data2", NULL, NULL, NULL,
		"gpio_72", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA3, 73,
		"dss_data3", NULL, NULL, NULL,
		"gpio_73", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA4, 74,
		"dss_data4", NULL, "uart3_rx_irrx", NULL,
		"gpio_74", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA5, 75,
		"dss_data5", NULL, "uart3_tx_irtx", NULL,
		"gpio_75", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA6, 76,
		"dss_data6", NULL, "uart1_tx", NULL,
		"gpio_76", "hw_dbg14", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA7, 77,
		"dss_data7", NULL, "uart1_rx", NULL,
		"gpio_77", "hw_dbg15", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA8, 78,
		"dss_data8", NULL, NULL, NULL,
		"gpio_78", "hw_dbg16", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA9, 79,
		"dss_data9", NULL, NULL, NULL,
		"gpio_79", "hw_dbg17", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_HSYNC, 67,
		"dss_hsync", NULL, NULL, NULL,
		"gpio_67", "hw_dbg13", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_PCLK, 66,
		"dss_pclk", NULL, NULL, NULL,
		"gpio_66", "hw_dbg12", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_VSYNC, 68,
		"dss_vsync", NULL, NULL, NULL,
		"gpio_68", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(ETK_CLK, 12,
		"etk_clk", "mcbsp5_clkx", "sdmmc3_clk", "hsusb1_stp",
		"gpio_12", "mm1_rxdp", "hsusb1_tll_stp", "hw_dbg0"),
	_OMAP3_MUXENTRY(ETK_CTL, 13,
		"etk_ctl", NULL, "sdmmc3_cmd", "hsusb1_clk",
		"gpio_13", NULL, "hsusb1_tll_clk", "hw_dbg1"),
	_OMAP3_MUXENTRY(ETK_D0, 14,
		"etk_d0", "mcspi3_simo", "sdmmc3_dat4", "hsusb1_data0",
		"gpio_14", "mm1_rxrcv", "hsusb1_tll_data0", "hw_dbg2"),
	_OMAP3_MUXENTRY(ETK_D1, 15,
		"etk_d1", "mcspi3_somi", NULL, "hsusb1_data1",
		"gpio_15", "mm1_txse0", "hsusb1_tll_data1", "hw_dbg3"),
	_OMAP3_MUXENTRY(ETK_D10, 24,
		"etk_d10", NULL, "uart1_rx", "hsusb2_clk",
		"gpio_24", NULL, "hsusb2_tll_clk", "hw_dbg12"),
	_OMAP3_MUXENTRY(ETK_D11, 25,
		"etk_d11", NULL, NULL, "hsusb2_stp",
		"gpio_25", "mm2_rxdp", "hsusb2_tll_stp", "hw_dbg13"),
	_OMAP3_MUXENTRY(ETK_D12, 26,
		"etk_d12", NULL, NULL, "hsusb2_dir",
		"gpio_26", NULL, "hsusb2_tll_dir", "hw_dbg14"),
	_OMAP3_MUXENTRY(ETK_D13, 27,
		"etk_d13", NULL, NULL, "hsusb2_nxt",
		"gpio_27", "mm2_rxdm", "hsusb2_tll_nxt", "hw_dbg15"),
	_OMAP3_MUXENTRY(ETK_D14, 28,
		"etk_d14", NULL, NULL, "hsusb2_data0",
		"gpio_28", "mm2_rxrcv", "hsusb2_tll_data0", "hw_dbg16"),
	_OMAP3_MUXENTRY(ETK_D15, 29,
		"etk_d15", NULL, NULL, "hsusb2_data1",
		"gpio_29", "mm2_txse0", "hsusb2_tll_data1", "hw_dbg17"),
	_OMAP3_MUXENTRY(ETK_D2, 16,
		"etk_d2", "mcspi3_cs0", NULL, "hsusb1_data2",
		"gpio_16", "mm1_txdat", "hsusb1_tll_data2", "hw_dbg4"),
	_OMAP3_MUXENTRY(ETK_D3, 17,
		"etk_d3", "mcspi3_clk", "sdmmc3_dat3", "hsusb1_data7",
		"gpio_17", NULL, "hsusb1_tll_data7", "hw_dbg5"),
	_OMAP3_MUXENTRY(ETK_D4, 18,
		"etk_d4", "mcbsp5_dr", "sdmmc3_dat0", "hsusb1_data4",
		"gpio_18", NULL, "hsusb1_tll_data4", "hw_dbg6"),
	_OMAP3_MUXENTRY(ETK_D5, 19,
		"etk_d5", "mcbsp5_fsx", "sdmmc3_dat1", "hsusb1_data5",
		"gpio_19", NULL, "hsusb1_tll_data5", "hw_dbg7"),
	_OMAP3_MUXENTRY(ETK_D6, 20,
		"etk_d6", "mcbsp5_dx", "sdmmc3_dat2", "hsusb1_data6",
		"gpio_20", NULL, "hsusb1_tll_data6", "hw_dbg8"),
	_OMAP3_MUXENTRY(ETK_D7, 21,
		"etk_d7", "mcspi3_cs1", "sdmmc3_dat7", "hsusb1_data3",
		"gpio_21", "mm1_txen_n", "hsusb1_tll_data3", "hw_dbg9"),
	_OMAP3_MUXENTRY(ETK_D8, 22,
		"etk_d8", "sys_drm_msecure", "sdmmc3_dat6", "hsusb1_dir",
		"gpio_22", NULL, "hsusb1_tll_dir", "hw_dbg10"),
	_OMAP3_MUXENTRY(ETK_D9, 23,
		"etk_d9", "sys_secure_indicator", "sdmmc3_dat5", "hsusb1_nxt",
		"gpio_23", "mm1_rxdm", "hsusb1_tll_nxt", "hw_dbg11"),
	_OMAP3_MUXENTRY(GPMC_A1, 34,
		"gpmc_a1", NULL, NULL, NULL,
		"gpio_34", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_A10, 43,
		"gpmc_a10", "sys_ndmareq3", NULL, NULL,
		"gpio_43", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_A2, 35,
		"gpmc_a2", NULL, NULL, NULL,
		"gpio_35", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_A3, 36,
		"gpmc_a3", NULL, NULL, NULL,
		"gpio_36", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_A4, 37,
		"gpmc_a4", NULL, NULL, NULL,
		"gpio_37", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_A5, 38,
		"gpmc_a5", NULL, NULL, NULL,
		"gpio_38", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_A6, 39,
		"gpmc_a6", NULL, NULL, NULL,
		"gpio_39", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_A7, 40,
		"gpmc_a7", NULL, NULL, NULL,
		"gpio_40", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_A8, 41,
		"gpmc_a8", NULL, NULL, NULL,
		"gpio_41", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_A9, 42,
		"gpmc_a9", "sys_ndmareq2", NULL, NULL,
		"gpio_42", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_CLK, 59,
		"gpmc_clk", NULL, NULL, NULL,
		"gpio_59", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_D10, 46,
		"gpmc_d10", NULL, NULL, NULL,
		"gpio_46", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_D11, 47,
		"gpmc_d11", NULL, NULL, NULL,
		"gpio_47", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_D12, 48,
		"gpmc_d12", NULL, NULL, NULL,
		"gpio_48", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_D13, 49,
		"gpmc_d13", NULL, NULL, NULL,
		"gpio_49", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_D14, 50,
		"gpmc_d14", NULL, NULL, NULL,
		"gpio_50", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_D15, 51,
		"gpmc_d15", NULL, NULL, NULL,
		"gpio_51", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_D8, 44,
		"gpmc_d8", NULL, NULL, NULL,
		"gpio_44", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_D9, 45,
		"gpmc_d9", NULL, NULL, NULL,
		"gpio_45", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_NBE0_CLE, 60,
		"gpmc_nbe0_cle", NULL, NULL, NULL,
		"gpio_60", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_NBE1, 61,
		"gpmc_nbe1", NULL, NULL, NULL,
		"gpio_61", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_NCS1, 52,
		"gpmc_ncs1", NULL, NULL, NULL,
		"gpio_52", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_NCS2, 53,
		"gpmc_ncs2", NULL, NULL, NULL,
		"gpio_53", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_NCS3, 54,
		"gpmc_ncs3", "sys_ndmareq0", NULL, NULL,
		"gpio_54", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_NCS4, 55,
		"gpmc_ncs4", "sys_ndmareq1", "mcbsp4_clkx", "gpt9_pwm_evt",
		"gpio_55", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_NCS5, 56,
		"gpmc_ncs5", "sys_ndmareq2", "mcbsp4_dr", "gpt10_pwm_evt",
		"gpio_56", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_NCS6, 57,
		"gpmc_ncs6", "sys_ndmareq3", "mcbsp4_dx", "gpt11_pwm_evt",
		"gpio_57", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_NCS7, 58,
		"gpmc_ncs7", "gpmc_io_dir", "mcbsp4_fsx", "gpt8_pwm_evt",
		"gpio_58", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_NWP, 62,
		"gpmc_nwp", NULL, NULL, NULL,
		"gpio_62", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_WAIT1, 63,
		"gpmc_wait1", NULL, NULL, NULL,
		"gpio_63", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_WAIT2, 64,
		"gpmc_wait2", NULL, NULL, NULL,
		"gpio_64", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_WAIT3, 65,
		"gpmc_wait3", "sys_ndmareq1", NULL, NULL,
		"gpio_65", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HDQ_SIO, 170,
		"hdq_sio", "sys_altclk", "i2c2_sccbe", "i2c3_sccbe",
		"gpio_170", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_CLK, 120,
		"hsusb0_clk", NULL, NULL, NULL,
		"gpio_120", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_DATA0, 125,
		"hsusb0_data0", NULL, "uart3_tx_irtx", NULL,
		"gpio_125", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_DATA1, 130,
		"hsusb0_data1", NULL, "uart3_rx_irrx", NULL,
		"gpio_130", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_DATA2, 131,
		"hsusb0_data2", NULL, "uart3_rts_sd", NULL,
		"gpio_131", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_DATA3, 169,
		"hsusb0_data3", NULL, "uart3_cts_rctx", NULL,
		"gpio_169", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_DATA4, 188,
		"hsusb0_data4", NULL, NULL, NULL,
		"gpio_188", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_DATA5, 189,
		"hsusb0_data5", NULL, NULL, NULL,
		"gpio_189", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_DATA6, 190,
		"hsusb0_data6", NULL, NULL, NULL,
		"gpio_190", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_DATA7, 191,
		"hsusb0_data7", NULL, NULL, NULL,
		"gpio_191", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_DIR, 122,
		"hsusb0_dir", NULL, NULL, NULL,
		"gpio_122", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_NXT, 124,
		"hsusb0_nxt", NULL, NULL, NULL,
		"gpio_124", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_STP, 121,
		"hsusb0_stp", NULL, NULL, NULL,
		"gpio_121", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(I2C2_SCL, 168,
		"i2c2_scl", NULL, NULL, NULL,
		"gpio_168", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(I2C2_SDA, 183,
		"i2c2_sda", NULL, NULL, NULL,
		"gpio_183", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(I2C3_SCL, 184,
		"i2c3_scl", NULL, NULL, NULL,
		"gpio_184", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(I2C3_SDA, 185,
		"i2c3_sda", NULL, NULL, NULL,
		"gpio_185", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(I2C4_SCL, 0,
		"i2c4_scl", "sys_nvmode1", NULL, NULL,
		NULL, NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(I2C4_SDA, 0,
		"i2c4_sda", "sys_nvmode2", NULL, NULL,
		NULL, NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(JTAG_EMU0, 11,
		"jtag_emu0", NULL, NULL, NULL,
		"gpio_11", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(JTAG_EMU1, 31,
		"jtag_emu1", NULL, NULL, NULL,
		"gpio_31", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP1_CLKR, 156,
		"mcbsp1_clkr", "mcspi4_clk", NULL, NULL,
		"gpio_156", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP1_CLKX, 162,
		"mcbsp1_clkx", NULL, "mcbsp3_clkx", NULL,
		"gpio_162", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP1_DR, 159,
		"mcbsp1_dr", "mcspi4_somi", "mcbsp3_dr", NULL,
		"gpio_159", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP1_DX, 158,
		"mcbsp1_dx", "mcspi4_simo", "mcbsp3_dx", NULL,
		"gpio_158", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP1_FSR, 157,
		"mcbsp1_fsr", NULL, "cam_global_reset", NULL,
		"gpio_157", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP1_FSX, 161,
		"mcbsp1_fsx", "mcspi4_cs0", "mcbsp3_fsx", NULL,
		"gpio_161", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP2_CLKX, 117,
		"mcbsp2_clkx", NULL, NULL, NULL,
		"gpio_117", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP2_DR, 118,
		"mcbsp2_dr", NULL, NULL, NULL,
		"gpio_118", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP2_DX, 119,
		"mcbsp2_dx", NULL, NULL, NULL,
		"gpio_119", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP2_FSX, 116,
		"mcbsp2_fsx", NULL, NULL, NULL,
		"gpio_116", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP3_CLKX, 142,
		"mcbsp3_clkx", "uart2_tx", NULL, NULL,
		"gpio_142", "hsusb3_tll_data6", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP3_DR, 141,
		"mcbsp3_dr", "uart2_rts", NULL, NULL,
		"gpio_141", "hsusb3_tll_data5", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP3_DX, 140,
		"mcbsp3_dx", "uart2_cts", NULL, NULL,
		"gpio_140", "hsusb3_tll_data4", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP3_FSX, 143,
		"mcbsp3_fsx", "uart2_rx", NULL, NULL,
		"gpio_143", "hsusb3_tll_data7", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP4_CLKX, 152,
		"mcbsp4_clkx", NULL, NULL, NULL,
		"gpio_152", "hsusb3_tll_data1", "mm3_txse0", "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP4_DR, 153,
		"mcbsp4_dr", NULL, NULL, NULL,
		"gpio_153", "hsusb3_tll_data0", "mm3_rxrcv", "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP4_DX, 154,
		"mcbsp4_dx", NULL, NULL, NULL,
		"gpio_154", "hsusb3_tll_data2", "mm3_txdat", "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP4_FSX, 155,
		"mcbsp4_fsx", NULL, NULL, NULL,
		"gpio_155", "hsusb3_tll_data3", "mm3_txen_n", "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP_CLKS, 160,
		"mcbsp_clks", NULL, "cam_shutter", NULL,
		"gpio_160", "uart1_cts", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCSPI1_CLK, 171,
		"mcspi1_clk", "sdmmc2_dat4", NULL, NULL,
		"gpio_171", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCSPI1_CS0, 174,
		"mcspi1_cs0", "sdmmc2_dat7", NULL, NULL,
		"gpio_174", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCSPI1_CS1, 175,
		"mcspi1_cs1", NULL, NULL, "sdmmc3_cmd",
		"gpio_175", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCSPI1_CS2, 176,
		"mcspi1_cs2", NULL, NULL, "sdmmc3_clk",
		"gpio_176", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCSPI1_CS3, 177,
		"mcspi1_cs3", NULL, "hsusb2_tll_data2", "hsusb2_data2",
		"gpio_177", "mm2_txdat", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCSPI1_SIMO, 172,
		"mcspi1_simo", "sdmmc2_dat5", NULL, NULL,
		"gpio_172", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCSPI1_SOMI, 173,
		"mcspi1_somi", "sdmmc2_dat6", NULL, NULL,
		"gpio_173", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCSPI2_CLK, 178,
		"mcspi2_clk", NULL, "hsusb2_tll_data7", "hsusb2_data7",
		"gpio_178", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCSPI2_CS0, 181,
		"mcspi2_cs0", "gpt11_pwm_evt",
		"hsusb2_tll_data6", "hsusb2_data6",
		"gpio_181", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCSPI2_CS1, 182,
		"mcspi2_cs1", "gpt8_pwm_evt",
		"hsusb2_tll_data3", "hsusb2_data3",
		"gpio_182", "mm2_txen_n", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCSPI2_SIMO, 179,
		"mcspi2_simo", "gpt9_pwm_evt",
		"hsusb2_tll_data4", "hsusb2_data4",
		"gpio_179", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCSPI2_SOMI, 180,
		"mcspi2_somi", "gpt10_pwm_evt",
		"hsusb2_tll_data5", "hsusb2_data5",
		"gpio_180", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_CLK, 120,
		"sdmmc1_clk", NULL, NULL, NULL,
		"gpio_120", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_CMD, 121,
		"sdmmc1_cmd", NULL, NULL, NULL,
		"gpio_121", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_DAT0, 122,
		"sdmmc1_dat0", NULL, NULL, NULL,
		"gpio_122", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_DAT1, 123,
		"sdmmc1_dat1", NULL, NULL, NULL,
		"gpio_123", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_DAT2, 124,
		"sdmmc1_dat2", NULL, NULL, NULL,
		"gpio_124", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_DAT3, 125,
		"sdmmc1_dat3", NULL, NULL, NULL,
		"gpio_125", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_DAT4, 126,
		"sdmmc1_dat4", NULL, "sim_io", NULL,
		"gpio_126", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_DAT5, 127,
		"sdmmc1_dat5", NULL, "sim_clk", NULL,
		"gpio_127", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_DAT6, 128,
		"sdmmc1_dat6", NULL, "sim_pwrctrl", NULL,
		"gpio_128", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_DAT7, 129,
		"sdmmc1_dat7", NULL, "sim_rst", NULL,
		"gpio_129", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC2_CLK, 130,
		"sdmmc2_clk", "mcspi3_clk", NULL, NULL,
		"gpio_130", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC2_CMD, 131,
		"sdmmc2_cmd", "mcspi3_simo", NULL, NULL,
		"gpio_131", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC2_DAT0, 132,
		"sdmmc2_dat0", "mcspi3_somi", NULL, NULL,
		"gpio_132", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC2_DAT1, 133,
		"sdmmc2_dat1", NULL, NULL, NULL,
		"gpio_133", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC2_DAT2, 134,
		"sdmmc2_dat2", "mcspi3_cs1", NULL, NULL,
		"gpio_134", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC2_DAT3, 135,
		"sdmmc2_dat3", "mcspi3_cs0", NULL, NULL,
		"gpio_135", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC2_DAT4, 136,
		"sdmmc2_dat4", "sdmmc2_dir_dat0", NULL, "sdmmc3_dat0",
		"gpio_136", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC2_DAT5, 137,
		"sdmmc2_dat5", "sdmmc2_dir_dat1",
		"cam_global_reset", "sdmmc3_dat1",
		"gpio_137", "hsusb3_tll_stp", "mm3_rxdp", "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC2_DAT6, 138,
		"sdmmc2_dat6", "sdmmc2_dir_cmd", "cam_shutter", "sdmmc3_dat2",
		"gpio_138", "hsusb3_tll_dir", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC2_DAT7, 139,
		"sdmmc2_dat7", "sdmmc2_clkin", NULL, "sdmmc3_dat3",
		"gpio_139", "hsusb3_tll_nxt", "mm3_rxdm", "safe_mode"),
	_OMAP3_MUXENTRY(SDRC_CKE0, 0,
		"sdrc_cke0", NULL, NULL, NULL,
		NULL, NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDRC_CKE1, 0,
		"sdrc_cke1", NULL, NULL, NULL,
		NULL, NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_BOOT0, 2,
		"sys_boot0", NULL, NULL, NULL,
		"gpio_2", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_BOOT1, 3,
		"sys_boot1", NULL, NULL, NULL,
		"gpio_3", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_BOOT2, 4,
		"sys_boot2", NULL, NULL, NULL,
		"gpio_4", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_BOOT3, 5,
		"sys_boot3", NULL, NULL, NULL,
		"gpio_5", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_BOOT4, 6,
		"sys_boot4", "sdmmc2_dir_dat2", NULL, NULL,
		"gpio_6", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_BOOT5, 7,
		"sys_boot5", "sdmmc2_dir_dat3", NULL, NULL,
		"gpio_7", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_BOOT6, 8,
		"sys_boot6", NULL, NULL, NULL,
		"gpio_8", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_CLKOUT1, 10,
		"sys_clkout1", NULL, NULL, NULL,
		"gpio_10", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_CLKOUT2, 186,
		"sys_clkout2", NULL, NULL, NULL,
		"gpio_186", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_CLKREQ, 1,
		"sys_clkreq", NULL, NULL, NULL,
		"gpio_1", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_NIRQ, 0,
		"sys_nirq", NULL, NULL, NULL,
		"gpio_0", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_NRESWARM, 30,
		"sys_nreswarm", NULL, NULL, NULL,
		"gpio_30", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_OFF_MODE, 9,
		"sys_off_mode", NULL, NULL, NULL,
		"gpio_9", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART1_CTS, 150,
		"uart1_cts", NULL, NULL, NULL,
		"gpio_150", "hsusb3_tll_clk", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART1_RTS, 149,
		"uart1_rts", NULL, NULL, NULL,
		"gpio_149", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART1_RX, 151,
		"uart1_rx", NULL, "mcbsp1_clkr", "mcspi4_clk",
		"gpio_151", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART1_TX, 148,
		"uart1_tx", NULL, NULL, NULL,
		"gpio_148", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART2_CTS, 144,
		"uart2_cts", "mcbsp3_dx", "gpt9_pwm_evt", NULL,
		"gpio_144", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART2_RTS, 145,
		"uart2_rts", "mcbsp3_dr", "gpt10_pwm_evt", NULL,
		"gpio_145", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART2_RX, 147,
		"uart2_rx", "mcbsp3_fsx", "gpt8_pwm_evt", NULL,
		"gpio_147", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART2_TX, 146,
		"uart2_tx", "mcbsp3_clkx", "gpt11_pwm_evt", NULL,
		"gpio_146", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART3_CTS_RCTX, 163,
		"uart3_cts_rctx", NULL, NULL, NULL,
		"gpio_163", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART3_RTS_SD, 164,
		"uart3_rts_sd", NULL, NULL, NULL,
		"gpio_164", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART3_RX_IRRX, 165,
		"uart3_rx_irrx", NULL, NULL, NULL,
		"gpio_165", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART3_TX_IRTX, 166,
		"uart3_tx_irtx", NULL, NULL, NULL,
		"gpio_166", NULL, NULL, "safe_mode"),

	/* Only on 3630, see omap36xx_cbp_subset for the signals */
	_OMAP3_MUXENTRY(GPMC_A11, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MBUSFLAG, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MREAD, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MWRITE, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_SBUSFLAG, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_SREAD, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_SWRITE, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(GPMC_A11, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD28, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD29, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD32, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD33, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD34, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD35, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD36, 0,
		NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};

/*
 * Signals different on CBC package compared to the superset
 */
#if defined(CONFIG_OMAP_MUX) && defined(CONFIG_OMAP_PACKAGE_CBC)
static struct omap_mux __initdata omap3_cbc_subset[] = {
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#else
#define omap3_cbc_subset	NULL
#endif

/*
 * Balls for CBC package
 * 515-pin s-PBGA Package, 0.65mm Ball Pitch (Top), 0.50mm Ball Pitch (Bottom)
 *
 * FIXME: What's up with the outdated TI documentation? See:
 *
 * http://wiki.davincidsp.com/index.php/Datasheet_Errata_for_OMAP35x_CBC_Package
 * http://community.ti.com/forums/t/10982.aspx
 */
#if defined(CONFIG_OMAP_MUX) && defined(CONFIG_DEBUG_FS)	\
		&& defined(CONFIG_OMAP_PACKAGE_CBC)
static struct omap_ball __initdata omap3_cbc_ball[] = {
	_OMAP3_BALLENTRY(CAM_D0, "ae16", NULL),
	_OMAP3_BALLENTRY(CAM_D1, "ae15", NULL),
	_OMAP3_BALLENTRY(CAM_D10, "d25", NULL),
	_OMAP3_BALLENTRY(CAM_D11, "e26", NULL),
	_OMAP3_BALLENTRY(CAM_D2, "a24", NULL),
	_OMAP3_BALLENTRY(CAM_D3, "b24", NULL),
	_OMAP3_BALLENTRY(CAM_D4, "d24", NULL),
	_OMAP3_BALLENTRY(CAM_D5, "c24", NULL),
	_OMAP3_BALLENTRY(CAM_D6, "p25", NULL),
	_OMAP3_BALLENTRY(CAM_D7, "p26", NULL),
	_OMAP3_BALLENTRY(CAM_D8, "n25", NULL),
	_OMAP3_BALLENTRY(CAM_D9, "n26", NULL),
	_OMAP3_BALLENTRY(CAM_FLD, "b23", NULL),
	_OMAP3_BALLENTRY(CAM_HS, "c23", NULL),
	_OMAP3_BALLENTRY(CAM_PCLK, "c26", NULL),
	_OMAP3_BALLENTRY(CAM_STROBE, "d26", NULL),
	_OMAP3_BALLENTRY(CAM_VS, "d23", NULL),
	_OMAP3_BALLENTRY(CAM_WEN, "a23", NULL),
	_OMAP3_BALLENTRY(CAM_XCLKA, "c25", NULL),
	_OMAP3_BALLENTRY(CAM_XCLKB, "e25", NULL),
	_OMAP3_BALLENTRY(CSI2_DX0, "ad17", NULL),
	_OMAP3_BALLENTRY(CSI2_DX1, "ae18", NULL),
	_OMAP3_BALLENTRY(CSI2_DY0, "ad16", NULL),
	_OMAP3_BALLENTRY(CSI2_DY1, "ae17", NULL),
	_OMAP3_BALLENTRY(DSS_ACBIAS, "f26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA0, "ae21", NULL),
	_OMAP3_BALLENTRY(DSS_DATA1, "ae22", NULL),
	_OMAP3_BALLENTRY(DSS_DATA10, "ac26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA11, "ad26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA12, "aa25", NULL),
	_OMAP3_BALLENTRY(DSS_DATA13, "y25", NULL),
	_OMAP3_BALLENTRY(DSS_DATA14, "aa26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA15, "ab26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA16, "l25", NULL),
	_OMAP3_BALLENTRY(DSS_DATA17, "l26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA18, "m24", NULL),
	_OMAP3_BALLENTRY(DSS_DATA19, "m26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA2, "ae23", NULL),
	_OMAP3_BALLENTRY(DSS_DATA20, "f25", NULL),
	_OMAP3_BALLENTRY(DSS_DATA21, "n24", NULL),
	_OMAP3_BALLENTRY(DSS_DATA22, "ac25", NULL),
	_OMAP3_BALLENTRY(DSS_DATA23, "ab25", NULL),
	_OMAP3_BALLENTRY(DSS_DATA3, "ae24", NULL),
	_OMAP3_BALLENTRY(DSS_DATA4, "ad23", NULL),
	_OMAP3_BALLENTRY(DSS_DATA5, "ad24", NULL),
	_OMAP3_BALLENTRY(DSS_DATA6, "g26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA7, "h25", NULL),
	_OMAP3_BALLENTRY(DSS_DATA8, "h26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA9, "j26", NULL),
	_OMAP3_BALLENTRY(DSS_HSYNC, "k24", NULL),
	_OMAP3_BALLENTRY(DSS_PCLK, "g25", NULL),
	_OMAP3_BALLENTRY(DSS_VSYNC, "m25", NULL),
	_OMAP3_BALLENTRY(ETK_CLK, "ab2", NULL),
	_OMAP3_BALLENTRY(ETK_CTL, "ab3", NULL),
	_OMAP3_BALLENTRY(ETK_D0, "ac3", NULL),
	_OMAP3_BALLENTRY(ETK_D1, "ad4", NULL),
	_OMAP3_BALLENTRY(ETK_D10, "ae4", NULL),
	_OMAP3_BALLENTRY(ETK_D11, "af6", NULL),
	_OMAP3_BALLENTRY(ETK_D12, "ae6", NULL),
	_OMAP3_BALLENTRY(ETK_D13, "af7", NULL),
	_OMAP3_BALLENTRY(ETK_D14, "af9", NULL),
	_OMAP3_BALLENTRY(ETK_D15, "ae9", NULL),
	_OMAP3_BALLENTRY(ETK_D2, "ad3", NULL),
	_OMAP3_BALLENTRY(ETK_D3, "aa3", NULL),
	_OMAP3_BALLENTRY(ETK_D4, "y3", NULL),
	_OMAP3_BALLENTRY(ETK_D5, "ab1", NULL),
	_OMAP3_BALLENTRY(ETK_D6, "ae3", NULL),
	_OMAP3_BALLENTRY(ETK_D7, "ad2", NULL),
	_OMAP3_BALLENTRY(ETK_D8, "aa4", NULL),
	_OMAP3_BALLENTRY(ETK_D9, "v2", NULL),
	_OMAP3_BALLENTRY(GPMC_A1, "j2", NULL),
	_OMAP3_BALLENTRY(GPMC_A10, "d2", NULL),
	_OMAP3_BALLENTRY(GPMC_A2, "h1", NULL),
	_OMAP3_BALLENTRY(GPMC_A3, "h2", NULL),
	_OMAP3_BALLENTRY(GPMC_A4, "g2", NULL),
	_OMAP3_BALLENTRY(GPMC_A5, "f1", NULL),
	_OMAP3_BALLENTRY(GPMC_A6, "f2", NULL),
	_OMAP3_BALLENTRY(GPMC_A7, "e1", NULL),
	_OMAP3_BALLENTRY(GPMC_A8, "e2", NULL),
	_OMAP3_BALLENTRY(GPMC_A9, "d1", NULL),
	_OMAP3_BALLENTRY(GPMC_CLK, "n1", "l1"),
	_OMAP3_BALLENTRY(GPMC_D10, "t1", "n1"),
	_OMAP3_BALLENTRY(GPMC_D11, "u2", "p2"),
	_OMAP3_BALLENTRY(GPMC_D12, "u1", "p1"),
	_OMAP3_BALLENTRY(GPMC_D13, "p1", "m1"),
	_OMAP3_BALLENTRY(GPMC_D14, "l2", "j2"),
	_OMAP3_BALLENTRY(GPMC_D15, "m2", "k2"),
	_OMAP3_BALLENTRY(GPMC_D8, "v1", "r1"),
	_OMAP3_BALLENTRY(GPMC_D9, "y1", "t1"),
	_OMAP3_BALLENTRY(GPMC_NBE0_CLE, "k2", NULL),
	_OMAP3_BALLENTRY(GPMC_NBE1, "j1", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS1, "ad1", "w1"),
	_OMAP3_BALLENTRY(GPMC_NCS2, "a3", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS3, "b6", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS4, "b4", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS5, "c4", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS6, "b5", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS7, "c5", NULL),
	_OMAP3_BALLENTRY(GPMC_NWP, "ac6", "y5"),
	_OMAP3_BALLENTRY(GPMC_WAIT1, "ac8", "y8"),
	_OMAP3_BALLENTRY(GPMC_WAIT2, "b3", NULL),
	_OMAP3_BALLENTRY(GPMC_WAIT3, "c6", NULL),
	_OMAP3_BALLENTRY(HDQ_SIO, "j23", NULL),
	_OMAP3_BALLENTRY(HSUSB0_CLK, "w19", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA0, "v20", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA1, "y20", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA2, "v18", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA3, "w20", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA4, "w17", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA5, "y18", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA6, "y19", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA7, "y17", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DIR, "v19", NULL),
	_OMAP3_BALLENTRY(HSUSB0_NXT, "w18", NULL),
	_OMAP3_BALLENTRY(HSUSB0_STP, "u20", NULL),
	_OMAP3_BALLENTRY(I2C2_SCL, "c2", NULL),
	_OMAP3_BALLENTRY(I2C2_SDA, "c1", NULL),
	_OMAP3_BALLENTRY(I2C3_SCL, "ab4", NULL),
	_OMAP3_BALLENTRY(I2C3_SDA, "ac4", NULL),
	_OMAP3_BALLENTRY(I2C4_SCL, "ad15", NULL),
	_OMAP3_BALLENTRY(I2C4_SDA, "w16", NULL),
	_OMAP3_BALLENTRY(JTAG_EMU0, "y15", NULL),
	_OMAP3_BALLENTRY(JTAG_EMU1, "y14", NULL),
	_OMAP3_BALLENTRY(MCBSP1_CLKR, "u19", NULL),
	_OMAP3_BALLENTRY(MCBSP1_CLKX, "t17", NULL),
	_OMAP3_BALLENTRY(MCBSP1_DR, "t20", NULL),
	_OMAP3_BALLENTRY(MCBSP1_DX, "u17", NULL),
	_OMAP3_BALLENTRY(MCBSP1_FSR, "v17", NULL),
	_OMAP3_BALLENTRY(MCBSP1_FSX, "p20", NULL),
	_OMAP3_BALLENTRY(MCBSP2_CLKX, "r18", NULL),
	_OMAP3_BALLENTRY(MCBSP2_DR, "t18", NULL),
	_OMAP3_BALLENTRY(MCBSP2_DX, "r19", NULL),
	_OMAP3_BALLENTRY(MCBSP2_FSX, "u18", NULL),
	_OMAP3_BALLENTRY(MCBSP3_CLKX, "u3", NULL),
	_OMAP3_BALLENTRY(MCBSP3_DR, "n3", NULL),
	_OMAP3_BALLENTRY(MCBSP3_DX, "p3", NULL),
	_OMAP3_BALLENTRY(MCBSP3_FSX, "w3", NULL),
	_OMAP3_BALLENTRY(MCBSP4_CLKX, "v3", NULL),
	_OMAP3_BALLENTRY(MCBSP4_DR, "u4", NULL),
	_OMAP3_BALLENTRY(MCBSP4_DX, "r3", NULL),
	_OMAP3_BALLENTRY(MCBSP4_FSX, "t3", NULL),
	_OMAP3_BALLENTRY(MCBSP_CLKS, "t19", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CLK, "p9", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS0, "r7", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS1, "r8", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS2, "r9", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS3, "t8", NULL),
	_OMAP3_BALLENTRY(MCSPI1_SIMO, "p8", NULL),
	_OMAP3_BALLENTRY(MCSPI1_SOMI, "p7", NULL),
	_OMAP3_BALLENTRY(MCSPI2_CLK, "w7", NULL),
	_OMAP3_BALLENTRY(MCSPI2_CS0, "v8", NULL),
	_OMAP3_BALLENTRY(MCSPI2_CS1, "v9", NULL),
	_OMAP3_BALLENTRY(MCSPI2_SIMO, "w8", NULL),
	_OMAP3_BALLENTRY(MCSPI2_SOMI, "u8", NULL),
	_OMAP3_BALLENTRY(SDMMC1_CLK, "n19", NULL),
	_OMAP3_BALLENTRY(SDMMC1_CMD, "l18", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT0, "m19", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT1, "m18", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT2, "k18", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT3, "n20", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT4, "m20", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT5, "p17", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT6, "p18", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT7, "p19", NULL),
	_OMAP3_BALLENTRY(SDMMC2_CLK, "w10", NULL),
	_OMAP3_BALLENTRY(SDMMC2_CMD, "r10", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT0, "t10", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT1, "t9", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT2, "u10", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT3, "u9", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT4, "v10", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT5, "m3", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT6, "l3", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT7, "k3", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT0, "f3", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT1, "d3", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT2, "c3", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT3, "e3", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT4, "e4", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT5, "g3", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT6, "d4", NULL),
	_OMAP3_BALLENTRY(SYS_CLKOUT1, "ae14", NULL),
	_OMAP3_BALLENTRY(SYS_CLKOUT2, "w11", NULL),
	_OMAP3_BALLENTRY(SYS_CLKREQ, "w15", NULL),
	_OMAP3_BALLENTRY(SYS_NIRQ, "v16", NULL),
	_OMAP3_BALLENTRY(SYS_NRESWARM, "ad7", "aa5"),
	_OMAP3_BALLENTRY(SYS_OFF_MODE, "v12", NULL),
	_OMAP3_BALLENTRY(UART1_CTS, "w2", NULL),
	_OMAP3_BALLENTRY(UART1_RTS, "r2", NULL),
	_OMAP3_BALLENTRY(UART1_RX, "h3", NULL),
	_OMAP3_BALLENTRY(UART1_TX, "l4", NULL),
	_OMAP3_BALLENTRY(UART2_CTS, "y24", NULL),
	_OMAP3_BALLENTRY(UART2_RTS, "aa24", NULL),
	_OMAP3_BALLENTRY(UART2_RX, "ad21", NULL),
	_OMAP3_BALLENTRY(UART2_TX, "ad22", NULL),
	_OMAP3_BALLENTRY(UART3_CTS_RCTX, "f23", NULL),
	_OMAP3_BALLENTRY(UART3_RTS_SD, "f24", NULL),
	_OMAP3_BALLENTRY(UART3_RX_IRRX, "h24", NULL),
	_OMAP3_BALLENTRY(UART3_TX_IRTX, "g24", NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#else
#define omap3_cbc_ball	 NULL
#endif

/*
 * Signals different on CUS package compared to superset
 */
#if defined(CONFIG_OMAP_MUX) && defined(CONFIG_OMAP_PACKAGE_CUS)
static struct omap_mux __initdata omap3_cus_subset[] = {
	_OMAP3_MUXENTRY(CAM_D10, 109,
		"cam_d10", NULL, NULL, NULL,
		"gpio_109", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D11, 110,
		"cam_d11", NULL, NULL, NULL,
		"gpio_110", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D2, 101,
		"cam_d2", NULL, NULL, NULL,
		"gpio_101", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D3, 102,
		"cam_d3", NULL, NULL, NULL,
		"gpio_102", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D4, 103,
		"cam_d4", NULL, NULL, NULL,
		"gpio_103", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D5, 104,
		"cam_d5", NULL, NULL, NULL,
		"gpio_104", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_FLD, 98,
		"cam_fld", NULL, "cam_global_reset", NULL,
		"gpio_98", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_HS, 94,
		"cam_hs", NULL, NULL, NULL,
		"gpio_94", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_PCLK, 97,
		"cam_pclk", NULL, NULL, NULL,
		"gpio_97", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_STROBE, 126,
		"cam_strobe", NULL, NULL, NULL,
		"gpio_126", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_VS, 95,
		"cam_vs", NULL, NULL, NULL,
		"gpio_95", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_WEN, 167,
		"cam_wen", NULL, "cam_shutter", NULL,
		"gpio_167", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA6, 76,
		"dss_data6", NULL, "uart1_tx", NULL,
		"gpio_76", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA7, 77,
		"dss_data7", NULL, "uart1_rx", NULL,
		"gpio_77", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA8, 78,
		"dss_data8", NULL, NULL, NULL,
		"gpio_78", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA9, 79,
		"dss_data9", NULL, NULL, NULL,
		"gpio_79", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_HSYNC, 67,
		"dss_hsync", NULL, NULL, NULL,
		"gpio_67", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_PCLK, 66,
		"dss_pclk", NULL, NULL, NULL,
		"gpio_66", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(ETK_CLK, 12,
		"etk_clk", "mcbsp5_clkx", "sdmmc3_clk", "hsusb1_stp",
		"gpio_12", "mm1_rxdp", "hsusb1_tll_stp", NULL),
	_OMAP3_MUXENTRY(ETK_CTL, 13,
		"etk_ctl", NULL, "sdmmc3_cmd", "hsusb1_clk",
		"gpio_13", NULL, "hsusb1_tll_clk", NULL),
	_OMAP3_MUXENTRY(ETK_D0, 14,
		"etk_d0", "mcspi3_simo", "sdmmc3_dat4", "hsusb1_data0",
		"gpio_14", "mm1_rxrcv", "hsusb1_tll_data0", NULL),
	_OMAP3_MUXENTRY(ETK_D1, 15,
		"etk_d1", "mcspi3_somi", NULL, "hsusb1_data1",
		"gpio_15", "mm1_txse0", "hsusb1_tll_data1", NULL),
	_OMAP3_MUXENTRY(ETK_D10, 24,
		"etk_d10", NULL, "uart1_rx", "hsusb2_clk",
		"gpio_24", NULL, "hsusb2_tll_clk", NULL),
	_OMAP3_MUXENTRY(ETK_D11, 25,
		"etk_d11", NULL, NULL, "hsusb2_stp",
		"gpio_25", "mm2_rxdp", "hsusb2_tll_stp", NULL),
	_OMAP3_MUXENTRY(ETK_D12, 26,
		"etk_d12", NULL, NULL, "hsusb2_dir",
		"gpio_26", NULL, "hsusb2_tll_dir", NULL),
	_OMAP3_MUXENTRY(ETK_D13, 27,
		"etk_d13", NULL, NULL, "hsusb2_nxt",
		"gpio_27", "mm2_rxdm", "hsusb2_tll_nxt", NULL),
	_OMAP3_MUXENTRY(ETK_D14, 28,
		"etk_d14", NULL, NULL, "hsusb2_data0",
		"gpio_28", "mm2_rxrcv", "hsusb2_tll_data0", NULL),
	_OMAP3_MUXENTRY(ETK_D15, 29,
		"etk_d15", NULL, NULL, "hsusb2_data1",
		"gpio_29", "mm2_txse0", "hsusb2_tll_data1", NULL),
	_OMAP3_MUXENTRY(ETK_D2, 16,
		"etk_d2", "mcspi3_cs0", NULL, "hsusb1_data2",
		"gpio_16", "mm1_txdat", "hsusb1_tll_data2", NULL),
	_OMAP3_MUXENTRY(ETK_D3, 17,
		"etk_d3", "mcspi3_clk", "sdmmc3_dat3", "hsusb1_data7",
		"gpio_17", NULL, "hsusb1_tll_data7", NULL),
	_OMAP3_MUXENTRY(ETK_D4, 18,
		"etk_d4", "mcbsp5_dr", "sdmmc3_dat0", "hsusb1_data4",
		"gpio_18", NULL, "hsusb1_tll_data4", NULL),
	_OMAP3_MUXENTRY(ETK_D5, 19,
		"etk_d5", "mcbsp5_fsx", "sdmmc3_dat1", "hsusb1_data5",
		"gpio_19", NULL, "hsusb1_tll_data5", NULL),
	_OMAP3_MUXENTRY(ETK_D6, 20,
		"etk_d6", "mcbsp5_dx", "sdmmc3_dat2", "hsusb1_data6",
		"gpio_20", NULL, "hsusb1_tll_data6", NULL),
	_OMAP3_MUXENTRY(ETK_D7, 21,
		"etk_d7", "mcspi3_cs1", "sdmmc3_dat7", "hsusb1_data3",
		"gpio_21", "mm1_txen_n", "hsusb1_tll_data3", NULL),
	_OMAP3_MUXENTRY(ETK_D8, 22,
		"etk_d8", "sys_drm_msecure", "sdmmc3_dat6", "hsusb1_dir",
		"gpio_22", NULL, "hsusb1_tll_dir", NULL),
	_OMAP3_MUXENTRY(ETK_D9, 23,
		"etk_d9", "sys_secure_indicator", "sdmmc3_dat5", "hsusb1_nxt",
		"gpio_23", "mm1_rxdm", "hsusb1_tll_nxt", NULL),
	_OMAP3_MUXENTRY(MCBSP3_CLKX, 142,
		"mcbsp3_clkx", "uart2_tx", NULL, NULL,
		"gpio_142", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP3_DR, 141,
		"mcbsp3_dr", "uart2_rts", NULL, NULL,
		"gpio_141", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP3_DX, 140,
		"mcbsp3_dx", "uart2_cts", NULL, NULL,
		"gpio_140", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP3_FSX, 143,
		"mcbsp3_fsx", "uart2_rx", NULL, NULL,
		"gpio_143", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC2_DAT5, 137,
		"sdmmc2_dat5", "sdmmc2_dir_dat1",
		"cam_global_reset", "sdmmc3_dat1",
		"gpio_137", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC2_DAT6, 138,
		"sdmmc2_dat6", "sdmmc2_dir_cmd", "cam_shutter", "sdmmc3_dat2",
		"gpio_138", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC2_DAT7, 139,
		"sdmmc2_dat7", "sdmmc2_clkin", NULL, "sdmmc3_dat3",
		"gpio_139", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART1_CTS, 150,
		"uart1_cts", NULL, NULL, NULL,
		"gpio_150", NULL, NULL, "safe_mode"),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#else
#define omap3_cus_subset	NULL
#endif

/*
 * Balls for CUS package
 * 423-pin s-PBGA Package, 0.65mm Ball Pitch (Bottom)
 */
#if defined(CONFIG_OMAP_MUX) && defined(CONFIG_DEBUG_FS)		\
		&& defined(CONFIG_OMAP_PACKAGE_CUS)
static struct omap_ball __initdata omap3_cus_ball[] = {
	_OMAP3_BALLENTRY(CAM_D0, "ab18", NULL),
	_OMAP3_BALLENTRY(CAM_D1, "ac18", NULL),
	_OMAP3_BALLENTRY(CAM_D10, "f21", NULL),
	_OMAP3_BALLENTRY(CAM_D11, "g21", NULL),
	_OMAP3_BALLENTRY(CAM_D2, "g19", NULL),
	_OMAP3_BALLENTRY(CAM_D3, "f19", NULL),
	_OMAP3_BALLENTRY(CAM_D4, "g20", NULL),
	_OMAP3_BALLENTRY(CAM_D5, "b21", NULL),
	_OMAP3_BALLENTRY(CAM_D6, "l24", NULL),
	_OMAP3_BALLENTRY(CAM_D7, "k24", NULL),
	_OMAP3_BALLENTRY(CAM_D8, "j23", NULL),
	_OMAP3_BALLENTRY(CAM_D9, "k23", NULL),
	_OMAP3_BALLENTRY(CAM_FLD, "h24", NULL),
	_OMAP3_BALLENTRY(CAM_HS, "a22", NULL),
	_OMAP3_BALLENTRY(CAM_PCLK, "j19", NULL),
	_OMAP3_BALLENTRY(CAM_STROBE, "j20", NULL),
	_OMAP3_BALLENTRY(CAM_VS, "e18", NULL),
	_OMAP3_BALLENTRY(CAM_WEN, "f18", NULL),
	_OMAP3_BALLENTRY(CAM_XCLKA, "b22", NULL),
	_OMAP3_BALLENTRY(CAM_XCLKB, "c22", NULL),
	_OMAP3_BALLENTRY(DSS_ACBIAS, "j21", NULL),
	_OMAP3_BALLENTRY(DSS_DATA0, "ac19", NULL),
	_OMAP3_BALLENTRY(DSS_DATA1, "ab19", NULL),
	_OMAP3_BALLENTRY(DSS_DATA10, "ac22", NULL),
	_OMAP3_BALLENTRY(DSS_DATA11, "ac23", NULL),
	_OMAP3_BALLENTRY(DSS_DATA12, "ab22", NULL),
	_OMAP3_BALLENTRY(DSS_DATA13, "y22", NULL),
	_OMAP3_BALLENTRY(DSS_DATA14, "w22", NULL),
	_OMAP3_BALLENTRY(DSS_DATA15, "v22", NULL),
	_OMAP3_BALLENTRY(DSS_DATA16, "j22", NULL),
	_OMAP3_BALLENTRY(DSS_DATA17, "g23", NULL),
	_OMAP3_BALLENTRY(DSS_DATA18, "g24", NULL),
	_OMAP3_BALLENTRY(DSS_DATA19, "h23", NULL),
	_OMAP3_BALLENTRY(DSS_DATA2, "ad20", NULL),
	_OMAP3_BALLENTRY(DSS_DATA20, "d23", NULL),
	_OMAP3_BALLENTRY(DSS_DATA21, "k22", NULL),
	_OMAP3_BALLENTRY(DSS_DATA22, "v21", NULL),
	_OMAP3_BALLENTRY(DSS_DATA23, "w21", NULL),
	_OMAP3_BALLENTRY(DSS_DATA3, "ac20", NULL),
	_OMAP3_BALLENTRY(DSS_DATA4, "ad21", NULL),
	_OMAP3_BALLENTRY(DSS_DATA5, "ac21", NULL),
	_OMAP3_BALLENTRY(DSS_DATA6, "d24", NULL),
	_OMAP3_BALLENTRY(DSS_DATA7, "e23", NULL),
	_OMAP3_BALLENTRY(DSS_DATA8, "e24", NULL),
	_OMAP3_BALLENTRY(DSS_DATA9, "f23", NULL),
	_OMAP3_BALLENTRY(DSS_HSYNC, "e22", NULL),
	_OMAP3_BALLENTRY(DSS_PCLK, "g22", NULL),
	_OMAP3_BALLENTRY(DSS_VSYNC, "f22", NULL),
	_OMAP3_BALLENTRY(ETK_CLK, "ac1", NULL),
	_OMAP3_BALLENTRY(ETK_CTL, "ad3", NULL),
	_OMAP3_BALLENTRY(ETK_D0, "ad6", NULL),
	_OMAP3_BALLENTRY(ETK_D1, "ac6", NULL),
	_OMAP3_BALLENTRY(ETK_D10, "ac3", NULL),
	_OMAP3_BALLENTRY(ETK_D11, "ac9", NULL),
	_OMAP3_BALLENTRY(ETK_D12, "ac10", NULL),
	_OMAP3_BALLENTRY(ETK_D13, "ad11", NULL),
	_OMAP3_BALLENTRY(ETK_D14, "ac11", NULL),
	_OMAP3_BALLENTRY(ETK_D15, "ad12", NULL),
	_OMAP3_BALLENTRY(ETK_D2, "ac7", NULL),
	_OMAP3_BALLENTRY(ETK_D3, "ad8", NULL),
	_OMAP3_BALLENTRY(ETK_D4, "ac5", NULL),
	_OMAP3_BALLENTRY(ETK_D5, "ad2", NULL),
	_OMAP3_BALLENTRY(ETK_D6, "ac8", NULL),
	_OMAP3_BALLENTRY(ETK_D7, "ad9", NULL),
	_OMAP3_BALLENTRY(ETK_D8, "ac4", NULL),
	_OMAP3_BALLENTRY(ETK_D9, "ad5", NULL),
	_OMAP3_BALLENTRY(GPMC_A1, "k4", NULL),
	_OMAP3_BALLENTRY(GPMC_A10, "g2", NULL),
	_OMAP3_BALLENTRY(GPMC_A2, "k3", NULL),
	_OMAP3_BALLENTRY(GPMC_A3, "k2", NULL),
	_OMAP3_BALLENTRY(GPMC_A4, "j4", NULL),
	_OMAP3_BALLENTRY(GPMC_A5, "j3", NULL),
	_OMAP3_BALLENTRY(GPMC_A6, "j2", NULL),
	_OMAP3_BALLENTRY(GPMC_A7, "j1", NULL),
	_OMAP3_BALLENTRY(GPMC_A8, "h1", NULL),
	_OMAP3_BALLENTRY(GPMC_A9, "h2", NULL),
	_OMAP3_BALLENTRY(GPMC_CLK, "w2", NULL),
	_OMAP3_BALLENTRY(GPMC_D10, "u1", NULL),
	_OMAP3_BALLENTRY(GPMC_D11, "r3", NULL),
	_OMAP3_BALLENTRY(GPMC_D12, "t3", NULL),
	_OMAP3_BALLENTRY(GPMC_D13, "u2", NULL),
	_OMAP3_BALLENTRY(GPMC_D14, "v1", NULL),
	_OMAP3_BALLENTRY(GPMC_D15, "v2", NULL),
	_OMAP3_BALLENTRY(GPMC_D8, "r2", NULL),
	_OMAP3_BALLENTRY(GPMC_D9, "t2", NULL),
	_OMAP3_BALLENTRY(GPMC_NBE0_CLE, "k5", NULL),
	_OMAP3_BALLENTRY(GPMC_NBE1, "l1", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS3, "d2", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS4, "f4", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS5, "g5", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS6, "f3", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS7, "g4", NULL),
	_OMAP3_BALLENTRY(GPMC_NWP, "e1", NULL),
	_OMAP3_BALLENTRY(GPMC_WAIT3, "c2", NULL),
	_OMAP3_BALLENTRY(HDQ_SIO, "a24", NULL),
	_OMAP3_BALLENTRY(HSUSB0_CLK, "r21", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA0, "t24", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA1, "t23", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA2, "u24", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA3, "u23", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA4, "w24", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA5, "v23", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA6, "w23", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA7, "t22", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DIR, "p23", NULL),
	_OMAP3_BALLENTRY(HSUSB0_NXT, "r22", NULL),
	_OMAP3_BALLENTRY(HSUSB0_STP, "r23", NULL),
	_OMAP3_BALLENTRY(I2C2_SCL, "ac15", NULL),
	_OMAP3_BALLENTRY(I2C2_SDA, "ac14", NULL),
	_OMAP3_BALLENTRY(I2C3_SCL, "ac13", NULL),
	_OMAP3_BALLENTRY(I2C3_SDA, "ac12", NULL),
	_OMAP3_BALLENTRY(I2C4_SCL, "y16", NULL),
	_OMAP3_BALLENTRY(I2C4_SDA, "y15", NULL),
	_OMAP3_BALLENTRY(JTAG_EMU0, "ac24", NULL),
	_OMAP3_BALLENTRY(JTAG_EMU1, "ad24", NULL),
	_OMAP3_BALLENTRY(MCBSP1_CLKR, "w19", NULL),
	_OMAP3_BALLENTRY(MCBSP1_CLKX, "v18", NULL),
	_OMAP3_BALLENTRY(MCBSP1_DR, "y18", NULL),
	_OMAP3_BALLENTRY(MCBSP1_DX, "w18", NULL),
	_OMAP3_BALLENTRY(MCBSP1_FSR, "ab20", NULL),
	_OMAP3_BALLENTRY(MCBSP1_FSX, "aa19", NULL),
	_OMAP3_BALLENTRY(MCBSP2_CLKX, "t21", NULL),
	_OMAP3_BALLENTRY(MCBSP2_DR, "v19", NULL),
	_OMAP3_BALLENTRY(MCBSP2_DX, "r20", NULL),
	_OMAP3_BALLENTRY(MCBSP2_FSX, "v20", NULL),
	_OMAP3_BALLENTRY(MCBSP3_CLKX, "w4", NULL),
	_OMAP3_BALLENTRY(MCBSP3_DR, "v5", NULL),
	_OMAP3_BALLENTRY(MCBSP3_DX, "v6", NULL),
	_OMAP3_BALLENTRY(MCBSP3_FSX, "v4", NULL),
	_OMAP3_BALLENTRY(MCBSP_CLKS, "aa18", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CLK, "t5", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS0, "t6", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS3, "r5", NULL),
	_OMAP3_BALLENTRY(MCSPI1_SIMO, "r4", NULL),
	_OMAP3_BALLENTRY(MCSPI1_SOMI, "t4", NULL),
	_OMAP3_BALLENTRY(MCSPI2_CLK, "n5", NULL),
	_OMAP3_BALLENTRY(MCSPI2_CS0, "m5", NULL),
	_OMAP3_BALLENTRY(MCSPI2_CS1, "m4", NULL),
	_OMAP3_BALLENTRY(MCSPI2_SIMO, "n4", NULL),
	_OMAP3_BALLENTRY(MCSPI2_SOMI, "n3", NULL),
	_OMAP3_BALLENTRY(SDMMC1_CLK, "m23", NULL),
	_OMAP3_BALLENTRY(SDMMC1_CMD, "l23", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT0, "m22", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT1, "m21", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT2, "m20", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT3, "n23", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT4, "n22", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT5, "n21", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT6, "n20", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT7, "p24", NULL),
	_OMAP3_BALLENTRY(SDMMC2_CLK, "y1", NULL),
	_OMAP3_BALLENTRY(SDMMC2_CMD, "ab5", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT0, "ab3", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT1, "y3", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT2, "w3", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT3, "v3", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT4, "ab2", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT5, "aa2", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT6, "y2", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT7, "aa1", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT0, "ab12", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT1, "ac16", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT2, "ad17", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT3, "ad18", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT4, "ac17", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT5, "ab16", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT6, "aa15", NULL),
	_OMAP3_BALLENTRY(SYS_CLKOUT1, "y7", NULL),
	_OMAP3_BALLENTRY(SYS_CLKOUT2, "aa6", NULL),
	_OMAP3_BALLENTRY(SYS_CLKREQ, "y13", NULL),
	_OMAP3_BALLENTRY(SYS_NIRQ, "w16", NULL),
	_OMAP3_BALLENTRY(SYS_NRESWARM, "y10", NULL),
	_OMAP3_BALLENTRY(SYS_OFF_MODE, "ad23", NULL),
	_OMAP3_BALLENTRY(UART1_CTS, "ac2", NULL),
	_OMAP3_BALLENTRY(UART1_RTS, "w6", NULL),
	_OMAP3_BALLENTRY(UART1_RX, "v7", NULL),
	_OMAP3_BALLENTRY(UART1_TX, "w7", NULL),
	_OMAP3_BALLENTRY(UART3_CTS_RCTX, "a23", NULL),
	_OMAP3_BALLENTRY(UART3_RTS_SD, "b23", NULL),
	_OMAP3_BALLENTRY(UART3_RX_IRRX, "b24", NULL),
	_OMAP3_BALLENTRY(UART3_TX_IRTX, "c23", NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#else
#define omap3_cus_ball	 NULL
#endif

/*
 * Signals different on CBB package comapared to superset
 */
#if defined(CONFIG_OMAP_MUX) && defined(CONFIG_OMAP_PACKAGE_CBB)
static struct omap_mux __initdata omap3_cbb_subset[] = {
	_OMAP3_MUXENTRY(CAM_D10, 109,
		"cam_d10", NULL, NULL, NULL,
		"gpio_109", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D11, 110,
		"cam_d11", NULL, NULL, NULL,
		"gpio_110", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D2, 101,
		"cam_d2", NULL, NULL, NULL,
		"gpio_101", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D3, 102,
		"cam_d3", NULL, NULL, NULL,
		"gpio_102", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D4, 103,
		"cam_d4", NULL, NULL, NULL,
		"gpio_103", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D5, 104,
		"cam_d5", NULL, NULL, NULL,
		"gpio_104", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_FLD, 98,
		"cam_fld", NULL, "cam_global_reset", NULL,
		"gpio_98", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_HS, 94,
		"cam_hs", NULL, NULL, NULL,
		"gpio_94", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_PCLK, 97,
		"cam_pclk", NULL, NULL, NULL,
		"gpio_97", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_STROBE, 126,
		"cam_strobe", NULL, NULL, NULL,
		"gpio_126", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_VS, 95,
		"cam_vs", NULL, NULL, NULL,
		"gpio_95", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_WEN, 167,
		"cam_wen", NULL, "cam_shutter", NULL,
		"gpio_167", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA6, 76,
		"dss_data6", NULL, "uart1_tx", NULL,
		"gpio_76", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA7, 77,
		"dss_data7", NULL, "uart1_rx", NULL,
		"gpio_77", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA8, 78,
		"dss_data8", NULL, NULL, NULL,
		"gpio_78", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA9, 79,
		"dss_data9", NULL, NULL, NULL,
		"gpio_79", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_HSYNC, 67,
		"dss_hsync", NULL, NULL, NULL,
		"gpio_67", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_PCLK, 66,
		"dss_pclk", NULL, NULL, NULL,
		"gpio_66", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(ETK_CLK, 12,
		"etk_clk", "mcbsp5_clkx", "sdmmc3_clk", "hsusb1_stp",
		"gpio_12", "mm1_rxdp", "hsusb1_tll_stp", NULL),
	_OMAP3_MUXENTRY(ETK_CTL, 13,
		"etk_ctl", NULL, "sdmmc3_cmd", "hsusb1_clk",
		"gpio_13", NULL, "hsusb1_tll_clk", NULL),
	_OMAP3_MUXENTRY(ETK_D0, 14,
		"etk_d0", "mcspi3_simo", "sdmmc3_dat4", "hsusb1_data0",
		"gpio_14", "mm1_rxrcv", "hsusb1_tll_data0", NULL),
	_OMAP3_MUXENTRY(ETK_D1, 15,
		"etk_d1", "mcspi3_somi", NULL, "hsusb1_data1",
		"gpio_15", "mm1_txse0", "hsusb1_tll_data1", NULL),
	_OMAP3_MUXENTRY(ETK_D10, 24,
		"etk_d10", NULL, "uart1_rx", "hsusb2_clk",
		"gpio_24", NULL, "hsusb2_tll_clk", NULL),
	_OMAP3_MUXENTRY(ETK_D11, 25,
		"etk_d11", NULL, NULL, "hsusb2_stp",
		"gpio_25", "mm2_rxdp", "hsusb2_tll_stp", NULL),
	_OMAP3_MUXENTRY(ETK_D12, 26,
		"etk_d12", NULL, NULL, "hsusb2_dir",
		"gpio_26", NULL, "hsusb2_tll_dir", NULL),
	_OMAP3_MUXENTRY(ETK_D13, 27,
		"etk_d13", NULL, NULL, "hsusb2_nxt",
		"gpio_27", "mm2_rxdm", "hsusb2_tll_nxt", NULL),
	_OMAP3_MUXENTRY(ETK_D14, 28,
		"etk_d14", NULL, NULL, "hsusb2_data0",
		"gpio_28", "mm2_rxrcv", "hsusb2_tll_data0", NULL),
	_OMAP3_MUXENTRY(ETK_D15, 29,
		"etk_d15", NULL, NULL, "hsusb2_data1",
		"gpio_29", "mm2_txse0", "hsusb2_tll_data1", NULL),
	_OMAP3_MUXENTRY(ETK_D2, 16,
		"etk_d2", "mcspi3_cs0", NULL, "hsusb1_data2",
		"gpio_16", "mm1_txdat", "hsusb1_tll_data2", NULL),
	_OMAP3_MUXENTRY(ETK_D3, 17,
		"etk_d3", "mcspi3_clk", "sdmmc3_dat3", "hsusb1_data7",
		"gpio_17", NULL, "hsusb1_tll_data7", NULL),
	_OMAP3_MUXENTRY(ETK_D4, 18,
		"etk_d4", "mcbsp5_dr", "sdmmc3_dat0", "hsusb1_data4",
		"gpio_18", NULL, "hsusb1_tll_data4", NULL),
	_OMAP3_MUXENTRY(ETK_D5, 19,
		"etk_d5", "mcbsp5_fsx", "sdmmc3_dat1", "hsusb1_data5",
		"gpio_19", NULL, "hsusb1_tll_data5", NULL),
	_OMAP3_MUXENTRY(ETK_D6, 20,
		"etk_d6", "mcbsp5_dx", "sdmmc3_dat2", "hsusb1_data6",
		"gpio_20", NULL, "hsusb1_tll_data6", NULL),
	_OMAP3_MUXENTRY(ETK_D7, 21,
		"etk_d7", "mcspi3_cs1", "sdmmc3_dat7", "hsusb1_data3",
		"gpio_21", "mm1_txen_n", "hsusb1_tll_data3", NULL),
	_OMAP3_MUXENTRY(ETK_D8, 22,
		"etk_d8", "sys_drm_msecure", "sdmmc3_dat6", "hsusb1_dir",
		"gpio_22", NULL, "hsusb1_tll_dir", NULL),
	_OMAP3_MUXENTRY(ETK_D9, 23,
		"etk_d9", "sys_secure_indicator", "sdmmc3_dat5", "hsusb1_nxt",
		"gpio_23", "mm1_rxdm", "hsusb1_tll_nxt", NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#else
#define omap3_cbb_subset	NULL
#endif

/*
 * Balls for CBB package
 * 515-pin s-PBGA Package, 0.50mm Ball Pitch (Top), 0.40mm Ball Pitch (Bottom)
 */
#if defined(CONFIG_OMAP_MUX) && defined(CONFIG_DEBUG_FS)		\
		&& defined(CONFIG_OMAP_PACKAGE_CBB)
static struct omap_ball __initdata omap3_cbb_ball[] = {
	_OMAP3_BALLENTRY(CAM_D0, "ag17", NULL),
	_OMAP3_BALLENTRY(CAM_D1, "ah17", NULL),
	_OMAP3_BALLENTRY(CAM_D10, "b25", NULL),
	_OMAP3_BALLENTRY(CAM_D11, "c26", NULL),
	_OMAP3_BALLENTRY(CAM_D2, "b24", NULL),
	_OMAP3_BALLENTRY(CAM_D3, "c24", NULL),
	_OMAP3_BALLENTRY(CAM_D4, "d24", NULL),
	_OMAP3_BALLENTRY(CAM_D5, "a25", NULL),
	_OMAP3_BALLENTRY(CAM_D6, "k28", NULL),
	_OMAP3_BALLENTRY(CAM_D7, "l28", NULL),
	_OMAP3_BALLENTRY(CAM_D8, "k27", NULL),
	_OMAP3_BALLENTRY(CAM_D9, "l27", NULL),
	_OMAP3_BALLENTRY(CAM_FLD, "c23", NULL),
	_OMAP3_BALLENTRY(CAM_HS, "a24", NULL),
	_OMAP3_BALLENTRY(CAM_PCLK, "c27", NULL),
	_OMAP3_BALLENTRY(CAM_STROBE, "d25", NULL),
	_OMAP3_BALLENTRY(CAM_VS, "a23", NULL),
	_OMAP3_BALLENTRY(CAM_WEN, "b23", NULL),
	_OMAP3_BALLENTRY(CAM_XCLKA, "c25", NULL),
	_OMAP3_BALLENTRY(CAM_XCLKB, "b26", NULL),
	_OMAP3_BALLENTRY(CSI2_DX0, "ag19", NULL),
	_OMAP3_BALLENTRY(CSI2_DX1, "ag18", NULL),
	_OMAP3_BALLENTRY(CSI2_DY0, "ah19", NULL),
	_OMAP3_BALLENTRY(CSI2_DY1, "ah18", NULL),
	_OMAP3_BALLENTRY(DSS_ACBIAS, "e27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA0, "ag22", NULL),
	_OMAP3_BALLENTRY(DSS_DATA1, "ah22", NULL),
	_OMAP3_BALLENTRY(DSS_DATA10, "ad28", NULL),
	_OMAP3_BALLENTRY(DSS_DATA11, "ad27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA12, "ab28", NULL),
	_OMAP3_BALLENTRY(DSS_DATA13, "ab27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA14, "aa28", NULL),
	_OMAP3_BALLENTRY(DSS_DATA15, "aa27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA16, "g25", NULL),
	_OMAP3_BALLENTRY(DSS_DATA17, "h27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA18, "h26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA19, "h25", NULL),
	_OMAP3_BALLENTRY(DSS_DATA2, "ag23", NULL),
	_OMAP3_BALLENTRY(DSS_DATA20, "e28", NULL),
	_OMAP3_BALLENTRY(DSS_DATA21, "j26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA22, "ac27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA23, "ac28", NULL),
	_OMAP3_BALLENTRY(DSS_DATA3, "ah23", NULL),
	_OMAP3_BALLENTRY(DSS_DATA4, "ag24", NULL),
	_OMAP3_BALLENTRY(DSS_DATA5, "ah24", NULL),
	_OMAP3_BALLENTRY(DSS_DATA6, "e26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA7, "f28", NULL),
	_OMAP3_BALLENTRY(DSS_DATA8, "f27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA9, "g26", NULL),
	_OMAP3_BALLENTRY(DSS_HSYNC, "d26", NULL),
	_OMAP3_BALLENTRY(DSS_PCLK, "d28", NULL),
	_OMAP3_BALLENTRY(DSS_VSYNC, "d27", NULL),
	_OMAP3_BALLENTRY(ETK_CLK, "af10", NULL),
	_OMAP3_BALLENTRY(ETK_CTL, "ae10", NULL),
	_OMAP3_BALLENTRY(ETK_D0, "af11", NULL),
	_OMAP3_BALLENTRY(ETK_D1, "ag12", NULL),
	_OMAP3_BALLENTRY(ETK_D10, "ae7", NULL),
	_OMAP3_BALLENTRY(ETK_D11, "af7", NULL),
	_OMAP3_BALLENTRY(ETK_D12, "ag7", NULL),
	_OMAP3_BALLENTRY(ETK_D13, "ah7", NULL),
	_OMAP3_BALLENTRY(ETK_D14, "ag8", NULL),
	_OMAP3_BALLENTRY(ETK_D15, "ah8", NULL),
	_OMAP3_BALLENTRY(ETK_D2, "ah12", NULL),
	_OMAP3_BALLENTRY(ETK_D3, "ae13", NULL),
	_OMAP3_BALLENTRY(ETK_D4, "ae11", NULL),
	_OMAP3_BALLENTRY(ETK_D5, "ah9", NULL),
	_OMAP3_BALLENTRY(ETK_D6, "af13", NULL),
	_OMAP3_BALLENTRY(ETK_D7, "ah14", NULL),
	_OMAP3_BALLENTRY(ETK_D8, "af9", NULL),
	_OMAP3_BALLENTRY(ETK_D9, "ag9", NULL),
	_OMAP3_BALLENTRY(GPMC_A1, "n4", "ac15"),
	_OMAP3_BALLENTRY(GPMC_A10, "k3", "ab19"),
	_OMAP3_BALLENTRY(GPMC_A2, "m4", "ab15"),
	_OMAP3_BALLENTRY(GPMC_A3, "l4", "ac16"),
	_OMAP3_BALLENTRY(GPMC_A4, "k4", "ab16"),
	_OMAP3_BALLENTRY(GPMC_A5, "t3", "ac17"),
	_OMAP3_BALLENTRY(GPMC_A6, "r3", "ab17"),
	_OMAP3_BALLENTRY(GPMC_A7, "n3", "ac18"),
	_OMAP3_BALLENTRY(GPMC_A8, "m3", "ab18"),
	_OMAP3_BALLENTRY(GPMC_A9, "l3", "ac19"),
	_OMAP3_BALLENTRY(GPMC_CLK, "t4", "w2"),
	_OMAP3_BALLENTRY(GPMC_D10, "p1", "ab4"),
	_OMAP3_BALLENTRY(GPMC_D11, "r1", "ac4"),
	_OMAP3_BALLENTRY(GPMC_D12, "r2", "ab6"),
	_OMAP3_BALLENTRY(GPMC_D13, "t2", "ac6"),
	_OMAP3_BALLENTRY(GPMC_D14, "w1", "ab7"),
	_OMAP3_BALLENTRY(GPMC_D15, "y1", "ac7"),
	_OMAP3_BALLENTRY(GPMC_D8, "h2", "ab3"),
	_OMAP3_BALLENTRY(GPMC_D9, "k2", "ac3"),
	_OMAP3_BALLENTRY(GPMC_NBE0_CLE, "g3", "ac12"),
	_OMAP3_BALLENTRY(GPMC_NBE1, "u3", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS1, "h3", "y1"),
	_OMAP3_BALLENTRY(GPMC_NCS2, "v8", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS3, "u8", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS4, "t8", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS5, "r8", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS6, "p8", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS7, "n8", NULL),
	_OMAP3_BALLENTRY(GPMC_NWP, "h1", "ab10"),
	_OMAP3_BALLENTRY(GPMC_WAIT1, "l8", "ac10"),
	_OMAP3_BALLENTRY(GPMC_WAIT2, "k8", NULL),
	_OMAP3_BALLENTRY(GPMC_WAIT3, "j8", NULL),
	_OMAP3_BALLENTRY(HDQ_SIO, "j25", NULL),
	_OMAP3_BALLENTRY(HSUSB0_CLK, "t28", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA0, "t27", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA1, "u28", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA2, "u27", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA3, "u26", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA4, "u25", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA5, "v28", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA6, "v27", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA7, "v26", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DIR, "r28", NULL),
	_OMAP3_BALLENTRY(HSUSB0_NXT, "t26", NULL),
	_OMAP3_BALLENTRY(HSUSB0_STP, "t25", NULL),
	_OMAP3_BALLENTRY(I2C2_SCL, "af15", NULL),
	_OMAP3_BALLENTRY(I2C2_SDA, "ae15", NULL),
	_OMAP3_BALLENTRY(I2C3_SCL, "af14", NULL),
	_OMAP3_BALLENTRY(I2C3_SDA, "ag14", NULL),
	_OMAP3_BALLENTRY(I2C4_SCL, "ad26", NULL),
	_OMAP3_BALLENTRY(I2C4_SDA, "ae26", NULL),
	_OMAP3_BALLENTRY(JTAG_EMU0, "aa11", NULL),
	_OMAP3_BALLENTRY(JTAG_EMU1, "aa10", NULL),
	_OMAP3_BALLENTRY(MCBSP1_CLKR, "y21", NULL),
	_OMAP3_BALLENTRY(MCBSP1_CLKX, "w21", NULL),
	_OMAP3_BALLENTRY(MCBSP1_DR, "u21", NULL),
	_OMAP3_BALLENTRY(MCBSP1_DX, "v21", NULL),
	_OMAP3_BALLENTRY(MCBSP1_FSR, "aa21", NULL),
	_OMAP3_BALLENTRY(MCBSP1_FSX, "k26", NULL),
	_OMAP3_BALLENTRY(MCBSP2_CLKX, "n21", NULL),
	_OMAP3_BALLENTRY(MCBSP2_DR, "r21", NULL),
	_OMAP3_BALLENTRY(MCBSP2_DX, "m21", NULL),
	_OMAP3_BALLENTRY(MCBSP2_FSX, "p21", NULL),
	_OMAP3_BALLENTRY(MCBSP3_CLKX, "af5", NULL),
	_OMAP3_BALLENTRY(MCBSP3_DR, "ae6", NULL),
	_OMAP3_BALLENTRY(MCBSP3_DX, "af6", NULL),
	_OMAP3_BALLENTRY(MCBSP3_FSX, "ae5", NULL),
	_OMAP3_BALLENTRY(MCBSP4_CLKX, "ae1", NULL),
	_OMAP3_BALLENTRY(MCBSP4_DR, "ad1", NULL),
	_OMAP3_BALLENTRY(MCBSP4_DX, "ad2", NULL),
	_OMAP3_BALLENTRY(MCBSP4_FSX, "ac1", NULL),
	_OMAP3_BALLENTRY(MCBSP_CLKS, "t21", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CLK, "ab3", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS0, "ac2", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS1, "ac3", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS2, "ab1", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS3, "ab2", NULL),
	_OMAP3_BALLENTRY(MCSPI1_SIMO, "ab4", NULL),
	_OMAP3_BALLENTRY(MCSPI1_SOMI, "aa4", NULL),
	_OMAP3_BALLENTRY(MCSPI2_CLK, "aa3", NULL),
	_OMAP3_BALLENTRY(MCSPI2_CS0, "y4", NULL),
	_OMAP3_BALLENTRY(MCSPI2_CS1, "v3", NULL),
	_OMAP3_BALLENTRY(MCSPI2_SIMO, "y2", NULL),
	_OMAP3_BALLENTRY(MCSPI2_SOMI, "y3", NULL),
	_OMAP3_BALLENTRY(SDMMC1_CLK, "n28", NULL),
	_OMAP3_BALLENTRY(SDMMC1_CMD, "m27", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT0, "n27", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT1, "n26", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT2, "n25", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT3, "p28", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT4, "p27", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT5, "p26", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT6, "r27", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT7, "r25", NULL),
	_OMAP3_BALLENTRY(SDMMC2_CLK, "ae2", NULL),
	_OMAP3_BALLENTRY(SDMMC2_CMD, "ag5", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT0, "ah5", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT1, "ah4", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT2, "ag4", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT3, "af4", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT4, "ae4", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT5, "ah3", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT6, "af3", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT7, "ae3", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT0, "ah26", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT1, "ag26", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT2, "ae14", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT3, "af18", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT4, "af19", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT5, "ae21", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT6, "af21", NULL),
	_OMAP3_BALLENTRY(SYS_CLKOUT1, "ag25", NULL),
	_OMAP3_BALLENTRY(SYS_CLKOUT2, "ae22", NULL),
	_OMAP3_BALLENTRY(SYS_CLKREQ, "af25", NULL),
	_OMAP3_BALLENTRY(SYS_NIRQ, "af26", NULL),
	_OMAP3_BALLENTRY(SYS_NRESWARM, "af24", NULL),
	_OMAP3_BALLENTRY(SYS_OFF_MODE, "af22", NULL),
	_OMAP3_BALLENTRY(UART1_CTS, "w8", NULL),
	_OMAP3_BALLENTRY(UART1_RTS, "aa9", NULL),
	_OMAP3_BALLENTRY(UART1_RX, "y8", NULL),
	_OMAP3_BALLENTRY(UART1_TX, "aa8", NULL),
	_OMAP3_BALLENTRY(UART2_CTS, "ab26", NULL),
	_OMAP3_BALLENTRY(UART2_RTS, "ab25", NULL),
	_OMAP3_BALLENTRY(UART2_RX, "ad25", NULL),
	_OMAP3_BALLENTRY(UART2_TX, "aa25", NULL),
	_OMAP3_BALLENTRY(UART3_CTS_RCTX, "h18", NULL),
	_OMAP3_BALLENTRY(UART3_RTS_SD, "h19", NULL),
	_OMAP3_BALLENTRY(UART3_RX_IRRX, "h20", NULL),
	_OMAP3_BALLENTRY(UART3_TX_IRTX, "h21", NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#else
#define omap3_cbb_ball	 NULL
#endif

/*
 * Signals different on 36XX CBP package comapared to 34XX CBC package
 */
#if defined(CONFIG_OMAP_MUX) && defined(CONFIG_OMAP_PACKAGE_CBP)
static struct omap_mux __initdata omap36xx_cbp_subset[] = {
	_OMAP3_MUXENTRY(CAM_D0, 99,
		"cam_d0", NULL, "csi2_dx2", NULL,
		"gpio_99", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D1, 100,
		"cam_d1", NULL, "csi2_dy2", NULL,
		"gpio_100", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D10, 109,
		"cam_d10", "ssi2_wake", NULL, NULL,
		"gpio_109", "hw_dbg8", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D2, 101,
		"cam_d2", "ssi2_rdy_tx", NULL, NULL,
		"gpio_101", "hw_dbg4", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D3, 102,
		"cam_d3", "ssi2_dat_rx", NULL, NULL,
		"gpio_102", "hw_dbg5", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D4, 103,
		"cam_d4", "ssi2_flag_rx", NULL, NULL,
		"gpio_103", "hw_dbg6", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_D5, 104,
		"cam_d5", "ssi2_rdy_rx", NULL, NULL,
		"gpio_104", "hw_dbg7", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_HS, 94,
		"cam_hs", "ssi2_dat_tx", NULL, NULL,
		"gpio_94", "hw_dbg0", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(CAM_VS, 95,
		"cam_vs", "ssi2_flag_tx", NULL, NULL,
		"gpio_95", "hw_dbg1", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA0, 70,
		"dss_data0", "dsi_dx0", "uart1_cts", NULL,
		"gpio_70", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA1, 71,
		"dss_data1", "dsi_dy0", "uart1_rts", NULL,
		"gpio_71", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA2, 72,
		"dss_data2", "dsi_dx1", NULL, NULL,
		"gpio_72", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA3, 73,
		"dss_data3", "dsi_dy1", NULL, NULL,
		"gpio_73", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA4, 74,
		"dss_data4", "dsi_dx2", "uart3_rx_irrx", NULL,
		"gpio_74", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA5, 75,
		"dss_data5", "dsi_dy2", "uart3_tx_irtx", NULL,
		"gpio_75", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA6, 76,
		"dss_data6", NULL, "uart1_tx", "dssvenc656_data6",
		"gpio_76", "hw_dbg14", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA7, 77,
		"dss_data7", NULL, "uart1_rx", "dssvenc656_data7",
		"gpio_77", "hw_dbg15", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA8, 78,
		"dss_data8", NULL, "uart3_rx_irrx", NULL,
		"gpio_78", "hw_dbg16", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(DSS_DATA9, 79,
		"dss_data9", NULL, "uart3_tx_irtx", NULL,
		"gpio_79", "hw_dbg17", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(ETK_D12, 26,
		"etk_d12", "sys_drm_msecure", NULL, "hsusb2_dir",
		"gpio_26", NULL, "hsusb2_tll_dir", "hw_dbg14"),
	_OMAP3_MUXENTRY(GPMC_A11, 0,
		"gpmc_a11", NULL, NULL, NULL,
		NULL, NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_WAIT2, 64,
		"gpmc_wait2", NULL, "uart4_tx", NULL,
		"gpio_64", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(GPMC_WAIT3, 65,
		"gpmc_wait3", "sys_ndmareq1", "uart4_rx", NULL,
		"gpio_65", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_DATA0, 125,
		"hsusb0_data0", NULL, "uart3_tx_irtx", NULL,
		"gpio_125", "uart2_tx", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_DATA1, 130,
		"hsusb0_data1", NULL, "uart3_rx_irrx", NULL,
		"gpio_130", "uart2_rx", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_DATA2, 131,
		"hsusb0_data2", NULL, "uart3_rts_sd", NULL,
		"gpio_131", "uart2_rts", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(HSUSB0_DATA3, 169,
		"hsusb0_data3", NULL, "uart3_cts_rctx", NULL,
		"gpio_169", "uart2_cts", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP1_CLKR, 156,
		"mcbsp1_clkr", "mcspi4_clk", "sim_cd", NULL,
		"gpio_156", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP1_FSR, 157,
		"mcbsp1_fsr", "adpllv2d_dithering_en1",
		"cam_global_reset", NULL,
		"gpio_157", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP4_CLKX, 152,
		"mcbsp4_clkx", "ssi1_dat_rx", NULL, NULL,
		"gpio_152", "hsusb3_tll_data1", "mm3_txse0", "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP4_DR, 153,
		"mcbsp4_dr", "ssi1_flag_rx", NULL, NULL,
		"gpio_153", "hsusb3_tll_data0", "mm3_rxrcv", "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP4_DX, 154,
		"mcbsp4_dx", "ssi1_rdy_rx", NULL, NULL,
		"gpio_154", "hsusb3_tll_data2", "mm3_txdat", "safe_mode"),
	_OMAP3_MUXENTRY(MCBSP4_FSX, 155,
		"mcbsp4_fsx", "ssi1_wake", NULL, NULL,
		"gpio_155", "hsusb3_tll_data3", "mm3_txen_n", "safe_mode"),
	_OMAP3_MUXENTRY(MCSPI1_CS1, 175,
		"mcspi1_cs1", "adpllv2d_dithering_en2", NULL, "sdmmc3_cmd",
		"gpio_175", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SAD2D_MBUSFLAG, 0,
		"sad2d_mbusflag", "mad2d_sbusflag", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD28, 0,
		"sad2d_mcad28", "mad2d_mcad28", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD29, 0,
		"sad2d_mcad29", "mad2d_mcad29", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD32, 0,
		"sad2d_mcad32", "mad2d_mcad32", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD33, 0,
		"sad2d_mcad33", "mad2d_mcad33", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD34, 0,
		"sad2d_mcad34", "mad2d_mcad34", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD35, 0,
		"sad2d_mcad35", "mad2d_mcad35", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MCAD36, 0,
		"sad2d_mcad36", "mad2d_mcad36", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MREAD, 0,
		"sad2d_mread", "mad2d_sread", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_MWRITE, 0,
		"sad2d_mwrite", "mad2d_swrite", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_SBUSFLAG, 0,
		"sad2d_sbusflag", "mad2d_mbusflag", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_SREAD, 0,
		"sad2d_sread", "mad2d_mread", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SAD2D_SWRITE, 0,
		"sad2d_swrite", "mad2d_mwrite", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_OMAP3_MUXENTRY(SDMMC1_CLK, 120,
		"sdmmc1_clk", "ms_clk", NULL, NULL,
		"gpio_120", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_CMD, 121,
		"sdmmc1_cmd", "ms_bs", NULL, NULL,
		"gpio_121", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_DAT0, 122,
		"sdmmc1_dat0", "ms_dat0", NULL, NULL,
		"gpio_122", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_DAT1, 123,
		"sdmmc1_dat1", "ms_dat1", NULL, NULL,
		"gpio_123", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_DAT2, 124,
		"sdmmc1_dat2", "ms_dat2", NULL, NULL,
		"gpio_124", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDMMC1_DAT3, 125,
		"sdmmc1_dat3", "ms_dat3", NULL, NULL,
		"gpio_125", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SDRC_CKE0, 0,
		"sdrc_cke0", NULL, NULL, NULL,
		NULL, NULL, NULL, "safe_mode_out1"),
	_OMAP3_MUXENTRY(SDRC_CKE1, 0,
		"sdrc_cke1", NULL, NULL, NULL,
		NULL, NULL, NULL, "safe_mode_out1"),
	_OMAP3_MUXENTRY(SIM_IO, 126,
		"sim_io", "sim_io_low_impedance", NULL, NULL,
		"gpio_126", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SIM_CLK, 127,
		"sim_clk", NULL, NULL, NULL,
		"gpio_127", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SIM_PWRCTRL, 128,
		"sim_pwrctrl", NULL, NULL, NULL,
		"gpio_128", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SIM_RST, 129,
		"sim_rst", NULL, NULL, NULL,
		"gpio_129", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_BOOT0, 2,
		"sys_boot0", NULL, NULL, "dss_data18",
		"gpio_2", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_BOOT1, 3,
		"sys_boot1", NULL, NULL, "dss_data19",
		"gpio_3", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_BOOT3, 5,
		"sys_boot3", NULL, NULL, "dss_data20",
		"gpio_5", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_BOOT4, 6,
		"sys_boot4", "sdmmc2_dir_dat2", NULL, "dss_data21",
		"gpio_6", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_BOOT5, 7,
		"sys_boot5", "sdmmc2_dir_dat3", NULL, "dss_data22",
		"gpio_7", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(SYS_BOOT6, 8,
		"sys_boot6", NULL, NULL, "dss_data23",
		"gpio_8", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART1_CTS, 150,
		"uart1_cts", "ssi1_rdy_tx", NULL, NULL,
		"gpio_150", "hsusb3_tll_clk", NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART1_RTS, 149,
		"uart1_rts", "ssi1_flag_tx", NULL, NULL,
		"gpio_149", NULL, NULL, "safe_mode"),
	_OMAP3_MUXENTRY(UART1_TX, 148,
		"uart1_tx", "ssi1_dat_tx", NULL, NULL,
		"gpio_148", NULL, NULL, "safe_mode"),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#else
#define omap36xx_cbp_subset	NULL
#endif

/*
 * Balls for 36XX CBP package
 * 515-pin s-PBGA Package, 0.50mm Ball Pitch (Top), 0.40mm Ball Pitch (Bottom)
 */
#if defined(CONFIG_OMAP_MUX) && defined(CONFIG_DEBUG_FS)		\
		&& defined (CONFIG_OMAP_PACKAGE_CBP)
static struct omap_ball __initdata omap36xx_cbp_ball[] = {
	_OMAP3_BALLENTRY(CAM_D0, "ag17", NULL),
	_OMAP3_BALLENTRY(CAM_D1, "ah17", NULL),
	_OMAP3_BALLENTRY(CAM_D10, "b25", NULL),
	_OMAP3_BALLENTRY(CAM_D11, "c26", NULL),
	_OMAP3_BALLENTRY(CAM_D2, "b24", NULL),
	_OMAP3_BALLENTRY(CAM_D3, "c24", NULL),
	_OMAP3_BALLENTRY(CAM_D4, "d24", NULL),
	_OMAP3_BALLENTRY(CAM_D5, "a25", NULL),
	_OMAP3_BALLENTRY(CAM_D6, "k28", NULL),
	_OMAP3_BALLENTRY(CAM_D7, "l28", NULL),
	_OMAP3_BALLENTRY(CAM_D8, "k27", NULL),
	_OMAP3_BALLENTRY(CAM_D9, "l27", NULL),
	_OMAP3_BALLENTRY(CAM_FLD, "c23", NULL),
	_OMAP3_BALLENTRY(CAM_HS, "a24", NULL),
	_OMAP3_BALLENTRY(CAM_PCLK, "c27", NULL),
	_OMAP3_BALLENTRY(CAM_STROBE, "d25", NULL),
	_OMAP3_BALLENTRY(CAM_VS, "a23", NULL),
	_OMAP3_BALLENTRY(CAM_WEN, "b23", NULL),
	_OMAP3_BALLENTRY(CAM_XCLKA, "c25", NULL),
	_OMAP3_BALLENTRY(CAM_XCLKB, "b26", NULL),
	_OMAP3_BALLENTRY(CSI2_DX0, "ag19", NULL),
	_OMAP3_BALLENTRY(CSI2_DX1, "ag18", NULL),
	_OMAP3_BALLENTRY(CSI2_DY0, "ah19", NULL),
	_OMAP3_BALLENTRY(CSI2_DY1, "ah18", NULL),
	_OMAP3_BALLENTRY(DSS_ACBIAS, "e27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA0, "ag22", NULL),
	_OMAP3_BALLENTRY(DSS_DATA1, "ah22", NULL),
	_OMAP3_BALLENTRY(DSS_DATA10, "ad28", NULL),
	_OMAP3_BALLENTRY(DSS_DATA11, "ad27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA12, "ab28", NULL),
	_OMAP3_BALLENTRY(DSS_DATA13, "ab27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA14, "aa28", NULL),
	_OMAP3_BALLENTRY(DSS_DATA15, "aa27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA16, "g25", NULL),
	_OMAP3_BALLENTRY(DSS_DATA17, "h27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA18, "h26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA19, "h25", NULL),
	_OMAP3_BALLENTRY(DSS_DATA2, "ag23", NULL),
	_OMAP3_BALLENTRY(DSS_DATA20, "e28", NULL),
	_OMAP3_BALLENTRY(DSS_DATA21, "j26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA22, "ac27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA23, "ac28", NULL),
	_OMAP3_BALLENTRY(DSS_DATA3, "ah23", NULL),
	_OMAP3_BALLENTRY(DSS_DATA4, "ag24", NULL),
	_OMAP3_BALLENTRY(DSS_DATA5, "ah24", NULL),
	_OMAP3_BALLENTRY(DSS_DATA6, "e26", NULL),
	_OMAP3_BALLENTRY(DSS_DATA7, "f28", NULL),
	_OMAP3_BALLENTRY(DSS_DATA8, "f27", NULL),
	_OMAP3_BALLENTRY(DSS_DATA9, "g26", NULL),
	_OMAP3_BALLENTRY(DSS_HSYNC, "d26", NULL),
	_OMAP3_BALLENTRY(DSS_PCLK, "d28", NULL),
	_OMAP3_BALLENTRY(DSS_VSYNC, "d27", NULL),
	_OMAP3_BALLENTRY(ETK_CLK, "af10", NULL),
	_OMAP3_BALLENTRY(ETK_CTL, "ae10", NULL),
	_OMAP3_BALLENTRY(ETK_D0, "af11", NULL),
	_OMAP3_BALLENTRY(ETK_D1, "ag12", NULL),
	_OMAP3_BALLENTRY(ETK_D10, "ae7", NULL),
	_OMAP3_BALLENTRY(ETK_D11, "af7", NULL),
	_OMAP3_BALLENTRY(ETK_D12, "ag7", NULL),
	_OMAP3_BALLENTRY(ETK_D13, "ah7", NULL),
	_OMAP3_BALLENTRY(ETK_D14, "ag8", NULL),
	_OMAP3_BALLENTRY(ETK_D15, "ah8", NULL),
	_OMAP3_BALLENTRY(ETK_D2, "ah12", NULL),
	_OMAP3_BALLENTRY(ETK_D3, "ae13", NULL),
	_OMAP3_BALLENTRY(ETK_D4, "ae11", NULL),
	_OMAP3_BALLENTRY(ETK_D5, "ah9", NULL),
	_OMAP3_BALLENTRY(ETK_D6, "af13", NULL),
	_OMAP3_BALLENTRY(ETK_D7, "ah14", NULL),
	_OMAP3_BALLENTRY(ETK_D8, "af9", NULL),
	_OMAP3_BALLENTRY(ETK_D9, "ag9", NULL),
	_OMAP3_BALLENTRY(GPMC_A1, "n4", "ac15"),
	_OMAP3_BALLENTRY(GPMC_A10, "k3", "ab19"),
	_OMAP3_BALLENTRY(GPMC_A11, NULL, "ac20"),
	_OMAP3_BALLENTRY(GPMC_A2, "m4", "ab15"),
	_OMAP3_BALLENTRY(GPMC_A3, "l4", "ac16"),
	_OMAP3_BALLENTRY(GPMC_A4, "k4", "ab16"),
	_OMAP3_BALLENTRY(GPMC_A5, "t3", "ac17"),
	_OMAP3_BALLENTRY(GPMC_A6, "r3", "ab17"),
	_OMAP3_BALLENTRY(GPMC_A7, "n3", "ac18"),
	_OMAP3_BALLENTRY(GPMC_A8, "m3", "ab18"),
	_OMAP3_BALLENTRY(GPMC_A9, "l3", "ac19"),
	_OMAP3_BALLENTRY(GPMC_CLK, "t4", "w2"),
	_OMAP3_BALLENTRY(GPMC_D10, "p1", "ab4"),
	_OMAP3_BALLENTRY(GPMC_D11, "r1", "ac4"),
	_OMAP3_BALLENTRY(GPMC_D12, "r2", "ab6"),
	_OMAP3_BALLENTRY(GPMC_D13, "t2", "ac6"),
	_OMAP3_BALLENTRY(GPMC_D14, "w1", "ab7"),
	_OMAP3_BALLENTRY(GPMC_D15, "y1", "ac7"),
	_OMAP3_BALLENTRY(GPMC_D9, "k2", "ac3"),
	_OMAP3_BALLENTRY(GPMC_NBE0_CLE, "g3", "ac12"),
	_OMAP3_BALLENTRY(GPMC_NBE1, "u3", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS1, "h3", "y1"),
	_OMAP3_BALLENTRY(GPMC_NCS2, "v8", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS3, "u8", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS4, "t8", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS5, "r8", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS6, "p8", NULL),
	_OMAP3_BALLENTRY(GPMC_NCS7, "n8", NULL),
	_OMAP3_BALLENTRY(GPMC_NWP, "h1", "ab10"),
	_OMAP3_BALLENTRY(GPMC_WAIT1, "l8", "ac10"),
	_OMAP3_BALLENTRY(GPMC_WAIT2, "k8", NULL),
	_OMAP3_BALLENTRY(GPMC_WAIT3, "j8", NULL),
	_OMAP3_BALLENTRY(HDQ_SIO, "j25", NULL),
	_OMAP3_BALLENTRY(HSUSB0_CLK, "t28", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA0, "t27", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA1, "u28", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA2, "u27", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA3, "u26", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA4, "u25", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA5, "v28", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA6, "v27", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DATA7, "v26", NULL),
	_OMAP3_BALLENTRY(HSUSB0_DIR, "r28", NULL),
	_OMAP3_BALLENTRY(HSUSB0_NXT, "t26", NULL),
	_OMAP3_BALLENTRY(HSUSB0_STP, "t25", NULL),
	_OMAP3_BALLENTRY(I2C2_SCL, "af15", NULL),
	_OMAP3_BALLENTRY(I2C2_SDA, "ae15", NULL),
	_OMAP3_BALLENTRY(I2C3_SCL, "af14", NULL),
	_OMAP3_BALLENTRY(I2C3_SDA, "ag14", NULL),
	_OMAP3_BALLENTRY(I2C4_SCL, "ad26", NULL),
	_OMAP3_BALLENTRY(I2C4_SDA, "ae26", NULL),
	_OMAP3_BALLENTRY(JTAG_EMU0, "aa11", NULL),
	_OMAP3_BALLENTRY(JTAG_EMU1, "aa10", NULL),
	_OMAP3_BALLENTRY(MCBSP1_CLKR, "y21", NULL),
	_OMAP3_BALLENTRY(MCBSP1_CLKX, "w21", NULL),
	_OMAP3_BALLENTRY(MCBSP1_DR, "u21", NULL),
	_OMAP3_BALLENTRY(MCBSP1_DX, "v21", NULL),
	_OMAP3_BALLENTRY(MCBSP1_FSR, "aa21", NULL),
	_OMAP3_BALLENTRY(MCBSP1_FSX, "k26", NULL),
	_OMAP3_BALLENTRY(MCBSP2_CLKX, "n21", NULL),
	_OMAP3_BALLENTRY(MCBSP2_DR, "r21", NULL),
	_OMAP3_BALLENTRY(MCBSP2_DX, "m21", NULL),
	_OMAP3_BALLENTRY(MCBSP2_FSX, "p21", NULL),
	_OMAP3_BALLENTRY(MCBSP3_CLKX, "af5", NULL),
	_OMAP3_BALLENTRY(MCBSP3_DR, "ae6", NULL),
	_OMAP3_BALLENTRY(MCBSP3_DX, "af6", NULL),
	_OMAP3_BALLENTRY(MCBSP3_FSX, "ae5", NULL),
	_OMAP3_BALLENTRY(MCBSP4_CLKX, "ae1", NULL),
	_OMAP3_BALLENTRY(MCBSP4_DR, "ad1", NULL),
	_OMAP3_BALLENTRY(MCBSP4_DX, "ad2", NULL),
	_OMAP3_BALLENTRY(MCBSP4_FSX, "ac1", NULL),
	_OMAP3_BALLENTRY(MCBSP_CLKS, "t21", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CLK, "ab3", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS0, "ac2", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS1, "ac3", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS2, "ab1", NULL),
	_OMAP3_BALLENTRY(MCSPI1_CS3, "ab2", NULL),
	_OMAP3_BALLENTRY(MCSPI1_SIMO, "ab4", NULL),
	_OMAP3_BALLENTRY(MCSPI1_SOMI, "aa4", NULL),
	_OMAP3_BALLENTRY(MCSPI2_CLK, "aa3", NULL),
	_OMAP3_BALLENTRY(MCSPI2_CS0, "y4", NULL),
	_OMAP3_BALLENTRY(MCSPI2_CS1, "v3", NULL),
	_OMAP3_BALLENTRY(MCSPI2_SIMO, "y2", NULL),
	_OMAP3_BALLENTRY(MCSPI2_SOMI, "y3", NULL),
	_OMAP3_BALLENTRY(SDMMC1_CLK, "n28", NULL),
	_OMAP3_BALLENTRY(SDMMC1_CMD, "m27", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT0, "n27", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT1, "n26", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT2, "n25", NULL),
	_OMAP3_BALLENTRY(SDMMC1_DAT3, "p28", NULL),
	_OMAP3_BALLENTRY(SDMMC2_CLK, "ae2", NULL),
	_OMAP3_BALLENTRY(SDMMC2_CMD, "ag5", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT0, "ah5", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT1, "ah4", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT2, "ag4", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT3, "af4", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT4, "ae4", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT5, "ah3", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT6, "af3", NULL),
	_OMAP3_BALLENTRY(SDMMC2_DAT7, "ae3", NULL),
	_OMAP3_BALLENTRY(SDRC_CKE0, "h16", "j22"),
	_OMAP3_BALLENTRY(SDRC_CKE1, "h17", "j23"),
	_OMAP3_BALLENTRY(SIM_CLK, "p26", NULL),
	_OMAP3_BALLENTRY(SIM_IO, "p27", NULL),
	_OMAP3_BALLENTRY(SIM_PWRCTRL, "r27", NULL),
	_OMAP3_BALLENTRY(SIM_RST, "r25", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT0, "ah26", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT1, "ag26", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT2, "ae14", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT3, "af18", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT4, "af19", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT5, "ae21", NULL),
	_OMAP3_BALLENTRY(SYS_BOOT6, "af21", NULL),
	_OMAP3_BALLENTRY(SYS_CLKOUT1, "ag25", NULL),
	_OMAP3_BALLENTRY(SYS_CLKOUT2, "ae22", NULL),
	_OMAP3_BALLENTRY(SYS_CLKREQ, "af25", NULL),
	_OMAP3_BALLENTRY(SYS_NIRQ, "af26", NULL),
	_OMAP3_BALLENTRY(SYS_NRESWARM, "af24", NULL),
	_OMAP3_BALLENTRY(SYS_OFF_MODE, "af22", NULL),
	_OMAP3_BALLENTRY(UART1_CTS, "w8", NULL),
	_OMAP3_BALLENTRY(UART1_RTS, "aa9", NULL),
	_OMAP3_BALLENTRY(UART1_RX, "y8", NULL),
	_OMAP3_BALLENTRY(UART1_TX, "aa8", NULL),
	_OMAP3_BALLENTRY(UART2_CTS, "ab26", NULL),
	_OMAP3_BALLENTRY(UART2_RTS, "ab25", NULL),
	_OMAP3_BALLENTRY(UART2_RX, "ad25", NULL),
	_OMAP3_BALLENTRY(UART2_TX, "aa25", NULL),
	_OMAP3_BALLENTRY(UART3_CTS_RCTX, "h18", NULL),
	_OMAP3_BALLENTRY(UART3_RTS_SD, "h19", NULL),
	_OMAP3_BALLENTRY(UART3_RX_IRRX, "h20", NULL),
	_OMAP3_BALLENTRY(UART3_TX_IRTX, "h21", NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#else
#define omap36xx_cbp_ball	 NULL
#endif

int __init omap3_mux_init(struct omap_board_mux *board_subset, int flags)
{
	struct omap_mux *package_subset;
	struct omap_ball *package_balls;

	switch (flags & OMAP_PACKAGE_MASK) {
	case OMAP_PACKAGE_CBC:
		package_subset = omap3_cbc_subset;
		package_balls = omap3_cbc_ball;
		break;
	case OMAP_PACKAGE_CBB:
		package_subset = omap3_cbb_subset;
		package_balls = omap3_cbb_ball;
		break;
	case OMAP_PACKAGE_CUS:
		package_subset = omap3_cus_subset;
		package_balls = omap3_cus_ball;
		break;
	case OMAP_PACKAGE_CBP:
		package_subset = omap36xx_cbp_subset;
		package_balls = omap36xx_cbp_ball;
		break;
	default:
		pr_err("%s Unknown omap package, mux disabled\n", __func__);
		return -EINVAL;
	}

	return omap_mux_init("core", 0,
			     OMAP3_CONTROL_PADCONF_MUX_PBASE,
			     OMAP3_CONTROL_PADCONF_MUX_SIZE,
			     omap3_muxmodes, package_subset, board_subset,
			     package_balls);
}
