/*
 * OMAP4 Clock data
 *
 * Copyright (C) 2009-2010 Texas Instruments, Inc.
 * Copyright (C) 2009-2010 Nokia Corporation
 *
 * Paul Walmsley (paul@pwsan.com)
 * Rajendra Nayak (rnayak@ti.com)
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * XXX Some of the ES1 clocks have been removed/changed; once support
 * is added for discriminating clocks by ES level, these should be added back
 * in.
 */

#include <linux/kernel.h>
#include <linux/list.h>
#include <linux/clk.h>
#include <plat/clkdev_omap.h>

#include "clock.h"
#include "clock44xx.h"
#include "cm1_44xx.h"
#include "cm2_44xx.h"
#include "cm-regbits-44xx.h"
#include "prm44xx.h"
#include "prm-regbits-44xx.h"
#include "control.h"
#include "scrm44xx.h"

/* OMAP4 modulemode control */
#define OMAP4430_MODULEMODE_HWCTRL			0
#define OMAP4430_MODULEMODE_SWCTRL			1

/* Root clocks */

static struct clk extalt_clkin_ck = {
	.name		= "extalt_clkin_ck",
	.rate		= 59000000,
	.ops		= &clkops_null,
};

static struct clk pad_clks_ck = {
	.name		= "pad_clks_ck",
	.rate		= 12000000,
	.ops            = &clkops_omap2_dflt,
	.enable_reg     = OMAP4430_CM_CLKSEL_ABE,
	.enable_bit     = OMAP4430_PAD_CLKS_GATE_SHIFT,
};

static struct clk pad_slimbus_core_clks_ck = {
	.name		= "pad_slimbus_core_clks_ck",
	.rate		= 12000000,
	.ops		= &clkops_null,
};

static struct clk secure_32k_clk_src_ck = {
	.name		= "secure_32k_clk_src_ck",
	.rate		= 32768,
	.ops		= &clkops_null,
};

static struct clk slimbus_clk = {
	.name		= "slimbus_clk",
	.rate		= 12000000,
	.ops            = &clkops_omap2_dflt,
	.enable_reg     = OMAP4430_CM_CLKSEL_ABE,
	.enable_bit     = OMAP4430_SLIMBUS_CLK_GATE_SHIFT,
};

static struct clk sys_32k_ck = {
	.name		= "sys_32k_ck",
	.rate		= 32768,
	.ops		= &clkops_null,
};

static struct clk virt_12000000_ck = {
	.name		= "virt_12000000_ck",
	.ops		= &clkops_null,
	.rate		= 12000000,
};

static struct clk virt_13000000_ck = {
	.name		= "virt_13000000_ck",
	.ops		= &clkops_null,
	.rate		= 13000000,
};

static struct clk virt_16800000_ck = {
	.name		= "virt_16800000_ck",
	.ops		= &clkops_null,
	.rate		= 16800000,
};

static struct clk virt_19200000_ck = {
	.name		= "virt_19200000_ck",
	.ops		= &clkops_null,
	.rate		= 19200000,
};

static struct clk virt_26000000_ck = {
	.name		= "virt_26000000_ck",
	.ops		= &clkops_null,
	.rate		= 26000000,
};

static struct clk virt_27000000_ck = {
	.name		= "virt_27000000_ck",
	.ops		= &clkops_null,
	.rate		= 27000000,
};

static struct clk virt_38400000_ck = {
	.name		= "virt_38400000_ck",
	.ops		= &clkops_null,
	.rate		= 38400000,
};

static const struct clksel_rate div_1_0_rates[] = {
	{ .div = 1, .val = 0, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel_rate div_1_1_rates[] = {
	{ .div = 1, .val = 1, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel_rate div_1_2_rates[] = {
	{ .div = 1, .val = 2, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel_rate div_1_3_rates[] = {
	{ .div = 1, .val = 3, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel_rate div_1_4_rates[] = {
	{ .div = 1, .val = 4, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel_rate div_1_5_rates[] = {
	{ .div = 1, .val = 5, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel_rate div_1_6_rates[] = {
	{ .div = 1, .val = 6, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel_rate div_1_7_rates[] = {
	{ .div = 1, .val = 7, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel sys_clkin_sel[] = {
	{ .parent = &virt_12000000_ck, .rates = div_1_1_rates },
	{ .parent = &virt_13000000_ck, .rates = div_1_2_rates },
	{ .parent = &virt_16800000_ck, .rates = div_1_3_rates },
	{ .parent = &virt_19200000_ck, .rates = div_1_4_rates },
	{ .parent = &virt_26000000_ck, .rates = div_1_5_rates },
	{ .parent = &virt_27000000_ck, .rates = div_1_6_rates },
	{ .parent = &virt_38400000_ck, .rates = div_1_7_rates },
	{ .parent = NULL },
};

static struct clk sys_clkin_ck = {
	.name		= "sys_clkin_ck",
	.rate		= 38400000,
	.clksel		= sys_clkin_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_SYS_CLKSEL,
	.clksel_mask	= OMAP4430_SYS_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk tie_low_clock_ck = {
	.name		= "tie_low_clock_ck",
	.rate		= 0,
	.ops		= &clkops_null,
};

static struct clk utmi_phy_clkout_ck = {
	.name		= "utmi_phy_clkout_ck",
	.rate		= 60000000,
	.ops		= &clkops_null,
};

static struct clk xclk60mhsp1_ck = {
	.name		= "xclk60mhsp1_ck",
	.rate		= 60000000,
	.ops		= &clkops_null,
};

static struct clk xclk60mhsp2_ck = {
	.name		= "xclk60mhsp2_ck",
	.rate		= 60000000,
	.ops		= &clkops_null,
};

static struct clk xclk60motg_ck = {
	.name		= "xclk60motg_ck",
	.rate		= 60000000,
	.ops		= &clkops_null,
};

/* Module clocks and DPLL outputs */

static const struct clksel abe_dpll_bypass_clk_mux_sel[] = {
	{ .parent = &sys_clkin_ck, .rates = div_1_0_rates },
	{ .parent = &sys_32k_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk abe_dpll_bypass_clk_mux_ck = {
	.name		= "abe_dpll_bypass_clk_mux_ck",
	.parent		= &sys_clkin_ck,
	.ops		= &clkops_null,
	.recalc		= &followparent_recalc,
};

static struct clk abe_dpll_refclk_mux_ck = {
	.name		= "abe_dpll_refclk_mux_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_ABE_PLL_REF_CLKSEL,
	.clksel_mask	= OMAP4430_CLKSEL_0_0_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

/* DPLL_ABE */
static struct dpll_data dpll_abe_dd = {
	.mult_div1_reg	= OMAP4430_CM_CLKSEL_DPLL_ABE,
	.clk_bypass	= &abe_dpll_bypass_clk_mux_ck,
	.clk_ref	= &abe_dpll_refclk_mux_ck,
	.control_reg	= OMAP4430_CM_CLKMODE_DPLL_ABE,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP4430_CM_AUTOIDLE_DPLL_ABE,
	.idlest_reg	= OMAP4430_CM_IDLEST_DPLL_ABE,
	.mult_mask	= OMAP4430_DPLL_MULT_MASK,
	.div1_mask	= OMAP4430_DPLL_DIV_MASK,
	.enable_mask	= OMAP4430_DPLL_EN_MASK,
	.autoidle_mask	= OMAP4430_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP4430_ST_DPLL_CLK_MASK,
	.max_multiplier	= OMAP4430_MAX_DPLL_MULT,
	.max_divider	= OMAP4430_MAX_DPLL_DIV,
	.min_divider	= 1,
};


static struct clk dpll_abe_ck = {
	.name		= "dpll_abe_ck",
	.parent		= &abe_dpll_refclk_mux_ck,
	.dpll_data	= &dpll_abe_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_noncore_dpll_ops,
	.recalc		= &omap3_dpll_recalc,
	.round_rate	= &omap2_dpll_round_rate,
	.set_rate	= &omap3_noncore_dpll_set_rate,
};

static struct clk dpll_abe_x2_ck = {
	.name		= "dpll_abe_x2_ck",
	.parent		= &dpll_abe_ck,
	.ops		= &clkops_null,
	.recalc		= &omap3_clkoutx2_recalc,
};

static const struct clksel_rate div31_1to31_rates[] = {
	{ .div = 1, .val = 1, .flags = RATE_IN_4430 },
	{ .div = 2, .val = 2, .flags = RATE_IN_4430 },
	{ .div = 3, .val = 3, .flags = RATE_IN_4430 },
	{ .div = 4, .val = 4, .flags = RATE_IN_4430 },
	{ .div = 5, .val = 5, .flags = RATE_IN_4430 },
	{ .div = 6, .val = 6, .flags = RATE_IN_4430 },
	{ .div = 7, .val = 7, .flags = RATE_IN_4430 },
	{ .div = 8, .val = 8, .flags = RATE_IN_4430 },
	{ .div = 9, .val = 9, .flags = RATE_IN_4430 },
	{ .div = 10, .val = 10, .flags = RATE_IN_4430 },
	{ .div = 11, .val = 11, .flags = RATE_IN_4430 },
	{ .div = 12, .val = 12, .flags = RATE_IN_4430 },
	{ .div = 13, .val = 13, .flags = RATE_IN_4430 },
	{ .div = 14, .val = 14, .flags = RATE_IN_4430 },
	{ .div = 15, .val = 15, .flags = RATE_IN_4430 },
	{ .div = 16, .val = 16, .flags = RATE_IN_4430 },
	{ .div = 17, .val = 17, .flags = RATE_IN_4430 },
	{ .div = 18, .val = 18, .flags = RATE_IN_4430 },
	{ .div = 19, .val = 19, .flags = RATE_IN_4430 },
	{ .div = 20, .val = 20, .flags = RATE_IN_4430 },
	{ .div = 21, .val = 21, .flags = RATE_IN_4430 },
	{ .div = 22, .val = 22, .flags = RATE_IN_4430 },
	{ .div = 23, .val = 23, .flags = RATE_IN_4430 },
	{ .div = 24, .val = 24, .flags = RATE_IN_4430 },
	{ .div = 25, .val = 25, .flags = RATE_IN_4430 },
	{ .div = 26, .val = 26, .flags = RATE_IN_4430 },
	{ .div = 27, .val = 27, .flags = RATE_IN_4430 },
	{ .div = 28, .val = 28, .flags = RATE_IN_4430 },
	{ .div = 29, .val = 29, .flags = RATE_IN_4430 },
	{ .div = 30, .val = 30, .flags = RATE_IN_4430 },
	{ .div = 31, .val = 31, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel dpll_abe_m2x2_div[] = {
	{ .parent = &dpll_abe_x2_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_abe_m2x2_ck = {
	.name		= "dpll_abe_m2x2_ck",
	.parent		= &dpll_abe_x2_ck,
	.clksel		= dpll_abe_m2x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M2_DPLL_ABE,
	.clksel_mask	= OMAP4430_DPLL_CLKOUT_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk abe_24m_fclk = {
	.name		= "abe_24m_fclk",
	.parent		= &dpll_abe_m2x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 8,
	.recalc		= &omap_fixed_divisor_recalc,
};

static const struct clksel_rate div3_1to4_rates[] = {
	{ .div = 1, .val = 0, .flags = RATE_IN_4430 },
	{ .div = 2, .val = 1, .flags = RATE_IN_4430 },
	{ .div = 4, .val = 2, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel abe_clk_div[] = {
	{ .parent = &dpll_abe_m2x2_ck, .rates = div3_1to4_rates },
	{ .parent = NULL },
};

static struct clk abe_clk = {
	.name		= "abe_clk",
	.parent		= &dpll_abe_m2x2_ck,
	.clksel		= abe_clk_div,
	.clksel_reg	= OMAP4430_CM_CLKSEL_ABE,
	.clksel_mask	= OMAP4430_CLKSEL_OPP_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel_rate div2_1to2_rates[] = {
	{ .div = 1, .val = 0, .flags = RATE_IN_4430 },
	{ .div = 2, .val = 1, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel aess_fclk_div[] = {
	{ .parent = &abe_clk, .rates = div2_1to2_rates },
	{ .parent = NULL },
};

static struct clk aess_fclk = {
	.name		= "aess_fclk",
	.parent		= &abe_clk,
	.clksel		= aess_fclk_div,
	.clksel_reg	= OMAP4430_CM1_ABE_AESS_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_AESS_FCLK_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_abe_m3x2_ck = {
	.name		= "dpll_abe_m3x2_ck",
	.parent		= &dpll_abe_x2_ck,
	.clksel		= dpll_abe_m2x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M3_DPLL_ABE,
	.clksel_mask	= OMAP4430_DPLL_CLKOUTHIF_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel core_hsd_byp_clk_mux_sel[] = {
	{ .parent = &sys_clkin_ck, .rates = div_1_0_rates },
	{ .parent = &dpll_abe_m3x2_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk core_hsd_byp_clk_mux_ck = {
	.name		= "core_hsd_byp_clk_mux_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= core_hsd_byp_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_CLKSEL_DPLL_CORE,
	.clksel_mask	= OMAP4430_DPLL_BYP_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

/* DPLL_CORE */
static struct dpll_data dpll_core_dd = {
	.mult_div1_reg	= OMAP4430_CM_CLKSEL_DPLL_CORE,
	.clk_bypass	= &core_hsd_byp_clk_mux_ck,
	.clk_ref	= &sys_clkin_ck,
	.control_reg	= OMAP4430_CM_CLKMODE_DPLL_CORE,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP4430_CM_AUTOIDLE_DPLL_CORE,
	.idlest_reg	= OMAP4430_CM_IDLEST_DPLL_CORE,
	.mult_mask	= OMAP4430_DPLL_MULT_MASK,
	.div1_mask	= OMAP4430_DPLL_DIV_MASK,
	.enable_mask	= OMAP4430_DPLL_EN_MASK,
	.autoidle_mask	= OMAP4430_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP4430_ST_DPLL_CLK_MASK,
	.max_multiplier	= OMAP4430_MAX_DPLL_MULT,
	.max_divider	= OMAP4430_MAX_DPLL_DIV,
	.min_divider	= 1,
};


static struct clk dpll_core_ck = {
	.name		= "dpll_core_ck",
	.parent		= &sys_clkin_ck,
	.dpll_data	= &dpll_core_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_null,
	.recalc		= &omap3_dpll_recalc,
};

static struct clk dpll_core_x2_ck = {
	.name		= "dpll_core_x2_ck",
	.parent		= &dpll_core_ck,
	.ops		= &clkops_null,
	.recalc		= &omap3_clkoutx2_recalc,
};

static const struct clksel dpll_core_m6x2_div[] = {
	{ .parent = &dpll_core_x2_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_core_m6x2_ck = {
	.name		= "dpll_core_m6x2_ck",
	.parent		= &dpll_core_x2_ck,
	.clksel		= dpll_core_m6x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M6_DPLL_CORE,
	.clksel_mask	= OMAP4430_HSDIVIDER_CLKOUT3_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel dbgclk_mux_sel[] = {
	{ .parent = &sys_clkin_ck, .rates = div_1_0_rates },
	{ .parent = &dpll_core_m6x2_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk dbgclk_mux_ck = {
	.name		= "dbgclk_mux_ck",
	.parent		= &sys_clkin_ck,
	.ops		= &clkops_null,
	.recalc		= &followparent_recalc,
};

static const struct clksel dpll_core_m2_div[] = {
	{ .parent = &dpll_core_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_core_m2_ck = {
	.name		= "dpll_core_m2_ck",
	.parent		= &dpll_core_ck,
	.clksel		= dpll_core_m2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M2_DPLL_CORE,
	.clksel_mask	= OMAP4430_DPLL_CLKOUT_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk ddrphy_ck = {
	.name		= "ddrphy_ck",
	.parent		= &dpll_core_m2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 2,
	.recalc		= &omap_fixed_divisor_recalc,
};

static struct clk dpll_core_m5x2_ck = {
	.name		= "dpll_core_m5x2_ck",
	.parent		= &dpll_core_x2_ck,
	.clksel		= dpll_core_m6x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M5_DPLL_CORE,
	.clksel_mask	= OMAP4430_HSDIVIDER_CLKOUT2_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel div_core_div[] = {
	{ .parent = &dpll_core_m5x2_ck, .rates = div2_1to2_rates },
	{ .parent = NULL },
};

static struct clk div_core_ck = {
	.name		= "div_core_ck",
	.parent		= &dpll_core_m5x2_ck,
	.clksel		= div_core_div,
	.clksel_reg	= OMAP4430_CM_CLKSEL_CORE,
	.clksel_mask	= OMAP4430_CLKSEL_CORE_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel_rate div4_1to8_rates[] = {
	{ .div = 1, .val = 0, .flags = RATE_IN_4430 },
	{ .div = 2, .val = 1, .flags = RATE_IN_4430 },
	{ .div = 4, .val = 2, .flags = RATE_IN_4430 },
	{ .div = 8, .val = 3, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel div_iva_hs_clk_div[] = {
	{ .parent = &dpll_core_m5x2_ck, .rates = div4_1to8_rates },
	{ .parent = NULL },
};

static struct clk div_iva_hs_clk = {
	.name		= "div_iva_hs_clk",
	.parent		= &dpll_core_m5x2_ck,
	.clksel		= div_iva_hs_clk_div,
	.clksel_reg	= OMAP4430_CM_BYPCLK_DPLL_IVA,
	.clksel_mask	= OMAP4430_CLKSEL_0_1_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk div_mpu_hs_clk = {
	.name		= "div_mpu_hs_clk",
	.parent		= &dpll_core_m5x2_ck,
	.clksel		= div_iva_hs_clk_div,
	.clksel_reg	= OMAP4430_CM_BYPCLK_DPLL_MPU,
	.clksel_mask	= OMAP4430_CLKSEL_0_1_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_core_m4x2_ck = {
	.name		= "dpll_core_m4x2_ck",
	.parent		= &dpll_core_x2_ck,
	.clksel		= dpll_core_m6x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M4_DPLL_CORE,
	.clksel_mask	= OMAP4430_HSDIVIDER_CLKOUT1_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dll_clk_div_ck = {
	.name		= "dll_clk_div_ck",
	.parent		= &dpll_core_m4x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 2,
	.recalc		= &omap_fixed_divisor_recalc,
};

static const struct clksel dpll_abe_m2_div[] = {
	{ .parent = &dpll_abe_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_abe_m2_ck = {
	.name		= "dpll_abe_m2_ck",
	.parent		= &dpll_abe_ck,
	.clksel		= dpll_abe_m2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M2_DPLL_ABE,
	.clksel_mask	= OMAP4430_DPLL_CLKOUT_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_core_m3x2_ck = {
	.name		= "dpll_core_m3x2_ck",
	.parent		= &dpll_core_x2_ck,
	.clksel		= dpll_core_m6x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M3_DPLL_CORE,
	.clksel_mask	= OMAP4430_DPLL_CLKOUTHIF_DIV_MASK,
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_DIV_M3_DPLL_CORE,
	.enable_bit	= OMAP4430_DPLL_CLKOUTHIF_GATE_CTRL_SHIFT,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_core_m7x2_ck = {
	.name		= "dpll_core_m7x2_ck",
	.parent		= &dpll_core_x2_ck,
	.clksel		= dpll_core_m6x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M7_DPLL_CORE,
	.clksel_mask	= OMAP4430_HSDIVIDER_CLKOUT4_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel iva_hsd_byp_clk_mux_sel[] = {
	{ .parent = &sys_clkin_ck, .rates = div_1_0_rates },
	{ .parent = &div_iva_hs_clk, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk iva_hsd_byp_clk_mux_ck = {
	.name		= "iva_hsd_byp_clk_mux_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= iva_hsd_byp_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_CLKSEL_DPLL_IVA,
	.clksel_mask	= OMAP4430_DPLL_BYP_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

/* DPLL_IVA */
static struct dpll_data dpll_iva_dd = {
	.mult_div1_reg	= OMAP4430_CM_CLKSEL_DPLL_IVA,
	.clk_bypass	= &iva_hsd_byp_clk_mux_ck,
	.clk_ref	= &sys_clkin_ck,
	.control_reg	= OMAP4430_CM_CLKMODE_DPLL_IVA,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP4430_CM_AUTOIDLE_DPLL_IVA,
	.idlest_reg	= OMAP4430_CM_IDLEST_DPLL_IVA,
	.mult_mask	= OMAP4430_DPLL_MULT_MASK,
	.div1_mask	= OMAP4430_DPLL_DIV_MASK,
	.enable_mask	= OMAP4430_DPLL_EN_MASK,
	.autoidle_mask	= OMAP4430_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP4430_ST_DPLL_CLK_MASK,
	.max_multiplier	= OMAP4430_MAX_DPLL_MULT,
	.max_divider	= OMAP4430_MAX_DPLL_DIV,
	.min_divider	= 1,
};


static struct clk dpll_iva_ck = {
	.name		= "dpll_iva_ck",
	.parent		= &sys_clkin_ck,
	.dpll_data	= &dpll_iva_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_noncore_dpll_ops,
	.recalc		= &omap3_dpll_recalc,
	.round_rate	= &omap2_dpll_round_rate,
	.set_rate	= &omap3_noncore_dpll_set_rate,
};

static struct clk dpll_iva_x2_ck = {
	.name		= "dpll_iva_x2_ck",
	.parent		= &dpll_iva_ck,
	.ops		= &clkops_null,
	.recalc		= &omap3_clkoutx2_recalc,
};

static const struct clksel dpll_iva_m4x2_div[] = {
	{ .parent = &dpll_iva_x2_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_iva_m4x2_ck = {
	.name		= "dpll_iva_m4x2_ck",
	.parent		= &dpll_iva_x2_ck,
	.clksel		= dpll_iva_m4x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M4_DPLL_IVA,
	.clksel_mask	= OMAP4430_HSDIVIDER_CLKOUT1_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_iva_m5x2_ck = {
	.name		= "dpll_iva_m5x2_ck",
	.parent		= &dpll_iva_x2_ck,
	.clksel		= dpll_iva_m4x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M5_DPLL_IVA,
	.clksel_mask	= OMAP4430_HSDIVIDER_CLKOUT2_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

/* DPLL_MPU */
static struct dpll_data dpll_mpu_dd = {
	.mult_div1_reg	= OMAP4430_CM_CLKSEL_DPLL_MPU,
	.clk_bypass	= &div_mpu_hs_clk,
	.clk_ref	= &sys_clkin_ck,
	.control_reg	= OMAP4430_CM_CLKMODE_DPLL_MPU,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP4430_CM_AUTOIDLE_DPLL_MPU,
	.idlest_reg	= OMAP4430_CM_IDLEST_DPLL_MPU,
	.mult_mask	= OMAP4430_DPLL_MULT_MASK,
	.div1_mask	= OMAP4430_DPLL_DIV_MASK,
	.enable_mask	= OMAP4430_DPLL_EN_MASK,
	.autoidle_mask	= OMAP4430_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP4430_ST_DPLL_CLK_MASK,
	.max_multiplier	= OMAP4430_MAX_DPLL_MULT,
	.max_divider	= OMAP4430_MAX_DPLL_DIV,
	.min_divider	= 1,
};


static struct clk dpll_mpu_ck = {
	.name		= "dpll_mpu_ck",
	.parent		= &sys_clkin_ck,
	.dpll_data	= &dpll_mpu_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_noncore_dpll_ops,
	.recalc		= &omap3_dpll_recalc,
	.round_rate	= &omap2_dpll_round_rate,
	.set_rate	= &omap3_noncore_dpll_set_rate,
};

static const struct clksel dpll_mpu_m2_div[] = {
	{ .parent = &dpll_mpu_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_mpu_m2_ck = {
	.name		= "dpll_mpu_m2_ck",
	.parent		= &dpll_mpu_ck,
	.clksel		= dpll_mpu_m2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M2_DPLL_MPU,
	.clksel_mask	= OMAP4430_DPLL_CLKOUT_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk per_hs_clk_div_ck = {
	.name		= "per_hs_clk_div_ck",
	.parent		= &dpll_abe_m3x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 2,
	.recalc		= &omap_fixed_divisor_recalc,
};

static const struct clksel per_hsd_byp_clk_mux_sel[] = {
	{ .parent = &sys_clkin_ck, .rates = div_1_0_rates },
	{ .parent = &per_hs_clk_div_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk per_hsd_byp_clk_mux_ck = {
	.name		= "per_hsd_byp_clk_mux_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= per_hsd_byp_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_CLKSEL_DPLL_PER,
	.clksel_mask	= OMAP4430_DPLL_BYP_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

/* DPLL_PER */
static struct dpll_data dpll_per_dd = {
	.mult_div1_reg	= OMAP4430_CM_CLKSEL_DPLL_PER,
	.clk_bypass	= &per_hsd_byp_clk_mux_ck,
	.clk_ref	= &sys_clkin_ck,
	.control_reg	= OMAP4430_CM_CLKMODE_DPLL_PER,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP4430_CM_AUTOIDLE_DPLL_PER,
	.idlest_reg	= OMAP4430_CM_IDLEST_DPLL_PER,
	.mult_mask	= OMAP4430_DPLL_MULT_MASK,
	.div1_mask	= OMAP4430_DPLL_DIV_MASK,
	.enable_mask	= OMAP4430_DPLL_EN_MASK,
	.autoidle_mask	= OMAP4430_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP4430_ST_DPLL_CLK_MASK,
	.max_multiplier	= OMAP4430_MAX_DPLL_MULT,
	.max_divider	= OMAP4430_MAX_DPLL_DIV,
	.min_divider	= 1,
};


static struct clk dpll_per_ck = {
	.name		= "dpll_per_ck",
	.parent		= &sys_clkin_ck,
	.dpll_data	= &dpll_per_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_noncore_dpll_ops,
	.recalc		= &omap3_dpll_recalc,
	.round_rate	= &omap2_dpll_round_rate,
	.set_rate	= &omap3_noncore_dpll_set_rate,
};

static const struct clksel dpll_per_m2_div[] = {
	{ .parent = &dpll_per_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_per_m2_ck = {
	.name		= "dpll_per_m2_ck",
	.parent		= &dpll_per_ck,
	.clksel		= dpll_per_m2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M2_DPLL_PER,
	.clksel_mask	= OMAP4430_DPLL_CLKOUT_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_per_x2_ck = {
	.name		= "dpll_per_x2_ck",
	.parent		= &dpll_per_ck,
	.ops		= &clkops_null,
	.recalc		= &omap3_clkoutx2_recalc,
};

static const struct clksel dpll_per_m2x2_div[] = {
	{ .parent = &dpll_per_x2_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_per_m2x2_ck = {
	.name		= "dpll_per_m2x2_ck",
	.parent		= &dpll_per_x2_ck,
	.clksel		= dpll_per_m2x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M2_DPLL_PER,
	.clksel_mask	= OMAP4430_DPLL_CLKOUT_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_per_m3x2_ck = {
	.name		= "dpll_per_m3x2_ck",
	.parent		= &dpll_per_x2_ck,
	.clksel		= dpll_per_m2x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M3_DPLL_PER,
	.clksel_mask	= OMAP4430_DPLL_CLKOUTHIF_DIV_MASK,
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_DIV_M3_DPLL_PER,
	.enable_bit	= OMAP4430_DPLL_CLKOUTHIF_GATE_CTRL_SHIFT,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_per_m4x2_ck = {
	.name		= "dpll_per_m4x2_ck",
	.parent		= &dpll_per_x2_ck,
	.clksel		= dpll_per_m2x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M4_DPLL_PER,
	.clksel_mask	= OMAP4430_HSDIVIDER_CLKOUT1_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_per_m5x2_ck = {
	.name		= "dpll_per_m5x2_ck",
	.parent		= &dpll_per_x2_ck,
	.clksel		= dpll_per_m2x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M5_DPLL_PER,
	.clksel_mask	= OMAP4430_HSDIVIDER_CLKOUT2_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_per_m6x2_ck = {
	.name		= "dpll_per_m6x2_ck",
	.parent		= &dpll_per_x2_ck,
	.clksel		= dpll_per_m2x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M6_DPLL_PER,
	.clksel_mask	= OMAP4430_HSDIVIDER_CLKOUT3_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_per_m7x2_ck = {
	.name		= "dpll_per_m7x2_ck",
	.parent		= &dpll_per_x2_ck,
	.clksel		= dpll_per_m2x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M7_DPLL_PER,
	.clksel_mask	= OMAP4430_HSDIVIDER_CLKOUT4_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

/* DPLL_UNIPRO */
static struct dpll_data dpll_unipro_dd = {
	.mult_div1_reg	= OMAP4430_CM_CLKSEL_DPLL_UNIPRO,
	.clk_bypass	= &sys_clkin_ck,
	.clk_ref	= &sys_clkin_ck,
	.control_reg	= OMAP4430_CM_CLKMODE_DPLL_UNIPRO,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP4430_CM_AUTOIDLE_DPLL_UNIPRO,
	.idlest_reg	= OMAP4430_CM_IDLEST_DPLL_UNIPRO,
	.mult_mask	= OMAP4430_DPLL_MULT_MASK,
	.div1_mask	= OMAP4430_DPLL_DIV_MASK,
	.enable_mask	= OMAP4430_DPLL_EN_MASK,
	.autoidle_mask	= OMAP4430_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP4430_ST_DPLL_CLK_MASK,
	.sddiv_mask	= OMAP4430_DPLL_SD_DIV_MASK,
	.max_multiplier	= OMAP4430_MAX_DPLL_MULT,
	.max_divider	= OMAP4430_MAX_DPLL_DIV,
	.min_divider	= 1,
};


static struct clk dpll_unipro_ck = {
	.name		= "dpll_unipro_ck",
	.parent		= &sys_clkin_ck,
	.dpll_data	= &dpll_unipro_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_noncore_dpll_ops,
	.recalc		= &omap3_dpll_recalc,
	.round_rate	= &omap2_dpll_round_rate,
	.set_rate	= &omap3_noncore_dpll_set_rate,
};

static struct clk dpll_unipro_x2_ck = {
	.name		= "dpll_unipro_x2_ck",
	.parent		= &dpll_unipro_ck,
	.ops		= &clkops_null,
	.recalc		= &omap3_clkoutx2_recalc,
};

static const struct clksel dpll_unipro_m2x2_div[] = {
	{ .parent = &dpll_unipro_x2_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_unipro_m2x2_ck = {
	.name		= "dpll_unipro_m2x2_ck",
	.parent		= &dpll_unipro_x2_ck,
	.clksel		= dpll_unipro_m2x2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M2_DPLL_UNIPRO,
	.clksel_mask	= OMAP4430_DPLL_CLKOUT_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk usb_hs_clk_div_ck = {
	.name		= "usb_hs_clk_div_ck",
	.parent		= &dpll_abe_m3x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 3,
	.recalc		= &omap_fixed_divisor_recalc,
};

/* DPLL_USB */
static struct dpll_data dpll_usb_dd = {
	.mult_div1_reg	= OMAP4430_CM_CLKSEL_DPLL_USB,
	.clk_bypass	= &usb_hs_clk_div_ck,
	.flags		= DPLL_J_TYPE,
	.clk_ref	= &sys_clkin_ck,
	.control_reg	= OMAP4430_CM_CLKMODE_DPLL_USB,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP4430_CM_AUTOIDLE_DPLL_USB,
	.idlest_reg	= OMAP4430_CM_IDLEST_DPLL_USB,
	.mult_mask	= OMAP4430_DPLL_MULT_MASK,
	.div1_mask	= OMAP4430_DPLL_DIV_MASK,
	.enable_mask	= OMAP4430_DPLL_EN_MASK,
	.autoidle_mask	= OMAP4430_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP4430_ST_DPLL_CLK_MASK,
	.max_multiplier	= OMAP4430_MAX_DPLL_MULT,
	.max_divider	= OMAP4430_MAX_DPLL_DIV,
	.min_divider	= 1,
};


static struct clk dpll_usb_ck = {
	.name		= "dpll_usb_ck",
	.parent		= &sys_clkin_ck,
	.dpll_data	= &dpll_usb_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_noncore_dpll_ops,
	.recalc		= &omap3_dpll_recalc,
	.round_rate	= &omap2_dpll_round_rate,
	.set_rate	= &omap3_noncore_dpll_set_rate,
};

static struct clk dpll_usb_clkdcoldo_ck = {
	.name		= "dpll_usb_clkdcoldo_ck",
	.parent		= &dpll_usb_ck,
	.ops		= &clkops_null,
	.recalc		= &followparent_recalc,
};

static const struct clksel dpll_usb_m2_div[] = {
	{ .parent = &dpll_usb_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_usb_m2_ck = {
	.name		= "dpll_usb_m2_ck",
	.parent		= &dpll_usb_ck,
	.clksel		= dpll_usb_m2_div,
	.clksel_reg	= OMAP4430_CM_DIV_M2_DPLL_USB,
	.clksel_mask	= OMAP4430_DPLL_CLKOUT_DIV_0_6_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel ducati_clk_mux_sel[] = {
	{ .parent = &div_core_ck, .rates = div_1_0_rates },
	{ .parent = &dpll_per_m6x2_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk ducati_clk_mux_ck = {
	.name		= "ducati_clk_mux_ck",
	.parent		= &div_core_ck,
	.clksel		= ducati_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_CLKSEL_DUCATI_ISS_ROOT,
	.clksel_mask	= OMAP4430_CLKSEL_0_0_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk func_12m_fclk = {
	.name		= "func_12m_fclk",
	.parent		= &dpll_per_m2x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 16,
	.recalc		= &omap_fixed_divisor_recalc,
};

static struct clk func_24m_clk = {
	.name		= "func_24m_clk",
	.parent		= &dpll_per_m2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 4,
	.recalc		= &omap_fixed_divisor_recalc,
};

static struct clk func_24mc_fclk = {
	.name		= "func_24mc_fclk",
	.parent		= &dpll_per_m2x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 8,
	.recalc		= &omap_fixed_divisor_recalc,
};

static const struct clksel_rate div2_4to8_rates[] = {
	{ .div = 4, .val = 0, .flags = RATE_IN_4430 },
	{ .div = 8, .val = 1, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel func_48m_fclk_div[] = {
	{ .parent = &dpll_per_m2x2_ck, .rates = div2_4to8_rates },
	{ .parent = NULL },
};

static struct clk func_48m_fclk = {
	.name		= "func_48m_fclk",
	.parent		= &dpll_per_m2x2_ck,
	.clksel		= func_48m_fclk_div,
	.clksel_reg	= OMAP4430_CM_SCALE_FCLK,
	.clksel_mask	= OMAP4430_SCALE_FCLK_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk func_48mc_fclk = {
	.name		= "func_48mc_fclk",
	.parent		= &dpll_per_m2x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 4,
	.recalc		= &omap_fixed_divisor_recalc,
};

static const struct clksel_rate div2_2to4_rates[] = {
	{ .div = 2, .val = 0, .flags = RATE_IN_4430 },
	{ .div = 4, .val = 1, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel func_64m_fclk_div[] = {
	{ .parent = &dpll_per_m4x2_ck, .rates = div2_2to4_rates },
	{ .parent = NULL },
};

static struct clk func_64m_fclk = {
	.name		= "func_64m_fclk",
	.parent		= &dpll_per_m4x2_ck,
	.clksel		= func_64m_fclk_div,
	.clksel_reg	= OMAP4430_CM_SCALE_FCLK,
	.clksel_mask	= OMAP4430_SCALE_FCLK_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel func_96m_fclk_div[] = {
	{ .parent = &dpll_per_m2x2_ck, .rates = div2_2to4_rates },
	{ .parent = NULL },
};

static struct clk func_96m_fclk = {
	.name		= "func_96m_fclk",
	.parent		= &dpll_per_m2x2_ck,
	.clksel		= func_96m_fclk_div,
	.clksel_reg	= OMAP4430_CM_SCALE_FCLK,
	.clksel_mask	= OMAP4430_SCALE_FCLK_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel hsmmc6_fclk_sel[] = {
	{ .parent = &func_64m_fclk, .rates = div_1_0_rates },
	{ .parent = &func_96m_fclk, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk hsmmc6_fclk = {
	.name		= "hsmmc6_fclk",
	.parent		= &func_64m_fclk,
	.ops		= &clkops_null,
	.recalc		= &followparent_recalc,
};

static const struct clksel_rate div2_1to8_rates[] = {
	{ .div = 1, .val = 0, .flags = RATE_IN_4430 },
	{ .div = 8, .val = 1, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel init_60m_fclk_div[] = {
	{ .parent = &dpll_usb_m2_ck, .rates = div2_1to8_rates },
	{ .parent = NULL },
};

static struct clk init_60m_fclk = {
	.name		= "init_60m_fclk",
	.parent		= &dpll_usb_m2_ck,
	.clksel		= init_60m_fclk_div,
	.clksel_reg	= OMAP4430_CM_CLKSEL_USB_60MHZ,
	.clksel_mask	= OMAP4430_CLKSEL_0_0_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel l3_div_div[] = {
	{ .parent = &div_core_ck, .rates = div2_1to2_rates },
	{ .parent = NULL },
};

static struct clk l3_div_ck = {
	.name		= "l3_div_ck",
	.parent		= &div_core_ck,
	.clksel		= l3_div_div,
	.clksel_reg	= OMAP4430_CM_CLKSEL_CORE,
	.clksel_mask	= OMAP4430_CLKSEL_L3_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel l4_div_div[] = {
	{ .parent = &l3_div_ck, .rates = div2_1to2_rates },
	{ .parent = NULL },
};

static struct clk l4_div_ck = {
	.name		= "l4_div_ck",
	.parent		= &l3_div_ck,
	.clksel		= l4_div_div,
	.clksel_reg	= OMAP4430_CM_CLKSEL_CORE,
	.clksel_mask	= OMAP4430_CLKSEL_L4_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk lp_clk_div_ck = {
	.name		= "lp_clk_div_ck",
	.parent		= &dpll_abe_m2x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 16,
	.recalc		= &omap_fixed_divisor_recalc,
};

static const struct clksel l4_wkup_clk_mux_sel[] = {
	{ .parent = &sys_clkin_ck, .rates = div_1_0_rates },
	{ .parent = &lp_clk_div_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk l4_wkup_clk_mux_ck = {
	.name		= "l4_wkup_clk_mux_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= l4_wkup_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L4_WKUP_CLKSEL,
	.clksel_mask	= OMAP4430_CLKSEL_0_0_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel per_abe_nc_fclk_div[] = {
	{ .parent = &dpll_abe_m2_ck, .rates = div2_1to2_rates },
	{ .parent = NULL },
};

static struct clk per_abe_nc_fclk = {
	.name		= "per_abe_nc_fclk",
	.parent		= &dpll_abe_m2_ck,
	.clksel		= per_abe_nc_fclk_div,
	.clksel_reg	= OMAP4430_CM_SCALE_FCLK,
	.clksel_mask	= OMAP4430_SCALE_FCLK_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel mcasp2_fclk_sel[] = {
	{ .parent = &func_96m_fclk, .rates = div_1_0_rates },
	{ .parent = &per_abe_nc_fclk, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk mcasp2_fclk = {
	.name		= "mcasp2_fclk",
	.parent		= &func_96m_fclk,
	.ops		= &clkops_null,
	.recalc		= &followparent_recalc,
};

static struct clk mcasp3_fclk = {
	.name		= "mcasp3_fclk",
	.parent		= &func_96m_fclk,
	.ops		= &clkops_null,
	.recalc		= &followparent_recalc,
};

static struct clk ocp_abe_iclk = {
	.name		= "ocp_abe_iclk",
	.parent		= &aess_fclk,
	.ops		= &clkops_null,
	.recalc		= &followparent_recalc,
};

static struct clk per_abe_24m_fclk = {
	.name		= "per_abe_24m_fclk",
	.parent		= &dpll_abe_m2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 4,
	.recalc		= &omap_fixed_divisor_recalc,
};

static const struct clksel pmd_stm_clock_mux_sel[] = {
	{ .parent = &sys_clkin_ck, .rates = div_1_0_rates },
	{ .parent = &dpll_core_m6x2_ck, .rates = div_1_1_rates },
	{ .parent = &tie_low_clock_ck, .rates = div_1_2_rates },
	{ .parent = NULL },
};

static struct clk pmd_stm_clock_mux_ck = {
	.name		= "pmd_stm_clock_mux_ck",
	.parent		= &sys_clkin_ck,
	.ops		= &clkops_null,
	.recalc		= &followparent_recalc,
};

static struct clk pmd_trace_clk_mux_ck = {
	.name		= "pmd_trace_clk_mux_ck",
	.parent		= &sys_clkin_ck,
	.ops		= &clkops_null,
	.recalc		= &followparent_recalc,
};

static const struct clksel syc_clk_div_div[] = {
	{ .parent = &sys_clkin_ck, .rates = div2_1to2_rates },
	{ .parent = NULL },
};

static struct clk syc_clk_div_ck = {
	.name		= "syc_clk_div_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= syc_clk_div_div,
	.clksel_reg	= OMAP4430_CM_ABE_DSS_SYS_CLKSEL,
	.clksel_mask	= OMAP4430_CLKSEL_0_0_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

/* Leaf clocks controlled by modules */

static struct clk aes1_fck = {
	.name		= "aes1_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4SEC_AES1_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_secure_clkdm",
	.parent		= &l3_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk aes2_fck = {
	.name		= "aes2_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4SEC_AES2_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_secure_clkdm",
	.parent		= &l3_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk aess_fck = {
	.name		= "aess_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM1_ABE_AESS_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "abe_clkdm",
	.parent		= &aess_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk bandgap_fclk = {
	.name		= "bandgap_fclk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_WKUP_BANDGAP_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_BGAP_32K_SHIFT,
	.clkdm_name	= "l4_wkup_clkdm",
	.parent		= &sys_32k_ck,
	.recalc		= &followparent_recalc,
};

static struct clk des3des_fck = {
	.name		= "des3des_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4SEC_DES3DES_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_secure_clkdm",
	.parent		= &l4_div_ck,
	.recalc		= &followparent_recalc,
};

static const struct clksel dmic_sync_mux_sel[] = {
	{ .parent = &abe_24m_fclk, .rates = div_1_0_rates },
	{ .parent = &syc_clk_div_ck, .rates = div_1_1_rates },
	{ .parent = &func_24m_clk, .rates = div_1_2_rates },
	{ .parent = NULL },
};

static struct clk dmic_sync_mux_ck = {
	.name		= "dmic_sync_mux_ck",
	.parent		= &abe_24m_fclk,
	.clksel		= dmic_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_DMIC_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_INTERNAL_SOURCE_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel func_dmic_abe_gfclk_sel[] = {
	{ .parent = &dmic_sync_mux_ck, .rates = div_1_0_rates },
	{ .parent = &pad_clks_ck, .rates = div_1_1_rates },
	{ .parent = &slimbus_clk, .rates = div_1_2_rates },
	{ .parent = NULL },
};

/* Merged func_dmic_abe_gfclk into dmic */
static struct clk dmic_fck = {
	.name		= "dmic_fck",
	.parent		= &dmic_sync_mux_ck,
	.clksel		= func_dmic_abe_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_DMIC_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_SOURCE_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM1_ABE_DMIC_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "abe_clkdm",
};

static struct clk dsp_fck = {
	.name		= "dsp_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_TESLA_TESLA_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "tesla_clkdm",
	.parent		= &dpll_iva_m4x2_ck,
	.recalc		= &followparent_recalc,
};

static struct clk dss_sys_clk = {
	.name		= "dss_sys_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_DSS_DSS_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_SYS_CLK_SHIFT,
	.clkdm_name	= "l3_dss_clkdm",
	.parent		= &syc_clk_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk dss_tv_clk = {
	.name		= "dss_tv_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_DSS_DSS_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_TV_CLK_SHIFT,
	.clkdm_name	= "l3_dss_clkdm",
	.parent		= &extalt_clkin_ck,
	.recalc		= &followparent_recalc,
};

static struct clk dss_dss_clk = {
	.name		= "dss_dss_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_DSS_DSS_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_DSSCLK_SHIFT,
	.clkdm_name	= "l3_dss_clkdm",
	.parent		= &dpll_per_m5x2_ck,
	.recalc		= &followparent_recalc,
};

static struct clk dss_48mhz_clk = {
	.name		= "dss_48mhz_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_DSS_DSS_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_48MHZ_CLK_SHIFT,
	.clkdm_name	= "l3_dss_clkdm",
	.parent		= &func_48mc_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk dss_fck = {
	.name		= "dss_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_DSS_DSS_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l3_dss_clkdm",
	.parent		= &l3_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk efuse_ctrl_cust_fck = {
	.name		= "efuse_ctrl_cust_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_CEFUSE_CEFUSE_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_cefuse_clkdm",
	.parent		= &sys_clkin_ck,
	.recalc		= &followparent_recalc,
};

static struct clk emif1_fck = {
	.name		= "emif1_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_MEMIF_EMIF_1_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.flags		= ENABLE_ON_INIT,
	.clkdm_name	= "l3_emif_clkdm",
	.parent		= &ddrphy_ck,
	.recalc		= &followparent_recalc,
};

static struct clk emif2_fck = {
	.name		= "emif2_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_MEMIF_EMIF_2_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.flags		= ENABLE_ON_INIT,
	.clkdm_name	= "l3_emif_clkdm",
	.parent		= &ddrphy_ck,
	.recalc		= &followparent_recalc,
};

static const struct clksel fdif_fclk_div[] = {
	{ .parent = &dpll_per_m4x2_ck, .rates = div3_1to4_rates },
	{ .parent = NULL },
};

/* Merged fdif_fclk into fdif */
static struct clk fdif_fck = {
	.name		= "fdif_fck",
	.parent		= &dpll_per_m4x2_ck,
	.clksel		= fdif_fclk_div,
	.clksel_reg	= OMAP4430_CM_CAM_FDIF_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_FCLK_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
	.enable_reg	= OMAP4430_CM_CAM_FDIF_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "iss_clkdm",
};

static struct clk fpka_fck = {
	.name		= "fpka_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4SEC_PKAEIP29_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_secure_clkdm",
	.parent		= &l4_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk gpio1_dbclk = {
	.name		= "gpio1_dbclk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_WKUP_GPIO1_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "l4_wkup_clkdm",
	.parent		= &sys_32k_ck,
	.recalc		= &followparent_recalc,
};

static struct clk gpio1_ick = {
	.name		= "gpio1_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_WKUP_GPIO1_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l4_wkup_clkdm",
	.parent		= &l4_wkup_clk_mux_ck,
	.recalc		= &followparent_recalc,
};

static struct clk gpio2_dbclk = {
	.name		= "gpio2_dbclk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_GPIO2_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &sys_32k_ck,
	.recalc		= &followparent_recalc,
};

static struct clk gpio2_ick = {
	.name		= "gpio2_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_GPIO2_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &l4_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk gpio3_dbclk = {
	.name		= "gpio3_dbclk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_GPIO3_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &sys_32k_ck,
	.recalc		= &followparent_recalc,
};

static struct clk gpio3_ick = {
	.name		= "gpio3_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_GPIO3_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &l4_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk gpio4_dbclk = {
	.name		= "gpio4_dbclk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_GPIO4_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &sys_32k_ck,
	.recalc		= &followparent_recalc,
};

static struct clk gpio4_ick = {
	.name		= "gpio4_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_GPIO4_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &l4_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk gpio5_dbclk = {
	.name		= "gpio5_dbclk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_GPIO5_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &sys_32k_ck,
	.recalc		= &followparent_recalc,
};

static struct clk gpio5_ick = {
	.name		= "gpio5_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_GPIO5_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &l4_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk gpio6_dbclk = {
	.name		= "gpio6_dbclk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_GPIO6_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &sys_32k_ck,
	.recalc		= &followparent_recalc,
};

static struct clk gpio6_ick = {
	.name		= "gpio6_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_GPIO6_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &l4_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk gpmc_ick = {
	.name		= "gpmc_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3_2_GPMC_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l3_2_clkdm",
	.parent		= &l3_div_ck,
	.recalc		= &followparent_recalc,
};

static const struct clksel sgx_clk_mux_sel[] = {
	{ .parent = &dpll_core_m7x2_ck, .rates = div_1_0_rates },
	{ .parent = &dpll_per_m7x2_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

/* Merged sgx_clk_mux into gpu */
static struct clk gpu_fck = {
	.name		= "gpu_fck",
	.parent		= &dpll_core_m7x2_ck,
	.clksel		= sgx_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_GFX_GFX_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_SGX_FCLK_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM_GFX_GFX_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l3_gfx_clkdm",
};

static struct clk hdq1w_fck = {
	.name		= "hdq1w_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_HDQ1W_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_12m_fclk,
	.recalc		= &followparent_recalc,
};

static const struct clksel hsi_fclk_div[] = {
	{ .parent = &dpll_per_m2x2_ck, .rates = div3_1to4_rates },
	{ .parent = NULL },
};

/* Merged hsi_fclk into hsi */
static struct clk hsi_fck = {
	.name		= "hsi_fck",
	.parent		= &dpll_per_m2x2_ck,
	.clksel		= hsi_fclk_div,
	.clksel_reg	= OMAP4430_CM_L3INIT_HSI_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_24_25_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
	.enable_reg	= OMAP4430_CM_L3INIT_HSI_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l3_init_clkdm",
};

static struct clk i2c1_fck = {
	.name		= "i2c1_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_I2C1_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_96m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk i2c2_fck = {
	.name		= "i2c2_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_I2C2_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_96m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk i2c3_fck = {
	.name		= "i2c3_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_I2C3_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_96m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk i2c4_fck = {
	.name		= "i2c4_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_I2C4_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_96m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk ipu_fck = {
	.name		= "ipu_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_DUCATI_DUCATI_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "ducati_clkdm",
	.parent		= &ducati_clk_mux_ck,
	.recalc		= &followparent_recalc,
};

static struct clk iss_ctrlclk = {
	.name		= "iss_ctrlclk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_CAM_ISS_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_CTRLCLK_SHIFT,
	.clkdm_name	= "iss_clkdm",
	.parent		= &func_96m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk iss_fck = {
	.name		= "iss_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_CAM_ISS_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "iss_clkdm",
	.parent		= &ducati_clk_mux_ck,
	.recalc		= &followparent_recalc,
};

static struct clk iva_fck = {
	.name		= "iva_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_IVAHD_IVAHD_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "ivahd_clkdm",
	.parent		= &dpll_iva_m5x2_ck,
	.recalc		= &followparent_recalc,
};

static struct clk kbd_fck = {
	.name		= "kbd_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_WKUP_KEYBOARD_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_wkup_clkdm",
	.parent		= &sys_32k_ck,
	.recalc		= &followparent_recalc,
};

static struct clk l3_instr_ick = {
	.name		= "l3_instr_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INSTR_L3_INSTR_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l3_instr_clkdm",
	.flags		= ENABLE_ON_INIT,
	.parent		= &l3_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk l3_main_3_ick = {
	.name		= "l3_main_3_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INSTR_L3_3_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l3_instr_clkdm",
	.flags		= ENABLE_ON_INIT,
	.parent		= &l3_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk mcasp_sync_mux_ck = {
	.name		= "mcasp_sync_mux_ck",
	.parent		= &abe_24m_fclk,
	.clksel		= dmic_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_MCASP_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_INTERNAL_SOURCE_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel func_mcasp_abe_gfclk_sel[] = {
	{ .parent = &mcasp_sync_mux_ck, .rates = div_1_0_rates },
	{ .parent = &pad_clks_ck, .rates = div_1_1_rates },
	{ .parent = &slimbus_clk, .rates = div_1_2_rates },
	{ .parent = NULL },
};

/* Merged func_mcasp_abe_gfclk into mcasp */
static struct clk mcasp_fck = {
	.name		= "mcasp_fck",
	.parent		= &mcasp_sync_mux_ck,
	.clksel		= func_mcasp_abe_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_MCASP_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_SOURCE_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM1_ABE_MCASP_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "abe_clkdm",
};

static struct clk mcbsp1_sync_mux_ck = {
	.name		= "mcbsp1_sync_mux_ck",
	.parent		= &abe_24m_fclk,
	.clksel		= dmic_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_MCBSP1_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_INTERNAL_SOURCE_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel func_mcbsp1_gfclk_sel[] = {
	{ .parent = &mcbsp1_sync_mux_ck, .rates = div_1_0_rates },
	{ .parent = &pad_clks_ck, .rates = div_1_1_rates },
	{ .parent = &slimbus_clk, .rates = div_1_2_rates },
	{ .parent = NULL },
};

/* Merged func_mcbsp1_gfclk into mcbsp1 */
static struct clk mcbsp1_fck = {
	.name		= "mcbsp1_fck",
	.parent		= &mcbsp1_sync_mux_ck,
	.clksel		= func_mcbsp1_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_MCBSP1_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_SOURCE_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM1_ABE_MCBSP1_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "abe_clkdm",
};

static struct clk mcbsp2_sync_mux_ck = {
	.name		= "mcbsp2_sync_mux_ck",
	.parent		= &abe_24m_fclk,
	.clksel		= dmic_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_MCBSP2_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_INTERNAL_SOURCE_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel func_mcbsp2_gfclk_sel[] = {
	{ .parent = &mcbsp2_sync_mux_ck, .rates = div_1_0_rates },
	{ .parent = &pad_clks_ck, .rates = div_1_1_rates },
	{ .parent = &slimbus_clk, .rates = div_1_2_rates },
	{ .parent = NULL },
};

/* Merged func_mcbsp2_gfclk into mcbsp2 */
static struct clk mcbsp2_fck = {
	.name		= "mcbsp2_fck",
	.parent		= &mcbsp2_sync_mux_ck,
	.clksel		= func_mcbsp2_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_MCBSP2_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_SOURCE_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM1_ABE_MCBSP2_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "abe_clkdm",
};

static struct clk mcbsp3_sync_mux_ck = {
	.name		= "mcbsp3_sync_mux_ck",
	.parent		= &abe_24m_fclk,
	.clksel		= dmic_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_MCBSP3_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_INTERNAL_SOURCE_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel func_mcbsp3_gfclk_sel[] = {
	{ .parent = &mcbsp3_sync_mux_ck, .rates = div_1_0_rates },
	{ .parent = &pad_clks_ck, .rates = div_1_1_rates },
	{ .parent = &slimbus_clk, .rates = div_1_2_rates },
	{ .parent = NULL },
};

/* Merged func_mcbsp3_gfclk into mcbsp3 */
static struct clk mcbsp3_fck = {
	.name		= "mcbsp3_fck",
	.parent		= &mcbsp3_sync_mux_ck,
	.clksel		= func_mcbsp3_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_MCBSP3_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_SOURCE_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM1_ABE_MCBSP3_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "abe_clkdm",
};

static struct clk mcbsp4_sync_mux_ck = {
	.name		= "mcbsp4_sync_mux_ck",
	.parent		= &func_96m_fclk,
	.clksel		= mcasp2_fclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L4PER_MCBSP4_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_INTERNAL_SOURCE_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel per_mcbsp4_gfclk_sel[] = {
	{ .parent = &mcbsp4_sync_mux_ck, .rates = div_1_0_rates },
	{ .parent = &pad_clks_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

/* Merged per_mcbsp4_gfclk into mcbsp4 */
static struct clk mcbsp4_fck = {
	.name		= "mcbsp4_fck",
	.parent		= &mcbsp4_sync_mux_ck,
	.clksel		= per_mcbsp4_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L4PER_MCBSP4_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_SOURCE_24_24_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM_L4PER_MCBSP4_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
};

static struct clk mcpdm_fck = {
	.name		= "mcpdm_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM1_ABE_PDM_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "abe_clkdm",
	.parent		= &pad_clks_ck,
	.recalc		= &followparent_recalc,
};

static struct clk mcspi1_fck = {
	.name		= "mcspi1_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_MCSPI1_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_48m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk mcspi2_fck = {
	.name		= "mcspi2_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_MCSPI2_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_48m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk mcspi3_fck = {
	.name		= "mcspi3_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_MCSPI3_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_48m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk mcspi4_fck = {
	.name		= "mcspi4_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_MCSPI4_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_48m_fclk,
	.recalc		= &followparent_recalc,
};

/* Merged hsmmc1_fclk into mmc1 */
static struct clk mmc1_fck = {
	.name		= "mmc1_fck",
	.parent		= &func_64m_fclk,
	.clksel		= hsmmc6_fclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L3INIT_MMC1_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM_L3INIT_MMC1_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l3_init_clkdm",
};

/* Merged hsmmc2_fclk into mmc2 */
static struct clk mmc2_fck = {
	.name		= "mmc2_fck",
	.parent		= &func_64m_fclk,
	.clksel		= hsmmc6_fclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L3INIT_MMC2_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM_L3INIT_MMC2_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l3_init_clkdm",
};

static struct clk mmc3_fck = {
	.name		= "mmc3_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_MMCSD3_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_48m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk mmc4_fck = {
	.name		= "mmc4_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_MMCSD4_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_48m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk mmc5_fck = {
	.name		= "mmc5_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_MMCSD5_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_48m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk ocp2scp_usb_phy_phy_48m = {
	.name		= "ocp2scp_usb_phy_phy_48m",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USBPHYOCP2SCP_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_PHY_48M_SHIFT,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &func_48m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk ocp2scp_usb_phy_ick = {
	.name		= "ocp2scp_usb_phy_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USBPHYOCP2SCP_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &l4_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk ocp_wp_noc_ick = {
	.name		= "ocp_wp_noc_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INSTR_OCP_WP1_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l3_instr_clkdm",
	.flags		= ENABLE_ON_INIT,
	.parent		= &l3_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk rng_ick = {
	.name		= "rng_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4SEC_RNG_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l4_secure_clkdm",
	.parent		= &l4_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk sha2md5_fck = {
	.name		= "sha2md5_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4SEC_SHA2MD51_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_secure_clkdm",
	.parent		= &l3_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk sl2if_ick = {
	.name		= "sl2if_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_IVAHD_SL2_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "ivahd_clkdm",
	.parent		= &dpll_iva_m5x2_ck,
	.recalc		= &followparent_recalc,
};

static struct clk slimbus1_fclk_1 = {
	.name		= "slimbus1_fclk_1",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM1_ABE_SLIMBUS_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_FCLK1_SHIFT,
	.clkdm_name	= "abe_clkdm",
	.parent		= &func_24m_clk,
	.recalc		= &followparent_recalc,
};

static struct clk slimbus1_fclk_0 = {
	.name		= "slimbus1_fclk_0",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM1_ABE_SLIMBUS_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_FCLK0_SHIFT,
	.clkdm_name	= "abe_clkdm",
	.parent		= &abe_24m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk slimbus1_fclk_2 = {
	.name		= "slimbus1_fclk_2",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM1_ABE_SLIMBUS_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_FCLK2_SHIFT,
	.clkdm_name	= "abe_clkdm",
	.parent		= &pad_clks_ck,
	.recalc		= &followparent_recalc,
};

static struct clk slimbus1_slimbus_clk = {
	.name		= "slimbus1_slimbus_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM1_ABE_SLIMBUS_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_SLIMBUS_CLK_11_11_SHIFT,
	.clkdm_name	= "abe_clkdm",
	.parent		= &slimbus_clk,
	.recalc		= &followparent_recalc,
};

static struct clk slimbus1_fck = {
	.name		= "slimbus1_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM1_ABE_SLIMBUS_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "abe_clkdm",
	.parent		= &ocp_abe_iclk,
	.recalc		= &followparent_recalc,
};

static struct clk slimbus2_fclk_1 = {
	.name		= "slimbus2_fclk_1",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_SLIMBUS2_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_PERABE24M_GFCLK_SHIFT,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &per_abe_24m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk slimbus2_fclk_0 = {
	.name		= "slimbus2_fclk_0",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_SLIMBUS2_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_PER24MC_GFCLK_SHIFT,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_24mc_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk slimbus2_slimbus_clk = {
	.name		= "slimbus2_slimbus_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_SLIMBUS2_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_SLIMBUS_CLK_SHIFT,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &pad_slimbus_core_clks_ck,
	.recalc		= &followparent_recalc,
};

static struct clk slimbus2_fck = {
	.name		= "slimbus2_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_SLIMBUS2_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &l4_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk smartreflex_core_fck = {
	.name		= "smartreflex_core_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_ALWON_SR_CORE_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_ao_clkdm",
	.parent		= &l4_wkup_clk_mux_ck,
	.recalc		= &followparent_recalc,
};

static struct clk smartreflex_iva_fck = {
	.name		= "smartreflex_iva_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_ALWON_SR_IVA_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_ao_clkdm",
	.parent		= &l4_wkup_clk_mux_ck,
	.recalc		= &followparent_recalc,
};

static struct clk smartreflex_mpu_fck = {
	.name		= "smartreflex_mpu_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_ALWON_SR_MPU_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_ao_clkdm",
	.parent		= &l4_wkup_clk_mux_ck,
	.recalc		= &followparent_recalc,
};

/* Merged dmt1_clk_mux into timer1 */
static struct clk timer1_fck = {
	.name		= "timer1_fck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_WKUP_TIMER1_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM_WKUP_TIMER1_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_wkup_clkdm",
};

/* Merged cm2_dm10_mux into timer10 */
static struct clk timer10_fck = {
	.name		= "timer10_fck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L4PER_DMTIMER10_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM_L4PER_DMTIMER10_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
};

/* Merged cm2_dm11_mux into timer11 */
static struct clk timer11_fck = {
	.name		= "timer11_fck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L4PER_DMTIMER11_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM_L4PER_DMTIMER11_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
};

/* Merged cm2_dm2_mux into timer2 */
static struct clk timer2_fck = {
	.name		= "timer2_fck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L4PER_DMTIMER2_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM_L4PER_DMTIMER2_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
};

/* Merged cm2_dm3_mux into timer3 */
static struct clk timer3_fck = {
	.name		= "timer3_fck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L4PER_DMTIMER3_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM_L4PER_DMTIMER3_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
};

/* Merged cm2_dm4_mux into timer4 */
static struct clk timer4_fck = {
	.name		= "timer4_fck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L4PER_DMTIMER4_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM_L4PER_DMTIMER4_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
};

static const struct clksel timer5_sync_mux_sel[] = {
	{ .parent = &syc_clk_div_ck, .rates = div_1_0_rates },
	{ .parent = &sys_32k_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

/* Merged timer5_sync_mux into timer5 */
static struct clk timer5_fck = {
	.name		= "timer5_fck",
	.parent		= &syc_clk_div_ck,
	.clksel		= timer5_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_TIMER5_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM1_ABE_TIMER5_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "abe_clkdm",
};

/* Merged timer6_sync_mux into timer6 */
static struct clk timer6_fck = {
	.name		= "timer6_fck",
	.parent		= &syc_clk_div_ck,
	.clksel		= timer5_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_TIMER6_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM1_ABE_TIMER6_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "abe_clkdm",
};

/* Merged timer7_sync_mux into timer7 */
static struct clk timer7_fck = {
	.name		= "timer7_fck",
	.parent		= &syc_clk_div_ck,
	.clksel		= timer5_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_TIMER7_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM1_ABE_TIMER7_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "abe_clkdm",
};

/* Merged timer8_sync_mux into timer8 */
static struct clk timer8_fck = {
	.name		= "timer8_fck",
	.parent		= &syc_clk_div_ck,
	.clksel		= timer5_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM1_ABE_TIMER8_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM1_ABE_TIMER8_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "abe_clkdm",
};

/* Merged cm2_dm9_mux into timer9 */
static struct clk timer9_fck = {
	.name		= "timer9_fck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L4PER_DMTIMER9_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4430_CM_L4PER_DMTIMER9_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
};

static struct clk uart1_fck = {
	.name		= "uart1_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_UART1_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_48m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk uart2_fck = {
	.name		= "uart2_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_UART2_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_48m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk uart3_fck = {
	.name		= "uart3_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_UART3_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_48m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk uart4_fck = {
	.name		= "uart4_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L4PER_UART4_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_per_clkdm",
	.parent		= &func_48m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk usb_host_fs_fck = {
	.name		= "usb_host_fs_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_HOST_FS_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &func_48mc_fclk,
	.recalc		= &followparent_recalc,
};

static const struct clksel utmi_p1_gfclk_sel[] = {
	{ .parent = &init_60m_fclk, .rates = div_1_0_rates },
	{ .parent = &xclk60mhsp1_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk utmi_p1_gfclk = {
	.name		= "utmi_p1_gfclk",
	.parent		= &init_60m_fclk,
	.clksel		= utmi_p1_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L3INIT_USB_HOST_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_UTMI_P1_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk usb_host_hs_utmi_p1_clk = {
	.name		= "usb_host_hs_utmi_p1_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_HOST_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_UTMI_P1_CLK_SHIFT,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &utmi_p1_gfclk,
	.recalc		= &followparent_recalc,
};

static const struct clksel utmi_p2_gfclk_sel[] = {
	{ .parent = &init_60m_fclk, .rates = div_1_0_rates },
	{ .parent = &xclk60mhsp2_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk utmi_p2_gfclk = {
	.name		= "utmi_p2_gfclk",
	.parent		= &init_60m_fclk,
	.clksel		= utmi_p2_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L3INIT_USB_HOST_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_UTMI_P2_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk usb_host_hs_utmi_p2_clk = {
	.name		= "usb_host_hs_utmi_p2_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_HOST_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_UTMI_P2_CLK_SHIFT,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &utmi_p2_gfclk,
	.recalc		= &followparent_recalc,
};

static struct clk usb_host_hs_utmi_p3_clk = {
	.name		= "usb_host_hs_utmi_p3_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_HOST_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_UTMI_P3_CLK_SHIFT,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &init_60m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk usb_host_hs_hsic480m_p1_clk = {
	.name		= "usb_host_hs_hsic480m_p1_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_HOST_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_HSIC480M_P1_CLK_SHIFT,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &dpll_usb_m2_ck,
	.recalc		= &followparent_recalc,
};

static struct clk usb_host_hs_hsic60m_p1_clk = {
	.name		= "usb_host_hs_hsic60m_p1_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_HOST_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_HSIC60M_P1_CLK_SHIFT,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &init_60m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk usb_host_hs_hsic60m_p2_clk = {
	.name		= "usb_host_hs_hsic60m_p2_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_HOST_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_HSIC60M_P2_CLK_SHIFT,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &init_60m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk usb_host_hs_hsic480m_p2_clk = {
	.name		= "usb_host_hs_hsic480m_p2_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_HOST_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_HSIC480M_P2_CLK_SHIFT,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &dpll_usb_m2_ck,
	.recalc		= &followparent_recalc,
};

static struct clk usb_host_hs_func48mclk = {
	.name		= "usb_host_hs_func48mclk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_HOST_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_FUNC48MCLK_SHIFT,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &func_48mc_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk usb_host_hs_fck = {
	.name		= "usb_host_hs_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_HOST_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &init_60m_fclk,
	.recalc		= &followparent_recalc,
};

static const struct clksel otg_60m_gfclk_sel[] = {
	{ .parent = &utmi_phy_clkout_ck, .rates = div_1_0_rates },
	{ .parent = &xclk60motg_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk otg_60m_gfclk = {
	.name		= "otg_60m_gfclk",
	.parent		= &utmi_phy_clkout_ck,
	.clksel		= otg_60m_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP4430_CM_L3INIT_USB_OTG_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_60M_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk usb_otg_hs_xclk = {
	.name		= "usb_otg_hs_xclk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_OTG_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_XCLK_SHIFT,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &otg_60m_gfclk,
	.recalc		= &followparent_recalc,
};

static struct clk usb_otg_hs_ick = {
	.name		= "usb_otg_hs_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_OTG_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &l3_div_ck,
	.recalc		= &followparent_recalc,
};

static struct clk usb_phy_cm_clk32k = {
	.name		= "usb_phy_cm_clk32k",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_ALWON_USBPHY_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_CLK32K_SHIFT,
	.clkdm_name	= "l4_ao_clkdm",
	.parent		= &sys_32k_ck,
	.recalc		= &followparent_recalc,
};

static struct clk usb_tll_hs_usb_ch2_clk = {
	.name		= "usb_tll_hs_usb_ch2_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_TLL_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_USB_CH2_CLK_SHIFT,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &init_60m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk usb_tll_hs_usb_ch0_clk = {
	.name		= "usb_tll_hs_usb_ch0_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_TLL_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_USB_CH0_CLK_SHIFT,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &init_60m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk usb_tll_hs_usb_ch1_clk = {
	.name		= "usb_tll_hs_usb_ch1_clk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_TLL_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_USB_CH1_CLK_SHIFT,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &init_60m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk usb_tll_hs_ick = {
	.name		= "usb_tll_hs_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_L3INIT_USB_TLL_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l3_init_clkdm",
	.parent		= &l4_div_ck,
	.recalc		= &followparent_recalc,
};

static const struct clksel_rate div2_14to18_rates[] = {
	{ .div = 14, .val = 0, .flags = RATE_IN_4430 },
	{ .div = 18, .val = 1, .flags = RATE_IN_4430 },
	{ .div = 0 },
};

static const struct clksel usim_fclk_div[] = {
	{ .parent = &dpll_per_m4x2_ck, .rates = div2_14to18_rates },
	{ .parent = NULL },
};

static struct clk usim_ck = {
	.name		= "usim_ck",
	.parent		= &dpll_per_m4x2_ck,
	.clksel		= usim_fclk_div,
	.clksel_reg	= OMAP4430_CM_WKUP_USIM_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk usim_fclk = {
	.name		= "usim_fclk",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_WKUP_USIM_CLKCTRL,
	.enable_bit	= OMAP4430_OPTFCLKEN_FCLK_SHIFT,
	.clkdm_name	= "l4_wkup_clkdm",
	.parent		= &usim_ck,
	.recalc		= &followparent_recalc,
};

static struct clk usim_fck = {
	.name		= "usim_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_WKUP_USIM_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_HWCTRL,
	.clkdm_name	= "l4_wkup_clkdm",
	.parent		= &sys_32k_ck,
	.recalc		= &followparent_recalc,
};

static struct clk wd_timer2_fck = {
	.name		= "wd_timer2_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM_WKUP_WDT2_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "l4_wkup_clkdm",
	.parent		= &sys_32k_ck,
	.recalc		= &followparent_recalc,
};

static struct clk wd_timer3_fck = {
	.name		= "wd_timer3_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP4430_CM1_ABE_WDT3_CLKCTRL,
	.enable_bit	= OMAP4430_MODULEMODE_SWCTRL,
	.clkdm_name	= "abe_clkdm",
	.parent		= &sys_32k_ck,
	.recalc		= &followparent_recalc,
};

/* Remaining optional clocks */
static const struct clksel stm_clk_div_div[] = {
	{ .parent = &pmd_stm_clock_mux_ck, .rates = div3_1to4_rates },
	{ .parent = NULL },
};

static struct clk stm_clk_div_ck = {
	.name		= "stm_clk_div_ck",
	.parent		= &pmd_stm_clock_mux_ck,
	.clksel		= stm_clk_div_div,
	.clksel_reg	= OMAP4430_CM_EMU_DEBUGSS_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_PMD_STM_CLK_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel trace_clk_div_div[] = {
	{ .parent = &pmd_trace_clk_mux_ck, .rates = div3_1to4_rates },
	{ .parent = NULL },
};

static struct clk trace_clk_div_ck = {
	.name		= "trace_clk_div_ck",
	.parent		= &pmd_trace_clk_mux_ck,
	.clksel		= trace_clk_div_div,
	.clksel_reg	= OMAP4430_CM_EMU_DEBUGSS_CLKCTRL,
	.clksel_mask	= OMAP4430_CLKSEL_PMD_TRACE_CLK_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

/* SCRM aux clk nodes */

static const struct clksel auxclk_sel[] = {
	{ .parent = &sys_clkin_ck, .rates = div_1_0_rates },
	{ .parent = &dpll_core_m3x2_ck, .rates = div_1_1_rates },
	{ .parent = &dpll_per_m3x2_ck, .rates = div_1_2_rates },
	{ .parent = NULL },
};

static struct clk auxclk0_ck = {
	.name		= "auxclk0_ck",
	.parent		= &sys_clkin_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_omap2_dflt,
	.clksel		= auxclk_sel,
	.clksel_reg	= OMAP4_SCRM_AUXCLK0,
	.clksel_mask	= OMAP4_SRCSELECT_MASK,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4_SCRM_AUXCLK0,
	.enable_bit	= OMAP4_ENABLE_SHIFT,
};

static struct clk auxclk1_ck = {
	.name		= "auxclk1_ck",
	.parent		= &sys_clkin_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_omap2_dflt,
	.clksel		= auxclk_sel,
	.clksel_reg	= OMAP4_SCRM_AUXCLK1,
	.clksel_mask	= OMAP4_SRCSELECT_MASK,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4_SCRM_AUXCLK1,
	.enable_bit	= OMAP4_ENABLE_SHIFT,
};

static struct clk auxclk2_ck = {
	.name		= "auxclk2_ck",
	.parent		= &sys_clkin_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_omap2_dflt,
	.clksel		= auxclk_sel,
	.clksel_reg	= OMAP4_SCRM_AUXCLK2,
	.clksel_mask	= OMAP4_SRCSELECT_MASK,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4_SCRM_AUXCLK2,
	.enable_bit	= OMAP4_ENABLE_SHIFT,
};
static struct clk auxclk3_ck = {
	.name		= "auxclk3_ck",
	.parent		= &sys_clkin_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_omap2_dflt,
	.clksel		= auxclk_sel,
	.clksel_reg	= OMAP4_SCRM_AUXCLK3,
	.clksel_mask	= OMAP4_SRCSELECT_MASK,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4_SCRM_AUXCLK3,
	.enable_bit	= OMAP4_ENABLE_SHIFT,
};

static struct clk auxclk4_ck = {
	.name		= "auxclk4_ck",
	.parent		= &sys_clkin_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_omap2_dflt,
	.clksel		= auxclk_sel,
	.clksel_reg	= OMAP4_SCRM_AUXCLK4,
	.clksel_mask	= OMAP4_SRCSELECT_MASK,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4_SCRM_AUXCLK4,
	.enable_bit	= OMAP4_ENABLE_SHIFT,
};

static struct clk auxclk5_ck = {
	.name		= "auxclk5_ck",
	.parent		= &sys_clkin_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_omap2_dflt,
	.clksel		= auxclk_sel,
	.clksel_reg	= OMAP4_SCRM_AUXCLK5,
	.clksel_mask	= OMAP4_SRCSELECT_MASK,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP4_SCRM_AUXCLK5,
	.enable_bit	= OMAP4_ENABLE_SHIFT,
};

static const struct clksel auxclkreq_sel[] = {
	{ .parent = &auxclk0_ck, .rates = div_1_0_rates },
	{ .parent = &auxclk1_ck, .rates = div_1_1_rates },
	{ .parent = &auxclk2_ck, .rates = div_1_2_rates },
	{ .parent = &auxclk3_ck, .rates = div_1_3_rates },
	{ .parent = &auxclk4_ck, .rates = div_1_4_rates },
	{ .parent = &auxclk5_ck, .rates = div_1_5_rates },
	{ .parent = NULL },
};

static struct clk auxclkreq0_ck = {
	.name		= "auxclkreq0_ck",
	.parent		= &auxclk0_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_null,
	.clksel         = auxclkreq_sel,
	.clksel_reg	= OMAP4_SCRM_AUXCLKREQ0,
	.clksel_mask	= OMAP4_MAPPING_MASK,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk auxclkreq1_ck = {
	.name		= "auxclkreq1_ck",
	.parent		= &auxclk1_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_null,
	.clksel         = auxclkreq_sel,
	.clksel_reg	= OMAP4_SCRM_AUXCLKREQ1,
	.clksel_mask	= OMAP4_MAPPING_MASK,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk auxclkreq2_ck = {
	.name		= "auxclkreq2_ck",
	.parent		= &auxclk2_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_null,
	.clksel         = auxclkreq_sel,
	.clksel_reg	= OMAP4_SCRM_AUXCLKREQ2,
	.clksel_mask	= OMAP4_MAPPING_MASK,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk auxclkreq3_ck = {
	.name		= "auxclkreq3_ck",
	.parent		= &auxclk3_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_null,
	.clksel         = auxclkreq_sel,
	.clksel_reg	= OMAP4_SCRM_AUXCLKREQ3,
	.clksel_mask	= OMAP4_MAPPING_MASK,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk auxclkreq4_ck = {
	.name		= "auxclkreq4_ck",
	.parent		= &auxclk4_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_null,
	.clksel         = auxclkreq_sel,
	.clksel_reg	= OMAP4_SCRM_AUXCLKREQ4,
	.clksel_mask	= OMAP4_MAPPING_MASK,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk auxclkreq5_ck = {
	.name		= "auxclkreq5_ck",
	.parent		= &auxclk5_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_null,
	.clksel         = auxclkreq_sel,
	.clksel_reg	= OMAP4_SCRM_AUXCLKREQ5,
	.clksel_mask	= OMAP4_MAPPING_MASK,
	.recalc		= &omap2_clksel_recalc,
};

/*
 * clkdev
 */

static struct omap_clk omap44xx_clks[] = {
	CLK(NULL,	"extalt_clkin_ck",		&extalt_clkin_ck,	CK_443X),
	CLK(NULL,	"pad_clks_ck",			&pad_clks_ck,	CK_443X),
	CLK(NULL,	"pad_slimbus_core_clks_ck",	&pad_slimbus_core_clks_ck,	CK_443X),
	CLK(NULL,	"secure_32k_clk_src_ck",	&secure_32k_clk_src_ck,	CK_443X),
	CLK(NULL,	"slimbus_clk",			&slimbus_clk,	CK_443X),
	CLK(NULL,	"sys_32k_ck",			&sys_32k_ck,	CK_443X),
	CLK(NULL,	"virt_12000000_ck",		&virt_12000000_ck,	CK_443X),
	CLK(NULL,	"virt_13000000_ck",		&virt_13000000_ck,	CK_443X),
	CLK(NULL,	"virt_16800000_ck",		&virt_16800000_ck,	CK_443X),
	CLK(NULL,	"virt_19200000_ck",		&virt_19200000_ck,	CK_443X),
	CLK(NULL,	"virt_26000000_ck",		&virt_26000000_ck,	CK_443X),
	CLK(NULL,	"virt_27000000_ck",		&virt_27000000_ck,	CK_443X),
	CLK(NULL,	"virt_38400000_ck",		&virt_38400000_ck,	CK_443X),
	CLK(NULL,	"sys_clkin_ck",			&sys_clkin_ck,	CK_443X),
	CLK(NULL,	"tie_low_clock_ck",		&tie_low_clock_ck,	CK_443X),
	CLK(NULL,	"utmi_phy_clkout_ck",		&utmi_phy_clkout_ck,	CK_443X),
	CLK(NULL,	"xclk60mhsp1_ck",		&xclk60mhsp1_ck,	CK_443X),
	CLK(NULL,	"xclk60mhsp2_ck",		&xclk60mhsp2_ck,	CK_443X),
	CLK(NULL,	"xclk60motg_ck",		&xclk60motg_ck,	CK_443X),
	CLK(NULL,	"abe_dpll_bypass_clk_mux_ck",	&abe_dpll_bypass_clk_mux_ck,	CK_443X),
	CLK(NULL,	"abe_dpll_refclk_mux_ck",	&abe_dpll_refclk_mux_ck,	CK_443X),
	CLK(NULL,	"dpll_abe_ck",			&dpll_abe_ck,	CK_443X),
	CLK(NULL,	"dpll_abe_x2_ck",		&dpll_abe_x2_ck,	CK_443X),
	CLK(NULL,	"dpll_abe_m2x2_ck",		&dpll_abe_m2x2_ck,	CK_443X),
	CLK(NULL,	"abe_24m_fclk",			&abe_24m_fclk,	CK_443X),
	CLK(NULL,	"abe_clk",			&abe_clk,	CK_443X),
	CLK(NULL,	"aess_fclk",			&aess_fclk,	CK_443X),
	CLK(NULL,	"dpll_abe_m3x2_ck",		&dpll_abe_m3x2_ck,	CK_443X),
	CLK(NULL,	"core_hsd_byp_clk_mux_ck",	&core_hsd_byp_clk_mux_ck,	CK_443X),
	CLK(NULL,	"dpll_core_ck",			&dpll_core_ck,	CK_443X),
	CLK(NULL,	"dpll_core_x2_ck",		&dpll_core_x2_ck,	CK_443X),
	CLK(NULL,	"dpll_core_m6x2_ck",		&dpll_core_m6x2_ck,	CK_443X),
	CLK(NULL,	"dbgclk_mux_ck",		&dbgclk_mux_ck,	CK_443X),
	CLK(NULL,	"dpll_core_m2_ck",		&dpll_core_m2_ck,	CK_443X),
	CLK(NULL,	"ddrphy_ck",			&ddrphy_ck,	CK_443X),
	CLK(NULL,	"dpll_core_m5x2_ck",		&dpll_core_m5x2_ck,	CK_443X),
	CLK(NULL,	"div_core_ck",			&div_core_ck,	CK_443X),
	CLK(NULL,	"div_iva_hs_clk",		&div_iva_hs_clk,	CK_443X),
	CLK(NULL,	"div_mpu_hs_clk",		&div_mpu_hs_clk,	CK_443X),
	CLK(NULL,	"dpll_core_m4x2_ck",		&dpll_core_m4x2_ck,	CK_443X),
	CLK(NULL,	"dll_clk_div_ck",		&dll_clk_div_ck,	CK_443X),
	CLK(NULL,	"dpll_abe_m2_ck",		&dpll_abe_m2_ck,	CK_443X),
	CLK(NULL,	"dpll_core_m3x2_ck",		&dpll_core_m3x2_ck,	CK_443X),
	CLK(NULL,	"dpll_core_m7x2_ck",		&dpll_core_m7x2_ck,	CK_443X),
	CLK(NULL,	"iva_hsd_byp_clk_mux_ck",	&iva_hsd_byp_clk_mux_ck,	CK_443X),
	CLK(NULL,	"dpll_iva_ck",			&dpll_iva_ck,	CK_443X),
	CLK(NULL,	"dpll_iva_x2_ck",		&dpll_iva_x2_ck,	CK_443X),
	CLK(NULL,	"dpll_iva_m4x2_ck",		&dpll_iva_m4x2_ck,	CK_443X),
	CLK(NULL,	"dpll_iva_m5x2_ck",		&dpll_iva_m5x2_ck,	CK_443X),
	CLK(NULL,	"dpll_mpu_ck",			&dpll_mpu_ck,	CK_443X),
	CLK(NULL,	"dpll_mpu_m2_ck",		&dpll_mpu_m2_ck,	CK_443X),
	CLK(NULL,	"per_hs_clk_div_ck",		&per_hs_clk_div_ck,	CK_443X),
	CLK(NULL,	"per_hsd_byp_clk_mux_ck",	&per_hsd_byp_clk_mux_ck,	CK_443X),
	CLK(NULL,	"dpll_per_ck",			&dpll_per_ck,	CK_443X),
	CLK(NULL,	"dpll_per_m2_ck",		&dpll_per_m2_ck,	CK_443X),
	CLK(NULL,	"dpll_per_x2_ck",		&dpll_per_x2_ck,	CK_443X),
	CLK(NULL,	"dpll_per_m2x2_ck",		&dpll_per_m2x2_ck,	CK_443X),
	CLK(NULL,	"dpll_per_m3x2_ck",		&dpll_per_m3x2_ck,	CK_443X),
	CLK(NULL,	"dpll_per_m4x2_ck",		&dpll_per_m4x2_ck,	CK_443X),
	CLK(NULL,	"dpll_per_m5x2_ck",		&dpll_per_m5x2_ck,	CK_443X),
	CLK(NULL,	"dpll_per_m6x2_ck",		&dpll_per_m6x2_ck,	CK_443X),
	CLK(NULL,	"dpll_per_m7x2_ck",		&dpll_per_m7x2_ck,	CK_443X),
	CLK(NULL,	"dpll_unipro_ck",		&dpll_unipro_ck,	CK_443X),
	CLK(NULL,	"dpll_unipro_x2_ck",		&dpll_unipro_x2_ck,	CK_443X),
	CLK(NULL,	"dpll_unipro_m2x2_ck",		&dpll_unipro_m2x2_ck,	CK_443X),
	CLK(NULL,	"usb_hs_clk_div_ck",		&usb_hs_clk_div_ck,	CK_443X),
	CLK(NULL,	"dpll_usb_ck",			&dpll_usb_ck,	CK_443X),
	CLK(NULL,	"dpll_usb_clkdcoldo_ck",	&dpll_usb_clkdcoldo_ck,	CK_443X),
	CLK(NULL,	"dpll_usb_m2_ck",		&dpll_usb_m2_ck,	CK_443X),
	CLK(NULL,	"ducati_clk_mux_ck",		&ducati_clk_mux_ck,	CK_443X),
	CLK(NULL,	"func_12m_fclk",		&func_12m_fclk,	CK_443X),
	CLK(NULL,	"func_24m_clk",			&func_24m_clk,	CK_443X),
	CLK(NULL,	"func_24mc_fclk",		&func_24mc_fclk,	CK_443X),
	CLK(NULL,	"func_48m_fclk",		&func_48m_fclk,	CK_443X),
	CLK(NULL,	"func_48mc_fclk",		&func_48mc_fclk,	CK_443X),
	CLK(NULL,	"func_64m_fclk",		&func_64m_fclk,	CK_443X),
	CLK(NULL,	"func_96m_fclk",		&func_96m_fclk,	CK_443X),
	CLK(NULL,	"hsmmc6_fclk",			&hsmmc6_fclk,	CK_443X),
	CLK(NULL,	"init_60m_fclk",		&init_60m_fclk,	CK_443X),
	CLK(NULL,	"l3_div_ck",			&l3_div_ck,	CK_443X),
	CLK(NULL,	"l4_div_ck",			&l4_div_ck,	CK_443X),
	CLK(NULL,	"lp_clk_div_ck",		&lp_clk_div_ck,	CK_443X),
	CLK(NULL,	"l4_wkup_clk_mux_ck",		&l4_wkup_clk_mux_ck,	CK_443X),
	CLK(NULL,	"per_abe_nc_fclk",		&per_abe_nc_fclk,	CK_443X),
	CLK(NULL,	"mcasp2_fclk",			&mcasp2_fclk,	CK_443X),
	CLK(NULL,	"mcasp3_fclk",			&mcasp3_fclk,	CK_443X),
	CLK(NULL,	"ocp_abe_iclk",			&ocp_abe_iclk,	CK_443X),
	CLK(NULL,	"per_abe_24m_fclk",		&per_abe_24m_fclk,	CK_443X),
	CLK(NULL,	"pmd_stm_clock_mux_ck",		&pmd_stm_clock_mux_ck,	CK_443X),
	CLK(NULL,	"pmd_trace_clk_mux_ck",		&pmd_trace_clk_mux_ck,	CK_443X),
	CLK(NULL,	"syc_clk_div_ck",		&syc_clk_div_ck,	CK_443X),
	CLK(NULL,	"aes1_fck",			&aes1_fck,	CK_443X),
	CLK(NULL,	"aes2_fck",			&aes2_fck,	CK_443X),
	CLK(NULL,	"aess_fck",			&aess_fck,	CK_443X),
	CLK(NULL,	"bandgap_fclk",			&bandgap_fclk,	CK_443X),
	CLK(NULL,	"des3des_fck",			&des3des_fck,	CK_443X),
	CLK(NULL,	"dmic_sync_mux_ck",		&dmic_sync_mux_ck,	CK_443X),
	CLK(NULL,	"dmic_fck",			&dmic_fck,	CK_443X),
	CLK(NULL,	"dsp_fck",			&dsp_fck,	CK_443X),
	CLK("omap_dss",	"sys_clk",			&dss_sys_clk,	CK_443X),
	CLK("omap_dss",	"tv_clk",			&dss_tv_clk,	CK_443X),
	CLK("omap_dss",	"dss_clk",			&dss_dss_clk,	CK_443X),
	CLK("omap_dss",	"video_clk",			&dss_48mhz_clk,	CK_443X),
	CLK("omap_dss",	"fck",				&dss_fck,	CK_443X),
	/*
	 * On OMAP4, DSS ick is a dummy clock; this is needed for compatibility
	 * with OMAP2/3.
	 */
	CLK("omap_dss",	"ick",				&dummy_ck,	CK_443X),
	CLK(NULL,	"efuse_ctrl_cust_fck",		&efuse_ctrl_cust_fck,	CK_443X),
	CLK(NULL,	"emif1_fck",			&emif1_fck,	CK_443X),
	CLK(NULL,	"emif2_fck",			&emif2_fck,	CK_443X),
	CLK(NULL,	"fdif_fck",			&fdif_fck,	CK_443X),
	CLK(NULL,	"fpka_fck",			&fpka_fck,	CK_443X),
	CLK(NULL,	"gpio1_dbclk",			&gpio1_dbclk,	CK_443X),
	CLK(NULL,	"gpio1_ick",			&gpio1_ick,	CK_443X),
	CLK(NULL,	"gpio2_dbclk",			&gpio2_dbclk,	CK_443X),
	CLK(NULL,	"gpio2_ick",			&gpio2_ick,	CK_443X),
	CLK(NULL,	"gpio3_dbclk",			&gpio3_dbclk,	CK_443X),
	CLK(NULL,	"gpio3_ick",			&gpio3_ick,	CK_443X),
	CLK(NULL,	"gpio4_dbclk",			&gpio4_dbclk,	CK_443X),
	CLK(NULL,	"gpio4_ick",			&gpio4_ick,	CK_443X),
	CLK(NULL,	"gpio5_dbclk",			&gpio5_dbclk,	CK_443X),
	CLK(NULL,	"gpio5_ick",			&gpio5_ick,	CK_443X),
	CLK(NULL,	"gpio6_dbclk",			&gpio6_dbclk,	CK_443X),
	CLK(NULL,	"gpio6_ick",			&gpio6_ick,	CK_443X),
	CLK(NULL,	"gpmc_ick",			&gpmc_ick,	CK_443X),
	CLK(NULL,	"gpu_fck",			&gpu_fck,	CK_443X),
	CLK("omap2_hdq.0",	"fck",				&hdq1w_fck,	CK_443X),
	CLK(NULL,	"hsi_fck",			&hsi_fck,	CK_443X),
	CLK("omap_i2c.1",	"fck",				&i2c1_fck,	CK_443X),
	CLK("omap_i2c.2",	"fck",				&i2c2_fck,	CK_443X),
	CLK("omap_i2c.3",	"fck",				&i2c3_fck,	CK_443X),
	CLK("omap_i2c.4",	"fck",				&i2c4_fck,	CK_443X),
	CLK(NULL,	"ipu_fck",			&ipu_fck,	CK_443X),
	CLK(NULL,	"iss_ctrlclk",			&iss_ctrlclk,	CK_443X),
	CLK(NULL,	"iss_fck",			&iss_fck,	CK_443X),
	CLK(NULL,	"iva_fck",			&iva_fck,	CK_443X),
	CLK(NULL,	"kbd_fck",			&kbd_fck,	CK_443X),
	CLK(NULL,	"l3_instr_ick",			&l3_instr_ick,	CK_443X),
	CLK(NULL,	"l3_main_3_ick",		&l3_main_3_ick,	CK_443X),
	CLK(NULL,	"mcasp_sync_mux_ck",		&mcasp_sync_mux_ck,	CK_443X),
	CLK(NULL,	"mcasp_fck",			&mcasp_fck,	CK_443X),
	CLK(NULL,	"mcbsp1_sync_mux_ck",		&mcbsp1_sync_mux_ck,	CK_443X),
	CLK("omap-mcbsp.1",	"fck",				&mcbsp1_fck,	CK_443X),
	CLK(NULL,	"mcbsp2_sync_mux_ck",		&mcbsp2_sync_mux_ck,	CK_443X),
	CLK("omap-mcbsp.2",	"fck",				&mcbsp2_fck,	CK_443X),
	CLK(NULL,	"mcbsp3_sync_mux_ck",		&mcbsp3_sync_mux_ck,	CK_443X),
	CLK("omap-mcbsp.3",	"fck",				&mcbsp3_fck,	CK_443X),
	CLK(NULL,	"mcbsp4_sync_mux_ck",		&mcbsp4_sync_mux_ck,	CK_443X),
	CLK("omap-mcbsp.4",	"fck",				&mcbsp4_fck,	CK_443X),
	CLK(NULL,	"mcpdm_fck",			&mcpdm_fck,	CK_443X),
	CLK("omap2_mcspi.1",	"fck",				&mcspi1_fck,	CK_443X),
	CLK("omap2_mcspi.2",	"fck",				&mcspi2_fck,	CK_443X),
	CLK("omap2_mcspi.3",	"fck",				&mcspi3_fck,	CK_443X),
	CLK("omap2_mcspi.4",	"fck",				&mcspi4_fck,	CK_443X),
	CLK("mmci-omap-hs.0",	"fck",				&mmc1_fck,	CK_443X),
	CLK("mmci-omap-hs.1",	"fck",				&mmc2_fck,	CK_443X),
	CLK("mmci-omap-hs.2",	"fck",				&mmc3_fck,	CK_443X),
	CLK("mmci-omap-hs.3",	"fck",				&mmc4_fck,	CK_443X),
	CLK("mmci-omap-hs.4",	"fck",				&mmc5_fck,	CK_443X),
	CLK(NULL,	"ocp2scp_usb_phy_phy_48m",	&ocp2scp_usb_phy_phy_48m,	CK_443X),
	CLK(NULL,	"ocp2scp_usb_phy_ick",		&ocp2scp_usb_phy_ick,	CK_443X),
	CLK(NULL,	"ocp_wp_noc_ick",		&ocp_wp_noc_ick,	CK_443X),
	CLK("omap_rng",	"ick",				&rng_ick,	CK_443X),
	CLK(NULL,	"sha2md5_fck",			&sha2md5_fck,	CK_443X),
	CLK(NULL,	"sl2if_ick",			&sl2if_ick,	CK_443X),
	CLK(NULL,	"slimbus1_fclk_1",		&slimbus1_fclk_1,	CK_443X),
	CLK(NULL,	"slimbus1_fclk_0",		&slimbus1_fclk_0,	CK_443X),
	CLK(NULL,	"slimbus1_fclk_2",		&slimbus1_fclk_2,	CK_443X),
	CLK(NULL,	"slimbus1_slimbus_clk",		&slimbus1_slimbus_clk,	CK_443X),
	CLK(NULL,	"slimbus1_fck",			&slimbus1_fck,	CK_443X),
	CLK(NULL,	"slimbus2_fclk_1",		&slimbus2_fclk_1,	CK_443X),
	CLK(NULL,	"slimbus2_fclk_0",		&slimbus2_fclk_0,	CK_443X),
	CLK(NULL,	"slimbus2_slimbus_clk",		&slimbus2_slimbus_clk,	CK_443X),
	CLK(NULL,	"slimbus2_fck",			&slimbus2_fck,	CK_443X),
	CLK(NULL,	"smartreflex_core_fck",		&smartreflex_core_fck,	CK_443X),
	CLK(NULL,	"smartreflex_iva_fck",		&smartreflex_iva_fck,	CK_443X),
	CLK(NULL,	"smartreflex_mpu_fck",		&smartreflex_mpu_fck,	CK_443X),
	CLK(NULL,	"gpt1_fck",			&timer1_fck,	CK_443X),
	CLK(NULL,	"gpt10_fck",			&timer10_fck,	CK_443X),
	CLK(NULL,	"gpt11_fck",			&timer11_fck,	CK_443X),
	CLK(NULL,	"gpt2_fck",			&timer2_fck,	CK_443X),
	CLK(NULL,	"gpt3_fck",			&timer3_fck,	CK_443X),
	CLK(NULL,	"gpt4_fck",			&timer4_fck,	CK_443X),
	CLK(NULL,	"gpt5_fck",			&timer5_fck,	CK_443X),
	CLK(NULL,	"gpt6_fck",			&timer6_fck,	CK_443X),
	CLK(NULL,	"gpt7_fck",			&timer7_fck,	CK_443X),
	CLK(NULL,	"gpt8_fck",			&timer8_fck,	CK_443X),
	CLK(NULL,	"gpt9_fck",			&timer9_fck,	CK_443X),
	CLK(NULL,	"uart1_fck",			&uart1_fck,	CK_443X),
	CLK(NULL,	"uart2_fck",			&uart2_fck,	CK_443X),
	CLK(NULL,	"uart3_fck",			&uart3_fck,	CK_443X),
	CLK(NULL,	"uart4_fck",			&uart4_fck,	CK_443X),
	CLK(NULL,	"usb_host_fs_fck",		&usb_host_fs_fck,	CK_443X),
	CLK("ehci-omap.0",	"fs_fck",		&usb_host_fs_fck,	CK_443X),
	CLK(NULL,	"utmi_p1_gfclk",		&utmi_p1_gfclk,	CK_443X),
	CLK(NULL,	"usb_host_hs_utmi_p1_clk",	&usb_host_hs_utmi_p1_clk,	CK_443X),
	CLK(NULL,	"utmi_p2_gfclk",		&utmi_p2_gfclk,	CK_443X),
	CLK(NULL,	"usb_host_hs_utmi_p2_clk",	&usb_host_hs_utmi_p2_clk,	CK_443X),
	CLK(NULL,	"usb_host_hs_utmi_p3_clk",	&usb_host_hs_utmi_p3_clk,	CK_443X),
	CLK(NULL,	"usb_host_hs_hsic480m_p1_clk",	&usb_host_hs_hsic480m_p1_clk,	CK_443X),
	CLK(NULL,	"usb_host_hs_hsic60m_p1_clk",	&usb_host_hs_hsic60m_p1_clk,	CK_443X),
	CLK(NULL,	"usb_host_hs_hsic60m_p2_clk",	&usb_host_hs_hsic60m_p2_clk,	CK_443X),
	CLK(NULL,	"usb_host_hs_hsic480m_p2_clk",	&usb_host_hs_hsic480m_p2_clk,	CK_443X),
	CLK(NULL,	"usb_host_hs_func48mclk",	&usb_host_hs_func48mclk,	CK_443X),
	CLK(NULL,	"usb_host_hs_fck",		&usb_host_hs_fck,	CK_443X),
	CLK("ehci-omap.0",	"hs_fck",		&usb_host_hs_fck,	CK_443X),
	CLK("ehci-omap.0",	"usbhost_ick",		&dummy_ck,		CK_443X),
	CLK(NULL,	"otg_60m_gfclk",		&otg_60m_gfclk,	CK_443X),
	CLK(NULL,	"usb_otg_hs_xclk",		&usb_otg_hs_xclk,	CK_443X),
	CLK("musb-omap2430",	"ick",				&usb_otg_hs_ick,	CK_443X),
	CLK(NULL,	"usb_phy_cm_clk32k",		&usb_phy_cm_clk32k,	CK_443X),
	CLK(NULL,	"usb_tll_hs_usb_ch2_clk",	&usb_tll_hs_usb_ch2_clk,	CK_443X),
	CLK(NULL,	"usb_tll_hs_usb_ch0_clk",	&usb_tll_hs_usb_ch0_clk,	CK_443X),
	CLK(NULL,	"usb_tll_hs_usb_ch1_clk",	&usb_tll_hs_usb_ch1_clk,	CK_443X),
	CLK(NULL,	"usb_tll_hs_ick",		&usb_tll_hs_ick,	CK_443X),
	CLK("ehci-omap.0",	"usbtll_ick",		&usb_tll_hs_ick,	CK_443X),
	CLK("ehci-omap.0",	"usbtll_fck",		&dummy_ck,	CK_443X),
	CLK(NULL,	"usim_ck",			&usim_ck,	CK_443X),
	CLK(NULL,	"usim_fclk",			&usim_fclk,	CK_443X),
	CLK(NULL,	"usim_fck",			&usim_fck,	CK_443X),
	CLK("omap_wdt",	"fck",				&wd_timer2_fck,	CK_443X),
	CLK(NULL,	"mailboxes_ick",		&dummy_ck,	CK_443X),
	CLK(NULL,	"wd_timer3_fck",		&wd_timer3_fck,	CK_443X),
	CLK(NULL,	"stm_clk_div_ck",		&stm_clk_div_ck,	CK_443X),
	CLK(NULL,	"trace_clk_div_ck",		&trace_clk_div_ck,	CK_443X),
	CLK(NULL,	"gpmc_ck",			&dummy_ck,	CK_443X),
	CLK(NULL,	"gpt1_ick",			&dummy_ck,	CK_443X),
	CLK(NULL,	"gpt2_ick",			&dummy_ck,	CK_443X),
	CLK(NULL,	"gpt3_ick",			&dummy_ck,	CK_443X),
	CLK(NULL,	"gpt4_ick",			&dummy_ck,	CK_443X),
	CLK(NULL,	"gpt5_ick",			&dummy_ck,	CK_443X),
	CLK(NULL,	"gpt6_ick",			&dummy_ck,	CK_443X),
	CLK(NULL,	"gpt7_ick",			&dummy_ck,	CK_443X),
	CLK(NULL,	"gpt8_ick",			&dummy_ck,	CK_443X),
	CLK(NULL,	"gpt9_ick",			&dummy_ck,	CK_443X),
	CLK(NULL,	"gpt10_ick",			&dummy_ck,	CK_443X),
	CLK(NULL,	"gpt11_ick",			&dummy_ck,	CK_443X),
	CLK("omap_i2c.1",	"ick",				&dummy_ck,	CK_443X),
	CLK("omap_i2c.2",	"ick",				&dummy_ck,	CK_443X),
	CLK("omap_i2c.3",	"ick",				&dummy_ck,	CK_443X),
	CLK("omap_i2c.4",	"ick",				&dummy_ck,	CK_443X),
	CLK("mmci-omap-hs.0",	"ick",				&dummy_ck,	CK_443X),
	CLK("mmci-omap-hs.1",	"ick",				&dummy_ck,	CK_443X),
	CLK("mmci-omap-hs.2",	"ick",				&dummy_ck,	CK_443X),
	CLK("mmci-omap-hs.3",	"ick",				&dummy_ck,	CK_443X),
	CLK("mmci-omap-hs.4",	"ick",				&dummy_ck,	CK_443X),
	CLK("omap-mcbsp.1",	"ick",				&dummy_ck,	CK_443X),
	CLK("omap-mcbsp.2",	"ick",				&dummy_ck,	CK_443X),
	CLK("omap-mcbsp.3",	"ick",				&dummy_ck,	CK_443X),
	CLK("omap-mcbsp.4",	"ick",				&dummy_ck,	CK_443X),
	CLK("omap2_mcspi.1",	"ick",				&dummy_ck,	CK_443X),
	CLK("omap2_mcspi.2",	"ick",				&dummy_ck,	CK_443X),
	CLK("omap2_mcspi.3",	"ick",				&dummy_ck,	CK_443X),
	CLK("omap2_mcspi.4",	"ick",				&dummy_ck,	CK_443X),
	CLK(NULL,	"uart1_ick",			&dummy_ck,	CK_443X),
	CLK(NULL,	"uart2_ick",			&dummy_ck,	CK_443X),
	CLK(NULL,	"uart3_ick",			&dummy_ck,	CK_443X),
	CLK(NULL,	"uart4_ick",			&dummy_ck,	CK_443X),
	CLK("omap_wdt",	"ick",				&dummy_ck,	CK_443X),
	CLK(NULL,	"auxclk0_ck",			&auxclk0_ck,	CK_443X),
	CLK(NULL,	"auxclk1_ck",			&auxclk1_ck,	CK_443X),
	CLK(NULL,	"auxclk2_ck",			&auxclk2_ck,	CK_443X),
	CLK(NULL,	"auxclk3_ck",			&auxclk3_ck,	CK_443X),
	CLK(NULL,	"auxclk4_ck",			&auxclk4_ck,	CK_443X),
	CLK(NULL,	"auxclk5_ck",			&auxclk5_ck,	CK_443X),
	CLK(NULL,	"auxclkreq0_ck",		&auxclkreq0_ck,	CK_443X),
	CLK(NULL,	"auxclkreq1_ck",		&auxclkreq1_ck,	CK_443X),
	CLK(NULL,	"auxclkreq2_ck",		&auxclkreq2_ck,	CK_443X),
	CLK(NULL,	"auxclkreq3_ck",		&auxclkreq3_ck,	CK_443X),
	CLK(NULL,	"auxclkreq4_ck",		&auxclkreq4_ck,	CK_443X),
	CLK(NULL,	"auxclkreq5_ck",		&auxclkreq5_ck,	CK_443X),
};

int __init omap4xxx_clk_init(void)
{
	struct omap_clk *c;
	u32 cpu_clkflg;

	if (cpu_is_omap44xx()) {
		cpu_mask = RATE_IN_4430;
		cpu_clkflg = CK_443X;
	}

	clk_init(&omap2_clk_functions);

	for (c = omap44xx_clks; c < omap44xx_clks + ARRAY_SIZE(omap44xx_clks);
									  c++)
		clk_preinit(c->lk.clk);

	for (c = omap44xx_clks; c < omap44xx_clks + ARRAY_SIZE(omap44xx_clks);
									  c++)
		if (c->cpu & cpu_clkflg) {
			clkdev_add(&c->lk);
			clk_register(c->lk.clk);
			omap2_init_clk_clkdm(c->lk.clk);
		}

	recalculate_root_clocks();

	/*
	 * Only enable those clocks we will need, let the drivers
	 * enable other clocks as necessary
	 */
	clk_enable_init_clocks();

	return 0;
}
