/*
 * arch/arm/mach-tegra/board-touch-raydium_spi.c
 *
 * Copyright (c) 2011, NVIDIA Corporation.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/spi/spi.h>
#include <linux/delay.h>
#include <linux/gpio.h>
#include <linux/spi/rm31080a_ts.h>

/* Raydium touchscreen                     Driver data */
/*-----------------------------------------------------*/
static const u8 rm31080_config_cardhu[] = {
	0x00, 0x00, 0x00, 0x00, 0x30, 0x1e, 0x20, 0x0f,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x06, 0x06, 0x04, 0x01, 0x02, 0x00,
	0x00, 0x0a, 0x00, 0xd5, 0x2b, 0x00, 0x00, 0x09,
	0x2c, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0xf8, 0x50, 0xce, 0x0a, 0x0c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x16, 0x1b, 0x14, 0x16, 0x16, 0x18, 0x32, 0x19,
	0x1d, 0x08, 0x30, 0x19, 0x10, 0xf6, 0xe2, 0x08,
	0x28, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x21, 0x00, 0x00, 0x21, 0x00, 0x00, 0x21,
	0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x80,
	0x00, 0xc0, 0x00, 0xc2, 0x00, 0xf0, 0xed, 0x02,
	0xed, 0x02, 0x00, 0x90, 0x0a, 0x06, 0x80, 0x02,
	0x00, 0x04, 0x00, 0x20, 0x03, 0x02, 0x08, 0x03,
	0x10, 0x20, 0x20, 0x40, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x05, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x80, 0x02, 0x02, 0x02, 0x00, 0x00, 0x33,
	0x32, 0x00, 0x01, 0x4c, 0xfa, 0x00, 0x00, 0x43,
	0x3c, 0x00, 0x01, 0x38, 0xe6, 0x00, 0x00, 0x26,
	0x19, 0x00, 0x02, 0x66, 0x19, 0x00, 0x02, 0x50,
	0x64, 0x00, 0x00, 0x36, 0x4a, 0x00, 0x00, 0x0c,
	0x19, 0x00, 0x02, 0x64, 0x96, 0xab, 0x88, 0x78,
	0x88, 0x78, 0x04, 0x0f, 0x38, 0xff, 0x02, 0x04,
	0x80, 0xe0, 0x13, 0x01, 0x00, 0x44, 0x61, 0x12,
	0x41, 0x00, 0x00, 0x00, 0x00, 0x97, 0x01, 0x0c,
	0x44, 0x61, 0x12, 0x29, 0x29, 0x41, 0x00, 0x00,
	0x97, 0x06, 0x0c, 0x12, 0x41, 0x44, 0x52, 0x52,
	0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x80, 0x80, 0x01, 0x80, 0x01, 0x80,
	0x22, 0x33, 0x22, 0x33, 0x66, 0x20, 0xff, 0xc9,
	0x19, 0xd0, 0xd0, 0x44, 0x00, 0x10, 0x00, 0x80,
	0x05, 0x44, 0xff, 0x00, 0x00, 0x10, 0x50, 0x00,
	0x00, 0x00, 0x30, 0x00, 0x00, 0x18, 0x18, 0x0f,
	0x0f, 0xf0, 0xf0, 0x00, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x01, 0x10, 0x01, 0x02,
};

/* Wintek 7" MB (01.18.10.01.10) */
static const u8 rm31080_config_kai_mainboard[] = {
	0x00, 0x00, 0x00, 0x00, 0x1e, 0x12, 0x20, 0x0f,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x19, 0x19, 0x06, 0x06, 0x04, 0x10, 0x02, 0x00,
	0x00, 0x0a, 0x00, 0xd5, 0x2b, 0x00, 0x00, 0x09,
	0x2c, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0xec, 0x5f, 0xce, 0x14, 0x0a, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x14, 0x19, 0x14, 0x19, 0x10, 0x10, 0x32, 0x12,
	0x1d, 0x08, 0x20, 0x19, 0x10, 0xf6, 0xe2, 0x08,
	0x1c, 0x04, 0x04, 0x20, 0x0f, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x28, 0x00, 0x10, 0x22, 0x00, 0x00, 0x21,
	0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x60,
	0x00, 0xa8, 0x00, 0xa8, 0x00, 0xd0, 0xed, 0x02,
	0xed, 0x02, 0x00, 0x90, 0x0a, 0x06, 0x20, 0x02,
	0x70, 0x03, 0x20, 0x1b, 0x03, 0x02, 0x08, 0x03,
	0x10, 0x20, 0x20, 0x40, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x20, 0x05, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x80, 0x02, 0x02, 0x02, 0x00, 0x00, 0x33,
	0x32, 0x00, 0x01, 0x60, 0xfa, 0x00, 0x00, 0x43,
	0x3c, 0x00, 0x01, 0x4c, 0xe6, 0x00, 0x00, 0x26,
	0x19, 0x00, 0x02, 0x7a, 0x19, 0x00, 0x02, 0x50,
	0x64, 0x00, 0x00, 0x36, 0x4a, 0x00, 0x00, 0x0c,
	0x19, 0x00, 0x02, 0x64, 0x96, 0xab, 0x88, 0x78,
	0x88, 0x78, 0x04, 0x0f, 0x38, 0xff, 0x02, 0x04,
	0x80, 0xe0, 0x13, 0x02, 0x00, 0x2c, 0x1b, 0x4b,
	0x2e, 0x00, 0x00, 0x00, 0x00, 0x97, 0x06, 0x0c,
	0x2c, 0x1b, 0x2e, 0x3c, 0x3c, 0x4b, 0x00, 0x00,
	0x97, 0x06, 0x0c, 0x12, 0x41, 0x44, 0x52, 0x52,
	0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x80, 0x80, 0x01, 0x80, 0x01, 0x80,
	0x21, 0x33, 0x21, 0x33, 0x66, 0x20, 0xff, 0xc9,
	0x19, 0xd0, 0xd0, 0x44, 0x00, 0x10, 0x00, 0x80,
	0x05, 0x44, 0xff, 0x00, 0x00, 0x10, 0x50, 0x00,
	0x00, 0x00, 0x30, 0x00, 0x00, 0x18, 0x18, 0x0f,
	0x0f, 0xf0, 0xf0, 0x00, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x01, 0x10, 0x01, 0x02,
};

/* Wintek 7" PCB (01.18.10.01.10), TS IC is on the mainboard */
static const u8 rm31080_config_kai_pcb[] = {
	0x00, 0x00, 0x00, 0x00, 0x1e, 0x12, 0x20, 0x0f,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x07,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x19, 0x19, 0x06, 0x06, 0x04, 0x10, 0x02, 0x00,
	0x00, 0x0a, 0x00, 0xd5, 0x2b, 0x00, 0x00, 0x09,
	0x2c, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0xec, 0x5f, 0xce, 0x14, 0x0a, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x14, 0x19, 0x14, 0x19, 0x10, 0x10, 0x32, 0x12,
	0x1d, 0x08, 0x20, 0x19, 0x10, 0xf6, 0xe2, 0x08,
	0x1c, 0x04, 0x04, 0x20, 0x0f, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x28, 0x00, 0x10, 0x22, 0x00, 0x00, 0x21,
	0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x60,
	0x00, 0xa8, 0x00, 0xa8, 0x00, 0xd0, 0xed, 0x02,
	0xed, 0x02, 0x00, 0x90, 0x0a, 0x06, 0x20, 0x02,
	0x70, 0x03, 0x20, 0x1b, 0x03, 0x02, 0x08, 0x03,
	0x10, 0x20, 0x20, 0x40, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x20, 0x05, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x80, 0x02, 0x02, 0x02, 0x00, 0x00, 0x33,
	0x32, 0x00, 0x01, 0x60, 0xfa, 0x00, 0x00, 0x43,
	0x3c, 0x00, 0x01, 0x4c, 0xe6, 0x00, 0x00, 0x26,
	0x19, 0x00, 0x02, 0x7a, 0x19, 0x00, 0x02, 0x50,
	0x64, 0x00, 0x00, 0x36, 0x4a, 0x00, 0x00, 0x0c,
	0x19, 0x00, 0x02, 0x64, 0x96, 0xab, 0x88, 0x78,
	0x88, 0x78, 0x04, 0x0f, 0x38, 0xff, 0x02, 0x04,
	0x80, 0xe0, 0x13, 0x02, 0x00, 0x28, 0x17, 0x4b,
	0x2e, 0x00, 0x00, 0x00, 0x00, 0x97, 0x06, 0x0c,
	0x28, 0x17, 0x2e, 0x3c, 0x3c, 0x4b, 0x00, 0x00,
	0x97, 0x06, 0x0c, 0x12, 0x41, 0x44, 0x52, 0x52,
	0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x80, 0x80, 0x01, 0x80, 0x01, 0x80,
	0x21, 0x33, 0x21, 0x33, 0x66, 0x20, 0xff, 0xc9,
	0x19, 0xd0, 0xd0, 0x44, 0x00, 0x10, 0x00, 0x80,
	0x05, 0x44, 0xff, 0x00, 0x00, 0x10, 0x50, 0x00,
	0x00, 0x00, 0x30, 0x00, 0x00, 0x18, 0x18, 0x0f,
	0x0f, 0xf0, 0xf0, 0x00, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x01, 0x10, 0x01, 0x02,
};

struct rm_spi_ts_platform_data rm31080ts_data = {
	.gpio_reset = 0,
	.config = 0,
};

struct spi_board_info rm31080a_spi_board[1] = {
	{
	 .modalias = "rm_ts_spidev",
	 .bus_num = 0,
	 .chip_select = 0,
	 .max_speed_hz = 13 * 1000 * 1000,
	 .mode = SPI_MODE_0,
	 .platform_data = &rm31080ts_data,
	 },
};

int __init touch_init_raydium(int irq_gpio, int reset_gpio, int platform)
{
	int err = 0;
	tegra_gpio_enable(irq_gpio);
	gpio_request(irq_gpio, "raydium-irq");
	gpio_direction_input(irq_gpio);

	tegra_gpio_enable(reset_gpio);
	gpio_request(reset_gpio, "raydium-reset");
	gpio_direction_output(reset_gpio, 0);

	rm31080ts_data.gpio_reset = reset_gpio;

	msleep(1);
	gpio_set_value(reset_gpio, 1);
	msleep(100);

	rm31080a_spi_board[0].irq = TEGRA_GPIO_TO_IRQ(irq_gpio);

	switch (platform) {
	case 0:
		pr_info("Raydium Kai PCB based touch init\n");
		rm31080ts_data.config = rm31080_config_kai_pcb;
		break;
	case 1:
		pr_info("Raydium Kai On-Board touch init\n");
		rm31080ts_data.config = rm31080_config_kai_mainboard;
		break;
	case 2:
		pr_info("Raydium cardhu touch init\n");
		rm31080ts_data.config = rm31080_config_cardhu;
		break;
	default:
		pr_err("touch_id error, no touch\n");
		err = -ENODEV;
	}

	if(!err)
		spi_register_board_info(rm31080a_spi_board,
				ARRAY_SIZE(rm31080a_spi_board));

	return err;
}
