/* Copyright (c) 2010, 2012, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef OV7692_H
#define OV7692_H
#include <linux/types.h>
#include <mach/board.h>

#define INVMASK(v)  (0xff-v)
#define OV7692Core_WritePREG(pTbl)  OV7692_WritePRegs \
			(pTbl, sizeof(pTbl)/sizeof(pTbl[0]))

extern int lcd_camera_power_onoff(int on);
struct reg_addr_val_pair_struct {
	uint8_t	reg_addr;
	uint8_t	reg_val;
};

enum ov7692_test_mode_t {
	TEST_OFF,
	TEST_1,
	TEST_2,
	TEST_3
};

enum ov7692_resolution_t {
	QTR_SIZE,
	FULL_SIZE,
	INVALID_SIZE
};

enum ov7692_setting {
	RES_PREVIEW,
	RES_CAPTURE
};
enum ov7692_reg_update {
	/* Sensor egisters that need to be updated during initialization */
	REG_INIT,
	/* Sensor egisters that needs periodic I2C writes */
	UPDATE_PERIODIC,
	/* All the sensor Registers will be updated */
	UPDATE_ALL,
	/* Not valid update */
	UPDATE_INVALID
};

/*OV SENSOR SCCB*/
struct OV7692_WREG {
	uint8_t addr;
	uint8_t data;
	uint8_t mask;
} OV7692_WREG;

#ifdef CONFIG_WEBCAM_OV7692_QRD
/*  96MHz PCLK @ 24MHz MCLK */
struct reg_addr_val_pair_struct ov7692_init_settings_array[] = {
	{0x12, 0x80},
	{0x0e, 0x08},
	{0x69, 0x52},
	{0x1e, 0xb3},
	{0x48, 0x42},
	{0xff, 0x01},
	{0xae, 0xa0},
	{0xa8, 0x26},
	{0xb4, 0xc0},
	{0xb5, 0x40},
	{0xff, 0x00},
	{0x0c, 0x00},
	{0x62, 0x10},
	{0x12, 0x00},
	{0x17, 0x65},
	{0x18, 0xa4},
	{0x19, 0x0a},
	{0x1a, 0xf6},
	{0x3e, 0x30},
	{0x64, 0x0a},
	{0xff, 0x01},
	{0xb4, 0xc0},
	{0xff, 0x00},
	{0x67, 0x20},
	{0x81, 0x3f},
	{0xcc, 0x02},
	{0xcd, 0x80},
	{0xce, 0x01},
	{0xcf, 0xe0},
	{0xc8, 0x02},
	{0xc9, 0x80},
	{0xca, 0x01},
	{0xcb, 0xe0},
	{0xd0, 0x48},
	{0x82, 0x03},
	/*{0x0e, 0x00},*/
	{0x70, 0x00},
	{0x71, 0x34},
	{0x74, 0x28},
	{0x75, 0x98},
	{0x76, 0x00},
	{0x77, 0x64},
	{0x78, 0x01},
	{0x79, 0xc2},
	{0x7a, 0x4e},
	{0x7b, 0x1f},
	{0x7c, 0x00},
	{0x11, 0x00},
	{0x20, 0x00},
	{0x21, 0x23},
	{0x50, 0x9a},
	{0x51, 0x80},
	{0x4c, 0x7d},
	/*{0x0e, 0x00},*/
	{0x85, 0x10},
	{0x86, 0x00},
	{0x87, 0x00},
	{0x88, 0x00},
	{0x89, 0x2a},
	{0x8a, 0x26},
	{0x8b, 0x22},
	{0xbb, 0x7a},
	{0xbc, 0x69},
	{0xbd, 0x11},
	{0xbe, 0x13},
	{0xbf, 0x81},
	{0xc0, 0x96},
	{0xc1, 0x1e},
	{0xb7, 0x05},
	{0xb8, 0x09},
	{0xb9, 0x00},
	{0xba, 0x18},
	{0x5a, 0x1f},
	{0x5b, 0x9f},
	{0x5c, 0x6a},
	{0x5d, 0x42},
	{0x24, 0x78},
	{0x25, 0x68},
	{0x26, 0xb3},
	{0xa3, 0x0b},
	{0xa4, 0x15},
	{0xa5, 0x2a},
	{0xa6, 0x51},
	{0xa7, 0x63},
	{0xa8, 0x74},
	{0xa9, 0x83},
	{0xaa, 0x91},
	{0xab, 0x9e},
	{0xac, 0xaa},
	{0xad, 0xbe},
	{0xae, 0xce},
	{0xaf, 0xe5},
	{0xb0, 0xf3},
	{0xb1, 0xfb},
	{0xb2, 0x06},
	{0x8c, 0x5c},
	{0x8d, 0x11},
	{0x8e, 0x12},
	{0x8f, 0x19},
	{0x90, 0x50},
	{0x91, 0x20},
	{0x92, 0x96},
	{0x93, 0x80},
	{0x94, 0x13},
	{0x95, 0x1b},
	{0x96, 0xff},
	{0x97, 0x00},
	{0x98, 0x3d},
	{0x99, 0x36},
	{0x9a, 0x51},
	{0x9b, 0x43},
	{0x9c, 0xf0},
	{0x9d, 0xf0},
	{0x9e, 0xf0},
	{0x9f, 0xff},
	{0xa0, 0x68},
	{0xa1, 0x62},
	{0xa2, 0x0e},
};
#endif
/* Exposure Compensation */
struct OV7692_WREG ov7692_exposure_compensation_lv0_tbl[] = {
	/*@@ +1.7EV*/
	{0x24, 0xc0},
	{0x25, 0xb8},
	{0x26, 0xe6},
};

struct OV7692_WREG ov7692_exposure_compensation_lv1_tbl[] = {
	/*@@ +1.0EV*/
	{0x24, 0xa8},
	{0x25, 0xa0},
	{0x26, 0xc4},
};

struct OV7692_WREG ov7692_exposure_compensation_lv2_default_tbl[] = {
	/*@@ default*/
	{0x24, 0x86},
	{0x25, 0x76},
	{0x26, 0xb3},
};

struct OV7692_WREG ov7692_exposure_compensation_lv3_tbl[] = {
	/*@@ -1.0EV*/
	{0x24, 0x70},
	{0x25, 0x60},
	{0x26, 0xa2},
};

struct OV7692_WREG ov7692_exposure_compensation_lv4_tbl[] = {
	/*@@ -1.7EV*/
	{0x24, 0x50},
	{0x25, 0x40},
	{0x26, 0xa2},
};

struct OV7692_WREG ov7692_antibanding_off_tbl[] = {
	{0x13, 0xE5, INVMASK(0x20)},
};

struct OV7692_WREG ov7692_antibanding_auto_tbl[] = {
	{0x13, 0x20, INVMASK(0x20)},
	{0x14, 0x14, INVMASK(0x17)},
};

struct OV7692_WREG ov7692_antibanding_50z_tbl[] = {
	/*Band 50Hz*/
	{0x13, 0x20, INVMASK(0x20)},
	{0x14, 0x17, INVMASK(0x17)},
};

struct OV7692_WREG ov7692_antibanding_60z_tbl[] = {
	/*Band 60Hz*/
	{0x13, 0x20, INVMASK(0x20)},
	{0x14, 0x16, INVMASK(0x17)},
};

/*Saturation*/
struct OV7692_WREG ov7692_saturation_lv0_tbl[] = {
	/*Saturation level 0*/
	{0x81, 0x33, INVMASK(0x33)},
	{0xd8, 0x00, INVMASK(0xff)},
	{0xd9, 0x00, INVMASK(0xff)},
	{0xd2, 0x02, INVMASK(0xff)},
};

struct OV7692_WREG ov7692_saturation_lv1_tbl[] = {
	/*Saturation level 1*/
	{0x81, 0x33, INVMASK(0x33)},
	{0xd8, 0x10, INVMASK(0xff)},
	{0xd9, 0x10, INVMASK(0xff)},
	{0xd2, 0x02, INVMASK(0xff)},
};

struct OV7692_WREG ov7692_saturation_lv2_tbl[] = {
	/*Saturation level 2*/
	{0x81, 0x33, INVMASK(0x33)},
	{0xd8, 0x20, INVMASK(0xff)},
	{0xd9, 0x20, INVMASK(0xff)},
	{0xd2, 0x02, INVMASK(0xff)},

};

struct OV7692_WREG ov7692_saturation_lv3_tbl[] = {
	/*Saturation level 3*/
	{0x81, 0x33, INVMASK(0x33)},
	{0xd8, 0x30, INVMASK(0xff)},
	{0xd9, 0x30, INVMASK(0xff)},
	{0xd2, 0x02, INVMASK(0xff)},

};

struct OV7692_WREG ov7692_saturation_default_lv4_tbl[] = {
	/*Saturation level 4 (default)*/
	{0x81, 0x33, INVMASK(0x33)},
	{0xd8, 0x40, INVMASK(0xff)},
	{0xd9, 0x40, INVMASK(0xff)},
	{0xd2, 0x02, INVMASK(0xff)},
};

struct OV7692_WREG ov7692_saturation_lv5_tbl[] = {
	/*Saturation level 5*/
	{0x81, 0x33, INVMASK(0x33)},
	{0xd8, 0x50, INVMASK(0xff)},
	{0xd9, 0x50, INVMASK(0xff)},
	{0xd2, 0x02, INVMASK(0xff)},
};

struct OV7692_WREG ov7692_saturation_lv6_tbl[] = {
	/*Saturation level 6*/
	{0x81, 0x33, INVMASK(0x33)},
	{0xd8, 0x60, INVMASK(0xff)},
	{0xd9, 0x60, INVMASK(0xff)},
	{0xd2, 0x02, INVMASK(0xff)},
};

struct OV7692_WREG ov7692_saturation_lv7_tbl[] = {
	/*Saturation level 7*/
	{0x81, 0x33, INVMASK(0x33)},
	{0xd8, 0x70, INVMASK(0xff)},
	{0xd9, 0x70, INVMASK(0xff)},
	{0xd2, 0x02, INVMASK(0xff)},
};

struct OV7692_WREG ov7692_saturation_lv8_tbl[] = {
	/*Saturation level 8*/
	{0x81, 0x33, INVMASK(0x33)},
	{0xd8, 0x80, INVMASK(0xff)},
	{0xd9, 0x80, INVMASK(0xff)},
	{0xd2, 0x02, INVMASK(0xff)},
};

/*EFFECT*/
struct OV7692_WREG ov7692_effect_normal_tbl[] = {
	{0x81, 0x00, INVMASK(0x20)},
	{0x28, 0x00, },
	{0xd2, 0x00, },
	{0xda, 0x80, },
	{0xdb, 0x80, },
};

struct OV7692_WREG ov7692_effect_mono_tbl[] = {
	{0x81, 0x20, INVMASK(0x20)},
	{0x28, 0x00, },
	{0xd2, 0x18, },
	{0xda, 0x80, },
	{0xdb, 0x80, },
};

struct OV7692_WREG ov7692_effect_bw_tbl[] = {
	{0x81, 0x20, INVMASK(0x20)},
	{0x28, 0x00, },
	{0xd2, 0x18, },
	{0xda, 0x80, },
	{0xdb, 0x80, },
};

struct OV7692_WREG ov7692_effect_sepia_tbl[] = {
	{0x81, 0x20, INVMASK(0x20)},
	{0x28, 0x00, },
	{0xd2, 0x18, },
	{0xda, 0x40, },
	{0xdb, 0xa0, },
};

struct OV7692_WREG ov7692_effect_bluish_tbl[] = {
	{0x81, 0x20, INVMASK(0x20)},
	{0x28, 0x00, },
	{0xd2, 0x18, },
	{0xda, 0xc0, },
	{0xdb, 0x80, },
};

struct OV7692_WREG ov7692_effect_reddish_tbl[] = {
	{0x81, 0x20, INVMASK(0x20)},
	{0x28, 0x00, },
	{0xd2, 0x18, },
	{0xda, 0x80, },
	{0xdb, 0xc0, },
};

struct OV7692_WREG ov7692_effect_greenish_tbl[] = {
	{0x81, 0x20, INVMASK(0x20)},
	{0x28, 0x00, },
	{0xd2, 0x18, },
	{0xda, 0x60, },
	{0xdb, 0x60, },
};

struct OV7692_WREG ov7692_effect_negative_tbl[] = {
	{0x81, 0x20, INVMASK(0x20)},
	{0x28, 0x80, },
	{0xd2, 0x40, },
	{0xda, 0x80, },
	{0xdb, 0x80, },
};

/*Contrast*/
struct OV7692_WREG ov7692_contrast_lv0_tbl[] = {
	/*Contrast -4*/
	{0xb2, 0x29},
	{0xa3, 0x55},
	{0xa4, 0x5b},
	{0xa5, 0x67},
	{0xa6, 0x7e},
	{0xa7, 0x89},
	{0xa8, 0x93},
	{0xa9, 0x9c},
	{0xaa, 0xa4},
	{0xab, 0xac},
	{0xac, 0xb3},
	{0xad, 0xbe},
	{0xae, 0xc7},
	{0xaf, 0xd5},
	{0xb0, 0xdd},
	{0xb1, 0xe1},
};

struct OV7692_WREG ov7692_contrast_lv1_tbl[] = {
	/*Contrast -3*/
	{0xb2, 0x20},
	{0xa3, 0x43},
	{0xa4, 0x4a},
	{0xa5, 0x58},
	{0xa6, 0x73},
	{0xa7, 0x80},
	{0xa8, 0x8b},
	{0xa9, 0x96},
	{0xaa, 0x9f},
	{0xab, 0xa8},
	{0xac, 0xb1},
	{0xad, 0xbe},
	{0xae, 0xc9},
	{0xaf, 0xd8},
	{0xb0, 0xe2},
	{0xb1, 0xe8},
};

struct OV7692_WREG ov7692_contrast_lv2_tbl[] = {
	/*Contrast -2*/
	{0xb2, 0x18},
	{0xa3, 0x31},
	{0xa4, 0x39},
	{0xa5, 0x4a},
	{0xa6, 0x68},
	{0xa7, 0x77},
	{0xa8, 0x84},
	{0xa9, 0x90},
	{0xaa, 0x9b},
	{0xab, 0xa5},
	{0xac, 0xaf},
	{0xad, 0xbe},
	{0xae, 0xca},
	{0xaf, 0xdc},
	{0xb0, 0xe7},
	{0xb1, 0xee},
};

struct OV7692_WREG ov7692_contrast_lv3_tbl[] = {
	/*Contrast -1*/
	{0xb2, 0x10},
	{0xa3, 0x1f},
	{0xa4, 0x28},
	{0xa5, 0x3b},
	{0xa6, 0x5d},
	{0xa7, 0x6e},
	{0xa8, 0x7d},
	{0xa9, 0x8a},
	{0xaa, 0x96},
	{0xab, 0xa2},
	{0xac, 0xad},
	{0xad, 0xbe},
	{0xae, 0xcc},
	{0xaf, 0xe0},
	{0xb0, 0xed},
	{0xb1, 0xf4},
};

struct OV7692_WREG ov7692_contrast_default_lv4_tbl[] = {
	/*Contrast 0*/
	{0xb2, 0x6},
	{0xa3, 0xb},
	{0xa4, 0x15},
	{0xa5, 0x2a},
	{0xa6, 0x51},
	{0xa7, 0x63},
	{0xa8, 0x74},
	{0xa9, 0x83},
	{0xaa, 0x91},
	{0xab, 0x9e},
	{0xac, 0xaa},
	{0xad, 0xbe},
	{0xae, 0xce},
	{0xaf, 0xe5},
	{0xb0, 0xf3},
	{0xb1, 0xfb},
};

struct OV7692_WREG ov7692_contrast_lv5_tbl[] = {
	/*Contrast 1*/
	{0xb2, 0xc},
	{0xa3, 0x4},
	{0xa4, 0xc},
	{0xa5, 0x1f},
	{0xa6, 0x45},
	{0xa7, 0x58},
	{0xa8, 0x6b},
	{0xa9, 0x7c},
	{0xaa, 0x8d},
	{0xab, 0x9d},
	{0xac, 0xac},
	{0xad, 0xc3},
	{0xae, 0xd2},
	{0xaf, 0xe8},
	{0xb0, 0xf2},
	{0xb1, 0xf7},
};

struct OV7692_WREG ov7692_contrast_lv6_tbl[] = {
	/*Contrast 2*/
	{0xb2, 0x1},
	{0xa3, 0x2},
	{0xa4, 0x9},
	{0xa5, 0x1a},
	{0xa6, 0x3e},
	{0xa7, 0x4a},
	{0xa8, 0x59},
	{0xa9, 0x6a},
	{0xaa, 0x79},
	{0xab, 0x8e},
	{0xac, 0xa4},
	{0xad, 0xc1},
	{0xae, 0xdb},
	{0xaf, 0xf4},
	{0xb0, 0xff},
	{0xb1, 0xff},
};

struct OV7692_WREG ov7692_contrast_lv7_tbl[] = {
	/*Contrast 3*/
	{0xb2, 0xc},
	{0xa3, 0x4},
	{0xa4, 0x8},
	{0xa5, 0x17},
	{0xa6, 0x27},
	{0xa7, 0x3d},
	{0xa8, 0x54},
	{0xa9, 0x60},
	{0xaa, 0x77},
	{0xab, 0x85},
	{0xac, 0xa4},
	{0xad, 0xc6},
	{0xae, 0xd2},
	{0xaf, 0xe9},
	{0xb0, 0xf0},
	{0xb1, 0xf7},
};

struct OV7692_WREG ov7692_contrast_lv8_tbl[] = {
	/*Contrast 4*/
	{0xb2, 0x1},
	{0xa3, 0x4},
	{0xa4, 0x4},
	{0xa5, 0x7},
	{0xa6, 0xb},
	{0xa7, 0x17},
	{0xa8, 0x2a},
	{0xa9, 0x41},
	{0xaa, 0x59},
	{0xab, 0x6b},
	{0xac, 0x8b},
	{0xad, 0xb1},
	{0xae, 0xd2},
	{0xaf, 0xea},
	{0xb0, 0xf4},
	{0xb1, 0xff},
};

	/*Sharpness*/
struct OV7692_WREG ov7692_sharpness_lv0_tbl[] = {
	/*Sharpness 0*/
	{0xb4, 0x20, INVMASK(0x20)},
	{0xb6, 0x00, INVMASK(0x1f)},
};
struct OV7692_WREG ov7692_sharpness_lv1_tbl[] = {
	/*Sharpness 1*/
	{0xb4, 0x20, INVMASK(0x20)},
	{0xb6, 0x01, INVMASK(0x1f)},
};
struct OV7692_WREG ov7692_sharpness_default_lv2_tbl[] = {
	/*Sharpness Auto (Default)*/
	{0xb4, 0x00, INVMASK(0x20)},
	{0xb6, 0x00, INVMASK(0x1f)},
};
struct OV7692_WREG ov7692_sharpness_lv3_tbl[] = {
	/*Sharpness 3*/
	{0xb4, 0x20, INVMASK(0x20)},
	{0xb6, 0x66, INVMASK(0x04)},
};
struct OV7692_WREG ov7692_sharpness_lv4_tbl[] = {
	/*Sharpness 4*/
	{0xb4, 0x20, INVMASK(0x20)},
	{0xb6, 0x99, INVMASK(0x1f)},
};
struct OV7692_WREG ov7692_sharpness_lv5_tbl[] = {
	/*Sharpness 5*/
	{0xb4, 0x20, INVMASK(0x20)},
	{0xb6, 0xcc, INVMASK(0x1f)},
};
struct OV7692_WREG ov7692_sharpness_lv6_tbl[] = {
	/*Sharpness 6*/
	{0xb4, 0x20, INVMASK(0x20)},
	{0xb6, 0xff, INVMASK(0x1f)},
};

	/* ISO TYPE*/
struct OV7692_WREG ov7692_iso_type_auto[] = {
	/*@@ISO Auto*/
	{0x14, 0x20, INVMASK(0x70)},
};

struct OV7692_WREG ov7692_iso_type_100[] = {
	/*@@ISO 100*/
	{0x14, 0x00, INVMASK(0x70)},
};

struct OV7692_WREG ov7692_iso_type_200[] = {
	/*@@ISO 200*/
	{0x14, 0x10, INVMASK(0x70)},
};

struct OV7692_WREG ov7692_iso_type_400[] = {
	/*@@ISO 400*/
	{0x14, 0x20, INVMASK(0x70)},
};

struct OV7692_WREG ov7692_iso_type_800[] = {
	/*@@ISO 800*/
	{0x14, 0x30, INVMASK(0x70)},
};

struct OV7692_WREG ov7692_iso_type_1600[] = {
	/*@@ISO 1600*/
	{0x14, 0x40, INVMASK(0x70)},
};

	/*Light Mode*/
struct OV7692_WREG ov7692_wb_def[] = {
	{0x13, 0xf7},
	{0x15, 0x00},
};

struct OV7692_WREG ov7692_wb_custom[] = {
	{0x13, 0xf5},
	{0x01, 0x56},
	{0x02, 0x50},
	{0x15, 0x00},
};

struct OV7692_WREG ov7692_wb_inc[] = {
	{0x13, 0xf5},
	{0x01, 0x66},
	{0x02, 0x40},
	{0x15, 0x00},
};

struct OV7692_WREG ov7692_wb_daylight[] = {
	{0x13, 0xf5},
	{0x01, 0x43},
	{0x02, 0x5d},
	{0x15, 0x00},
};

struct OV7692_WREG ov7692_wb_cloudy[] = {
	{0x13, 0xf5},
	{0x01, 0x48},
	{0x02, 0x63},
	{0x15, 0x00},
};

#endif

