/*
 *  load.c: Load related functions, list management etc.
 *
 *  Copyright (C) 1997-2005 John Coppens (john@jcoppens.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <gtk/gtk.h>
#include <math.h>

#include "types.h"

enum {LD_FREQ, LD_REAL, LD_REACT,
      LD_FREQ_VAL, LD_REAL_VAL, LD_REACT_VAL,
      LD_POINT, LD_LOGCOL,
      LD_COLS};
      
void	initialize_loadtable(void);
void    get_load_selected(GtkTreeView *treeview);

int	load_valid(void);
void	load_append(void);
void    load_update(void);
int	number_loads(void);

void	active_load_update();
void	active_load_remove(void);

void	load_loads(char *fn);
void	save_loads(char *fn);
