/*
 *  global.c: A few global routines - mostly configuration
 *
 *  Copyright (C) 1997-2005 John Coppens (john@jcoppens.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "global.h"
#include "confmgr.h"

pref_struct     pref;
char		*initial_chart = PACKAGE_DATA_DIR"/pixmaps/smith2.png";

conf_definition preftable[] = {
  // General
  {CFM_W_ENTRY_STR,     "conf_last_ld_entry",    &pref.last_ld_file, 0,
   CFM_T_STR,           "files/last_load_file",  0, ""},
  {CFM_W_ENTRY_STR,     "conf_last_el_entry",    &pref.last_el_file, 0,
   CFM_T_STR,           "files/last_elem_file",  0, ""},
  {CFM_W_ENTRY_STR,     "conf_last_ps_entry",    &pref.last_ps_file, 0,
   CFM_T_STR,           "files/last_ps_file",    0, ""},

  {CFM_W_SPBTN_INT,     "conf_prec_mhz_spbtn",   &pref.prec_mhz, 0,
   CFM_T_INT,           "global/prec_mhz",       0, "3"},

  {CFM_W_ENTRY_DOUBLE,  "conf_swr_entry",        &pref.swr_circle, 2,
   CFM_T_DOUBLE,        "global/swr_circle",     0, "2.0"},
  {CFM_W_COLORPICK,     "conf_swrcircle_cpick",  &pref.swr_color, 0,
   CFM_T_INT,           "aspect/swr_color",      0, "-16776961"},
  {CFM_W_CBTN,          "conf_swr_cbtn",         &pref.show_swr, 0,
   CFM_T_CHAR,          "global/show_swr",       0, "1"},
  {CFM_W_ENTRY_STR,     "conf_complex_entry",    &pref.complex_sfx, 0,
   CFM_T_STR,           "global/complex_suffix", 0, "j"},

  {CFM_W_CBTN,          "conf_g1_cbtn",          &pref.show_g1, 0,
   CFM_T_CHAR,          "global/show_g1",        0, "1"},
  {CFM_W_COLORPICK,     "conf_g1circle_cpick",   &pref.g1_color, 0,
   CFM_T_INT,           "aspect/g1_color",       0, "-1381126657"},
  {CFM_W_CBTN,          "use_bitmap_cbtn",       &pref.use_bitmap, 0,
   CFM_T_CHAR,          "global/use_bitmap",     0, "1"},

  // screen plot colors & sizes
  {CFM_W_SPBTN_INT,     "conf_load_spbtn",       &pref.point_size[ZPT_LOAD], 0,
   CFM_T_INT,           "aspect/load_size",      0, "8"},
  {CFM_W_SPBTN_INT,     "conf_point_spbtn",      &pref.point_size[ZPT_INT], 0,
   CFM_T_INT,           "aspect/point_size",     0, "6"},
  {CFM_W_SPBTN_INT,     "conf_final_spbtn",      &pref.point_size[ZPT_FINAL], 0,
   CFM_T_INT,           "aspect/final_size",     0, "8"},

  {CFM_W_COLORPICK,     "conf_load_cpick",       &pref.point_color[ZPT_LOAD], 0,
   CFM_T_INT,           "aspect/load_color",     0, "-65281"},
  {CFM_W_COLORPICK,     "conf_point_cpick",      &pref.point_color[ZPT_INT], 0,
   CFM_T_INT,           "aspect/point_color",    0, "16711935"},
  {CFM_W_COLORPICK,     "conf_final_cpick",      &pref.point_color[ZPT_FINAL], 0,
   CFM_T_INT,           "aspect/final_color",    0, "-16645889"},

  {CFM_W_COLORPICK,     "conf_z_arc_cpick",      &pref.arc_color[Z_ARC], 0,
   CFM_T_INT,           "aspect/z_arc_color",    0, "-9210881"},
  {CFM_W_COLORPICK,     "conf_y_arc_cpick",      &pref.arc_color[Y_ARC], 0,
   CFM_T_INT,           "aspect/y_arc_color",    0, "-2139029505"},
  {CFM_W_COLORPICK,     "conf_line_arc_cpick",   &pref.arc_color[K_ARC], 0,
   CFM_T_INT,           "aspect/line_arc_color", 0, "1590583039"},
  {CFM_W_COLORPICK,     "conf_zy_line_cpick",    &pref.arc_color[ZY_LINE], 0,
   CFM_T_INT,           "aspect/zy_line_color", 0, "-1482184705"},

  {CFM_W_COLORPICK,     "conf_r_arc_cpick",      &pref.arc_color[R_ARC], 0,
   CFM_T_INT,           "aspect/r_arc_color",    0, "-9210881"},
  {CFM_W_COLORPICK,     "conf_r_arc_bold_cpick", &pref.arc_color[RB_ARC], 0,
   CFM_T_INT,           "aspect/rb_arc_color",    0, "-2139029505"},
  {CFM_W_COLORPICK,     "conf_x_arc_cpick",      &pref.arc_color[X_ARC], 0,
   CFM_T_INT,           "aspect/x_arc_color",    0, "-9210881"},
  {CFM_W_COLORPICK,     "conf_x_arc_bold_cpick", &pref.arc_color[XB_ARC], 0,
   CFM_T_INT,           "aspect/xb_arc_color",   0, "-2139029505"},

  {CFM_W_ENTRY_STR,     "conf_font_entry",       &pref.font_color, 0,
   CFM_T_STR,           "aspect/font",           0, "Helvetica"},
  {CFM_W_SPBTN_INT,     "conf_fontsize_spbtn",   &pref.font_size, 0,
   CFM_T_STR,           "aspect/font",           0, "Helvetica"},
  {CFM_W_COLORPICK,     "conf_font_cpick",       &pref.font_color, 0,
   CFM_T_INT,           "aspect/font_color",     0, "-9210881"},

  // Screen background image
  {CFM_W_ENTRY_STR,     "conf_chartbg_entry",    &pref.chart, 0,
   CFM_T_STR,           "chart/chartbg",         0,
			PACKAGE_DATA_DIR"/pixmaps/linsmith/smith4.png"},
  {CFM_W_ENTRY_DOUBLE,  "conf_radius_entry",     &pref.chartradius, 1,
   CFM_T_DOUBLE,        "chart/radius",          0, "211"},
  {CFM_W_ENTRY_DOUBLE,  "conf_xoffs_entry",      &pref.x_offs, 1,
   CFM_T_DOUBLE,        "chart/x_offs",          0, "2"},
  {CFM_W_ENTRY_DOUBLE,  "conf_yoffs_entry",      &pref.y_offs, 1,
   CFM_T_DOUBLE,        "chart/y_offs",          0, "0"},

  // Printer setup
  {CFM_W_ENTRY_STR,     "prt_papersize_entry",   &pref.prt_papersize, 0,
   CFM_T_STR,           "print/papersize",       0, "A4"},
  {CFM_W_ENTRY_DOUBLE,  "prt_chartsize_entry",   &pref.prt_chartsize, 1,
   CFM_T_DOUBLE,        "print/chartsize",       0, "160.0"},
  {CFM_W_ENTRY_DOUBLE,  "prt_mleft_entry",       &pref.prt_mleft, 1,
   CFM_T_DOUBLE,        "print/marginleft",      0, "1.0"},
  {CFM_W_ENTRY_DOUBLE,  "prt_mbottom_entry",     &pref.prt_mbottom, 1,
   CFM_T_DOUBLE,        "print/marginbottom",    0, "1.0"},

  // Printer chart background properties
  // R arcs - normal
  {CFM_W_COLORPICK,     "prt_r_arc_cpick",
			&pref.prt_arc_color[R_ARC],  0,
   CFM_T_INT,           "print/bgarc_color_r",       0, "-4629761"},
  {CFM_W_SPBTN_DOUBLE,  "prt_r_arc_spbtn",
			&pref.prt_arc_size[R_ARC],   0,
   CFM_T_DOUBLE,        "print/bgarc_size_r",        0, "0.1"},

  // R arcs - bold
  {CFM_W_COLORPICK,     "prt_r_arc_bold_cpick",
			&pref.prt_arc_color[RB_ARC], 0,
   CFM_T_INT,           "print/bgarc_bold_color_r",  0, "-91225345"},
  {CFM_W_SPBTN_DOUBLE,  "prt_r_arc_bold_spbtn",
                        &pref.prt_arc_size[RB_ARC],  0,
   CFM_T_DOUBLE,        "print/bgarc_bold_size_r",   0, "0.2"},

  // X arcs - normal
  {CFM_W_COLORPICK,     "prt_x_arc_cpick",
   			&pref.prt_arc_color[X_ARC],  0,
   CFM_T_INT,           "print/bgarc_color_x",       0, "-5921281"},
  {CFM_W_SPBTN_DOUBLE,  "prt_x_arc_spbtn",
			&pref.prt_arc_size[X_ARC],   0,
   CFM_T_DOUBLE,        "print/bgarc_size_x",        0, "0.1"},

  // X arcs - bold
  {CFM_W_COLORPICK,     "prt_x_arc_bold_cpick",
   			&pref.prt_arc_color[XB_ARC], 0,
   CFM_T_INT,           "print/bgarc_bold_color_x",  0, "-10460929"},
  {CFM_W_SPBTN_DOUBLE,  "prt_x_arc_bold_spbtn",
                        &pref.prt_arc_size[XB_ARC],  0,
   CFM_T_DOUBLE,        "print/bgarc_bold_size_x",   0, "0.2"},

  // Actual (print) plot properties - points
  // Load points
  {CFM_W_COLORPICK,     "prt_ldfill_cpick",
			&pref.prt_fill_color[ZPT_LOAD], 0,
   CFM_T_INT,           "print/ldfill_color",        0, "-65281"},
  {CFM_W_SPBTN_DOUBLE,  "prt_lddiam_spbtn",
			&pref.prt_diam[ZPT_LOAD],    0,
   CFM_T_DOUBLE,        "print/lddiam",              0, "2.0"},
  {CFM_W_COLORPICK,     "prt_ldbrdr_cpick",
			&pref.prt_brdr_color[ZPT_LOAD], 0,
   CFM_T_INT,           "print/ldbrdr_color",        0, "-6160129"},
  {CFM_W_SPBTN_DOUBLE,  "prt_ldbrdr_spbtn",
			&pref.prt_brdr[ZPT_LOAD],    0,
   CFM_T_DOUBLE,        "print/ldbrdr",              0, "0.2"},

  // Intermediate points
  {CFM_W_COLORPICK,     "prt_intfill_cpick",
			&pref.prt_fill_color[ZPT_INT], 0,
   CFM_T_INT,           "print/intfill_color",       0, "16711935"},
  {CFM_W_SPBTN_DOUBLE,  "prt_intdiam_spbtn",
			&pref.prt_diam[ZPT_INT],     0,
   CFM_T_DOUBLE,        "print/intdiam",             0, "1.0"},
  {CFM_W_COLORPICK,     "prt_intbrdr_cpick",
			&pref.prt_brdr_color[ZPT_INT], 0,
   CFM_T_INT,           "print/intbrdr_color",       0, "7210751"},
  {CFM_W_SPBTN_DOUBLE,  "prt_intbrdr_spbtn",
			&pref.prt_brdr[ZPT_INT],     0,
   CFM_T_DOUBLE,        "print/intbrdr",             0, "0.1"},

  // Final points
  {CFM_W_COLORPICK,     "prt_finalfill_cpick",
			&pref.prt_fill_color[ZPT_FINAL], 0,
   CFM_T_INT,           "print/finalfill_color",     0, "-16776961"},
  {CFM_W_COLORPICK,     "prt_finalbrdr_cpick",
			&pref.prt_brdr_color[ZPT_FINAL], 0,
   CFM_T_INT,           "print/finalbrdr_color",     0, "-1275068161"},
  {CFM_W_SPBTN_DOUBLE,  "prt_finaldiam_spbtn",
			&pref.prt_diam[ZPT_FINAL],   0,
   CFM_T_DOUBLE,        "print/finaldiam",           0, "2.0"},
  {CFM_W_SPBTN_DOUBLE,  "prt_finalbrdr_spbtn",
			&pref.prt_brdr[ZPT_FINAL],   0,
   CFM_T_DOUBLE,        "print/finalbrdr",           0, "0.2"},


  // Actual plot properties - arcs
  // Z - arcs
  {CFM_W_COLORPICK,     "prt_z_arc_cpick",
                        &pref.prt_arc_color[Z_ARC],  0,
   CFM_T_INT,           "print/arc_color_z",         0, "-6576641"},
  {CFM_W_SPBTN_DOUBLE,  "prt_z_arc_spbtn",
			&pref.prt_arc_size[Z_ARC],   0,
   CFM_T_DOUBLE,        "print/arc_z",               0, "0.4"},

  // Y - arcs
  {CFM_W_COLORPICK,     "prt_y_arc_cpick",
                        &pref.prt_arc_color[Y_ARC],  0,
   CFM_T_INT,           "print/arc_color_y",         0, "-1212678145"},
  {CFM_W_SPBTN_DOUBLE,  "prt_y_arc_spbtn",
			&pref.prt_arc_size[Y_ARC],   0,
   CFM_T_DOUBLE,        "print/arc_y",               0, "0.4"},

  // Line - arcs
  {CFM_W_COLORPICK,     "prt_line_arc_cpick",
                        &pref.prt_arc_color[K_ARC],  0,
   CFM_T_INT,           "print/arc_color_line",      0, "-1308642817"},
  {CFM_W_SPBTN_DOUBLE,  "prt_line_arc_spbtn",
			&pref.prt_arc_size[K_ARC],   0,
   CFM_T_DOUBLE,        "print/arc_line",            0, "0.4"},

  // Z-Y connection lines
  {CFM_W_COLORPICK,     "prt_zy_line_cpick",
                        &pref.prt_arc_color[ZY_LINE], 0,
   CFM_T_INT,           "print/arc_color_zyline",    0, "-1179010561"},
  {CFM_W_SPBTN_DOUBLE,  "prt_zy_line_spbtn",
                        &pref.prt_arc_size[ZY_LINE], 0,
   CFM_T_DOUBLE,        "print/arc_zyline",          0, "0.1"},

  // Misc
  // SWR circle
  {CFM_W_COLORPICK,     "prt_swrcircle_cpick",   &pref.prt_swr_color, 0,
   CFM_T_INT,           "print/swr_color",           0, "-8750337"},
  {CFM_W_SPBTN_DOUBLE,  "prt_swrcircle_spbtn",   &pref.prt_swr_size, 0,
   CFM_T_DOUBLE,        "print/swr_size",            0, "0.1"},

  // G=1 circle
  {CFM_W_COLORPICK,     "prt_g1circle_cpick",    &pref.prt_g1_color, 0,
   CFM_T_INT,           "print/g1_color",            0, "-1010580481"},
  {CFM_W_SPBTN_DOUBLE,  "prt_g1circle_spbtn",    &pref.prt_g1_size, 0,
   CFM_T_DOUBLE,        "print/g1_size",             0, "0.1"},

  // Font
  {CFM_W_ENTRY_STR,     "prt_font_entry",        &pref.prt_font_name, 0,
   CFM_T_STR,           "print/prt_font_name",       0, "Helvetica"},
  {CFM_W_COLORPICK,     "prt_font_cpick",        &pref.font_color, 0,
   CFM_T_INT,           "print/font_color",          0, "-1097924353"},
  {CFM_W_SPBTN_DOUBLE,  "prt_fontsize_spbtn",    &pref.prt_font_size, 0,
   CFM_T_DOUBLE,        "print/font_size",           0, "2.0"},

  // Remote control parameters
  {CFM_W_CBTN,		"confrem_enable_cbtn",   &pref.rem_enabled, 0,
   CFM_T_CHAR,		"remote/enabled",            0, "0"},
  {CFM_W_ENTRY_STR,	"confrem_outpipe_entry", &pref.rem_outpipe, 0,
   CFM_T_STR,		"remote/outpipe",	     0, "/tmp/linsmith.out"},
  {CFM_W_ENTRY_STR,	"confrem_inpipe_entry",	 &pref.rem_inpipe, 0,
   CFM_T_STR,		"remote/inpipe",	     0, "/tmp/linsmith.in"},
  {CFM_W_ENTRY_INT,	"confrem_timeout_entry", &pref.rem_timeout, 0,
   CFM_T_INT,		"remote/timeout",	     0, "2000"},
  {CFM_W_CBTN,		"confrem_enext_cbtn",    &pref.rem_enext, 0,
   CFM_T_CHAR,          "remote/enable_remote",	     0, "0"}
};
#define preflen (sizeof(preftable)/sizeof(conf_definition))

conf_definition pathtable[] = {
  // Common
  {CFM_W_ENTRY_STR,     "conf_last_ld_entry",    &pref.last_ld_file, 0,
   CFM_T_STR,           "files/last_load_file",  0, ""},
  {CFM_W_ENTRY_STR,     "conf_last_el_entry",    &pref.last_el_file, 0,
   CFM_T_STR,           "files/last_elem_file",  0, ""},
  {CFM_W_ENTRY_STR,     "conf_last_ps_entry",    &pref.last_ps_file, 0,
   CFM_T_STR,           "files/last_ps_file",    0, ""}
};
#define pathlen (sizeof(pathtable)/sizeof(conf_definition))

void
save_config(void)
{
  save_by_table(NULL, preftable, preflen);
}

void
save_file_paths(void)
{
  save_by_table(NULL, pathtable, pathlen);
}

void
load_config(void)
{
  load_by_table(NULL, preftable, preflen);
}


void
parse_configwindow(GtkWidget *ref)
{
  parse_widget_by_table(preftable, preflen, ref);
}


void
load_configwindow(GtkWidget *ref)
{
  load_widget_by_table(preftable, preflen, ref);
}
