#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

#include "dialog.h"

#include "selection.h"

using namespace std;

namespace MLS {

Selection::~Selection()
{
}

};

std::string MLS::Selection::GetFullPath(int idx) const
{
	if ( *(vData[idx].end() - 1) == '/' ) return sBaseDir + vData[idx];
	
	// idx를 기준으로 끝이 / 인 것을 차례로 찾는다
	for (int t=idx-1; t>=0; t++)
		if ( *(vData[t].end() - 1) == '/' ) return sBaseDir + vData[t] + vData[idx];
	
	return sBaseDir + vData[idx];
}

uint MLS::Selection::CalcSize( )
{
	struct stat statbufs;
	string path = sBaseDir;
	int size = vData.size();	
	bool bDirAvail = true;
	
	nSize = 0;
		
	for (int t=0; t<size; t++)
	{
		if (vData[t][vData[t].size()-1] == '/')
		{// 디렉토리 라면..
			path = sBaseDir;
			path += vData[t];
			
			if (lstat(path.c_str(), &statbufs)==-1) bDirAvail = false;
			
			// sum을 세지 않는다.		
			continue;
		}	
						
		if (!bDirAvail) continue;
		if (lstat((path + vData[t]).c_str(), &statbufs)==-1) continue;
			
		nSize += statbufs.st_size;
	}
	
	return nSize;
}

void MLS::Selection::ExpandDir(bool bCtlBreak)
{
	DIR        *handle;
	dirent     *pFile;
	struct stat stat_bufs;
	
	vector<std::string> dirs;
	
	// dirs를 채워 넣는다.
	// 뒤에 있으므로 뒤에서부터 채워넣기
	int t, size = vData.size();
		
	for (t = size-1; t>=0; t--)
	{
		if (*vData[t].rbegin() != '/') break;
	}
	
	t++;
		
	dirs.reserve(size-t);	
	dirs.assign(vData.rbegin(), vData.rbegin()+(size-t));
	vData.erase(vData.begin()+t, vData.end());	

	nodelay(stdscr, TRUE);
	
	while(!dirs.empty())
	{
		string curr = dirs.back();
		dirs.pop_back();
		
		struct stat statbuf;
		string tmp = sBaseDir + curr;

		// ESC를 누르면 STOP 된다.
		if (bCtlBreak && getch()==27) break;
		
		if (lstat(tmp.substr(0, tmp.size()-1).c_str(), &statbuf) == -1) continue;
		
		if (S_ISLNK(statbuf.st_mode))
		{
			vData.push_back(curr);
			continue;
		}
	
		if ((handle = opendir((sBaseDir + curr).c_str()))==NULL) continue;	
		vData.push_back(curr);
		
	
		while((pFile = readdir(handle)))
		{
			
			if (!strcmp(pFile->d_name, ".")) continue;
			if (!strcmp(pFile->d_name, "..")) continue;
		
			if (lstat((sBaseDir + curr +  pFile->d_name).c_str(), &stat_bufs)==-1) continue;
			
			if (S_ISDIR(stat_bufs.st_mode) ) dirs.push_back(curr + pFile->d_name + '/');
			else 
			{
				vData.push_back(pFile->d_name);
				nSize += stat_bufs.st_size;
			}
		}
		closedir(handle);
	}

	nodelay(stdscr, FALSE);
}

