#include "qcd.h"
#include "dialog.h"
#include "strutil.h"
#include "DirMcd.h"
#include "mainframe.h"

using namespace strutil;

namespace MLS {

Qcd::Qcd()
	: ListBox("QCD - Quick Change Directory")
{
	UpdateConfig();
}


Qcd::~Qcd()
{
	SaveConfig();
}

void Qcd::UpdateConfig()
{
	_item.resize(10);

	for (int t=0; t<10; t++)
		_item[t] = config.GetValue("QcdF" + itoa(t+1));

}

void Qcd::SaveConfig()
{
	for (int t=0; t<10; t++)
		config.SetValue("QcdF" + itoa(t+1), _item[t] );
}

void Qcd::Proc(int key)
{
	switch(key)
	{
	case 13:
		if ( _item[_sel].empty() )
		{
			DirMcd mcd( "" /* 현재 디렉토리 집어넣기..*/, "QCD - What directory you want to make a shortcut to ");
			if (mcd.proc())
				_item[_sel] = mcd.getCur();

		}
		else
		{
			g_Command.Execute("cd " + _item[_sel]);
			g_MainFrame->RefreshPanel();
			Shutdown(true);
		}
		return;

	case KEY_IC:
		{
			DirMcd mcd;
			mcd.proc();

			_item[_sel] = mcd.getCur();
		}
		break;

	case KEY_DC:
		_item[_sel].erase();

		break;
	}

	ListBox::Proc(key);
}

int Qcd::Do()
{
	CalcWidth();
	return ListBox::Do();
}

}

