///	\file	panel_draw.cpp
///	\brief	panel_draw.cpp
#include <ncurses.h>
#include <vector>
#include <algorithm>

#include "mls.h"
#include "panel.h"
#include "mlslocale.h"
#include "drawutil.h"
#include "strutil.h"
#include "dialog.h"
#include "mainframe.h"

using namespace std;
using namespace strutil;

namespace {
	char kindsort[6] = {' ', 'N', 'E', 'S', 'T', 'B'};	///< 파일 정렬 방식
}

namespace MLS {

///	\brief	화면에 mls를 그린다.
void Panel::Draw(bool bDrawCursor)
{
	int i;

	setcol(g_Color.Default, _win);
	for (int j=0;j<_lines; j++)
	{
		wmove(_win, j, 0);
		whline(_win, ' ', _cols);
	}

	int size = _file_list.size();
	const int maxlen = 12;

	// . 자동 컬럼 지정 모드
	// 1. 파일 개수에 맞게 컬럼수 지정 -> 모드 선택
	if (_column == 0)
	{
		if (size <= _lines) _ncol = 1;
		else if (size <= _lines*2) _ncol = 2;
		else if (size <= _lines*3) _ncol = 3;
		else if (size <= _lines*4) _ncol = 4;
		else if (size <= _lines*5) _ncol = 5;
		else _ncol = 6;

		// 최대 가능 컬럼수  maxcol = _cols / 12(최소 열두자)
		// 적어도 12자는 보이게 하자
		if (_ncol > _cols / maxlen)
			_ncol = _cols / maxlen;
	}
	else
	{
		_ncol = _column;
	}

	if ( !_bFixedRow && !g_MainFrame->IsSplit() &&
		(size + _ncol - 1) / _ncol <= _lines )
	{
		_nrow = (size + _ncol - 1 )/ _ncol;
	}
	else
	{
		_nrow = _lines;
	}

	if ( (maxlen+39)*_ncol-1 <= _cols)
	{
		DrawMode1((_cols+1)/_ncol-39, bDrawCursor);
	}
	else if ( (maxlen+24)*_ncol-1 <= _cols)
	{
		DrawMode2((_cols+1)/_ncol-24, bDrawCursor);
	}
	else if ( (maxlen+9)*_ncol-1 <= _cols)
	{
		DrawMode3((_cols+1)/_ncol-9, bDrawCursor);
	}
	else
	{
		DrawMode4((_cols+1)/_ncol-2, bDrawCursor);
	}

	redrawwin(_win);
	wrefresh(_win);
}


void Panel::DrawStatus()
{
	// _nrow부터.. 마지막까지..
	setcol(g_Color.Line);
	for(int t=_nrow+5 ; t< g_nLINES-1; t++)
	{
		move(t, 0);
		hline(' ', g_nCOLS);
	}

	// 위 아래 선 및 경계선 긋기..
	setcol(g_Color.Line);
	move(2,0);	    hline(HLINE, g_nCOLS);
	move(_nrow+3,0);	hline(HLINE, g_nCOLS);

	// 찾기 창
	setcol(g_Color.Default);
	if (!_strSearch.empty())
		mvprintw(2, g_nCOLS-22, "[%-20s]", _strSearch.c_str());

	//  FileManager Status
	setcol(g_Color.StatA);
	move(_nrow+4, 0);
	hline(' ', g_nCOLS);

	mvprintw(_nrow+4, 0, "%5d ", _nfile);
	mvprintw(_nrow+4, 10, "%5d ", _ndir);
	mvprintw(_nrow+4, 23, "%14.14s ", toregular(_dir_size).c_str());

	if (_sel_num)
	{
		 mvprintw(_nrow+4, 42, "%5d", _sel_num);
		 if (_sel_size >= 1000000000)
		 	mvprintw(_nrow+4, 58, " %10.3f G", (float)_sel_size/1073741824);
		 else
		 	mvprintw(_nrow+4, 58, " %11.11s ", toregular(_sel_size).c_str());
	}

	setcol(g_Color.Stat);
	mvprintw(_nrow+4, 6,	gettext("File"));
	mvprintw(_nrow+4, 16, 	gettext("Dir"));
	mvprintw(_nrow+4, 38, 	gettext("Byte"));

	if (_sel_num)
	{
		mvprintw(_nrow+4, 47, gettext(" Selected ("));
		mvprintw(_nrow+4, 71, gettext("Bytes)       "));
	}

	if (g_MainFrame->_tClipboard.GetState() == CLIP_COPY)
	{
		setcol(g_Color.StatA);
		mvaddch(_nrow+4, g_nCOLS-3, 'C');
	}

	if (g_MainFrame->_tClipboard.GetState() == CLIP_CUT)
	{
		setcol(g_Color.StatA);
		mvaddch(_nrow+4, g_nCOLS-3, 'U');
	}

	setcol(COLOR_YELLOW+8, COLOR_WHITE);
	mvaddch(_nrow+4, g_nCOLS-2, kindsort[_eSortMethod%6]);

	setcol(COLOR_RED, COLOR_WHITE);

	if(_bShowHidden) mvaddch(_nrow+4, g_nCOLS-1, 'H');

	// Functional Status Panel
	// attr
	// //소유자
	// //그룹
	// 만들어진 시간
	// 크기
	// 파일 이름

	File &rf = *_file_list[_cur];

	setcol(g_Color.Func);

	move(g_nLINES-1, 0);
	hline(' ', g_nCOLS);

	mvprintw(g_nLINES-1, 0, "%-11.11s", rf.attr);
	mvprintw(g_nLINES-1, 12, "%10.0d", rf.size);
	mvprintw(g_nLINES-1, 23, "%s %s", rf.date, rf.time);
	mvprintw(g_nLINES-1, 38, "%s", rf.name.substr(0, g_nCOLS-38).c_str());

	setcol(COLOR_BLACK, g_Color.Func.back);
	mvaddch(g_nLINES-1, 11, VLINE);
	mvaddch(g_nLINES-1, 22, VLINE);
	mvaddch(g_nLINES-1, 37, VLINE);
}

// 퍼미션(10) + 1 + 날짜(8) + 1 + 시간(5) + 셀렉트 표시(1) + 파일(n) + 1 + 크기(10) + 1
// = n + 38
void Panel::DrawMode1(int n, bool bDrawCursor)
{
	int width = n + 39;
	int  page = _cur / (_ncol * _nrow);
	uint cnum = page * _ncol * _nrow;

	pFileIterator p = _file_list.begin() + cnum;

	// 경계선 긋기
	setcol(g_Color.Line, _win);
	for (int i=1; i<_ncol; i++)
		for (int j=0; j<_nrow; j++)
			mvwaddch (_win, j, i * width - 1, VLINE);

	for (int col=0; col<_ncol; col++)
	for (int row=0; row<_nrow; row++)
	{
		if (p == _file_list.end()) return;
		File &rf = *(*p);

		wmove(_win,row,col*width);

		// 디렉토리일 경우
		if (rf.bDir)
		{
			if (bDrawCursor && cnum == _cur) setrcol(g_Color.Dir, _win);
			else setcol(g_Color.Default, _win);

			whline(_win,' ', width-1);
			wprintw(_win,"%s %s %s", rf.attr, rf.date, rf.time);


			if (bDrawCursor && cnum == _cur) setcol(COLOR_WHITE+8, g_Color.Dir.font, _win);
			else setcol(COLOR_WHITE+8, g_Color.Dir.back, _win);

			if (rf.selected) waddch(_win, '*');
			else waddch(_win, ' ');


			if (bDrawCursor && cnum == _cur) setrcol(g_Color.Dir, _win);
			else setcol(g_Color.Dir, _win);

			if (krstrlen(rf.name) >= n) wprintw(_win,"%s~ ", krstrncpy(rf.name, 0, n-1).c_str());
			else wprintw(_win,"%s ", rf.name.c_str());

			mvwprintw(_win,row, col*width+width-12, "[ SubDir ] ");

		}
		else
		{
			if (bDrawCursor && cnum == _cur) setrcol(*rf.color, _win);
			else setcol(g_Color.Default, _win);

			whline(_win,' ', width-1);
			wprintw(_win,"%s %s %s",rf.attr, rf.date, rf.time);


			if (bDrawCursor && cnum == _cur) setcol(COLOR_WHITE+8, rf.color->font, _win);
			else setcol(COLOR_WHITE+8, rf.color->back, _win);

			if (rf.selected) waddch(_win, '*');
			else waddch(_win, ' ');

			if (bDrawCursor && cnum == _cur) setrcol(*rf.color, _win);
			else setcol(*rf.color, _win);

			if (krstrlen(rf.name) > n ) wprintw(_win,"%s~ ", krstrncpy(rf.name,0,n-1).c_str());
			else wprintw(_win,"%s ", rf.name.c_str());

			wmove(_win, row, col * width + width -12);

			if (rf.size >= 10000000)
			{
				wprintw(_win,"%9.1f", (float)rf.size/1048576);

				if (cnum == _cur) setcol(11, rf.color->font, _win);
				else setcol(11, g_Color.Default.back, _win);
				waddch(_win,'M');
				waddch(_win,' ');
			}
			else wprintw (_win, "%10s ", toregular(rf.size).c_str());
		}

		p++;
		cnum++;
	}

}

// 파일(n) + 셀렉트 표시(1) + 크기(6) + 1 + 날짜(8) + 1 + 시간(5) + 1
// = n + 23
void Panel::DrawMode2(int n, bool bDrawCursor)
{
	int width = n + 24;
	int  page = _cur / (_ncol * _nrow);
	uint cnum = page * _ncol * _nrow;

	pFileIterator p = _file_list.begin() + cnum;

	// 경계선 긋기
	setcol(g_Color.Line, _win);
	for (int i=1; i<_ncol; i++)
		for (int j=0; j<_nrow; j++)
			mvwaddch (_win, j, i * width - 1, VLINE);

	for (int col=0; col<_ncol; col++)
	for (int row=0; row<_nrow; row++)
	{
		if (p == _file_list.end()) return;

		File &rf = *(*p);

		if (rf.bDir)
		{
			if (bDrawCursor && cnum == _cur) setrcol(g_Color.Dir, _win);
			else setcol(g_Color.Dir, _win);

			wmove(_win,row, col*width);
			whline(_win,' ', width-1);

			if (krstrlen(rf.name) >= n ) 
				mvwprintw(_win,row,col*width, "%s~", krstrncpy(rf.name,0, n-1).c_str());
			else 
				mvwprintw(_win,row,col*width, "%s", rf.name.c_str());

			if (bDrawCursor && cnum == _cur) setcol(COLOR_WHITE+8, g_Color.Dir.font, _win);
			else setcol(COLOR_WHITE+8, g_Color.Dir.back, _win);

			wmove(_win,row, col*width+width-24);

			if (rf.selected) waddch(_win, '*');
			else waddch(_win, ' ');

			if (bDrawCursor && cnum == _cur) setrcol(g_Color.Dir, _win);
			else setcol(g_Color.Dir, _win);

			wprintw(_win,"  DIR  ");

			if (bDrawCursor && cnum == _cur) setrcol(g_Color.Dir, _win);
			else setcol(g_Color.Default, _win);

			wprintw(_win,"%s %s ",rf.date, rf.time);
		}
		else
		{

			if (bDrawCursor && cnum == _cur) setrcol(*rf.color, _win);
			else setcol(*rf.color, _win);

			wmove(_win,row, col*width);
			whline(_win,' ', width-1);

			if (rf.name.size() >= n) mvwprintw(_win,row,col*width, "%s~", rf.name.substr(0, n-1).c_str());
			else mvwprintw(_win,row,col*width, "%s", rf.name.c_str());



			wmove(_win,row, col*width+width-24);

			if (bDrawCursor && cnum == _cur) setcol(COLOR_WHITE+8, rf.color->font, _win);
			else setcol(COLOR_WHITE+8, rf.color->back, _win);

			if (rf.selected) waddch(_win,'*');
			else waddch(_win,' ');

			if (bDrawCursor && cnum == _cur) setrcol(*rf.color,_win);
			else setcol(g_Color.Default, _win);

			if (rf.size >= 1000000)
			{
				wprintw(_win,"%5.1f", (float)rf.size/1048576);

				if (bDrawCursor && cnum == _cur) setcol(11, rf.color->font, _win);
				else setcol(11, g_Color.Default.back, _win);
				waddch(_win,'M');

				if (bDrawCursor && cnum == _cur) setrcol(*rf.color,_win);
				else setcol(g_Color.Default,_win);
			}
			else wprintw (_win,"%6d", rf.size);
			wprintw(_win," %s %s ",rf.date, rf.time);
		}

		p++;
		cnum++;
	}
}

// 셀렉트 표시(1) + 파일(n) + 1 + 크기(6)
// = n + 8
void Panel::DrawMode3(int n, bool bDrawCursor)
{
	int width = n + 9;
	int  page = _cur / (_ncol * _nrow);
	uint cnum = page * _ncol * _nrow;

	pFileIterator p = _file_list.begin() + cnum;

	// 경계선 긋기
	setcol(g_Color.Line, _win);
	for (int i=1; i<_ncol; i++)
		for (int j=0; j<_nrow; j++)
			mvwaddch (_win, j, i * width - 1, VLINE);

	for (int col=0; col<_ncol; col++)
		for (int row=0; row<_nrow; row++)
		{
			if (p == _file_list.end()) return;
			File &rf = *(*p);

			wmove(_win,row, col*width);

			if (rf.bDir)
			{
				if (bDrawCursor && cnum == _cur) setcol(COLOR_WHITE+8, g_Color.Dir.font, _win);
				else setcol(COLOR_WHITE+8, g_Color.Dir.back, _win);
				// 뒷배경 채우기
				whline(_win,' ', width-1);
				// 셀렉트 표시 하기
				if (rf.selected) waddch(_win,'*');
				else waddch(_win,' ');

				if (bDrawCursor && cnum == _cur) setrcol(g_Color.Dir, _win);
				else setcol(g_Color.Dir, _win);
				if (krstrlen(rf.name) > width-2) wprintw(_win,"%s~", krstrncpy(rf.name, 0, width - 3).c_str());
				else wprintw(_win,"%s", rf.name.c_str());

			}
			else
			{
				if (bDrawCursor && cnum == _cur) setcol(COLOR_WHITE+8, rf.color->font, _win);
				else setcol(COLOR_WHITE+8, rf.color->back, _win);
				// 뒷배경 채우기
				whline(_win,' ', width-1);
				// 셀렉트 표시 하기
				if (rf.selected) waddch(_win,'*');
				else waddch(_win,' ');


				// 파일 표시
				if (bDrawCursor && cnum == _cur) setrcol(*rf.color, _win);
				else setcol(*rf.color, _win);
				if (krstrlen(rf.name) > n) wprintw(_win,"%s~ ", krstrncpy(rf.name, 0, n-1).c_str());
				else wprintw(_win,"%s ", rf.name.c_str());


				// 크기 표시
				wmove(_win,row, col*width+width-7);

				if (bDrawCursor && cnum == _cur) setrcol(*rf.color, _win);
				else setcol(g_Color.Default, _win);

				if (rf.size >= 1000000)
				{
					wprintw(_win,"%5.1f", (float)rf.size/1048576);

					if (bDrawCursor && cnum == _cur) setcol(11, rf.color->font, _win);
					else setcol(11, g_Color.Default.back, _win);
					waddch(_win, 'M');
				}
				else wprintw(_win,"%6d", rf.size);

			}

			p++;
			cnum++;
		}
}

// 셀렉트 표시(1) + 파일(n)
// = n + 1
void Panel::DrawMode4(int n, bool bDrawCursor)
{
	int width = n + 2;
	int  page = _cur / (_ncol * _nrow);
	uint cnum = page * _ncol * _nrow;

	pFileIterator p = _file_list.begin() + cnum;

	// 경계선 긋기
	setcol(g_Color.Line, _win);
	for (int i=1; i<_ncol; i++)
		for (int j=0; j<_nrow; j++)
			mvwaddch (_win, j, i * width - 1, VLINE);


	for (int col=0; col<_ncol; col++)
		for (int row=0; row<_nrow; row++)
		{
			if (p == _file_list.end()) return;

			File &rf = *(*p);

			wmove(_win,row, col*width);

			if (rf.bDir)
			{
				// 뒷 배경 채우기
				if (bDrawCursor && cnum == _cur) setrcol(g_Color.Dir, _win);
				else setcol(g_Color.Dir, _win);
				whline(_win,' ', width-1);


				// 셀렉트 표시 하기
				if (bDrawCursor && cnum == _cur) setcol(COLOR_WHITE+8, g_Color.Dir.font, _win);
				else setcol(COLOR_WHITE+8, g_Color.Dir.back, _win);
				if (rf.selected) waddch(_win,'*');
				else waddch(_win,' ');


				// 디렉토리 이름 표시하기
				if (bDrawCursor && cnum == _cur) setrcol(g_Color.Dir, _win);
				else setcol(g_Color.Dir, _win);
				if (krstrlen(rf.name) > width-2) wprintw(_win,"%s~", krstrncpy(rf.name,0, width-3).c_str());
				else wprintw(_win,"%s", rf.name.c_str());
			}
			else
			{
				// 뒷배경 채우기
				if (bDrawCursor && cnum == _cur) setrcol(*rf.color, _win);
				else setcol(*rf.color, _win);
				whline(_win,' ', width-1);

				// 셀렉트 표시
				if (bDrawCursor && cnum == _cur) setcol(COLOR_WHITE+8, rf.color->font, _win);
				else setcol(COLOR_WHITE+8, rf.color->back, _win);
				if (rf.selected) waddch(_win,'*');
				else waddch(_win,' ');


				// 파일 이름 표시
				if (bDrawCursor && cnum == _cur) setrcol(*rf.color, _win);
				else setcol(*rf.color, _win);
				if (krstrlen(rf.name) > n) wprintw(_win,"%s~", krstrncpy(rf.name,0, n-1).c_str());
				else wprintw(_win,"%s", rf.name.c_str());

			}

			p++;
			cnum++;
		}
}

} // namespace MLS
