///	@file	panel_cmd.cpp
///	@brief	panel_cmd.cpp
#include <ncurses.h>
#include <sys/stat.h>

#include <string>
#include <vector>

#include "mls.h"
#include "panel.h"
#include "strutil.h"
#include "mlslocale.h"
#include "dialog.h"
#include "commandimp.h"
#include "StringTokenizer.h"
#include "editor.h"
#include "editorcmd.h"

using namespace std;
using namespace strutil;
using namespace MLS;

void MLS::CommandImp::NewFile()
{
	if (panel->isZip() == false)
	{
		string	sFilename;
		if (InputBox("New File...", sFilename) == 0) return;
		if (sFilename.size() == 0)	return;

		if (!config.GetValue("ExtViewer").empty() || !g_pEditor->isKeyCfgLoad())
		{
			if (!config.GetValue("ExtEditor").empty())
			{
				ParseAndRun(config.GetValue("ExtEditor") + " " + sFilename);
				return;
			}
		}
		
		int		nSize = 0;
		string	sSize = config.GetValue("EditorTabSize");
		
		if (sSize == "")	nSize = 8;
		else 				nSize = atoi(sSize.c_str());
	
		bool bEditorLineNum = config.GetBool("EditorLineNum");
		bool bEditorBackup = config.GetBool("EditorBackup");
		
		g_pEditor->SetEditor(nSize, bEditorBackup, bEditorLineNum);
		
		ifstream in(sFilename.c_str());
		if (in)
		{
			MsgBox(gettext("Error"), gettext("current file using."));
			Refresh();
			return;
		}
		
		g_pEditor->New(sFilename);
		g_pEditor->SetTitle("["+sFilename+"]");
		g_pEditor->Resize(g_nLINES, g_nCOLS);
		g_pEditor->Do();
		Refresh();
	}
}

void MLS::CommandImp::ExtEditor()
{
	if (config.GetValue("ExtEditor").empty())
		EditorChoice(false, "vi");
	else
		EditorChoice(false, config.GetValue("ExtEditor"));
}

void MLS::CommandImp::Edit()
{
	if (config.GetValue("ExtEditor").empty())
		EditorChoice(false);
	else
		EditorChoice(false, config.GetValue("ExtEditor"));
}

void MLS::CommandImp::View()
{
	if (config.GetValue("ExtViewer").empty())
		EditorChoice(false);
	else
		EditorChoice(false, config.GetValue("ExtViewer"));
}

void MLS::CommandImp::EditorChoice(bool bReadOnly, const string& sEditorCmd)
{
	File 	rf = panel->GetCurrentFile();
	string	tmp_name;
	string sTitle;

	if (panel->isZip() == true)
	{
		try
		{
			if (panel->_tReader->View(rf, "/tmp") == SUCCESS)
			{
				tmp_name = rf.name;
				rf.name = "/tmp/" + rf.FullName;
			}
		}
		catch(Exception& ex)
		{
			MsgBox(	gettext("Error"), gettext("file reading failure !!!!"));
			return;
		}
		sTitle = "[" + panel->GetPathView() + rf.FullName + "]";	
	}
	else
		sTitle = "[" + panel->GetPathView() + rf.name + "]";

	bool bExtEditor = false;
	if (!sEditorCmd.empty()) bExtEditor = true;

	// 키파일 설정이 없으면 외부에디터로 띄운다.
	if (config.GetValue("EditorKeyFile").empty() || !g_pEditor->isKeyCfgLoad()) bExtEditor = true;
	
	if (bExtEditor == false)
	{
		int		nSize = 0;
		string	sSize = config.GetValue("EditorTabSize");
		if (sSize == "")	nSize = 8;
		else 				nSize = atoi(sSize.c_str());
	
		bool bEditorLineNum = config.GetBool("EditorLineNum");
		bool bEditorBackup = config.GetBool("EditorBackup");

		if (bReadOnly == false) bReadOnly = panel->isZip();
		g_pEditor->SetEditor(nSize, bEditorBackup, bEditorLineNum);
		
		if (g_pEditor->Load(rf.name.c_str(), bReadOnly) == false)
			MsgBox(	gettext("Error"), gettext("File loading failure."));
		else
		{
			g_pEditor->SetTitle(sTitle);
			g_pEditor->Resize(g_nLINES, g_nCOLS);
			g_pEditor->Do();
			Refresh();
		}
	}
	else
	{
		if (sEditorCmd.empty())
			ParseAndRun("vi " + rf.name);
		else
			ParseAndRun(sEditorCmd + " " + rf.name);
	}

	if (panel->isZip())
	{
		string sDir;
		sDir = rf.name.substr(5);
		
		string::size_type p = sDir.find('/');
		if (p != -1)
			sDir = "rm -rf /tmp/" + sDir.substr(0, p);
		else
			sDir = "rm -rf /tmp/" + sDir;
		
		system(sDir.c_str());
		rf.name = tmp_name;
	}
	return;
}

/*
void MLS::CommandImp::View()
{
	File 	rf = panel->GetCurrentFile();
	string	tmp_name;
	string sTitle;

	if (panel->isZip() == true)
	{
		try
		{
			if (panel->_tReader->View(rf, "/tmp") == SUCCESS)
			{
				tmp_name = rf.name;
				rf.name = "/tmp/" + rf.FullName;
			}
		}
		catch(Exception& ex)
		{
			MsgBox(	gettext("Error"), gettext("file reading failure !!!!"));
			return;
		}
		sTitle = "View [" + panel->GetPathView() + rf.FullName + "]";	
	}
	else
		sTitle = "View [" + panel->GetPathView() + rf.name + "]";

	int		nSize = 0;
	string	sSize = config.GetValue("ViewTabSize");
	if (sSize == "")	nSize = 8;
	else 				nSize = atoi(sSize.c_str());

	bool bViewLineNum = config.GetBool("ViewLineNum");
	bool bViewLineNext = config.GetBool("ViewLineNext");

	TextBox		tTextBox(sTitle.c_str(), g_nLINES-6, g_nCOLS-6);
	if (tTextBox.Load(rf.name.c_str(), nSize) == false)
		MsgBox(	gettext("Error"), gettext("Don't execute"));
	else
		tTextBox.Do(bViewLineNum, bViewLineNext);
	
	if (panel->isZip())
	{
		string sDir;
		sDir = rf.name.substr(5);
		
		string::size_type p = sDir.find('/');
		if (p != -1)
			sDir = "rm -rf /tmp/" + sDir.substr(0, p);
		else
			sDir = "rm -rf /tmp/" + sDir;
		
		system(sDir.c_str());
		rf.name = tmp_name;
	}
	return;
}
*/

///	@brief	모든 커맨드 메시지를 관리
///	@param	p	실행 시킬 명령어
///	@return		명령어 실행 결과
int MLS::CommandImp::ParseAndRun(const string &p, bool Pause)
{
	bool	bFlag  = false, 
		 	bPause = Pause,
		 	bParam = false,
		 	bMcd   = false ,
		 	bConfirm = false,
			bBackground = false,
			bRootExe = false;
			
	// cd 구현
	if (p.substr(0, 2) == "cd")
	{
		string sStr;
		if (p == "cd" || p == "cd ") 
			sStr = panel->GetRealPath("~");
		else
			sStr = panel->GetRealPath(p.substr(3));

		string empty;
		sStr = Replace(sStr, "\\", "");
		
		// Zip일때는 실행하지 않는다.
		if (panel->isZip() == false)
		{
			LOG("chdir [%s]", sStr.c_str());
			int nRet = 0;
			if (sStr != "")	
			{
				if (panel->Read(sStr) == true) nRet = 1;
				panel->Refresh();
			}
			return nRet;
		}
	}
	
	File 	rf = panel->GetCurrentFile();
	string 	arg, tmp_name;
	
	// 압축파일인지 검사하여 /tmp 밑에 압축을 풀고 그 파일을 링크해준다.
	if (panel->isZip() == true)
	{
		try
		{
			if (panel->_tReader->View(rf, "/tmp") == SUCCESS)
			{
				tmp_name = rf.name;
				rf.name = "/tmp/" + rf.FullName;
			}
		}
		catch(Exception& ex)
		{
			MsgBox(	gettext("Error"), gettext("file reading failure !!!!"));
			return 0;
		}
	}
	
	// 파싱
	for (string::const_iterator i = p.begin(); i!= p.end(); i++)
	{
		if (*i == '%')
		{
			bFlag = true;
			continue;
		}
		
		if (bFlag)
		{
			switch(*i)
			{
			// 파일을 리턴해줌
			case '1':
			case 'F':
				arg += addslash(rf.name);
				break;
				
			case 'N':
			{
				if (rf.name[0]=='.') return 0;
				
				string::size_type p = rf.name.rfind('.');
				
				if (p!=string::npos)
					arg += addslash(rf.name.substr(0, p-1));
				else
					arg += addslash(rf.name);
				break;
			}
			
			case 'E':
				if (rf.ext().empty()) return 0;
				arg += addslash(rf.ext());
				
				break;
				
			case 'W':
				bPause = true;
				break;
				
			case '%':
				arg += '%';
				break;
				
			case 'S':
			{
				Selection tSelection = panel->GetSelection();
				
				if (tSelection.Size() == 0) return 0;				
				bool first = true;				
			
				for (int t = 0; t< tSelection.Size(); t++)
				{
					if (first) first= false;
					else arg += ' ';
					
					arg += addslash(tSelection[t]);
				}
				break;
			}
			
			case 's':
			{
				Selection tSelection = panel->GetSelection();
				
				if (!tSelection.Size() == 0)
				{
					bool first = true;					
				
					for (int t = 0; t< tSelection.Size(); t++)
					{
						if (first) first= false;
						else arg += ' ';
					
						arg += addslash(tSelection[t]);
					}
				}
				else 
				{
					if (rf.name == "..") return 0;
					arg += addslash(rf.name);
				}
				break;
			}
			
			case 'd':			
				arg += addslash(panel->GetCurrentPath());
				break;		
			
			case 'D':
				bMcd = true;
				break;
			
			case 'P':
				bParam= true;
				break;

			case 'R': // root 계정 실행시
				bRootExe = true;
				break;
				
			case 'H':
				arg += addslash(config.GetValue("home"));
				break;
				
			case 'Q':
				bConfirm = true;
				break;
				
			case 'B':
				bBackground = true;
				break;
				
			default:
				break;
			}
			
			bFlag = false;
			continue;
		}
		else arg += *i;
	}
	
	if (bMcd)
	{
		MLS::DirMcd mcd;
		mcd.setCur(panel->GetCurrentPath());
		if (!mcd.proc())
            return 0;
		arg += addslash(mcd.getCur());
	}
	
	if (bParam)	if (InputBox(gettext("Edit Parameter"), arg)<0) return 0;
		
	if (bConfirm)
		if (YNBox(gettext("Do you want to run this operation?"), YN_N) != YN_Y) return 0;

	if (bRootExe)
		arg = "su - --command=\"" + arg + "\"";
	
	// 실행
	int nRt = Run(arg, bPause, bBackground);
	
	// /tmp에 풀린 압축 파일을 지운다.
	if (panel->isZip() == true && bBackground == false)
	{
		string sDir;
		sDir = rf.name.substr(5);
		
		string::size_type p = sDir.find('/');
		
		if (p != -1)
			sDir = "rm -rf /tmp/" + sDir.substr(0, p);
		else
			sDir = "rm -rf /tmp/" + sDir;
		
		system(sDir.c_str());
		rf.name = tmp_name;
	}
	panel->Refresh();
	return nRt;
}
