#include "mlsmenu.h"
#include "keybind.h"
#include "mainframe.h"

using namespace MLS;
using namespace std;

void MlsMenu::MenuAddCatecory()
{
	MenuCategory mls("Mls");
		mls.AddItem(gettext("About"), "<about>");
		mls.AddItem(gettext("Help"), "<help>");
		mls.AddItem("", "");
		mls.AddItem(gettext("Quit Mls"), "<exit>");
	AddItem(mls);

	MenuCategory run(gettext("Run"));
		run.AddItem(gettext("Run"), "<enter>");
		run.AddItem(gettext("Run(select)"), "<execute>");
		run.AddItem("", "");
		run.AddItem(gettext("Shell command"), "<shell>");
		run.AddItem("", "");
		run.AddItem(gettext("View console"), "<viewconsole>");
	AddItem(run);

	MenuCategory files(gettext("File"));
		files.AddItem(gettext("New"), "<newfile>");
		files.AddItem(gettext("Touch File"), "<touchfile>");
		files.AddItem("", "");
		files.AddItem(gettext("CutClip"), "<cutclip>");
		files.AddItem(gettext("CopyClip"), "<copyclip>");
		files.AddItem(gettext("PasteClip"), "<pasteclip>");
		files.AddItem("", "");
		files.AddItem(gettext("Copy"), "<copy>");
		files.AddItem(gettext("Move"), "<move>");
		files.AddItem(gettext("Rename"), "<rename>");
		files.AddItem(gettext("Delete"), "<remove>");
		files.AddItem(gettext("Chmod"), "<chmod>");
		files.AddItem("", "");
		files.AddItem(gettext("View"), "<view>");
		files.AddItem(gettext("Edit"), "<edit>");
		files.AddItem(gettext("Size info"), "<sizeinfo>");
		files.AddItem(gettext("FileListSave"), "<filelist>");
		//files.AddItem(gettext("FileFind"), "", false);
		files.AddItem("", "");
		files.AddItem(gettext("Select all"), "<selectall>");
		files.AddItem(gettext("Invert select"), "<selectinvert>");
		//files.AddItem(gettext("Select group"), "", false);
	AddItem(files);

	MenuCategory dire(gettext("Directory"));
		dire.AddItem("Mcd", "<mcd>");
		dire.AddItem("Qcd", "<qcd>");
		dire.AddItem("", "");
		dire.AddItem(gettext("Mkdir"), "<mkdir>");
		dire.AddItem(gettext("To parent"), "<goup>");
		dire.AddItem(gettext("To root"), "<goroot>");
		dire.AddItem(gettext("To home"), "<gohome>");
		dire.AddItem("", "");
		dire.AddItem(gettext("Back"), "<back>");
		dire.AddItem(gettext("Forward"), "<forward>");
		//dire.AddItem("", "");
		//dire.AddItem(gettext("Properties"), "<properties>", false);
	AddItem(dire);

	MenuCategory arc(gettext("Archive"));
		arc.AddItem(gettext("Extract"), "<extract>");
		arc.AddItem("", "");
		arc.AddItem(gettext("Compress (tar.gz)"), "<targzcomp>");
		arc.AddItem(gettext("Compress (tar.bz2)"), "<tarbz2comp>");
		arc.AddItem(gettext("Compress (zip)"), "<zipcomp>");
	AddItem(arc);

	MenuCategory view(gettext("View"));
		view.AddItem(gettext("Refresh"), "<refresh>");
		view.AddItem("", "");
		view.AddItem(gettext("Column AUTO"), "<columnauto>");
		view.AddItem("", "");
		view.AddItem(gettext("Column 1"), "<column1>");
		view.AddItem(gettext("Column 2"), "<column2>");
		view.AddItem(gettext("Column 3"), "<column3>");
		view.AddItem(gettext("Column 4"), "<column4>");
		view.AddItem("", "");
		view.AddItem(gettext("Show/Hide hidden"), "<showhidden>");
		view.AddItem(gettext("Sort Change"), "<sortchange>");
		view.AddItem("", "");
		view.AddItem(gettext("Split"),  "<split>");
		view.AddItem(gettext("Next window"), "<nextwindow>");
	AddItem(view);

	MenuCategory op(gettext("Option"));
		op.AddItem(gettext("Linecode Change"), "<boxcodechange>");
		op.AddItem(gettext("Korean Mode"), "<langchange>");
		op.AddItem("", "");
		op.AddItem(gettext("Edit Config"), "<editconfig>");
		op.AddItem(gettext("Edit Keybind"), "<editkeybind>");
		op.AddItem(gettext("Edit Colorset"), "<editcolorset>");
	AddItem(op);
}

void 	MlsMenu::MenuRefresh()
{
	g_MainFrame->Refresh();
}
