///	\file	help.cpp
///	\brief	help.cpp

#include <ncurses.h>
#include "mlslocale.h"
#include "panel.h"
#include "config.h"
#include "strutil.h"
#include "commandimp.h"
#include "keybind.h"

using namespace MLS;
using namespace strutil;

static char *help;

namespace MLS {

void CommandImp::About()
{
	int width = 40;
	int height = 13;

	width +=4;

	WINDOW *win = newwin(height, width, (g_nLINES-height)/2, (g_nCOLS-width)/2);
	//wclear(win);
	wbkgd(win, COLOR(COLOR_WHITE, 3));

	wattron(win ,A_BOLD);
	wborder(win, VLINE, VLINE, HLINE, HLINE, ULCORNER, URCORNER, LLCORNER, LRCORNER);

	wattroff(win, A_BOLD);

	// title 출력
	wattron(win, COLOR(COLOR_BLACK, COLOR_WHITE));
	wmove(win, 1, 1);
	whline(win, ' ', width-2);
	string sTitle = gettext("About Mls");
	mvwprintw(win, 1, (40 - krstrlen(sTitle))/2, (char*)sTitle.c_str());
	wattroff(win, A_BOLD);

	// msg
	wattron (win, COLOR(COLOR_WHITE, 3));
	wattron (win, A_BOLD);
	mvwprintw(win, 3, 2, gettext("Mls %s - User-Interfaced File Manager "), VERSION);
	mvwprintw(win, 5, 2, gettext("Author : "));
	mvwprintw(win, 6, 2, gettext("  Byoungyoung, La (la9527@yahoo.co.kr)"));
	mvwprintw(win, 7, 2, gettext("  IOKLO  (leesjung@nownuri.net)"));
	mvwprintw(win, 8, 2, gettext("  fehead (infiniterun@gmail.com)"));
	mvwprintw(win, 9, 2, gettext("  Eunseo, Choi (eunseo.choi@gmail.com)"));
	mvwprintw(win, 11, 2, "(c) 2004 The Mls Developers");
	wattroff(win, A_BOLD);

	wrefresh(win);

	getch();
	delwin(win);
}

void CommandImp::Help()
{
	vector<string>		vMsgData;
	string	sKeyName, sMsg;

	vMsgData.push_back("-------------------------------------------------------");
	vMsgData.push_back("Function Key List");
	vMsgData.push_back("");
	for (int nKey = 0; nKey < 12; nKey++)
	{
		sMsg = "    F" + strutil::itoa(nKey+1) + " : ";
		sMsg = sMsg + gettext(g_MainFrame->_Func[nKey].getName());
		vMsgData.push_back(sMsg);
	}	
	vMsgData.push_back("");
	vMsgData.push_back("-------------------------------------------------------");
	vMsgData.push_back("Meta Key List");
	vMsgData.push_back("");
	for (int nKey = 'A'; nKey < 'Z'; nKey++)
	{
		sKeyName = g_MainFrame->_tKeyBind.GetHelpMetaKey(nKey);
		if (sKeyName != "")
		{
			sMsg = "Alt+";
			sMsg.append(1, (char)nKey);
			sMsg = "    " + sMsg + " : " + gettext(sKeyName.c_str());
			vMsgData.push_back(sMsg);
		}
	}

	vMsgData.push_back("");
	vMsgData.push_back("-------------------------------------------------------");
	vMsgData.push_back("Control Key List");
	vMsgData.push_back("");
	for (int nKey = 1; nKey < 33; nKey++)
	{
		sKeyName = g_MainFrame->_tKeyBind.GetHelpKey(nKey);
		if (sKeyName != "")
		{
			switch(nKey)
			{
				case 13: sMsg = "";	break;
				case 27: sMsg = "";	break;
				case 9:  sMsg = "";	break;
				case 32: sMsg = "";	break;
				default:
					sMsg = "Ctrl+";
					sMsg.append(1, (char)((nKey+'A')-1));
			}
			if (sMsg != "")
			{
				sMsg = "    " + sMsg + " : " + gettext(sKeyName.c_str());
				vMsgData.push_back(sMsg);
			}
		}
	}

	vMsgData.push_back("");
	vMsgData.push_back("-------------------------------------------------------");
	vMsgData.push_back("Etc Key List");
	vMsgData.push_back("");
	for (int nKey = 1; nKey < 33; nKey++)
	{
		sKeyName = g_MainFrame->_tKeyBind.GetHelpKey(nKey);
		if (sKeyName != "")
		{
			switch(nKey)
			{
				case 13: sMsg = "Enter ";	break;
				case 27: sMsg = "ESC   ";	break;
				case 9:  sMsg = "TAB   ";	break;
				case 32: sMsg = "SPACE ";	break;
				default: sMsg = "";
			}
			if (sMsg != "")
			{
				sMsg = "    " + sMsg + " : " + gettext(sKeyName.c_str());
				vMsgData.push_back(sMsg);
			}
		}
	}
	vMsgData.push_back("");

	TextBox		tTextBox(gettext("Help"), g_nLINES-6, 50);
	
	tTextBox.SetText(vMsgData);
	tTextBox.Do();
}

// void CommandImp::Help()
// {
// 	int width = 70;
// 	int height = 18;
// 	int nLine = 0;
// 	
// 	width +=4;
// 
// 	WINDOW *win = newwin(height, width, (g_nLINES-height)/2, (g_nCOLS-width)/2);
// 	//wclear(win);
// 	wbkgd(win, COLOR(COLOR_WHITE, 3));
// 
// 	wattron(win ,A_BOLD);
// 	wborder(win, VLINE, VLINE, HLINE, HLINE, ULCORNER, URCORNER, LLCORNER, LRCORNER);
// 
// 	wattroff(win, A_BOLD);
// 
// 	// title 출력
// 	wattron(win, COLOR(COLOR_BLACK, COLOR_WHITE));
// 	wmove(win, 1, 1);
// 	whline(win, ' ', width-2);
// 	string sTitle = gettext("Help");
// 	mvwprintw(win, 1, (70 - krstrlen(sTitle))/2, sTitle.c_str());
// 	wattroff(win, A_BOLD);
// 
// 	// msg
// 	wattron (win, COLOR(COLOR_WHITE, 3));
// 	wattron (win, A_BOLD);
// 
// 	string sKeyName = "";
// 	string sMsg = "";
// 
// 	nLine = 3;
// 	for (int nKey = 'A'; nKey < 'Z'; nKey++)
// 	{
// 		sKeyName = g_MainFrame->_tKeybind.GetHelpMetaKey(nKey);
// 		if (sKeyName != "")
// 		{
// 			sMsg = "Alt+";
// 			sMsg.append(1, (char)nKey);
// 			sMsg = sMsg + " : " + gettext(sKeyName.c_str());
// 			mvwprintw(win, nLine, 2, sMsg.c_str());
// 			nLine++;
// 		}
// 	}
// 
// 	nLine = 3;
// 
// 	for (int nKey = 1; nKey < 33; nKey++)
// 	{
// 		sKeyName = g_MainFrame->_tKeybind.GetHelpKey(nKey);
// 		if (sKeyName != "")
// 		{
// 			switch(nKey)
// 			{
// 				case 13: sMsg = "Enter ";	break;
// 				case 27: sMsg = "ESC   ";	break;
// 				case 9:  sMsg = "TAB   ";	break;
// 				case 32: sMsg = "SPACE ";	break;
// 				default: sMsg = "";
// 			}
// 			if (sMsg != "")
// 			{
// 				sMsg = sMsg + " : " + gettext(sKeyName.c_str());
// 				mvwprintw(win, nLine, 40, sMsg.c_str());
// 				nLine++;
// 			}
// 		}
// 	}
// 
// 	nLine = 8;
// 
// 	for (int nKey = 1; nKey < 33; nKey++)
// 	{
// 		sKeyName = g_MainFrame->_tKeybind.GetHelpKey(nKey);
// 		if (sKeyName != "")
// 		{
// 			switch(nKey)
// 			{
// 				case 13: sMsg = "";	break;
// 				case 27: sMsg = "";	break;
// 				case 9:  sMsg = "";	break;
// 				case 32: sMsg = "";	break;
// 				default:
// 					sMsg = "Ctrl+";
// 					sMsg.append(1, (char)((nKey+'A')-1));
// 			}
// 			if (sMsg != "")
// 			{
// 				sMsg = sMsg + " : " + gettext(sKeyName.c_str());
// 				mvwprintw(win, nLine, 40, sMsg.c_str());
// 				nLine++;
// 			}
// 		}
// 	}
// 	
// 	/*
// 	mvwprintw(win, 3,  40, gettext("F1    : Help"));
// 	mvwprintw(win, 4,  40, gettext("F2    : Rename"));
// 	mvwprintw(win, 5,  40, gettext("F3    : Vi"));
// 	mvwprintw(win, 6,  40, gettext("F4    : Edit"));
// 	mvwprintw(win, 7,  40, gettext("F5    : Refresh"));
// 	mvwprintw(win, 8,  40, gettext("F6    : Move"));
// 	mvwprintw(win, 9,  40, gettext(	"F7    : Make directory (mkdir)"));
// 	mvwprintw(win, 10, 40, gettext(	"F8    : Delete (rm)"));
// 	mvwprintw(win, 11, 40, gettext(	"F9    : Extract"));
// 	mvwprintw(win, 12, 40, gettext(	"F10   : MCD"));
// 	mvwprintw(win, 13, 40, gettext(	"F11   : QCD"));
// 	mvwprintw(win, 14, 40, gettext(	"F12   : Menu"));
// 	*/
// 	wattroff(win, A_BOLD);
// 
// 	wrefresh(win);
// 
// 	getch();
// 	delwin(win);
// }

}; // namespace MLS
