#ifndef __MLS_COMMANDIMP_H__
#define __MLS_COMMANDIMP_H__

#include "define.h"
#include "mlslocale.h"
#include "exception.h"
#include "panel.h"
#include "dialog.h"
#include "mainframe.h"
#include "DirMcd.h"
#include "ZipMcd.h"

namespace MLS {

class CommandImp : public IConfigurable
{
private:
	Panel *panel;

public:
	CommandImp() : panel(NULL)	{ UpdateConfig();	}
	~CommandImp() { SaveConfig(); }

	// IConfigurable
	void UpdateConfig();
	void SaveConfig();

	void SetPanel(Panel *p) { panel = p; }

	int  Run(const std::string &, bool = false, bool = false);
	int  ParseAndRun(const string &p, bool = false);

	void Default()			{ }

	void Key_Enter()		{ panel->Key_Enter();		}
	void RunExecute()		{ panel->Key_Enter(true);	}
	void Key_Left()			{ panel->Key_Left();	 	}
	void Key_Right() 		{ panel->Key_Right(); 		}
	void Key_Up () 			{ panel->Key_Up();			}
	void Key_Down () 		{ panel->Key_Down();		}
	void Key_Home () 		{ panel->Key_Home();		}
	void Key_End () 		{ panel->Key_End();			}
	void Key_PageUp() 		{ panel->Key_PageUp();		}
	void Key_PageDown() 	{ panel->Key_PageDown();	}

	// other implementations
	void Remove()
	{
		if (!panel->isZip()) panel->cmd_remove();
		else panel->cmd_zip_remove();
	}

	void EditConfig()
	{
		Run(config.GetValue("ExtEditor") + " " + config.GetValue("cfgfile"));

		g_Config.Load((config.GetValue("home") + ".mls/mls.cfg").c_str());
		panel->Refresh();
	}

	void EditColorset()
	{
		Run(config.GetValue("ExtEditor") + " " + config.GetValue("colfile"));
		g_Color.Load(config.GetValue("colfile").c_str());
		panel->Refresh();
	}

	void EditKeybind()
	{
		Run(config.GetValue("ExtEditor") + " " + config.GetValue("keyfile"));
		g_MainFrame->_tKeyBind.Load(config.GetValue("keyfile"));
		panel->Refresh();
	}

	void About();
	void Help();
	void Exit()
	{
		if (config.GetBool("AskMlsExit") == true)
		{
			int nYN = YNBox(gettext("Do you really want to quit the mls ?"), 0);

			if (nYN == YN_N)
			{
				return;
			}
		}

		// 마지막 mls 가 마지막으로 사용한 디렉토리를 저장한다.
		FILE *fp= fopen((config.GetValue("cfghome") + "path").c_str(), "wb");

		if (fp)
		{
			fputs(panel->GetCurrentPath().c_str(), fp);
			fclose(fp);
		}
		else
		{
			LOG("'path' file write failure !!!");
		}
		g_MainFrame->Exit();
	}

	void Menu()
	{
		vector<string>	vDisableCmd;
		
		if (g_MainFrame->IsSplit() == false)
			vDisableCmd.push_back("<nextwindow>");

		if (panel->isZip() == true)
		{
			vDisableCmd.push_back("<targzcomp>");
			vDisableCmd.push_back("<tarbz2comp>");
			vDisableCmd.push_back("<zipcomp>");
			vDisableCmd.push_back("<sizeinfo>");
			vDisableCmd.push_back("<filelist>");
			vDisableCmd.push_back("<touchfile>");
		}

		ClipState state = g_MainFrame->_tClipboard.GetState();
		if (state == CLIP_NONE) 
			vDisableCmd.push_back("<pasteclip>");
		
		g_MainFrame->_tMenu.SetDisable(vDisableCmd);
		g_MainFrame->_tMenu.Create();
		string sCmd = g_MainFrame->_tMenu.Process(&g_MainFrame->_tKeyBind);
		g_Command.Execute(sCmd);
	}

	void TargzCompress() { panel->FileCompress(0);	}

	void Tarbz2Compress()	{ panel->FileCompress(1); }

	void ZipCompress()	{	panel->FileCompress(2);	}
	
	void Refresh()
	{
		g_MainFrame->Refresh();
		g_MainFrame->RefreshPanel(true);
	}

	void Extract()		{ panel->Key_ZipInstall(); }

	void Mcd()
	{
		if (panel->isZip() == false)
		{
			WINDOW*	pWin = NULL;

			try
			{
				pWin = MsgWaitBox(	gettext("Wait"),
									gettext(	"Please wait !!! - Cancel Key [ESC]"));

				LOG("Mcd !!!");
				MLS::DirMcd mcd;
				int			nRt = 0;
				string 		sDir;
				mcd.AddDirectory(panel->GetCurrentPath());
				mcd.setCur(panel->GetCurrentPath());
				if (pWin) MsgWaitEnd(pWin);

				do
				{
					if (mcd.proc())
					{
						sDir = mcd.getCur();
						if ((nRt = access(sDir.c_str(), R_OK | X_OK)) == -1)
						{
							MsgBox(	gettext("Error"), strerror(errno));
						}
					}
				}
				while(nRt == -1);
				panel->Read(sDir);
			}
			catch(Exception& ex)
			{
				MsgBox(1, gettext("Error"), "%s", (char*)ex);
			}

			Refresh();
		}
		else
		{
			WINDOW*	pWin = NULL;

			try
			{
				string sMcdView;

				pWin = MsgWaitBox(	gettext("Wait"),
									gettext("Please wait !!! - Cancel Key [ESC]"));

				sMcdView = "Mcd - Mls Change Directory [" + panel->_sZipFile + "]";
				ZipMcd zipmcd(panel->GetZipFiles(), "/", sMcdView.c_str(), panel->_sZipFile);

				zipmcd.AddDirectory(panel->GetZipCurrentPath());
				zipmcd.setCur(panel->GetZipCurrentPath());

				if (pWin) MsgWaitEnd(pWin);

				if (zipmcd.proc())
				{
					LOG("Current Directory [%s]", (zipmcd.getCur()).c_str());
					panel->SetZipCurrentPath(zipmcd.getCur());
					panel->SetPathView(zipmcd.getCur());
					if (panel->Read(zipmcd.getCur()) == false)
					{
						string dir_name = zipmcd.getCur();
						string dir_name_2 = dir_name.substr(1, dir_name.size() - 1);

						panel->Read(dir_name_2);
					}
				}
			}
			catch(Exception& ex)
			{
				MsgBox(1, gettext("Wait"), "%s", (char*)ex);
			}
		}
	}

	void Qcd();

	void Copy()
	{
		if (!panel->isZip()) panel->cmd_copy();
		else panel->cmd_zip_copy();
	}

	void Move()
	{
		if (!panel->isZip()) panel->cmd_move();
	}

	/// panel_cmd.cpp 에 구현
	void NewFile();

	// 내부, 외부 선택
	void EditorChoice(bool bReadOnly, const string& sEditorCmd = "");
	
	void ExtEditor(); /// 외부 에디터  
	void Edit();	/// 내부 에디터
	void View();	/// panel_cmd.cpp 에 구현

	void Mkdir()
	{
		if (!panel->isZip())
		{
			string p;
			if (InputBox(gettext("Make Directory"), p)<0) return;
	
			if (mkdir(p.c_str(), 0755)==-1)
			{
				MsgBox(	gettext("Error"), strerror(errno));
				return;
			}
			Refresh();
		}
		else
		{
			MsgBox(	gettext("Error"), gettext("Don't execute"));
		}
		return;
	}

	void Rename()
	{
		if (!panel->isZip())
		{
			string ren = panel->GetCurrentFile().name;
	
			if (ren == "..") return;
	
			if (InputBox(gettext("rename"), ren)<0) return;
	
			if (rename(panel->GetCurrentFile().name.c_str(), ren.c_str()) == -1)
			{
				MsgBox(	gettext("Error"), strerror(errno));
				return;
			}
			Refresh();
			panel->Search(ren);
		}
		else
		{
			MsgBox(	gettext("Error"), gettext("Don't execute"));
		}
	}

	void ViewScreen();

	void Back()			{	panel->Read(panel->_tHistory.GetPrev());	}
	void Forward()		{	panel->Read(panel->_tHistory.GetPrev());	}

	void Select() {   panel->ToggleSelect(); }
	void SelectAll() {
		for (int t=0; t<panel->_file_list.size(); t++)
			panel->Select(*panel->_file_list[t]);
	}
	void SelectInvert() {
		for (int t=0; t<panel->_file_list.size(); t++)
			if (panel->_file_list[t]->selected) panel->Deselect(*panel->_file_list[t]);
			else panel->Select(*panel->_file_list[t]);
	}


	void ShowHidden()
	{
		panel->_bShowHidden = (!panel->_bShowHidden);
		Refresh();
	}

	/// @brief	User로 부터 입력 받은 Shell 명령실행
	void Shell();

	// sort
	void	SortChange()
	{
		panel->_sort++;
		if (panel->_sort == 5) panel->_sort=0;
		switch(panel->_sort)
		{
			case 0:	SortName();	break;
			case 1:	SortExt();	break;
			case 2:	SortSize();	break;
			case 3:	SortTime(); break;
			case 4: SortColor(); break;
		}
	}
				
	void SortName()	{ panel->SetSortMethod(SORT_NAME);	panel->Sort();	}
	void SortExt()	{ panel->SetSortMethod(SORT_EXT);	panel->Sort();	}
	void SortSize()	{ panel->SetSortMethod(SORT_SIZE);	panel->Sort();	}
	void SortTime()	{ panel->SetSortMethod(SORT_TIME); 	panel->Sort();	}
	void SortColor(){ panel->SetSortMethod(SORT_COLOR); panel->Sort();	}

	// column

	void ColumnAuto() { panel->_column = 0; panel->Refresh(); }
	void Column1()    { panel->_column = 1; panel->Refresh(); }
	void Column2()    { panel->_column = 2; panel->Refresh(); }
	void Column3()    { panel->_column = 3; panel->Refresh(); }
	void Column4()    { panel->_column = 4; panel->Refresh(); }

	void Split() {
		g_MainFrame->SwitchSplit();
		g_MainFrame->Refresh();
	}

	void NextWindow() { g_MainFrame->NextWindow(); }

	void GotoRoot() { panel->Read("/"); }
	void GotoHome() { panel->Read(config.GetValue("home")); }
	void GotoUpperDirectory() { panel->Read(".."); }

	void BoxCodeChange()
	{
		if (e_nBoxLineCode == ACSLINE)
			Set_Line(CHARLINE);
		else
			Set_Line(ACSLINE);
	}

	void LangChange()
	{
		if (e_nCurLang == US)
		{
			Set_Locale(AUTO);
			g_MainFrame->ReloadMenu();
		}
		else
		{
			Set_Locale(US);
			g_MainFrame->ReloadMenu();
		}
	}

	void CopyClip();
	void PasteClip();
	void CutClip();

	void	Chmod();
	void	SizeInfo();
	void	TouchFile();
	void	FileListSave();
}; // class CommandImp

}; // namespace

#endif
