#include "commandimp.h"
#include <sys/wait.h>
#include "strutil.h"
#include "qcd.h"
#include "TargzUtil.h"
#include "progress.h"

using namespace strutil;

extern int Copy(MLS::Selection &, std::string);
extern int Move(MLS::Selection &, std::string);

namespace MLS {

void CommandImp::UpdateConfig()
{
}

void CommandImp::SaveConfig()
{
}

void CommandImp::CopyClip()
{
	g_MainFrame->_tClipboard.Set(panel->GetSelection(), CLIP_COPY);
}

void CommandImp::CutClip()
{
	g_MainFrame->_tClipboard.Set(panel->GetSelection(), CLIP_CUT);
}

void CommandImp::PasteClip()
{
	ClipState state = g_MainFrame->_tClipboard.GetState();

	if (state == CLIP_NONE) return;

	if (state == CLIP_COPY)
	{
		if (panel->isZip() == false)
		{
			string sZipName = (g_MainFrame->_tClipboard.Get()).GetZipFile();
			vector<string> tFileList = (g_MainFrame->_tClipboard.Get()).GetData();
			if (tFileList.size() == 0) return;

			LOG("CLIP_COPY [%s]", sZipName.c_str());

			if (sZipName != "")
			{
				try
				{
					TargzUtil	tTargzUtil(sZipName, 0);

					string sView = gettext("Please wait !!! - Uncompress file [") + sZipName + "]";

					Progress 	tProgress(gettext("Wait"), sView.c_str());
					tProgress.Start((Counter*)&tTargzUtil, JOIN);
					tTargzUtil.SetCounter(0);

					tTargzUtil.Uncompress(tFileList, panel->_path);

					tTargzUtil.SetCounter(100);
					tProgress.SetRun(PTHREAD_END);
					tProgress.End();
				}
				catch(Exception& ex)
				{
					MsgBox(1, gettext("Error"), "%s", (char*)ex);
				}
			}
			else
			{
				::Copy(g_MainFrame->_tClipboard.Get(), panel->_path);
			}
		}
		else
		{
			// zip 파일 안의 내용에서 zip파일로는 복사 불가능.
			if (panel->isZip() == 1)
			{
				string sDir = (g_MainFrame->_tClipboard.Get()).GetBaseDir();
				vector<string> tFileList = (g_MainFrame->_tClipboard.Get()).GetData();
				
				if (tFileList.size() == 0) return;

				try
				{
					TargzUtil	tTargzUtil(panel->_Zip_Reader.GetZipPath(), panel->_sZipFile, 0);
					string sView = gettext("Please wait !!! - Uncompress file [") + panel->_sZipFile + "]";

					Progress 	tProgress(gettext("Wait"), sView.c_str());
					tProgress.Start((Counter*)&tTargzUtil, JOIN);
					tTargzUtil.SetCounter(0);

					tTargzUtil.SetWorkDir(sDir);
					tTargzUtil.Compress(tFileList, TAR_APPEND);

					tTargzUtil.SetCounter(100);
					tProgress.SetRun(PTHREAD_END);
					tProgress.End();

					panel->Refresh(true);
				}
				catch(Exception& ex)
				{
					MsgBox(1, gettext("Error"), "%s", (char*)ex);
				}
			}
		}
		Refresh();
	}
	else if (state == CLIP_CUT)
	{
		if (panel->isZip() == false)
		{
			string sZipName = (g_MainFrame->_tClipboard.Get()).GetZipFile();

			if (sZipName == "")
				::Move(g_MainFrame->_tClipboard.Get(), panel->_path);
		}
		Refresh();
	}
}

void CommandImp::Qcd()
{
	MLS::Qcd qcd;

	qcd.Do();
}

void CommandImp::ViewScreen( )
{
	g_MainFrame->Destroy();

	cbreak();
	noecho();

	getch();

	g_MainFrame->Init();
	g_MainFrame->Refresh();
}

///	@brief	명령어를 실행한다.
///	@param	cmd		명령어및 인자
///	@param	bPause	명령어를 실행시키고 종료시 잠시 정지시킬지 여부
/// @param	bFork	Fork할 것인지?
///	@return	명령어 실행 결과
int CommandImp::Run( const std::string &cmd, bool bPause, bool bBackground)
{
	//def_prog_mode();
	//endwin();

	// command 창에서 exit, quit 를 치면 종료하게 한다.
	if (cmd == "exit" || cmd == "quit") 
	{
		Exit();
		return 0;
	}

	g_MainFrame->Destroy();

	int status;

	if (bBackground)
	{
		cout << "mls $ " << cmd.c_str() << endl;
		string sCmd = cmd + " > /dev/null 2>&1 &";
		status = system(sCmd.c_str());
	}
	else
	{
		cout << "mls $ " << cmd.c_str() << endl;
		status = system(cmd.c_str());
	}

	if (bPause)
	{
		cbreak();
		noecho();

		cout << endl << gettext("Press any key to return Mls...") << '\r' << endl;
		getch();
	}
	g_MainFrame->Init();
	Refresh();

	return status;
}

void ModeToBool(mode_t tMode, vector<bool>& vBool)
{
	for (int n=0; n< 12;n++) vBool.push_back(false);
	if (tMode & S_ISUID) vBool[0] = true;
	if (tMode & S_ISGID) vBool[1] = true;
	if (tMode & S_ISVTX) vBool[2] = true;
	if (tMode & S_IRUSR) vBool[3] = true;
	if (tMode & S_IWUSR) vBool[4] = true;
	if (tMode & S_IXUSR) vBool[5] = true;
	if (tMode & S_IRGRP) vBool[6] = true;
	if (tMode & S_IWGRP) vBool[7] = true;
	if (tMode & S_IXGRP) vBool[8] = true;
	if (tMode & S_IROTH) vBool[9] = true;
	if (tMode & S_IWOTH) vBool[10] = true;
	if (tMode & S_IXOTH) vBool[11] = true;
}

mode_t BoolToMode(vector<bool>& vBool)
{
	mode_t	tMode = 0;
	if (vBool[0] == true)  tMode = tMode | S_ISUID;
	if (vBool[1] == true)  tMode = tMode | S_ISGID;
	if (vBool[2] == true)  tMode = tMode | S_ISVTX;
	if (vBool[3] == true)  tMode = tMode | S_IRUSR;
	if (vBool[4] == true)  tMode = tMode | S_IWUSR;
	if (vBool[5] == true)  tMode = tMode | S_IXUSR;
	if (vBool[6] == true)  tMode = tMode | S_IRGRP;
	if (vBool[7] == true)  tMode = tMode | S_IWGRP;
	if (vBool[8] == true)  tMode = tMode | S_IXGRP;
	if (vBool[9] == true)  tMode = tMode | S_IROTH;
	if (vBool[10] == true) tMode = tMode | S_IWOTH;
	if (vBool[11] == true) tMode = tMode | S_IXOTH;
	return tMode;
}

void	CommandImp::Chmod()
{
	if (!panel->isZip())
	{
		Selection sel = panel->GetSelection();
		vector<string>	files=sel.GetData();

		struct 	stat	t_stat;
		mode_t	mode_1, mode_2;
		bool	bStat = true;
		
		for (int n=0; n<files.size();n++)
		{
			if (stat(files[n].c_str(), &t_stat) == -1)	continue;
			mode_1 = t_stat.st_mode;
			if (mode_1 != mode_2 && n != 0)
			{	
				bStat = false;
				break;
			}
			mode_2 = t_stat.st_mode;
		}

		vector<string>	vViewStr;
		vector<bool>	vBool;
		vViewStr.push_back(gettext("set user ID on execution"));
		vViewStr.push_back(gettext("set group ID on execution"));
		vViewStr.push_back(gettext("sticky bit"));
		
		vViewStr.push_back(gettext("read by owner"));
		vViewStr.push_back(gettext("write by owner"));
		vViewStr.push_back(gettext("execute/search by owner"));

		vViewStr.push_back(gettext("read by group"));	
		vViewStr.push_back(gettext("write by group"));
		vViewStr.push_back(gettext("execute/search by group"));

		vViewStr.push_back(gettext("read by other"));
		vViewStr.push_back(gettext("write by other"));
		vViewStr.push_back(gettext("execute/search by other"));

		ModeToBool(mode_1, vBool);
		CheckBox		tCheckBox(gettext("Chmod selected files"));

		tCheckBox.SetItem(vViewStr, vBool);
		
		vBool = tCheckBox.Do();
		if (vBool.size() == 0) 
		{
			Refresh();
			return;
		}
		
		mode_1 = BoolToMode(vBool);

		vViewStr.clear(); // Errstring 역활을 한다.
		for (int n=0; n<files.size();n++)
		{
			if (chmod(files[n].c_str(), mode_1)==-1)
			{
				string	sStr = files[n] + " - " + strerror(errno);
				vViewStr.push_back(sStr);
			}
		}

		if (vViewStr.size() != 0)
		{
			TextBox		tErrorInfo("Error Info");
			tErrorInfo.SetText(vViewStr);
			if (vViewStr.size() < 10)
				tErrorInfo.SetHeight(vViewStr.size()+6);
			tErrorInfo.SetBackColor(COLOR_RED);
			tErrorInfo.Do();
		}		
		Refresh();
	}
}

void	CommandImp::SizeInfo()
{
	if (!panel->isZip())
	{
		Selection sel = panel->GetSelection();
		
		WINDOW*  pWin = MsgWaitBox(	gettext("Wait"),
									gettext(	"Please wait !!! - Cancel Key [ESC]"));

		sel.ExpandDir(true);
		
		MsgWaitEnd(pWin);

		MsgBox(COLOR_BLUE, gettext("Size info"),
			   gettext("  Selected files     %10s  /  %10s byte  "), 
						strutil::toregular(sel.Size()).c_str(),
						strutil::toregular(sel.CalcSize()).c_str());
	}
}

void	CommandImp::TouchFile()
{
	if (!panel->isZip())
	{
		if (access(panel->_path.c_str(), W_OK | X_OK) == -1)
		{
			MsgBox(	gettext("Error"), strerror(errno));
			return;
		}

		string	sTouchFile;
		if (InputBox(gettext("Input touch file."), sTouchFile)>0)
		{
			sTouchFile = panel->_path + sTouchFile;

			if (access(sTouchFile.c_str(), R_OK) == -1)
			{
				FILE*	pf = fopen(sTouchFile.c_str(), "wb");
				if (!pf)
				{
					MsgBox(	gettext("Error"), strerror(errno));
					return;
				}
				fclose(pf);
				Refresh();
				panel->Search(sTouchFile);
			}
			else
			{
				MsgBox(	gettext("Error"), gettext("input file using."));
			}
		}
	}
}

void	CommandImp::FileListSave()
{
	if (!panel->isZip())
	{
		string	sFileList;
		if (InputBox(gettext("Selected file list save. Input filename."), sFileList)>0)
		{
			sFileList = "echo '%S\n' > " + sFileList;
			system(sFileList.c_str());
			Refresh();
			panel->Search(sFileList);
		}
	}
}

};
