#include "command.h"
#include "commandimp.h"

namespace MLS {

Command g_Command;

void Command::Init()
{
	// -- Key
	_func["left"]		= &CommandImp::Key_Left;
	_func["right"]		= &CommandImp::Key_Right;
	_func["up"]			= &CommandImp::Key_Up;
	_func["down"]		= &CommandImp::Key_Down;
	_func["home"]		= &CommandImp::Key_Home;
	_func["end"]		= &CommandImp::Key_End;
	_func["pgup"]		= &CommandImp::Key_PageUp;
	_func["pgdn"]		= &CommandImp::Key_PageDown;
	_func["enter"]		= &CommandImp::Key_Enter;
	
	// -- select
	_func["select"]      = &CommandImp::Select;
	_func["selectall"]   = &CommandImp::SelectAll;
	_func["selectinvert"]= &CommandImp::SelectInvert;

	// -- shell
	_func["shell"]		= &CommandImp::Shell;
	//_func["shellparam"]= &CommandImp::Shell;
	_func["viewconsole"]	= &CommandImp::ViewScreen;

	// -- file
	_func["copy"]        = &CommandImp::Copy;
	_func["move"]        = &CommandImp::Move;
	_func["del"]         = &CommandImp::Remove;
	_func["remove"]      = &CommandImp::Remove;
	_func["rename"]      = &CommandImp::Rename;
	_func["newfile"]		= &CommandImp::NewFile;

	// -- dir
	_func["mkdir"]       = &CommandImp::Mkdir;
	_func["mcd"]         = &CommandImp::Mcd;
	_func["qcd"]		= &CommandImp::Qcd;
	_func["goroot"]		= &CommandImp::GotoRoot;
	_func["gohome"]		= &CommandImp::GotoHome;
	_func["goup"]		= &CommandImp::GotoUpperDirectory;

	// -- panel
	_func["refresh"]     = &CommandImp::Refresh;

	// -- archive
	_func["extract"]     = &CommandImp::Extract;
	_func["targzcomp"]   = &CommandImp::TargzCompress;
	_func["tarbz2comp"]   = &CommandImp::Tarbz2Compress;
	_func["zipcomp"]   = &CommandImp::ZipCompress;
	
	//_func["archive"]		=

	// -- history
	_func["back"]		= &CommandImp::Back;
	_func["forward"]		= &CommandImp::Forward;
	//_func["history"]		=

	// -- window
	_func["split"]		= &CommandImp::Split;
	_func["nextwindow"]  = &CommandImp::NextWindow;

	// --sort
	_func["sortchange"]	= &CommandImp::SortChange;
	
	_func["sortname"]	= &CommandImp::SortName;
	_func["sortext"]	= &CommandImp::SortExt;
	_func["sortcolor"]	= &CommandImp::SortColor;
	_func["sortsize"]	= &CommandImp::SortSize;
	_func["sorttime"]	= &CommandImp::SortTime;

	// --column
	_func["columnauto"]  = &CommandImp::ColumnAuto;
	_func["column1"]  = &CommandImp::Column1;
	_func["column2"]  = &CommandImp::Column2;
	_func["column3"]  = &CommandImp::Column3;
	_func["column4"]  = &CommandImp::Column4;

	// -- clipboard
	_func["copyclip"]    = &CommandImp::CopyClip;
	_func["cutclip"]     = &CommandImp::CutClip;
	_func["pasteclip"]   = &CommandImp::PasteClip;

	// -- etc
	_func["showhidden"]	= &CommandImp::ShowHidden;
	_func["editconfig"]  = &CommandImp::EditConfig;
	_func["editcolorset"]= &CommandImp::EditColorset;
	_func["editkeybind"] = &CommandImp::EditKeybind;
	_func["exit"]        = &CommandImp::Exit;

	_func["about"]       = &CommandImp::About;
	_func["help"]        = &CommandImp::Help;
	_func["menu"]        = &CommandImp::Menu;

	_func["exteditor"]		= &CommandImp::ExtEditor;
	_func["edit"]			= &CommandImp::Edit;
	_func["view"]			= &CommandImp::View;
	_func["boxcodechange"]	= &CommandImp::BoxCodeChange;
	_func["langchange"]		= &CommandImp::LangChange;
	_func["execute"]	= &CommandImp::RunExecute;

	_func["chmod"]		= &CommandImp::Chmod;
	_func["sizeinfo"]	= &CommandImp::SizeInfo;

	_func["touchfile"]		= &CommandImp::TouchFile;
	_func["filelist"]	= &CommandImp::FileListSave;
}

Command::Command() : _imp(new CommandImp)
{
}

Command::~ Command( )
{
	delete _imp;
}

void Command::SetPanel(Panel *p)
{
	_imp->SetPanel(p);
}

/// @brief	해당 str 명령을 실행시킨다.
/// @return	0
int Command::Execute(
	const std::string &		str			///< 실행할 명령어
	)
{
	if (str.empty())
		return 0;

	if (*str.begin() == '<' && *(str.end()-1) == '>')
	{//  < > 로 둘러쌓인 문자열에 대해서.
		FuncMap::iterator i;

		if ((i = _func.find(str.substr(1, str.size()-2))) != _func.end())
		{
			(_imp->*((*i).second))();
		}
		else
		{
			MsgBox(COLOR_RED, gettext("Error"),
				gettext("configure command not found.."), str.c_str());
		}
	}
	else
	{// 일반적 문자열 처리 ( 실행 )
		return ParseAndRun(str);
	}
	return 0;
}

int Command::Run( const std::string &str, bool bPause)
{
	_imp->Run(str, bPause);
}

int Command::ParseAndRun( const std::string & str )
{
	_imp->ParseAndRun(str);
}

};
