///	\file	drawutil.h
///	\brief	Dwaw Util
#ifndef DRAWUTIL_H
#define DRAWUTIL_H

#include <ncurses.h>
#include <iostream>

#define COLOR(fg, bg) COLOR_PAIR(((fg)<<3)+(bg))	///< COLOR_PAIR 변환 define

namespace MLS {

/// \brief	color entry struct
class ColorEntry
{
	public:
	int font,		///< font color
		back;		///< background color
	
	/// \brief	기본 생성자
	ColorEntry() : font(0), back(0) {}
	ColorEntry(int f, int b) : font(f), back(b) { }
	
	///	\brief	operator == 재정의 함수
	/// \param	t	비교할 ColorEntry
	///	\return	비교 대상과 같은가
	bool operator == (ColorEntry &t)
	{
		return font==t.font && back==t.back;
	}
	
	///	\brief	operator < 재정의 함수 
	///	\param	t	비교할 ColorEntry
	///	\return	비교 대상과 크기 비교된 결과
	bool operator < (ColorEntry &t)
	{
		return font*16+back > t.font*16+t.back;
	}	
};

///	\brief	color 지정 및 속성 지정 함수
///	\param	font	font color
///	\param	back	background color
///	\param	win		ncurses window
inline void setcol(int font, int back, WINDOW *win=stdscr)
{
	wattroff(win, A_BOLD | A_BLINK);
	
	if ( font >= 8 ) wattron(win, A_BOLD);
//	if ( back >= 8 ) wattron(win, A_BLINK);
	
	if (back == -1)			wattron(win, COLOR_PAIR(70));
	else if (font == -1)	wattron(win, COLOR_PAIR(back%8));
	else
		wattron(win, COLOR_PAIR( ((font%8) << 3) + (back%8)));
}

///	\brief	color 지정 및 속성 지정 함수
///	\param	p		ColorEntry
///	\param	win		ncurses window
inline void setcol(ColorEntry &p, WINDOW *win=stdscr)
{
	setcol(p.font, p.back, win);
}

///	\brief	color 지정 및 속성 지정 함수(반전)
///	\param	p		ColorEntry
///	\param	win		ncurses window
inline void setrcol(ColorEntry &p, WINDOW *win=stdscr)
{
	setcol(p.back, p.font, win);
}

inline int GetColumnWidth(int width, int n, int i)
{
	// width : 80,  n : 7 일때..
	// 12, 12, 12, 11, 11, 11, 11
	int a = width / n;
	int r = width - a * n;
	
	if ( i < r )
		return a + 1;
	else
		return a;	
}

inline int GetColumnIndex(int width, int n, int i)
{
	// width : 80,  n : 7 일때
	// 0, 12, 24, 36, 47, 58, 69
	int a = width / n;
	int r = width - a * n;
		
	if ( i <= r )
		return (a + 1) * i;
	else 
		return a * i + r;
}

inline int GetIndex(int width, int n, int x)
{// inverse 함수..	
	int a = width / n;
	int r = width - a * n;
	
	if ( x <= (a + 1) * r )
		return x / (a + 1);
	else 
		return (x - r) / a;	
}


}; // namespace 
#endif

