#ifndef MLSCONFIGURE_H
#define MLSCONFIGURE_H

#include <string>
#include <map>
#include <vector>
#include "drawutil.h"
#include "strutil.h"

namespace MLS {

class Configure
{
	struct Entry
	{
		bool modified;
		std::string var;
		std::string val;
		Entry() : modified(false) { }
		Entry(const std::string &_var, const std::string &_val, bool b) : modified(b), var(_var), val(_val) {}
	};
	
	typedef std::map<std::string, Entry> MapType;
	
	std::string filename;
	
	MapType env_map;
		
	// singleton
	Configure() { }
	~Configure(){ }
	
public:
	std::string							_sVersion;
	std::map<std::string, std::string>	ext_bind;
	std::map<std::string, std::string>	name_bind;
	static Configure &GetInstance();

	bool Load(const char *);
	bool Save();
	
	const std::string &GetValue(const std::string& var);
	bool SetValue(const std::string &var, const std::string &val, bool bSave=true);
	bool SetStaticValue(const std::string &var, const std::string &val);
	
	bool GetBool(const std::string &);
	bool SetBool(const std::string &var, bool val, bool bSave = true);
};

class IConfigurable
{
protected:
	Configure &config;

public:
	IConfigurable();
	virtual ~IConfigurable();
	virtual void UpdateConfig() = 0;
	virtual void SaveConfig() = 0;
};

#define g_Config Configure::GetInstance()

};

#endif
