#include "define.h"
#include "configure.h"
#include <fstream>
#include "strutil.h"
#include "StringTokenizer.h"
#include <algorithm>

using namespace strutil;
using namespace std;

namespace MLS {

static std::string EmptyString;

bool Configure::Load( const char * file)
{
	ifstream in(file);
	if (!in) return false;

	filename = file;

	string line, var, val;

	while(!getline(in, line).eof())
	{
		if (line.empty()) continue;
		if (tolower(line.substr(0, 10)) == "#!version ")
		{
			_sVersion = tolower(chop(line.substr(10)));
			continue;
		}
		
		if (line[0] == '#') continue;

		string::size_type p = line.find('=');
		if (p == string::npos) continue;

		// . var와 값을 찾는다.
		var = chop(line.substr(0, p));
		val = chop(line.substr(p+1));

		if (var == "version")
		{
			_sVersion = val;
			continue;
		}

		if (tolower(var.substr(0, 4)) == "ext[")
		{
			StringTokenizer st(getbetween(var, '[', ']'), "; ");
			while (st.Next())
			{
				ext_bind[tolower(st.Get())] = val;
			}
		}
		else if (tolower(var.substr(0, 5)) == "name[")
		{
			StringTokenizer st(getbetween(var, '[', ']'), "; ");
			while (st.Next())
			{
				name_bind[tolower(st.Get())] = val;
			}
		}
		else
		{
			env_map[tolower(var)] = Entry(var, val, false);
		}
	}

	return true;
}

bool Configure::Save()
{// 바로 그 파일에다 저장한다.
	if (filename == "/etc/mls/mls.cfg")
		filename = g_Config.GetValue("cfghome") + "mls.cfg";
	
	string bakfile = filename + ".bak";
		
	unlink(bakfile.c_str());
	if (rename(filename.c_str(), bakfile.c_str()) == -1 ) return false;

	ifstream in(bakfile.c_str());
	ofstream out(filename.c_str());

	if (!in) return false;
	if (!out) return false;

	// Modified 된 것을 정리
	MapType::iterator i = env_map.begin(), end = env_map.end();
	MapType mod_list, dup_list;

	for(;i!=end;++i)
	{
		if (i->second.modified)
		{
			mod_list.insert(*i);
		}
	}

	string line, var, val, lower_var;

	while( !getline(in, line).eof() )
	{
		if (line.empty() || line[0] == '#' || line[0] == '$')
		{
			out << line << endl;
			continue;
		}

		string::size_type p = line.find('=');
		if (p == string::npos)
		{
			out << line << endl;
			continue;
		}

		var = chop(line.substr(0, p));		
		val = chop(line.substr(p+1));
		lower_var = tolower(var);

		i = mod_list.find(lower_var);

		if ( i != mod_list.end() )
		{
			out << i->second.var << "=" << i->second.val << endl;
			dup_list.insert(*i);
			mod_list.erase(i);
		}
		else if ((i = dup_list.find(lower_var)) != dup_list.end())
		{
			out << '#' << line << endl;
	 	}
		else out << line << endl;

	}
	// 남은 것들 처리
	for (i = mod_list.begin(); i!=mod_list.end(); i++)
		out << i->second.var << "=" << i->second.val << endl;

	in.close();
	out.close();

	return true;
}

const std::string &Configure::GetValue(const std::string& var)
{
	MapType::iterator i = env_map.find(tolower(var));	
	
	if (i == env_map.end())	return EmptyString;
	return i->second.val;
}

bool Configure::SetValue(const std::string &var, const std::string &val, bool bSave)
{
	string v = tolower(var);
	MapType::iterator i = env_map.find(v);

	if (i == env_map.end())
		env_map.insert(MapType::value_type(v, Entry (var, val, bSave)));
	else
	{
		if (!i->second.modified)
			i->second.modified = (bSave && (i->second.val != val));
		i->second.val = val;
	}
	
	return true;
}

bool Configure::SetStaticValue(const std::string &var, const std::string &val)
{
	return SetValue(var, val, false);
}

bool Configure::GetBool( const std::string &var )
{	
	MapType::iterator i = env_map.find(tolower(var));
	
	if (i == env_map.end()) return false;
	return (tolower(i->second.val) == "on");
}

bool Configure::SetBool(const std::string &var, bool value, bool bSave)
{
	const char *strBool = value ? "On" : "Off";	
	string v = tolower(var);
	MapType::iterator i = env_map.find(v);

	if (i == env_map.end())
		env_map.insert(MapType::value_type(v, Entry (var, strBool, bSave)));
	else
	{
		if (!i->second.modified)
			i->second.modified = (bSave && tolower(i->second.val) != strBool);
		i->second.val = strBool;
	}
	
	return true;
}

Configure &Configure::GetInstance()
{
	static Configure conf;
	return conf;
}

IConfigurable::IConfigurable()
	: config( Configure::GetInstance() )  { }

IConfigurable::~IConfigurable() { }

};
