

#include <config.h>
#include <map>
#include <string>
#include <iostream>
#include <fstream>
#include "colorset.h"
#include "strutil.h"
#include "StringTokenizer.h"

using namespace std;
using namespace strutil;

namespace MLS {

ColorSet::ColorSet()
{	
}

ColorSet::~ColorSet()
{
}

ColorSet &ColorSet::GetInstance()
{
	static ColorSet instance;
	return instance;
}


bool ColorSet::Init( )
{
	Default = ColorEntry(7,0);   // 색지정안된 파일 기본색상
	MCD     = ColorEntry(15,4);
	MCDLine = ColorEntry(15,4);
	MCDstat = ColorEntry(1,15);
	Dir     = ColorEntry(9,0);
	Drive   = ColorEntry(3,0);   // 메인창 드라이브 색
	Line    = ColorEntry(6,0);   // 메인창 선 색
	Func    = ColorEntry(15,6);  // 펑션키 보통
	FuncA   = ColorEntry(11,6);  // 펑션키 강조
	Stat    = ColorEntry(0,7);   // 상태선 보통
	StatA   = ColorEntry(15,7);  // 상태선 강조	
	Help    = ColorEntry(11,6);  // 도움말
	QCD     = ColorEntry(15,4);  // 빨리찾기 메인	
	Dialog  = ColorEntry(15,12); // 대화상자 색
	Back    = ColorEntry(0,0);
	MEdit	= ColorEntry(7,4);	 // 에디터 화면
	MEditInfo = ColorEntry(2,4);	// 에디터 정보 보통
	MEditInfoA = ColorEntry(10,4);	// 에디터 정보 강조
	return true;
}

bool ColorSet::Load(const char *file)
{
	map<string, ColorEntry> color_set;	
	string line, var, val;
	string::size_type cmt, p;	
	int fcol, bcol;

	ifstream in(file);
	if (!in) return false;

	while(!in.eof())
	{	
		getline(in, line);

		if (tolower(line.substr(0, 10)) == "#!version ")
		{
			_sVersion = tolower(chop(line.substr(10)));
			continue;
		}
		
		if ((cmt = line.find('#')) != string::npos)
			line.erase(cmt);
		
		if ((p = line.find('=')) == string::npos) continue;
		
		var = tolower(chop(line.substr(0, p)));
		val = tolower(chop(line.substr(p+1)));

		if (var == "version")
		{
			_sVersion = val;
			continue;
		}

		std::string::size_type p = val.find(',');
                
		if (p != string::npos)
		{
			fcol = atoi(val.substr(0, p).c_str());
			bcol = atoi(val.substr(p+1).c_str());
		}
		else 
		{
			fcol = atoi(val.c_str());
			bcol = Default.back;
		}
		
		ColorEntry cur(fcol, bcol);
	
		if (var.substr(0, 4) == "mask")		
		{
			int num = strtol(getbetween(var, '[', ']').c_str(), NULL, 8);
			mapMask[num] = cur;
		}
		else if(var.substr(0, 4) == "name")
		{
			StringTokenizer st(getbetween(var, '[', ']'), ";");					
			while(st.Next())
			{
				if (st.Get().empty()) continue;
				mapName[st.Get()] = cur;
			}
		}
		else if (var.substr(0, 3) == "ext")
		{
			StringTokenizer st(getbetween(var, '[', ']'), ";");	
		
			while(st.Next())
			{
				if (st.Get().empty()) continue;
				mapExt[st.Get()] = cur;
			}
		}	
		else
		{
			if (var == "mcd") MCD = cur;
			else if (var == "mcdline") MCDLine = cur;
			else if (var == "mcdstat") MCDstat = cur;
			else if (var == "dir") Dir = cur;
			else if (var == "drive") Drive = cur;
			else if (var == "line") Line = cur;
			else if (var == "func") Func = cur;
			else if (var == "funca") FuncA = cur;
			else if (var == "stat") Stat = cur;
			else if (var == "stata") StatA = cur;
			else if (var == "default") Default = cur;
			else if (var == "help") Help = cur;
			else if (var == "qcd") QCD = cur;
			else if (var == "dialog") Dialog = cur;
			else if (var == "default") Default = cur;
			else if (var == "back") Back = cur;
			else if (var == "medit") MEdit = cur;
			else if (var == "meditinfo")  MEditInfo = cur;
			else if (var == "meditinfoa") MEditInfoA = cur;
		}
	}
	return true;
}



};

