///	\file	ZipMcd.h
///	\brief	ZipMcd.h
#ifndef ZipMCD_H__
#define ZipMCD_H__

#include "define.h"
#include "file.h"
#include "exception.h"
#include "Mcd.h"
#include "action.h"

namespace MLS {

	///	\brief	ZipMcd class
	class ZipMcd : public Mcd
	{
		private:
			vector<File*>	m_vZipVector;	///< ZipFile 리스트
			string			m_sZipFile;		///< ZipFile 일시 파일 이름
			Action          m_McdZipFunc[12]; ///< 펑션키
			
		protected:
			int 	AddDir(dir* pRootTree, File* pFile, int nDepth = 0);
			int		Rescan(int = 0);
			int		Scan(dir *, int = 0);
			int		DirFind(void);
			int		DrawEtc(void);
			int		McdExecute(int nKey);
			void	Help();
			
			// IConfigurable			
			void    UpdateConfig();
			void    SaveConfig();
			
		public:
			ZipMcd(vector<File*> vZipVector, string = "", const char * = "MCD - Mls Change Directory", string sZipFile = "");
			
			int		AddDirectory(const std::string &);
	};
}; // namespace

#endif //ZipMCD_H__
