///	\file	StringTokenizer.h
///	\brief	문자열 분쇄기
#ifndef StringTokenizer_h_
#define StringTokenizer_h_

#include <string>

namespace MLS {

///	\brief	string 분쇄기
class StringTokenizer
{
protected:
	std::string _str;				///< 분쇄할 문자열
	std::string _delim;				///< 기준 문자. 예(';')

	std::string _token;				///< 분쇄된 문자열

	std::string::size_type _cur;	///< 문자열 중 위치 index

public:
	StringTokenizer();
	StringTokenizer(const std::string &p, const std::string &d = "\r\n ");
	~StringTokenizer();

	///	\brief	분쇄할 문자열을 설정한다.
	///	\param	p	분쇄할 문자열
	void SetString(const std::string &p) {_str = p; _cur = 0; }

	///	\brief	기준문자를 설정한다.
	///	\param	p	기준문자
	void SetDelim (const std::string &p) {_delim = p;}

	bool Next();

	///	\brief	분쇄된 하나의 문자열을 얻는다.
	///	\return	분쇄된 하나의 문자열
	const std::string &Get() {return _token;}


	///	\brief	문자열중 분쇄할 필요가 문자열을 구함
	///	\return	문자열중 분쇄할 필요가 문자열
	const std::string Rest() {return _str.substr(_cur);}

//	bool operator ==(const std::string &p) { return _token == p ;}
//	operator std::string &() {return _token;}

//	friend bool operator==(const std::string &p1, StringTokenizer &p2);
};

//bool operator==(const std::string &p1, StringTokenizer &p2)
//{
//	return p1 == p2._token;
//}

}; // namespace

#endif

