///	\file	Mcd.h
///	\brief	Mcd.h
#ifndef MLSMcd_H__
#define MLSMcd_H__

#include <string>
#include <vector>
#include <unistd.h>
#include <ncurses.h>

// mcd_cur.cpp
#include <sys/stat.h>
#include <dirent.h>
#include <algorithm>

#include <ncurses.h>
#include <vector>
#include <string>
#include <sys/stat.h>

#include <unistd.h>
#include <dirent.h>
#include <sys/stat.h>
#include <cassert>

#include "define.h"
#include "exception.h"

#include "configure.h"
#include "dialog.h"
#include "strutil.h"
#include "keydef.h"
#include "mlslocale.h"
#include "drawutil.h"
#include "StringTokenizer.h"
#include "progress.h"

namespace MLS {

///	\brief	Mcd class
class Mcd : public Counter, public IConfigurable
{

protected:
	///	\brief	directory 정보 
	struct dir
	{
		std::string name;		///< directory name
		int  		depth,		///< directory 깊이
					row,		///< 위치
					index;		///< index?
		struct dir  *parent;	///< parent directory
		int 		nlink;		///< link : number of hard links
		bool        linked;		///< linked : 링크인가?
		bool		bCheck;		///< 현재 디렉토리를 체크 했는가?
		
		std::vector<dir*> node;	///< node
		
		///	\brief	생성자
		///	\param	p		directory name
		///	\param	pa		parent directory
		///	\param	n		nlink :  number of hard links
		///	\param	l		linked : 링크 인가?
		dir(std::string p, dir *pa, int n, bool l = false, bool Chk = false) 
			: name(p), parent(pa), nlink(n), linked(l), bCheck(Chk)
		{ 
			depth = pa ? pa->depth+1 : 0; 
		}
		
		std::string &path();
	};

	///	\brief	mcdsort
	class mcdsort
	{
	public:
		///	\brief	operator() 함수
		///	\param	a	directory 정보
		///	\param	b	directory 정보
		///	\return	true :		a directory 명이 b directory 명보다 우선 정렬
		///			false:		b directory 명이 a directory 명보다 우선 정렬
		bool operator()(dir *a, dir *b)	{return a->name < b->name;}
	};
	
	bool            bMcdSort;
	
	WINDOW 			*win;
	
	typedef std::vector<dir *>	         pDirContainer;	///< dir * 벡터 재정의
	typedef std::vector<dir *>::iterator pDirIterator;///< dir * iterator 재정의
	
	pDirContainer	m_pOrder;  		///< 순회 테이블
	pDirIterator	m_pCur;			///< 현 위치 index
	
	dir				*m_pRoot;        ///< 루트 트리..  마지막 '/' 을 뺀 이름만을 기록
	int				m_nSRow,			///< 스크롤 한 Row	
					m_nSCol;			///< 스크롤 한 Col	

	bool			bExit;		///< exit 여부
	std::string		m_sSearch;    ///< 검색단어
	std::string		m_sInfofile;		///< treeinfo 파일 위치
	char			*m_sCode;   ///< treeinfo 헤더
	const char		*m_sTitle;	///< title string
	
	int				m_nCounter;		/// 현재 진행상황 전달
	
	// 순회테이블 재정리, m_pCur 무효화
	void setOrder();
	
	// 커서이동	
	void left();
	void right();
	void up();
	void down();
	
	// scan fuction
	int  load();
	int  save();
	
	void destroy(dir *, bool = true);	
	
	// draw function
	bool draw();
	
	///	\brief	Help 내용. (virtual)
	virtual void Help() = 0;
	
	///	\brief	draw 이외에 그릴 내용. (virtual)
	virtual int	DrawEtc() = 0;
	
	///	\brief	디렉토리 재검색 (virtual)
	virtual int  Rescan(int nDepth=0) = 0;
	
	///	\brief	디렉토리 검색 (virtual)
	virtual int  Scan(dir *arg, int nDepth=1) = 0;
	
	///	\brief	키 실행 (virtual)
	virtual int  McdExecute(int nKey) = 0;

public:
	Mcd(string = "", const char * = "MCD - Mls Change Directory");
	~Mcd();
	
	void	setCur(const std::string &);
	int		Search(const std::string &str, int nNextNum = 0);
	
	int		GetCounter() { return m_nCounter; }

	///	\brief	현재 위치한 정보를 얻어낸다.
	///	\return	현재 위치한 정보
	std::string &getCur() {return (*m_pCur)->path();}
	
	///	\brief	디렉토리 추가 (virtual)
	virtual int		AddDirectory(const std::string &) = 0;
	
	bool	proc();
	
};

}; // namespace

#endif //MLSmcd_H__
