///	\file	Mcd_cur.cpp
///	\brief	Mcd_cur.cpp
#include "DirMcd.h"
#include "colorset.h"
#include "mlslocale.h"

using namespace std;
using namespace MLS;

///	\brief	초기화
/// \param	sDir	초기 디렉토리
/// \param	_title	Title
DirMcd::
DirMcd(string		sDir, const char *_title):Mcd(sDir, _title)
{
	if (load() == ERROR)
	{
		struct stat stat_bufs;

		if (sDir == "")
		{
			lstat(m_McdRoot.c_str(), &stat_bufs);
			// 최상위 디렉토리는 왠만한 운영 서버에서는 접근이 가능하다.
			// 따라서 접근이 가능한 디렉토리만 보여주면 되는 것이다.
			m_pRoot = new dir("/", NULL, stat_bufs.st_nlink);
		}
		else
		{
			lstat(sDir.c_str(), &stat_bufs);
			m_pRoot = new dir(sDir, NULL, stat_bufs.st_nlink);
		}

		// 처음 깊이는 3으로 설정
		Scan(m_pRoot, 3);
	}

	UpdateConfig();
}

DirMcd::
~DirMcd()
{
	SaveConfig();
	save();
}

void DirMcd::UpdateConfig()
{
	m_McdFunc[0].addEntry(config.GetValue("McdFuncF1"));
	m_McdFunc[1].addEntry(config.GetValue("McdFuncF2"));
	m_McdFunc[2].addEntry(config.GetValue("McdFuncF3"));
	m_McdFunc[3].addEntry(config.GetValue("McdFuncF4"));
	m_McdFunc[4].addEntry(config.GetValue("McdFuncF5"));
	m_McdFunc[5].addEntry(config.GetValue("McdFuncF6"));
	m_McdFunc[6].addEntry(config.GetValue("McdFuncF7"));
	m_McdFunc[7].addEntry(config.GetValue("McdFuncF8"));
	m_McdFunc[8].addEntry(config.GetValue("McdFuncF9"));
	m_McdFunc[9].addEntry(config.GetValue("McdFuncF10"));
	m_McdFunc[10].addEntry(config.GetValue("McdFuncF11"));
	m_McdFunc[11].addEntry(config.GetValue("McdFuncF12"));
	_bHidden = config.GetBool("DirShowHidden");
}

void DirMcd::SaveConfig()
{
	config.SetBool("DirShowHidden", _bHidden);
}


///	\brief	directory을 mcd에 추가한다.
///	\param	_dir	추가할 directory 명
int DirMcd::AddDirectory( const std::string &_dir )
{
	// 디렉토리가 있는지 맞는지 확인한다.
	struct stat stat_bufs;

    if (lstat(_dir.c_str(), &stat_bufs) == -1)
    {
        throw Exception(	gettext("Directory not found [%s]"),
							_dir.c_str());
        return ERROR;
    }

	if (!S_ISDIR (stat_bufs.st_mode))
	{
		throw Exception(	gettext(	"Directory not access [%s]"), _dir.c_str());
		return ERROR;
	}

	if (!m_pRoot)
	{
		throw Exception("Root invalid.");
		return ERROR;
	}

	Mcd::dir *p = m_pRoot;

	StringTokenizer st(_dir, "/"); // /을 중심으로 계속 끊어줌

	while(st.Next())
	{
		const string &token = st.Get();

		LOG("Token :: [%s]", token.c_str());

		pDirIterator i;

		for (i = p->node.begin(); i!=p->node.end() ;i++)
		{
			if ((*i)->name == token)
			{
				break;
			}
		}

		if (i == p->node.end())
		{// 못찾았을 경우
			LOG("Not Find...!!! [%s]", token.c_str());
			Mcd::dir *d = new Mcd::dir(token, p, 2);

			p->node.push_back(d);

			if (bMcdSort) sort(p->node.begin(), p->node.end(), mcdsort());

			// 디렉토리 많아질 수록 느려짐
			setOrder();

			// 현재 디렉토리에 있는 디렉토리 전체 검색
			Scan(d, 0);

			p = d;
		}
		else
		{// 찾았을 경우
			p = (*i);
			LOG("Find...!!! [%s]", token.c_str());
		}
	}
	return SUCCESS;
}

///	\brief	directory를 전체를 재 검색한다.
///	\return	0을 반환
int DirMcd::Rescan(int nDepth)
{
	if (m_pRoot)
	{
		for (pDirIterator p = m_pOrder.begin(); p!=m_pOrder.end(); ++p)
			delete *p;
	}

	struct stat stat_bufs;
	lstat(m_McdRoot.c_str(), &stat_bufs);

	m_pRoot = new dir("/", NULL, stat_bufs.st_nlink);
	return Scan(m_pRoot, nDepth); // 루트를 중심으로 다시 스캔
}

///	\brief	tree로 넘어온 디렉토리에 서브디렉토리를 추가한다
///	\param	arg			directory 인자
///	\param	nDepth		디렉토리 검색 깊이
///	\return	0을 반환
int DirMcd::Scan(dir *arg, int nDepth)
{// 비재귀판
	pDirContainer st;
	Mcd::dir     *tree;
	DIR          *handle;
	dirent     	 *pFile;
	struct stat   stat_bufs;

	int			nDepthCount = 1;
	bool		bDirNull = false;

	char *lpath = new char[FILENAME_MAX]; // links 용
	char *curdir = getcwd(NULL, 0);	// 현재디렉토리. NULL로 설정하면 자동으로 메모리 사이즈를 잡는다.

	int n;

	try
	{
		destroy(arg, false);	// 구성요소들을 destroy.. 시킨다..
		nodelay(stdscr, TRUE);

		st.push_back(arg);

		while(!st.empty())
		{
			tree = st.back();
			st.pop_back();

			// Linked 되어 있으면 그냥 넘긴다.
			if (tree->linked) continue;

			// ESC를 누르면 STOP 된다.
			if (getch()==27) break;

			// 디렉토리를 이동한다.
			if (chdir(tree->path().c_str())==-1) continue;

			// 현재디렉토리를 연다. 에러면 다음으로 넘긴다.
			if ((handle = opendir("."))==NULL) continue;

			// 디렉토리를 읽어 들인다.
			while((pFile = readdir(handle)))
			{
				// ., ..은 넘긴다.
				if (!strcmp(pFile->d_name, "."))	continue;
				if (!strcmp(pFile->d_name, ".."))	continue;

				if (_bHidden == false)
					if (!strncmp(pFile->d_name, ".", 1)) continue;

				// 파일 정보얻어오기
				if (lstat(pFile->d_name, &stat_bufs)==-1) continue;

				// 링크인가?
				if (S_ISLNK(stat_bufs.st_mode))
				{
					if ((n = readlink(pFile->d_name, lpath, FILENAME_MAX)) == -1) continue;

					lpath[n] = '\0';
					if (lstat(lpath, &stat_bufs) == -1) continue;

					// 디렉토리면
					if (S_ISDIR(stat_bufs.st_mode))
					{
						tree->node.push_back(new dir(pFile->d_name, tree, stat_bufs.st_nlink));
					}
					//continue;
				}
				else
				{
					// 디렉토리가 아니면 넘기고
					if (!S_ISDIR (stat_bufs.st_mode))
						continue;
					else
					{
						// 디렉토리를 tree node에 저장.
						tree->node.push_back(new dir(pFile->d_name, tree, stat_bufs.st_nlink));
					}
				}
			}
			closedir(handle);

			// 이 디렉토리를 체크 했는가?
			tree->bCheck = true;

			// tree 를 정렬한다.
			if (bMcdSort)
				sort(tree->node.begin(), tree->node.end(), mcdsort());

			// 스택에 노드들을 채운다.. 순서는 반대로 한다.
			if (nDepth != nDepthCount)
			{
				nDepthCount++;
				copy (tree->node.rbegin(), tree->node.rend(), back_inserter(st));
			}
		}

		nodelay(stdscr, FALSE);
		setOrder();
	}
	catch(...)
	{
		delete []lpath;
		free(curdir);
		throw;
	}

	// 함수를 실행하기 전 디렉토리로 이동.
	chdir(curdir);

	delete []lpath;
	free(curdir);

	return 0;
}

///	\brief	DirMcd 에 필요한 내용을 그린다.
///	\return	SUCCESS, ERROR
int DirMcd::DrawEtc(void)
{
	int i;

	// Function 그리기
	setcol(g_Color.Func, win);
	wmove(win, g_nLINES-1,0);
	whline(win, ' ', g_nCOLS);
	for (i=0; i<8; i++)
		mvwprintw(win, g_nLINES-1, 2+i*(g_nCOLS/8),"%s", gettext(m_McdFunc[i+1].getName()));


	// F 그리기
	setcol(g_Color.FuncA, win);
	mvwprintw (win, g_nLINES-1, 0, "F");
	for (i=0; i<8; i++)
		mvwprintw(win, g_nLINES-1, 1+i*(g_nCOLS/8), "%d", i+2);

	setcol(g_Color.MCD, win);
	mvwprintw(win, g_nLINES-2, 0, 	gettext(" Path [ %s ]"), (*m_pCur)->path().c_str());

	return SUCCESS;
}

///	\brief	도움말을 보여준다.
void
DirMcd::Help()
{
	int width = 70;
	int height = 17;

	width +=4;

	WINDOW *win = newwin(height, width, (g_nLINES-height)/2, (g_nCOLS-width)/2);
	//	wclear(win);
	wbkgd(win, COLOR(COLOR_WHITE, 3));

	wattron(win ,A_BOLD);
	wborder(win, VLINE, VLINE, HLINE, HLINE, ULCORNER, URCORNER, LLCORNER, LRCORNER);

	wattroff(win, A_BOLD);

	// title 출력
	wattron(win, COLOR(COLOR_BLACK, COLOR_WHITE));
	wmove(win, 1, 1);
	whline(win, ' ', width-2);
	mvwprintw(win, 1, 30, "Mcd Help");
	wattroff(win, A_BOLD);

	// msg
	wattron (win, COLOR(COLOR_WHITE, 3));
	wattron (win, A_BOLD);

	mvwprintw(win, 3, 2,  gettext("/ , \\  : Shell"));
	mvwprintw(win, 4, 2,  gettext("+      : Current directory OneSearch"));
	mvwprintw(win, 5, 2,  gettext("-      : Current directory Delete"));
	mvwprintw(win, 6, 2,  gettext("=      : Current directory AllSearch"));
	mvwprintw(win, 13, 2, gettext("Alt+X  : Mcd exit"));

	mvwprintw(win, 3,  40, gettext("F1    : Help"));
	mvwprintw(win, 4,  40, gettext("F2    : Rescan"));
	mvwprintw(win, 5,  40, "F3    : (NULL)");
	mvwprintw(win, 6,  40, "F4    : (NULL)");
	mvwprintw(win, 7,  40, gettext("F5    : Reflesh"));
	mvwprintw(win, 8,  40, gettext("F6    : Rename Dir"));
	mvwprintw(win, 9,  40, gettext("F7    : Make Dir"));
	mvwprintw(win, 10, 40, gettext("F8    : Remove Dir"));
	mvwprintw(win, 11, 40, gettext("F9    : Dir Info"));
	mvwprintw(win, 12, 40, "F10   : (NULL)");
	mvwprintw(win, 13, 40, "F11   : (NULL)");
	mvwprintw(win, 14, 40, "F12   : (NULL)");
	wattroff(win, A_BOLD);

	wrefresh(win);

	getch();
	delwin(win);
}

vector<string> CmdExecute(string sCmd)
{
	char 	cLine[1024];
	vector<string>	vPrtList;

	sCmd.append(" 2> /dev/null");
	FILE*	pfFile = popen(sCmd.c_str(), "r");
	
	if (pfFile) 
	{
		rewind(pfFile);
		// 줄단위로 데이터 읽음.
		while (fgets(cLine, sizeof(cLine), pfFile))
		{
			vPrtList.push_back(cLine);
		}
		pclose(pfFile);
	}
	else
	{
		throw Exception(gettext("file open error"));
	}
	return vPrtList;
}

void
DirMcd::
ViewDirInfo()
{
	vector<string>	vPrtList;
	uint			uFileSize = 0, uFileNum = 0, uDirNum = 0;
	string 			sCmd;

	WINDOW*  pWin = MsgWaitBox(	gettext("Wait"),
								gettext("Please wait !!! - Cancel Key [Ctrl+C]"));

	// 파일 사이즈
	sCmd = "cd " + (*m_pCur)->path() + "; du -b --max-depth=0 2> /dev/null | awk '{print $1}'";
	vPrtList = CmdExecute(sCmd); 
	if (vPrtList.size() != 1)
	{
		MsgWaitEnd(pWin);
		return;
	}
	uFileSize = atol(vPrtList[0].c_str());

	// 파일 개수
	sCmd = "cd " + (*m_pCur)->path() + "; find . -type f 2> /dev/null | wc -l";
	vPrtList = CmdExecute(sCmd);
	if (vPrtList.size() != 1)
	{
		MsgWaitEnd(pWin);
		return;
	}
	uFileNum = atol(vPrtList[0].c_str());

	// 디렉토리 개수 
	sCmd = "cd " + (*m_pCur)->path() + "; find . -type d 2> /dev/null | wc -l";
	vPrtList = CmdExecute(sCmd);
	if (vPrtList.size() != 1)
	{
		MsgWaitEnd(pWin);
		return;
	}
	uDirNum = atol(vPrtList[0].c_str());

	MsgWaitEnd(pWin);
	
	int width = 44;
	int height = 7;

	width +=4;

	WINDOW *win = newwin(height, width, (g_nLINES-height)/2, (g_nCOLS-width)/2);
	//wclear(win);
	wbkgd(win, COLOR(COLOR_WHITE, 3));

	wattron(win ,A_BOLD);
	wborder(win, VLINE, VLINE, HLINE, HLINE, ULCORNER, URCORNER, LLCORNER, LRCORNER);

	wattroff(win, A_BOLD);

	// title 출력
	wattron(win, COLOR(COLOR_BLACK, COLOR_WHITE));
	wmove(win, 1, 1);
	whline(win, ' ', width-2);
	string sTitle = gettext("Directory Info");
	mvwprintw(win, 1, (width - strutil::krstrlen(sTitle))/2, (char*)sTitle.c_str());
	wattroff(win, A_BOLD);

	// msg
	wattron (win, COLOR(COLOR_WHITE, 3));
	wattron (win, A_BOLD);
	mvwprintw(win, 3, 4, gettext("Directory  size : %s Byte"), strutil::toregular(uFileSize).c_str());
	mvwprintw(win, 4, 4, gettext("File count      : %s"), strutil::toregular(uFileNum).c_str());
	mvwprintw(win, 5, 4, gettext("Directory count : %s"), strutil::toregular(uDirNum).c_str());
	wattroff(win, A_BOLD);

	wrefresh(win);

	getch();
	delwin(win);
}

///	\brief	키 실행
///	\param	nKey	키번호
///	\return	SUCCESS, ERROR
int
DirMcd::
McdExecute(int nKey)
{
	switch(nKey)
	{
		// 자신의 디렉토리의 깊이 하나만 찾아준다.
		case '+':
		{
			WINDOW*	pWin = MsgWaitBox(	gettext("Wait"),
										gettext(	"Please wait !!! - Cancel Key [ESC]"));

			string p = (*m_pCur)->path();
			Scan(*m_pCur, 1);
			setCur(p);
			if (pWin) MsgWaitEnd(pWin);
			break;
		}

		// 자신의 디렉토리에서 밑의 전체를 찾아준다.
		case '=':
		{
			WINDOW*	pWin = MsgWaitBox(	gettext("Wait"),
										gettext(	"Please wait !!! - Cancel Key [ESC]"));

			string p = (*m_pCur)->path();
			Scan(*m_pCur, 0);
			setCur(p);
			if (pWin) MsgWaitEnd(pWin);
			break;
		}

		case '-':
		{
			string p = (*m_pCur)->path();
			destroy(*m_pCur);
			setCur(p);
			break;
		}

		case KEY_F(1):
		{
			Help();
			break;
		}

		case KEY_F(2):
		{
			int p= YNBox(gettext(	"Rescan directory now?"), YN_Y, COLOR_MAGENTA);
			if (p==YN_N || p==-1) break;

			WINDOW*	pWin = MsgWaitBox(	gettext("Wait"),
										gettext("Please wait !!! - Cancel Key [ESC]"));
			string pa = (*m_pCur)->path();
			Rescan();
			if (pWin) MsgWaitEnd(pWin);
			setCur(pa);
			break;
		}

		case KEY_F(3):
		{
			WINDOW*	pWin = MsgWaitBox(	gettext("Wait"),
										gettext("Please wait !!! - Cancel Key [ESC]"));
			string pa = (*m_pCur)->path();
			Rescan(3);
			if (pWin) MsgWaitEnd(pWin);
			AddDirectory(pa);
			setCur(pa);
			break;
		}

		case KEY_F(4):
		{
			WINDOW*	pWin = MsgWaitBox(	gettext("Wait"),
										gettext("Please wait !!! - Cancel Key [ESC]"));
			string sCurPath = (*m_pCur)->path();
			_bHidden = !_bHidden;
			Rescan(3);
			setCur(sCurPath);
			if (pWin) MsgWaitEnd(pWin);
			break;
		}

		case KEY_F(5):
		{
			g_nLINES = LINES;
			g_nCOLS = COLS;
			draw();
			break;
		}

		case KEY_F(6):
		{
			string sRenamedir, sRenamePath;
			string sCmd, sCurPath;

			sCurPath = (*m_pCur)->path();

			if (sCurPath == "/")
			{
				MsgBox(	gettext("Error"),
						gettext(	"Don't rename directory !!!"));
				break;
			}

			if (access(sCurPath.c_str(), W_OK) == -1)
			{
				MsgBox(	gettext("Error"), strerror(errno));
				break;
			}

			if (InputBox(gettext("Rename Directory"), sRenamedir)<0) break;
			
			// 바로위의 디렉토리로 이동.
			left();
			sRenamePath = (*m_pCur)->path() + sRenamedir;

			sCmd = "mv " + sCurPath + " " +  sRenamePath;
			LOG("sCmd : [%s]", sCmd.c_str());

			system(sCmd.c_str());

			WINDOW*	pWin = MsgWaitBox(	gettext("Wait"),
										gettext("Please wait !!! - Cancel Key [ESC]"));
			sCurPath = (*m_pCur)->path();
			LOG("CURPATH : [%s]", sCurPath.c_str());
			Scan(*m_pCur, 1);
			setCur(sCurPath);
			if (pWin) MsgWaitEnd(pWin);
			break;
		}

		case KEY_F(7):
		{
			string sMkdir;
			string sCurPath = (*m_pCur)->path();

			if (access(sCurPath.c_str(), W_OK) == -1)
			{
				MsgBox(	gettext("Error"), strerror(errno));
				break;
			}

			if (InputBox(gettext("Make Directory"), sMkdir)<0) break;

			sMkdir = sCurPath + sMkdir;
			LOG("MKDIR [%s]", sMkdir.c_str());

			if (mkdir(sMkdir.c_str(), 0755)==-1)
			{
				MsgBox(	gettext("Error"), strerror(errno));
				break;
			}

			WINDOW*	pWin = MsgWaitBox(	gettext("Wait"),
										gettext("Please wait !!! - Cancel Key [ESC]"));

			string p = (*m_pCur)->path();
			Scan(*m_pCur, 1);
			setCur(p);
			if (pWin) MsgWaitEnd(pWin);
			break;
		}

		case KEY_DC:
		case KEY_F(8):
		{
			string sCmd, sCurPath;
			sCurPath = (*m_pCur)->path();
			if (sCurPath == "/")
			{
				MsgBox(	gettext("Error"),
						gettext("Don't remove directory !!!"));
				break;
			}

			if (access(sCurPath.c_str(), W_OK) == -1)
			{
				MsgBox(	gettext("Error"), strerror(errno));
				break;
			}

			int nYN = YNBox(gettext("Do you really want to remove directory now?"),
							YN_N, COLOR_MAGENTA);
			if (nYN == YN_N) break;

			sCmd = "rm -rf " + sCurPath;
			LOG("sCmd : [%s]", sCmd.c_str());

			system(sCmd.c_str());

			// 바로위의 디렉토리로 이동.
			left();
			WINDOW*	pWin = MsgWaitBox(	gettext("Wait"),
										gettext("Please wait !!! - Cancel Key [ESC]"));
			sCurPath = (*m_pCur)->path();
			LOG("CURPATH : [%s]", sCurPath.c_str());
			Scan(*m_pCur, 1);
			setCur(sCurPath);
			if (pWin) MsgWaitEnd(pWin);
			break;
		}

		case KEY_F(9):
		{
			noraw();	cbreak();    // Ctrl+C 를 가능하게 하기 위해서
			ViewDirInfo();
			nocbreak(); raw();
		}
	}
	return SUCCESS;
}
