/***************************************************************************
 *   Copyright (C) 2004 by Byoungyoung, La                                 *
 *   la9527@yahoo.co.kr                                                    *
 ***************************************************************************/

#ifndef		__EditorCmd_H__
#define		__EditorCmd_H__

#include "define.h"
#include "editor.h"
#include "menu.h"

namespace MLS
{

class EditorMenu:public Menu
{
public:
	EditorMenu() {}
	void MenuAddCatecory();
	void MenuRefresh();
};

class EditorCmd
{
	Editor* _pEditor;

	typedef void (Editor::* CmdFun)();
	typedef std::map<std::string, CmdFun>	FuncMap;

	FuncMap _func;

public:
	EditorCmd(): _pEditor(NULL) {}

	void	Init(Editor* pEditor);

	/// @brief	해당 str 명령을 실행시킨다.
	/// @param str	실행할 명령어
	/// @return	0
	int Execute(const std::string&	str)
	{
		if (_pEditor == NULL) return ERROR;
		if (str.empty())
			return ERROR;
	
		if (*str.begin() == '<' && *(str.end()-1) == '>')
		{//  < > 로 둘러쌓인 문자열에 대해서.
			FuncMap::iterator i;
	
			if ((i = _func.find(str.substr(1, str.size()-2))) != _func.end())
			{
				(_pEditor->*((*i).second))();
				return SUCCESS;
			}
			else
			{
				MsgBox(COLOR_RED, gettext("Error"),
					gettext("configure command not found.."), str.c_str());
			}
		}
		return ERROR;
	}
};

extern EditorCmd*	g_pEditorCmd;
};

#endif
