/* $Id: print.c,v 1.2 2005/05/12 07:31:19 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "print.h"

static int __init = 0;

static void init_pslib (void);
static void stop_pslib (void);

/* initializing call to pslib - call this in any public function of 
 * this file */
static void
init_pslib (void)
{
     if (__init == 0)
     {
          PS_boot();
          __init = 1;
     }
     return;
}

/*
 * releases pslib
 */
static void
stop_pslib (void)
{
     if (__init == 1)
     {
          PS_shutdown();
          __init = 0;
     }
     return;
}

/* 
 * Creates a flashcard like document for a specific meaning.
 */
PSDoc*
print_create_flashcard (lingMeaning *meaning)
{
     PSDoc *doc;
     
     init_pslib ();
     doc = PS_new ();

     return doc;
}

/*
 * Closes a postscript document created with pslib
 */
void
print_close_document (PSDoc *doc)
{
     PS_close (doc);
     PS_delete (doc);
     return;
}

