/* $Id: gtkplugin.c,v 1.3 2005/03/28 16:24:40 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "../li18n.h"
#include "../errors.h"
#include "gtkplugin.h"

lingGtkPlugin*
gtkplugin_plugin_new (void)
{
     lingGtkPlugin *plugin = NULL;

     plugin = g_new (lingGtkPlugin, 1);
     if (!plugin)
          return NULL;

     plugin->name = NULL;
     plugin->desc = NULL;
     plugin->init = NULL;
     plugin->free = NULL;
     plugin->module = NULL;
     plugin->path = NULL;
     return plugin;
}

lingGtkPlugin*
gtkplugin_plugin_load (gchar *file)
{
     lingGtkPlugin *plugin = NULL;

     g_return_val_if_fail (file != NULL, NULL);

     plugin = gtkplugin_plugin_new ();
     if (!plugin)
     {
          error_warning (ERR_MEM_INFO,
                         _("Plugin structure could not be allocated."),
                         ERR_NOT_AVAILABLE);
          return NULL;
     }

     /* try to open the module */
     plugin->module = g_module_open (file, 0);
     if (!plugin->module)
     {
          error_warning (_("Plugin could not be opened!"),
                         _("This error usually happens, if the file is not a "
                           "valid lingoteach plugin."),
                         _("Make sure, the file is a real lingoteach "
                           "plugin."));
          g_free (plugin);
          return NULL;
     }
     
     /* load the module functions (symbols) into our structure */
     if (!g_module_symbol (plugin->module, "plugin_name",
                           (gpointer *) &plugin->name)
         || !g_module_symbol (plugin->module, "plugin_desc",
                              (gpointer *) &plugin->desc)
         || !g_module_symbol (plugin->module, "plugin_init",
                              (gpointer *) &plugin->init)
         || !g_module_symbol (plugin->module, "plugin_free",
                              (gpointer *) &plugin->free))
     {
          error_warning (_("Plugin could not be loaded!"),
                         _("The plugin seems to lack some necessary "
                           "symbols (funtions)."),
                         _("The plugin is broken and can not be used. "
                           "Best would be to inform the maintainer "
                           "and/or developer of that problem."));
          gtkplugin_plugin_free (plugin);
          return NULL;
     }

     /* save file path */
     plugin->path = g_strdup (file);

     return plugin;
}

void
gtkplugin_plugin_free (lingGtkPlugin *plugin)
{
     if (plugin->free)
          plugin->free ();
     
     g_module_close (plugin->module);

     if (plugin->path)
          g_free (plugin->path);
     
     g_free (plugin);
     return;
}
