/* $Id: gtkerr.c,v 1.8 2005/03/28 16:24:40 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "../li18n.h"
#include "../errors.h"
#include "hig-widgets.h"
#include "gtkdefs.h"

#include "gtkerr.h"

extern lingGtkMainWindow *main_app;

static gboolean last_critical = FALSE;
static const char *last_info = NULL;
static const char *last_desc = NULL;
static const char *last_sol = NULL;
static const char *last_file = NULL;
static int last_line = 0;

static void create_view_solution (GtkWidget *dialog);
static void run_error_dialog (gboolean critical, const char *information,
                              const char *description);
static void gui_warning (const char *information, const char *description,
                         const char *solution, char *file, int line);
static void gui_critical (const char *information, const char *description,
                          const char *solution, char *file, int line);

static void
create_view_solution (GtkWidget *dialog)
{
     gtk_message_dialog_format_secondary_markup (GTK_MESSAGE_DIALOG (dialog),
                                                 "%s\n\n<i>Solution: %s</i>",
                                                 last_desc, last_sol);
     return;
}

static void
run_error_dialog (gboolean critical, const char *information,
                  const char *description)
{
     GtkWidget *dialog;
     GtkWidget *btn_sol;

     dialog = gtk_message_dialog_new (GTK_WINDOW (main_app->window),
                                      GTK_DIALOG_MODAL |
                                      GTK_DIALOG_DESTROY_WITH_PARENT,
                                      (!critical) ? GTK_MESSAGE_WARNING :
                                      GTK_MESSAGE_ERROR,
                                      GTK_BUTTONS_CANCEL,
                                      information);
     gtk_window_set_position (GTK_WINDOW (dialog),
                              GTK_WIN_POS_CENTER_ON_PARENT);
     gtk_container_set_border_width (GTK_CONTAINER (dialog), WIDGET_BORDER);
     gtk_message_dialog_format_secondary_text (GTK_MESSAGE_DIALOG (dialog),
                                               description);

     btn_sol = gtk_button_new_with_mnemonic (_("_Solution"));
     g_signal_connect_swapped (G_OBJECT (btn_sol), "clicked",
                               G_CALLBACK (create_view_solution), dialog);
     gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->action_area),
                        btn_sol);
     gtk_widget_show (btn_sol);

     /* main content */
     gtk_dialog_run (GTK_DIALOG (dialog));
     gtk_widget_destroy (dialog);
     return;
}

static void
gui_warning (const char *information, const char *description,
             const char *solution, char *file, int line)
{
     last_critical = FALSE;
     last_info = information;
     last_desc = description;
     last_sol = solution;
     last_file = file;
     last_line = line;
     run_error_dialog (last_critical, information, description);
     return;
}

static void
gui_critical (const char *information, const char *description,
              const char *solution, char *file, int line)
{
     last_critical = TRUE;
     last_info = information;
     last_desc = description;
     last_sol = solution;
     last_file = file;
     last_line = line;
     run_error_dialog (last_critical, information, description);
     
     return;
}

void
gtkerr_register_errors (void)
{
     debug ("Registering gui error callbacks.\n");
     error_connect_signal (LING_ERR_WARNING, (lingErrorCallback) gui_warning);
     error_connect_signal (LING_ERR_CRITICAL,
                           (lingErrorCallback) gui_critical);
     return;
}

void
gtkerr_show_last_error (void)
{
     run_error_dialog (last_critical, last_info, last_desc);
     return;
}
