/* $Id: gtkedit-meaning.h,v 1.7 2005/03/29 10:08:30 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LING_GTKEDIT_MEANING_H
#define LING_GTKEDIT_MEANING_H 1

#include "gtkedit.h"
#include <lingoteach.h>

enum {
     GTKEDITMEANING_TOOL_ADD,
     GTKEDITMEANING_TOOL_REM,
     GTKEDITMEANING_TOOL_EDIT
};

lingLesson*
gtkedit_meaning_create_lesson_from_list (GtkTreeView *view);

GtkWidget*
gtkedit_meaning_create_view (lingGtkEditor *editor, const gchar *labels[]);

GtkTreeModel*
gtkedit_meaning_create_entry_list (lingLesson *lesson);

void 
gtkedit_meaning_apply_search (GtkEntry *text, GtkTreeView *view);

void
gtkedit_meaning_update_menus (lingGtkEditor *editor);

#endif /* LING_GTKEDIT_MEANING_H */
