/* $Id: gtkconfig.h,v 1.11 2005/03/24 10:27:24 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LING_GTKCONFIG_H
#define LING_GTKCONFIG_H 1

#include <gtk/gtk.h>
#include "../cfg.h"
#include "../learn.h"

typedef struct
{
     lingoteachSettings *prefs;        /* the global preferences */

     guint               learn_words;  /* default word amount to use */
     gboolean            learn_hints;  /* hints for learning */
     learnMethodType     learn_method; /* learn method */
     learnLanguage      *learn_lang;   /* */

     guint               train_words;  /* default word amount to use */
     gboolean            train_hints;  /* hints for testing */
     learnMethodType     train_method; /* train method */
     learnLanguage      *train_lang;   /* */

     lingchar           *edit_lang;    /* language to use for the editor */

     GSList             *plugins;      /* plugins loaded by the user */

     /* those are user session dependant data, which will not be saved */
     learnSession       *learn_session;
     learnSession       *train_session; /* TODO:this has to be changed later */
     
} lingGtkPrefs;

typedef enum
{
     PREFERENCE_GENERAL,
     PREFERENCE_LEARN,
     PREFERENCE_TRAIN,
     PREFERENCE_EDIT,
     PREFERENCE_PLUGIN
} PreferenceType;

void 
gtkconfig_load (lingGtkPrefs *settings);

lingGtkPrefs*
gtkconfig_init_settings (lingoteachSettings *preferences);

void
gtkconfig_free_settings (lingGtkPrefs *settings);

gboolean
gtkconfig_save_settings (lingGtkPrefs *settings);

void
gtkconfig_load_defaults (lingGtkPrefs *settings);

gboolean
gtkconfig_check_config (lingGtkPrefs *settings, PreferenceType type);

#endif /* LING_GTKCONFIG_H */
