/* $Id: gtkcellrenderercombo.c,v 1.2 2005/03/24 10:27:25 marcusva Exp $
 * GtkCellRendererCombo
 * Copyright (C) 2004-2005 Marcus von Appen
 * Copyright (C) 2004 Lorenzo Gil Sanchez
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "gtkcellrenderercombo.h"
#include "lingcombobox.h"

static void gtk_cell_renderer_combo_class_init (GtkCellRendererComboClass *klass);
static void gtk_cell_renderer_combo_init       (GtkCellRendererCombo      *self);
static void gtk_cell_renderer_combo_get_property (GObject      *object,
						  guint         prop_id,
						  GValue       *value,
						  GParamSpec   *pspec);

static void gtk_cell_renderer_combo_set_property (GObject      *object,
						  guint         prop_id,
						  const GValue *value,
						  GParamSpec   *pspec);

static GtkCellEditable * gtk_cell_renderer_combo_start_editing (GtkCellRenderer     *cell,
								GdkEvent            *event,
								GtkWidget           *widget,
								const gchar         *path,
								GdkRectangle        *background_area,
								GdkRectangle        *cell_area,
								GtkCellRendererState flags);

enum {
  PROP_0,
  PROP_MODEL
};

static GObjectClass *parent_class = NULL;

#define GTK_CELL_RENDERER_COMBO_PATH "gtk-cell-renderer-combo-path"

GType
gtk_cell_renderer_combo_get_type (void)
{
  static GType gtk_cell_renderer_combo_type = 0;

  if (!gtk_cell_renderer_combo_type)
    {
      static const GTypeInfo gtk_cell_renderer_combo_info = 
	{
	  sizeof (GtkCellRendererComboClass),
	  (GBaseInitFunc)     NULL,
	  (GBaseFinalizeFunc) NULL,
	  (GClassInitFunc)    gtk_cell_renderer_combo_class_init,
	  NULL,
	  NULL,
	  sizeof (GtkCellRendererCombo),
	  0,
	  (GInstanceInitFunc) gtk_cell_renderer_combo_init
	};
      gtk_cell_renderer_combo_type =
	g_type_register_static (GTK_TYPE_CELL_RENDERER_TEXT,
				"GtkCellRendererCombo",
				&gtk_cell_renderer_combo_info,
				0);
    }
  return gtk_cell_renderer_combo_type;
}

static void
gtk_cell_renderer_combo_class_init (GtkCellRendererComboClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  GtkCellRendererClass *cell_class = GTK_CELL_RENDERER_CLASS (klass);

  parent_class = g_type_class_peek_parent (klass);

  object_class->get_property = gtk_cell_renderer_combo_get_property;
  object_class->set_property = gtk_cell_renderer_combo_set_property;

  cell_class->start_editing = gtk_cell_renderer_combo_start_editing;

  g_object_class_install_property (object_class,
				   PROP_MODEL,
				   g_param_spec_object ("model",
							"Model",
							"The model for combo",
							GTK_TYPE_TREE_MODEL,
							G_PARAM_READWRITE));
}

static void
gtk_cell_renderer_combo_init (GtkCellRendererCombo *self)
{
}

GtkCellRenderer *
gtk_cell_renderer_combo_new (void)
{
  return g_object_new (GTK_TYPE_CELL_RENDERER_COMBO, NULL);
}

static void
gtk_cell_renderer_combo_get_property (GObject    *object,
				      guint       prop_id,
				      GValue     *value,
				      GParamSpec *pspec)
{
  GtkCellRendererCombo *cell;
 
  g_return_if_fail (GTK_IS_CELL_RENDERER_COMBO (object));

  cell = GTK_CELL_RENDERER_COMBO (object);

  switch (prop_id)
    {
    case PROP_MODEL:
      g_value_set_object (value, cell->model);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
gtk_cell_renderer_combo_set_property (GObject      *object,
				      guint         prop_id,
				      const GValue *value,
				      GParamSpec   *pspec)
{
  GtkCellRendererCombo *cell;
  
  g_return_if_fail (GTK_IS_CELL_RENDERER_COMBO (object));

  cell = GTK_CELL_RENDERER_COMBO (object);

  switch (prop_id)
    {
    case PROP_MODEL:
      cell->model = g_value_get_object (value);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
gtk_cell_renderer_combo_editing_done (GtkCellEditable *combo,
				      gpointer         data)
{
  const gchar *path;
  const gchar *new_text;
  
  path = g_object_get_data (G_OBJECT (combo), GTK_CELL_RENDERER_COMBO_PATH);

  new_text = gtk_entry_get_text (GTK_ENTRY (GTK_BIN(combo)->child));

  g_signal_emit_by_name (data, "edited", path, new_text);
}

static gboolean
gtk_cell_renderer_combo_focus_out_event (GtkWidget *widget,
					 GdkEvent  *event,
					 gpointer   data)
{

  gtk_cell_renderer_combo_editing_done (GTK_CELL_EDITABLE (widget), data);
  g_signal_handlers_disconnect_by_func (widget,
					gtk_cell_renderer_combo_focus_out_event,
					data);

  return FALSE;
}

static GtkCellEditable *
gtk_cell_renderer_combo_start_editing (GtkCellRenderer     *cell,
				       GdkEvent            *event,
				       GtkWidget           *widget,
				       const gchar         *path,
				       GdkRectangle        *background_area,
				       GdkRectangle        *cell_area,
				       GtkCellRendererState flags)
{
  GtkCellRendererCombo *cell_combo;
  GtkCellRendererText *cell_text;
  GtkWidget *combo;

  cell_text = GTK_CELL_RENDERER_TEXT (cell);
  if (cell_text->editable == FALSE)
    return NULL;

  cell_combo = GTK_CELL_RENDERER_COMBO (cell);
  if (cell_combo->model == NULL)
    return NULL;

  combo = gtk_combo_box_entry_new_with_model (cell_combo->model, 0);
  
  if (cell_text->text)
    gtk_entry_set_text (GTK_ENTRY (GTK_BIN (combo)->child), cell_text->text);

  g_object_set_data_full (G_OBJECT (combo),
			  GTK_CELL_RENDERER_COMBO_PATH,
			  g_strdup (path), g_free);

  gtk_widget_show (combo);

  g_signal_connect (LING_COMBO_BOX(combo), "editing_done",
		    G_CALLBACK (gtk_cell_renderer_combo_editing_done),
		    cell_combo);
  g_signal_connect (LING_COMBO_BOX(combo), "focus_out_event",
		    G_CALLBACK (gtk_cell_renderer_combo_focus_out_event),
		    cell);

  return GTK_CELL_EDITABLE (LING_COMBO_BOX(combo));
}
