/*
 * Line6 Linux USB driver - 0.7.3beta
 *
 * Copyright (C) 2004-2008 Markus Grabner (grabner@icg.tugraz.at)
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation, version 2.
 *
 */

/*
  Testing utility for MidiBuffer. Kernel functions are mapped to user space
  functions by macros.
*/

#include <cstdlib>
#include <iostream>

extern "C" {
#include "midibuf.h"
}


#define BUF_SIZE 256
#define CHUNK_SIZE 8


void
write_partial(MidiBuffer *mb, int length)
{
  static unsigned char message[] = {
    0xb0, 0x0e, 0x28, 0x0f, 0xfe, 0x29,
    0xc0, 0x10, 0x12,
    0xf0, 0x00, 0x01, 0x0c, 0xf7,
    0xb0, 0x0d, 0x58,
    0xb0, 0x0d, 0x59,
    0xb0, 0x0d, 0x5a,
    0xc0, 0x23
  };

  static unsigned char *mp = message;
  midibuf_write(mb, mp, length);
  mp += length;
}

void
catchup(MidiBuffer *mb)
{
  unsigned char chunk[CHUNK_SIZE];
  int done;

  while((done = midibuf_read(mb, chunk, sizeof(chunk))) > 0) {
    for(int i = 0; i < done; ++i)
      printf("%02x ", chunk[i]);

    printf("\n");
  }

  printf("\n");
}

int
main()
{
  MidiBuffer mb;
  midibuf_init(&mb, BUF_SIZE, 0);

  write_partial(&mb, 2);
  write_partial(&mb, 3);
  catchup(&mb);
  write_partial(&mb, 2);
  write_partial(&mb, 4);
  catchup(&mb);
  write_partial(&mb, 3);
  write_partial(&mb, 1);
  write_partial(&mb, 2);
  catchup(&mb);
  catchup(&mb);

  midibuf_destroy(&mb);
  return 0;
}
