#!/bin/sh

#
# Line6 Linux USB driver - 0.6
#
# Copyright (C) 2005, 2006 Markus Grabner (grabner@icg.tugraz.at)
#
#	This program is free software; you can redistribute it and/or
#	modify it under the terms of the GNU General Public License as
#	published by the Free Software Foundation, version 2.
#

# record audio data from PODxt Pro

# ALSA card number of PODxt Pro
CARD=`line6_find_device.pl card POD`

if test -z $2; then
    echo "usage: arecord.sh <wav-file> <seconds>"
    exit 1
fi

# use PODxt Pro's native sample format:
arecord --device=hw:$CARD,0 --channels=2 --rate=39063 --format=S24_3LE --duration=$2 $1

# resample to "standard" format:
#arecord --device=plughw:$CARD,0 --channels=2 --rate=44100 --format=S16_LE --duration=$2 $1
