// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution

//QT
#include <qfiledialog.h>

#include <utils.h>

extern TUtils 	     Util;
extern TConfig  *ConfigW;


extern TAttrs FormAttrsTb[10];

//
extern QString  port;
extern QString  mycall;
extern QString  bbs;
extern QString  bbs_w_ssid;
extern QString  bbs_wo_ssid;
extern QString  digi;
extern QString  ListPath;
extern QString  PrgPath;
extern QString  ConfigFormat;
extern QString  LineFormat;
extern QString  IdxFormat;
extern int   header_lines;
extern QString  Cmds2GetLst;
extern QString  Cmds2LogOff;
extern QString  SysopName;
extern QString  Email;
extern QString  QuotePref;
extern QString  SID;
extern QString  RePref;
extern QString  HierAddr;
extern QString  BBSprompt;
extern QString  Altprompt;
extern QString  Version;
extern int   lastnum;
extern QStringList PersSigLines;
extern QStringList BullSigLines;
extern QString  HTMLV;
extern QString  HTMLE;
extern QString  ExtEd;
extern QString  ExtAd;

extern bool  AutoSig;
extern bool  Killmymsg;
extern int   Disconn;
extern bool  IsScript;
extern bool  IsTelnet;
extern char  Buffer[2047];
extern int   DataRead;
extern QString DataContent;
extern bool  AgeExpire;
extern int   AgeExpireDays;
extern bool  NrExpire;
extern int   NumberExpire;
extern bool  ShowHeaders;
extern bool  WordWrap;
extern int   WordWrapNr;


void TConfig::SaveBtn()
{
	port		= E_Port->text().stripWhiteSpace();
	mycall		= E_MyCall->text().stripWhiteSpace();
	bbs		= E_BBS->text().stripWhiteSpace();
	digi		= E_Path->text().stripWhiteSpace();
	header_lines	= E_HeaderLines->text().toInt();
	Cmds2GetLst	= E_CmdsToGetList->text().stripWhiteSpace();
	Cmds2LogOff	= E_CmdsToLogOff->text().stripWhiteSpace();
	SysopName	= E_Name->text().stripWhiteSpace();
	Email		= E_email->text().stripWhiteSpace();
	QuotePref	= E_Quote->text().stripWhiteSpace();
	SID		= E_SID->text().stripWhiteSpace();
	RePref		= E_SR->text().stripWhiteSpace();
	HierAddr	= E_HAddr->text().stripWhiteSpace();
	BBSprompt	= E_Prompt->text().stripWhiteSpace();
	Altprompt	= E_AltPrompt->text().stripWhiteSpace();
	
	PersSigLines.clear();
	PersSigLines.append( T_PersSig->text() );
	BullSigLines.clear();
	BullSigLines.append( T_BullSig->text() );
	
	HTMLV		= E_HTMLViewer->text().stripWhiteSpace();
	HTMLE		= E_HTMLEditor->text().stripWhiteSpace();
	ExtEd		= E_ExtEditor->text().stripWhiteSpace();
	ExtAd		= E_Addon->text().stripWhiteSpace();
	// 
	AutoSig		= Chb_AddSig->isChecked(  );
	Killmymsg	= Chb_KillMy->isChecked(  );
	Disconn		= Chb_disc->isChecked(  );
	AgeExpire	= Chb_ExpDays->isChecked(  );
	AgeExpireDays	= E_ExpDays->text().toInt();
	NrExpire	= Chb_ExpNr->isChecked(  );
	NumberExpire	= E_ExpNr->text().toInt();
	ShowHeaders	= Chb_HeaderLines->isChecked(  );
	WordWrapNr	= E_WordWrap->text().toInt();
	WordWrap	= Chb_WordWrap->isChecked(  );
}


void TConfig::CancelBtn()
{
	ConfigW->hide();
}


void TConfig::showEvent( QShowEvent * e )
{
	if ( ! e->spontaneous ()  )
	{
		QFont fi;
		QColor color; //(MsgList->paletteBackgroundColor());
  
  
		fi.setFamily(FormAttrsTb[8].FontAttrs.Name);
		fi.setPointSize(FormAttrsTb[8].FontAttrs.Size);
  
		fi.setFixedPitch(FormAttrsTb[8].FontAttrs.Pitch);
		fi.setBold(FormAttrsTb[8].FontAttrs.Bold);
		fi.setItalic(FormAttrsTb[8].FontAttrs.Italic);
		//ConfigW->setFont( fi );
  
		color.setNamedColor(FormAttrsTb[8].FormAttrs.Color);
		ConfigW->setPaletteBackgroundColor(color);
		ConfigW->setPaletteForegroundColor (FormAttrsTb[8].FontAttrs.Color); // Font Color
  
		move( FormAttrsTb[8].FormAttrs.x, FormAttrsTb[8].FormAttrs.y );
		resize( FormAttrsTb[8].FormAttrs.width, FormAttrsTb[8].FormAttrs.height );
	
		E_Port->setText( port );
		E_MyCall->setText( mycall );
		E_BBS->setText( bbs );
		E_Path->setText( digi );
		E_HeaderLines->setText( QString::number(header_lines) );
		E_CmdsToGetList->setText( Cmds2GetLst );
		E_CmdsToLogOff->setText( Cmds2LogOff );
		E_Name->setText( SysopName );
		E_email->setText( Email );
		E_Quote->setText( QuotePref );
		E_SID->setText( SID );
		E_SR->setText( RePref );
		E_HAddr->setText( HierAddr );
		E_Prompt->setText( BBSprompt );
		E_AltPrompt->setText( Altprompt );
		T_PersSig->setText( PersSigLines.join( "\n") );
		T_BullSig->setText( BullSigLines.join( "\n") );
		E_HTMLViewer->setText( HTMLV );
		E_HTMLEditor->setText( HTMLE );
		E_ExtEditor->setText( ExtEd );
		E_Addon->setText( ExtAd );
		// 
		Chb_AddSig->setChecked( AutoSig );
		Chb_KillMy->setChecked( Killmymsg );
		Chb_disc->setChecked( Disconn );
		Chb_ExpDays->setChecked( AgeExpire );
		E_ExpDays->setText( QString::number( AgeExpireDays ));
		Chb_ExpNr->setChecked( NrExpire );
		E_ExpNr->setText( QString::number( NumberExpire ));
		Chb_HeaderLines->setChecked( ShowHeaders );
		E_WordWrap->setText( QString::number( WordWrapNr ) );
		Chb_WordWrap->setChecked( WordWrap );

	}

}


void TConfig::hideEvent( QHideEvent * e )
{
	if ( ! e->spontaneous ()  )    UpdateFormAttrs();
}


void TConfig::UpdateFormAttrs()
{
	QFontInfo fi (ConfigW->font());
	QColor font_color(ConfigW->foregroundColor());
	QColor background(ConfigW->paletteBackgroundColor());
  
	FormAttrsTb[1].FontAttrs.Name      =  fi.family();
	FormAttrsTb[1].FontAttrs.Size      =  fi.pointSize();
  
	FormAttrsTb[1].FontAttrs.Color     =  font_color.name();
	FormAttrsTb[1].FontAttrs.Pitch     =  fi.fixedPitch();
	FormAttrsTb[1].FontAttrs.Bold      =  fi.bold();
	FormAttrsTb[1].FontAttrs.Italic    =  fi.italic();
  
	FormAttrsTb[1].FormAttrs.Color  =  ConfigW->paletteBackgroundColor().name();
	FormAttrsTb[1].FormAttrs.x      =  ConfigW->x();
	FormAttrsTb[1].FormAttrs.y      =  ConfigW->y();
	FormAttrsTb[1].FormAttrs.height =  ConfigW->height();
	FormAttrsTb[1].FormAttrs.width  =  ConfigW->width();

}


QString TConfig::SelectFile()
{
	QString s = QFileDialog::getOpenFileName(
			PrgPath, "All files (*)",this,"Select file dialog", "Choose a progrm " );

	return s;
}
