###
# Copyright (c) 2014-2015, James Lu
# Copyright (c) 2020-2021, The Limnoria Contributors
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   * Redistributions of source code must retain the above copyright notice,
#     this list of conditions, and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright notice,
#     this list of conditions, and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the author of this software nor the name of
#     contributors to this software may be used to endorse or promote products
#     derived from this software without specific prior written consent.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

###

import supybot.conf as conf
import supybot.registry as registry
try:
    from supybot.i18n import PluginInternationalization
    _ = PluginInternationalization('DDG')
except:
    # Placeholder that allows to run the plugin on a bot
    # without the i18n module
    _ = lambda x: x


def configure(advanced):
    # This will be called by supybot to configure this module.  advanced is
    # a bool that specifies whether the user identified themself as an advanced
    # user or not.  You should effect your configuration by manipulating the
    # registry as appropriate.
    from supybot.questions import expect, anything, something, yn
    conf.registerPlugin('DDG', True)

class SafeSearch(registry.OnlySomeStrings):
    validStrings = ['active', 'moderate', 'off']

DDG = conf.registerPlugin('DDG')
conf.registerChannelValue(DDG, 'maxResults',
    registry.PositiveInteger(4, _("""Determines the maximum number of
    results the bot will respond with.""")))
conf.registerChannelValue(DDG, 'showSnippet',
    registry.Boolean(True, _("""Determines whether the bot will show a
    snippet of each resulting link. If False, it will show the title
    of the link instead.""")))
conf.registerChannelValue(DDG, 'region',
    registry.String("", _("""Set the DDG search region to return results
    for the language/country of your choice. E.g. 'us-en' for United States.
    https://duckduckgo.com/params""")))
conf.registerChannelValue(DDG, 'searchFilter',
    SafeSearch('moderate', _("""Determines what level of search filtering to use
    by default.  'active' - most filtering, 'moderate' - default filtering,
    'off' - no filtering""")))

# vim:set shiftwidth=4 tabstop=4 expandtab textwidth=79:

