/**
@file	LMS7002M_parameters.cpp
@author Lime Microsystems (www.limemicro.com)
@brief 	Definition of LMS7002M transceiver control parameters registers
*/

#include "LMS7002M_parameters.h"

#include <vector>

int LMS7ParameterCompare(LMS7Parameter a, LMS7Parameter b)
{
    if (a.address == b.address && a.msb == b.msb && a.lsb == b.lsb)
        return 0;
    return -1;
}

std::vector<const LMS7Parameter*> LMS7parameterList =
{
&LMS7_LRST_TX_B,
&LMS7_MRST_TX_B,
&LMS7_LRST_TX_A,
&LMS7_MRST_TX_A,
&LMS7_LRST_RX_B,
&LMS7_MRST_RX_B,
&LMS7_LRST_RX_A,
&LMS7_MRST_RX_A,
&LMS7_SRST_RXFIFO,
&LMS7_SRST_TXFIFO,
&LMS7_RXEN_B,
&LMS7_RXEN_A,
&LMS7_TXEN_B,
&LMS7_TXEN_A,
&LMS7_MAC,
&LMS7_TX_CLK_PE,
&LMS7_RX_CLK_PE,
&LMS7_SDA_PE,
&LMS7_SDA_DS,
&LMS7_SCL_PE,
&LMS7_SCL_DS,
&LMS7_SDIO_DS,
&LMS7_SDIO_PE,
&LMS7_SDO_PE,
&LMS7_SCLK_PE,
&LMS7_SEN_PE,
&LMS7_SPIMODE,
&LMS7_DIQ2_DS,
&LMS7_DIQ2_PE,
&LMS7_IQ_SEL_EN_2_PE,
&LMS7_TXNRX2_PE,
&LMS7_FCLK2_PE,
&LMS7_MCLK2_PE,
&LMS7_DIQ1_DS,
&LMS7_DIQ1_PE,
&LMS7_IQ_SEL_EN_1_PE,
&LMS7_TXNRX1_PE,
&LMS7_FCLK1_PE,
&LMS7_MCLK1_PE,
&LMS7_DIQDIRCTR2,
&LMS7_DIQDIR2,
&LMS7_DIQDIRCTR1,
&LMS7_DIQDIR1,
&LMS7_ENABLEDIRCTR2,
&LMS7_ENABLEDIR2,
&LMS7_ENABLEDIRCTR1,
&LMS7_ENABLEDIR1,
&LMS7_MOD_EN,
&LMS7_LML2_FIDM,
&LMS7_LML2_TXNRXIQ,
&LMS7_LML2_MODE,
&LMS7_LML1_FIDM,
&LMS7_LML1_TXNRXIQ,
&LMS7_LML1_MODE,
&LMS7_LML1_S3S,
&LMS7_LML1_S2S,
&LMS7_LML1_S1S,
&LMS7_LML1_S0S,
&LMS7_LML1_BQP,
&LMS7_LML1_BIP,
&LMS7_LML1_AQP,
&LMS7_LML1_AIP,
&LMS7_LML1_BB2RF_PST,
&LMS7_LML1_BB2RF_PRE,
&LMS7_LML1_RF2BB_PST,
&LMS7_LML1_RF2BB_PRE,
&LMS7_LML2_S3S,
&LMS7_LML2_S2S,
&LMS7_LML2_S1S,
&LMS7_LML2_S0S,
&LMS7_LML2_BQP,
&LMS7_LML2_BIP,
&LMS7_LML2_AQP,
&LMS7_LML2_AIP,
&LMS7_LML2_BB2RF_PST,
&LMS7_LML2_BB2RF_PRE,
&LMS7_LML2_RF2BB_PST,
&LMS7_LML2_RF2BB_PRE,
&LMS7_FCLK2_DLY,
&LMS7_FCLK1_DLY,
&LMS7_RX_MUX,
&LMS7_TX_MUX,
&LMS7_TXRDCLK_MUX,
&LMS7_TXWRCLK_MUX,
&LMS7_RXRDCLK_MUX,
&LMS7_RXWRCLK_MUX,
&LMS7_FCLK2_INV,
&LMS7_FCLK1_INV,
&LMS7_MCLK2DLY,
&LMS7_MCLK1DLY,
&LMS7_MCLK2SRC,
&LMS7_MCLK1SRC,
&LMS7_TXDIVEN,
&LMS7_RXDIVEN,
&LMS7_TXTSPCLKA_DIV,
&LMS7_RXTSPCLKA_DIV,
&LMS7_MIMO_SISO,
&LMS7_VER,
&LMS7_REV,
&LMS7_MASK,
&LMS7_EN_DIR_LDO,
&LMS7_EN_DIR_CGEN,
&LMS7_EN_DIR_XBUF,
&LMS7_EN_DIR_AFE,
&LMS7_ISEL_DAC_AFE,
&LMS7_MODE_INTERLEAVE_AFE,
&LMS7_MUX_AFE_1,
&LMS7_MUX_AFE_2,
&LMS7_PD_AFE,
&LMS7_PD_RX_AFE1,
&LMS7_PD_RX_AFE2,
&LMS7_PD_TX_AFE1,
&LMS7_PD_TX_AFE2,
&LMS7_EN_G_AFE,
&LMS7_MUX_BIAS_OUT,
&LMS7_RP_CALIB_BIAS,
&LMS7_PD_FRP_BIAS,
&LMS7_PD_F_BIAS,
&LMS7_PD_PTRP_BIAS,
&LMS7_PD_PT_BIAS,
&LMS7_PD_BIAS_MASTER,
&LMS7_SLFB_XBUF_RX,
&LMS7_SLFB_XBUF_TX,
&LMS7_BYP_XBUF_RX,
&LMS7_BYP_XBUF_TX,
&LMS7_EN_OUT2_XBUF_TX,
&LMS7_EN_TBUFIN_XBUF_RX,
&LMS7_PD_XBUF_RX,
&LMS7_PD_XBUF_TX,
&LMS7_EN_G_XBUF,
&LMS7_SPDUP_VCO_CGEN,
&LMS7_RESET_N_CGEN,
&LMS7_EN_ADCCLKH_CLKGN,
&LMS7_EN_COARSE_CKLGEN,
&LMS7_EN_INTONLY_SDM_CGEN,
&LMS7_EN_SDM_CLK_CGEN,
&LMS7_PD_CP_CGEN,
&LMS7_PD_FDIV_FB_CGEN,
&LMS7_PD_FDIV_O_CGEN,
&LMS7_PD_SDM_CGEN,
&LMS7_PD_VCO_CGEN,
&LMS7_PD_VCO_COMP_CGEN,
&LMS7_EN_G_CGEN,
&LMS7_FRAC_SDM_CGEN_LSB,
&LMS7_INT_SDM_CGEN,
&LMS7_FRAC_SDM_CGEN_MSB,
&LMS7_REV_SDMCLK_CGEN,
&LMS7_SEL_SDMCLK_CGEN,
&LMS7_SX_DITHER_EN_CGEN,
&LMS7_CLKH_OV_CLKL_CGEN,
&LMS7_DIV_OUTCH_CGEN,
&LMS7_TST_CGEN,
&LMS7_REV_CLKDAC_CGEN,
&LMS7_CMPLO_CTRL_CGEN,
&LMS7_REV_CLKADC_CGEN,
&LMS7_REVPH_PFD_CGEN,
&LMS7_IOFFSET_CP_CGEN,
&LMS7_IPULSE_CP_CGEN,
&LMS7_ICT_VCO_CGEN,
&LMS7_CSW_VCO_CGEN,
&LMS7_COARSE_START_CGEN,
&LMS7_COARSE_STEPDONE_CGEN,
&LMS7_COARSEPLL_COMPO_CGEN,
&LMS7_VCO_CMPHO_CGEN,
&LMS7_VCO_CMPLO_CGEN,
&LMS7_CP2_CGEN,
&LMS7_CP3_CGEN,
&LMS7_CZ_CGEN,
&LMS7_EN_LDO_DIG,
&LMS7_EN_LDO_DIGGN,
&LMS7_EN_LDO_DIGSXR,
&LMS7_EN_LDO_DIGSXT,
&LMS7_EN_LDO_DIVGN,
&LMS7_EN_LDO_DIVSXR,
&LMS7_EN_LDO_DIVSXT,
&LMS7_EN_LDO_LNA12,
&LMS7_EN_LDO_LNA14,
&LMS7_EN_LDO_MXRFE,
&LMS7_EN_LDO_RBB,
&LMS7_EN_LDO_RXBUF,
&LMS7_EN_LDO_TBB,
&LMS7_EN_LDO_TIA12,
&LMS7_EN_LDO_TIA14,
&LMS7_EN_G_LDO,
&LMS7_EN_LOADIMP_LDO_TLOB,
&LMS7_EN_LOADIMP_LDO_TPAD,
&LMS7_EN_LOADIMP_LDO_TXBUF,
&LMS7_EN_LOADIMP_LDO_VCOGN,
&LMS7_EN_LOADIMP_LDO_VCOSXR,
&LMS7_EN_LOADIMP_LDO_VCOSXT,
&LMS7_EN_LDO_AFE,
&LMS7_EN_LDO_CPGN,
&LMS7_EN_LDO_CPSXR,
&LMS7_EN_LDO_TLOB,
&LMS7_EN_LDO_TPAD,
&LMS7_EN_LDO_TXBUF,
&LMS7_EN_LDO_VCOGN,
&LMS7_EN_LDO_VCOSXR,
&LMS7_EN_LDO_VCOSXT,
&LMS7_EN_LDO_CPSXT,
&LMS7_EN_LOADIMP_LDO_CPSXT,
&LMS7_EN_LOADIMP_LDO_DIG,
&LMS7_EN_LOADIMP_LDO_DIGGN,
&LMS7_EN_LOADIMP_LDO_DIGSXR,
&LMS7_EN_LOADIMP_LDO_DIGSXT,
&LMS7_EN_LOADIMP_LDO_DIVGN,
&LMS7_EN_LOADIMP_LDO_DIVSXR,
&LMS7_EN_LOADIMP_LDO_DIVSXT,
&LMS7_EN_LOADIMP_LDO_LNA12,
&LMS7_EN_LOADIMP_LDO_LNA14,
&LMS7_EN_LOADIMP_LDO_MXRFE,
&LMS7_EN_LOADIMP_LDO_RBB,
&LMS7_EN_LOADIMP_LDO_RXBUF,
&LMS7_EN_LOADIMP_LDO_TBB,
&LMS7_EN_LOADIMP_LDO_TIA12,
&LMS7_EN_LOADIMP_LDO_TIA14,
&LMS7_BYP_LDO_TBB,
&LMS7_BYP_LDO_TIA12,
&LMS7_BYP_LDO_TIA14,
&LMS7_BYP_LDO_TLOB,
&LMS7_BYP_LDO_TPAD,
&LMS7_BYP_LDO_TXBUF,
&LMS7_BYP_LDO_VCOGN,
&LMS7_BYP_LDO_VCOSXR,
&LMS7_BYP_LDO_VCOSXT,
&LMS7_EN_LOADIMP_LDO_AFE,
&LMS7_EN_LOADIMP_LDO_CPGN,
&LMS7_EN_LOADIMP_LDO_CPSXR,
&LMS7_BYP_LDO_AFE,
&LMS7_BYP_LDO_CPGN,
&LMS7_BYP_LDO_CPSXR,
&LMS7_BYP_LDO_CPSXT,
&LMS7_BYP_LDO_DIG,
&LMS7_BYP_LDO_DIGGN,
&LMS7_BYP_LDO_DIGSXR,
&LMS7_BYP_LDO_DIGSXT,
&LMS7_BYP_LDO_DIVGN,
&LMS7_BYP_LDO_DIVSXR,
&LMS7_BYP_LDO_DIVSXT,
&LMS7_BYP_LDO_LNA12,
&LMS7_BYP_LDO_LNA14,
&LMS7_BYP_LDO_MXRFE,
&LMS7_BYP_LDO_RBB,
&LMS7_BYP_LDO_RXBUF,
&LMS7_SPDUP_LDO_DIVSXR,
&LMS7_SPDUP_LDO_DIVSXT,
&LMS7_SPDUP_LDO_LNA12,
&LMS7_SPDUP_LDO_LNA14,
&LMS7_SPDUP_LDO_MXRFE,
&LMS7_SPDUP_LDO_RBB,
&LMS7_SPDUP_LDO_RXBUF,
&LMS7_SPDUP_LDO_TBB,
&LMS7_SPDUP_LDO_TIA12,
&LMS7_SPDUP_LDO_TIA14,
&LMS7_SPDUP_LDO_TLOB,
&LMS7_SPDUP_LDO_TPAD,
&LMS7_SPDUP_LDO_TXBUF,
&LMS7_SPDUP_LDO_VCOGN,
&LMS7_SPDUP_LDO_VCOSXR,
&LMS7_SPDUP_LDO_VCOSXT,
&LMS7_SPDUP_LDO_AFE,
&LMS7_SPDUP_LDO_CPGN,
&LMS7_SPDUP_LDO_CPSXR,
&LMS7_SPDUP_LDO_CPSXT,
&LMS7_SPDUP_LDO_DIG,
&LMS7_SPDUP_LDO_DIGGN,
&LMS7_SPDUP_LDO_DIGSXR,
&LMS7_SPDUP_LDO_DIGSXT,
&LMS7_SPDUP_LDO_DIVGN,
&LMS7_RDIV_VCOSXR,
&LMS7_RDIV_VCOSXT,
&LMS7_RDIV_TXBUF,
&LMS7_RDIV_VCOGN,
&LMS7_RDIV_TLOB,
&LMS7_RDIV_TPAD,
&LMS7_RDIV_TIA12,
&LMS7_RDIV_TIA14,
&LMS7_RDIV_RXBUF,
&LMS7_RDIV_TBB,
&LMS7_RDIV_MXRFE,
&LMS7_RDIV_RBB,
&LMS7_RDIV_LNA12,
&LMS7_RDIV_LNA14,
&LMS7_RDIV_DIVSXR,
&LMS7_RDIV_DIVSXT,
&LMS7_RDIV_DIGSXT,
&LMS7_RDIV_DIVGN,
&LMS7_RDIV_DIGGN,
&LMS7_RDIV_DIGSXR,
&LMS7_RDIV_CPSXT,
&LMS7_RDIV_DIG,
&LMS7_RDIV_CPGN,
&LMS7_RDIV_CPSXR,
&LMS7_RDIV_SPIBUF,
&LMS7_RDIV_AFE,
&LMS7_SPDUP_LDO_SPIBUF,
&LMS7_SPDUP_LDO_DIGIp2,
&LMS7_SPDUP_LDO_DIGIp1,
&LMS7_BYP_LDO_SPIBUF,
&LMS7_BYP_LDO_DIGIp2,
&LMS7_BYP_LDO_DIGIp1,
&LMS7_EN_LOADIMP_LDO_SPIBUF,
&LMS7_EN_LOADIMP_LDO_DIGIp2,
&LMS7_EN_LOADIMP_LDO_DIGIp1,
&LMS7_PD_LDO_SPIBUF,
&LMS7_PD_LDO_DIGIp2,
&LMS7_PD_LDO_DIGIp1,
&LMS7_EN_G_LDOP,
&LMS7_RDIV_DIGIp2,
&LMS7_RDIV_DIGIp1,
&LMS7_BSIGT,
&LMS7_BSTATE,
&LMS7_EN_SDM_TSTO_SXT,
&LMS7_EN_SDM_TSTO_SXR,
&LMS7_EN_SDM_TSTO_CGEN,
&LMS7_BENC,
&LMS7_BENR,
&LMS7_BENT,
&LMS7_BSTART,
&LMS7_BSIGR,
&LMS7_BSIGC,
&LMS7_CDS_MCLK2,
&LMS7_CDS_MCLK1,
&LMS7_CDSN_TXBTSP,
&LMS7_CDSN_TXATSP,
&LMS7_CDSN_RXBTSP,
&LMS7_CDSN_RXATSP,
&LMS7_CDSN_TXBLML,
&LMS7_CDSN_TXALML,
&LMS7_CDSN_RXBLML,
&LMS7_CDSN_RXALML,
&LMS7_CDSN_MCLK2,
&LMS7_CDSN_MCLK1,
&LMS7_CDS_TXBTSP,
&LMS7_CDS_TXATSP,
&LMS7_CDS_RXBTSP,
&LMS7_CDS_RXATSP,
&LMS7_CDS_TXBLML,
&LMS7_CDS_TXALML,
&LMS7_CDS_RXBLML,
&LMS7_CDS_RXALML,
&LMS7_EN_LOWBWLOMX_TMX_TRF,
&LMS7_EN_NEXTTX_TRF,
&LMS7_EN_AMPHF_PDET_TRF,
&LMS7_LOADR_PDET_TRF,
&LMS7_PD_PDET_TRF,
&LMS7_PD_TLOBUF_TRF,
&LMS7_PD_TXPAD_TRF,
&LMS7_EN_G_TRF,
&LMS7_F_TXPAD_TRF,
&LMS7_L_LOOPB_TXPAD_TRF,
&LMS7_LOSS_LIN_TXPAD_TRF,
&LMS7_LOSS_MAIN_TXPAD_TRF,
&LMS7_EN_LOOPB_TXPAD_TRF,
&LMS7_GCAS_GNDREF_TXPAD_TRF,
&LMS7_ICT_LIN_TXPAD_TRF,
&LMS7_ICT_MAIN_TXPAD_TRF,
&LMS7_VGCAS_TXPAD_TRF,
&LMS7_SEL_BAND1_TRF,
&LMS7_SEL_BAND2_TRF,
&LMS7_LOBIASN_TXM_TRF,
&LMS7_LOBIASP_TXX_TRF,
&LMS7_CDC_I_TRF,
&LMS7_CDC_Q_TRF,
&LMS7_STATPULSE_TBB,
&LMS7_LOOPB_TBB,
&LMS7_PD_LPFH_TBB,
&LMS7_PD_LPFIAMP_TBB,
&LMS7_PD_LPFLAD_TBB,
&LMS7_PD_LPFS5_TBB,
&LMS7_EN_G_TBB,
&LMS7_ICT_LPFS5_F_TBB,
&LMS7_ICT_LPFS5_PT_TBB,
&LMS7_ICT_LPF_H_PT_TBB,
&LMS7_ICT_LPFH_F_TBB,
&LMS7_ICT_LPFLAD_F_TBB,
&LMS7_ICT_LPFLAD_PT_TBB,
&LMS7_CG_IAMP_TBB,
&LMS7_ICT_IAMP_FRP_TBB,
&LMS7_ICT_IAMP_GG_FRP_TBB,
&LMS7_RCAL_LPFH_TBB,
&LMS7_RCAL_LPFLAD_TBB,
&LMS7_TSTIN_TBB,
&LMS7_BYPLADDER_TBB,
&LMS7_CCAL_LPFLAD_TBB,
&LMS7_RCAL_LPFS5_TBB,
&LMS7_CDC_I_RFE,
&LMS7_CDC_Q_RFE,
&LMS7_PD_LNA_RFE,
&LMS7_PD_RLOOPB_1_RFE,
&LMS7_PD_RLOOPB_2_RFE,
&LMS7_PD_MXLOBUF_RFE,
&LMS7_PD_QGEN_RFE,
&LMS7_PD_RSSI_RFE,
&LMS7_PD_TIA_RFE,
&LMS7_EN_G_RFE,
&LMS7_SEL_PATH_RFE,
&LMS7_EN_DCOFF_RXFE_RFE,
&LMS7_EN_INSHSW_LB1_RFE,
&LMS7_EN_INSHSW_LB2_RFE,
&LMS7_EN_INSHSW_L_RFE,
&LMS7_EN_INSHSW_W_RFE,
&LMS7_EN_NEXTRX_RFE,
&LMS7_DCOFFI_RFE,
&LMS7_DCOFFQ_RFE,
&LMS7_ICT_LOOPB_RFE,
&LMS7_ICT_TIAMAIN_RFE,
&LMS7_ICT_TIAOUT_RFE,
&LMS7_ICT_LNACMO_RFE,
&LMS7_ICT_LNA_RFE,
&LMS7_ICT_LODC_RFE,
&LMS7_CAP_RXMXO_RFE,
&LMS7_CGSIN_LNA_RFE,
&LMS7_CCOMP_TIA_RFE,
&LMS7_CFB_TIA_RFE,
&LMS7_G_LNA_RFE,
&LMS7_G_RXLOOPB_RFE,
&LMS7_G_TIA_RFE,
&LMS7_RCOMP_TIA_RFE,
&LMS7_RFB_TIA_RFE,
&LMS7_EN_LB_LPFH_RBB,
&LMS7_EN_LB_LPFL_RBB,
&LMS7_PD_LPFH_RBB,
&LMS7_PD_LPFL_RBB,
&LMS7_PD_PGA_RBB,
&LMS7_EN_G_RBB,
&LMS7_R_CTL_LPF_RBB,
&LMS7_RCC_CTL_LPFH_RBB,
&LMS7_C_CTL_LPFH_RBB,
&LMS7_RCC_CTL_LPFL_RBB,
&LMS7_C_CTL_LPFL_RBB,
&LMS7_INPUT_CTL_PGA_RBB,
&LMS7_ICT_LPF_IN_RBB,
&LMS7_ICT_LPF_OUT_RBB,
&LMS7_OSW_PGA_RBB,
&LMS7_ICT_PGA_OUT_RBB,
&LMS7_ICT_PGA_IN_RBB,
&LMS7_G_PGA_RBB,
&LMS7_RCC_CTL_PGA_RBB,
&LMS7_C_CTL_PGA_RBB,
&LMS7_RESET_N,
&LMS7_SPDUP_VCO,
&LMS7_BYPLDO_VCO,
&LMS7_EN_COARSEPLL,
&LMS7_CURLIM_VCO,
&LMS7_EN_DIV2_DIVPROG,
&LMS7_EN_INTONLY_SDM,
&LMS7_EN_SDM_CLK,
&LMS7_PD_FBDIV,
&LMS7_PD_LOCH_T2RBUF,
&LMS7_PD_CP,
&LMS7_PD_FDIV,
&LMS7_PD_SDM,
&LMS7_PD_VCO_COMP,
&LMS7_PD_VCO,
&LMS7_EN_G,
&LMS7_FRAC_SDM_LSB,
&LMS7_INT_SDM,
&LMS7_FRAC_SDM_MSB,
&LMS7_PW_DIV2_LOCH,
&LMS7_PW_DIV4_LOCH,
&LMS7_DIV_LOCH,
&LMS7_TST_SX,
&LMS7_SEL_SDMCLK,
&LMS7_SX_DITHER_EN,
&LMS7_REV_SDMCLK,
&LMS7_VDIV_VCO,
&LMS7_ICT_VCO,
&LMS7_RSEL_LDO_VCO,
&LMS7_CSW_VCO,
&LMS7_SEL_VCO,
&LMS7_COARSE_START,
&LMS7_REVPH_PFD,
&LMS7_IOFFSET_CP,
&LMS7_IPULSE_CP,
&LMS7_COARSE_STEPDONE,
&LMS7_COARSEPLL_COMPO,
&LMS7_VCO_CMPHO,
&LMS7_VCO_CMPLO,
&LMS7_CP2_PLL,
&LMS7_CP3_PLL,
&LMS7_CZ,
&LMS7_EN_DIR_SXRSXT,
&LMS7_EN_DIR_RBB,
&LMS7_EN_DIR_RFE,
&LMS7_EN_DIR_TBB,
&LMS7_EN_DIR_TRF,
&LMS7_TSGFC_TXTSP,
&LMS7_TSGFCW_TXTSP,
&LMS7_TSGDCLDQ_TXTSP,
&LMS7_TSGDCLDI_TXTSP,
&LMS7_TSGSWAPIQ_TXTSP,
&LMS7_TSGMODE_TXTSP,
&LMS7_INSEL_TXTSP,
&LMS7_BSTART_TXTSP,
&LMS7_EN_TXTSP,
&LMS7_GCORRQ_TXTSP,
&LMS7_GCORRI_TXTSP,
&LMS7_HBI_OVR_TXTSP,
&LMS7_IQCORR_TXTSP,
&LMS7_DCCORRI_TXTSP,
&LMS7_DCCORRQ_TXTSP,
&LMS7_GFIR1_L_TXTSP,
&LMS7_GFIR1_N_TXTSP,
&LMS7_GFIR2_L_TXTSP,
&LMS7_GFIR2_N_TXTSP,
&LMS7_GFIR3_L_TXTSP,
&LMS7_GFIR3_N_TXTSP,
&LMS7_CMIX_GAIN_TXTSP,
&LMS7_CMIX_SC_TXTSP,
&LMS7_CMIX_BYP_TXTSP,
&LMS7_ISINC_BYP_TXTSP,
&LMS7_GFIR3_BYP_TXTSP,
&LMS7_GFIR2_BYP_TXTSP,
&LMS7_GFIR1_BYP_TXTSP,
&LMS7_DC_BYP_TXTSP,
&LMS7_GC_BYP_TXTSP,
&LMS7_PH_BYP_TXTSP,
&LMS7_BSIGI_TXTSP,
&LMS7_BSTATE_TXTSP,
&LMS7_BSIGQ_TXTSP,
&LMS7_DC_REG_TXTSP,
&LMS7_DTHBIT_TX,
&LMS7_SEL_TX,
&LMS7_MODE_TX,
&LMS7_CAPTURE,
&LMS7_CAPSEL,
&LMS7_CAPSEL_ADC,
&LMS7_TSGFC_RXTSP,
&LMS7_TSGFCW_RXTSP,
&LMS7_TSGDCLDQ_RXTSP,
&LMS7_TSGDCLDI_RXTSP,
&LMS7_TSGSWAPIQ_RXTSP,
&LMS7_TSGMODE_RXTSP,
&LMS7_INSEL_RXTSP,
&LMS7_BSTART_RXTSP,
&LMS7_EN_RXTSP,
&LMS7_GCORRQ_RXTSP,
&LMS7_GCORRI_RXTSP,
&LMS7_HBD_OVR_RXTSP,
&LMS7_IQCORR_RXTSP,
&LMS7_HBD_DLY,
&LMS7_DCCORR_AVG_RXTSP,
&LMS7_GFIR1_L_RXTSP,
&LMS7_GFIR1_N_RXTSP,
&LMS7_GFIR2_L_RXTSP,
&LMS7_GFIR2_N_RXTSP,
&LMS7_GFIR3_L_RXTSP,
&LMS7_GFIR3_N_RXTSP,
&LMS7_AGC_K_RXTSP,
&LMS7_AGC_ADESIRED_RXTSP,
&LMS7_RSSI_MODE,
&LMS7_AGC_MODE_RXTSP,
&LMS7_AGC_AVG_RXTSP,
&LMS7_DC_REG_RXTSP,
&LMS7_CMIX_GAIN_RXTSP,
&LMS7_CMIX_SC_RXTSP,
&LMS7_CMIX_BYP_RXTSP,
&LMS7_AGC_BYP_RXTSP,
&LMS7_GFIR3_BYP_RXTSP,
&LMS7_GFIR2_BYP_RXTSP,
&LMS7_GFIR1_BYP_RXTSP,
&LMS7_DC_BYP_RXTSP,
&LMS7_GC_BYP_RXTSP,
&LMS7_PH_BYP_RXTSP,
&LMS7_CAPD,
&LMS7_DTHBIT_RX,
&LMS7_SEL_RX,
&LMS7_MODE_RX,
&LMS7_TRX_GAIN_SRC,
&LMS7_DCMODE,
&LMS7_PD_DCDAC_RXB,
&LMS7_PD_DCDAC_RXA,
&LMS7_PD_DCDAC_TXB,
&LMS7_PD_DCDAC_TXA,
&LMS7_PD_DCCMP_RXB,
&LMS7_PD_DCCMP_RXA,
&LMS7_PD_DCCMP_TXB,
&LMS7_PD_DCCMP_TXA,
&LMS7_DCCAL_CALSTATUS_RXBQ,
&LMS7_DCCAL_CALSTATUS_RXBI,
&LMS7_DCCAL_CALSTATUS_RXAQ,
&LMS7_DCCAL_CALSTATUS_RXAI,
&LMS7_DCCAL_CALSTATUS_TXBQ,
&LMS7_DCCAL_CALSTATUS_TXBI,
&LMS7_DCCAL_CALSTATUS_TXAQ,
&LMS7_DCCAL_CALSTATUS_TXAI,
&LMS7_DCCAL_CMPSTATUS_RXBQ,
&LMS7_DCCAL_CMPSTATUS_RXBI,
&LMS7_DCCAL_CMPSTATUS_RXAQ,
&LMS7_DCCAL_CMPSTATUS_RXAI,
&LMS7_DCCAL_CMPSTATUS_TXBQ,
&LMS7_DCCAL_CMPSTATUS_TXBI,
&LMS7_DCCAL_CMPSTATUS_TXAQ,
&LMS7_DCCAL_CMPSTATUS_TXAI,
&LMS7_DCCAL_CMPCFG_RXBQ,
&LMS7_DCCAL_CMPCFG_RXBI,
&LMS7_DCCAL_CMPCFG_RXAQ,
&LMS7_DCCAL_CMPCFG_RXAI,
&LMS7_DCCAL_CMPCFG_TXBQ,
&LMS7_DCCAL_CMPCFG_TXBI,
&LMS7_DCCAL_CMPCFG_TXAQ,
&LMS7_DCCAL_CMPCFG_TXAI,
&LMS7_DCCAL_START_RXBQ,
&LMS7_DCCAL_START_RXBI,
&LMS7_DCCAL_START_RXAQ,
&LMS7_DCCAL_START_RXAI,
&LMS7_DCCAL_START_TXBQ,
&LMS7_DCCAL_START_TXBI,
&LMS7_DCCAL_START_TXAQ,
&LMS7_DCCAL_START_TXAI,
&LMS7_DCWR_TXAI,
&LMS7_DCRD_TXAI,
&LMS7_DC_TXAI,
&LMS7_DCWR_TXAQ,
&LMS7_DCRD_TXAQ,
&LMS7_DC_TXAQ,
&LMS7_DCWR_TXBI,
&LMS7_DCRD_TXBI,
&LMS7_DC_TXBI,
&LMS7_DCWR_TXBQ,
&LMS7_DCRD_TXBQ,
&LMS7_DC_TXBQ,
&LMS7_DCWR_RXAI,
&LMS7_DCRD_RXAI,
&LMS7_DC_RXAI,
&LMS7_DCWR_RXAQ,
&LMS7_DCRD_RXAQ,
&LMS7_DC_RXAQ,
&LMS7_DCWR_RXBI,
&LMS7_DCRD_RXBI,
&LMS7_DC_RXBI,
&LMS7_DCWR_RXBQ,
&LMS7_DCRD_RXBQ,
&LMS7_DC_RXBQ,
&LMS7_DC_RXCDIV,
&LMS7_DC_TXCDIV,
&LMS7_HYSCMP_RXB,
&LMS7_HYSCMP_RXA,
&LMS7_HYSCMP_TXB,
&LMS7_HYSCMP_TXA,
&LMS7_DAC_CLKDIV,
&LMS7_RSSI_RSSIMODE,
&LMS7_RSSI_PD,
&LMS7_RSSI_BIAS,
&LMS7_RSSI_HYSCMP,
&LMS7_RSSI_DAC_VAL,
&LMS7_RSSI_PDET2_VAL,
&LMS7_RSSI_PDET1_VAL,
&LMS7_RSSI_RSSI2_VAL,
&LMS7_RSSI_RSSI1_VAL,
&LMS7_RSSI_TREF_VAL,
&LMS7_RSSI_TVPTAT_VAL,
&LMS7_RSSIDC_CMPSTATUS,
&LMS7_RSSIDC_RSEL,
&LMS7_RSSIDC_HYSCMP,
&LMS7_RSSIDC_PD,
&LMS7_RSSIDC_DCO2,
&LMS7_RSSIDC_DCO1,
&LMS7_LML2_TRXIQPULSE,
&LMS7_LML2_SISODDR,
&LMS7_LML1_TRXIQPULSE,
&LMS7_LML1_SISODDR,
&LMS7_MCLK2_DLY,
&LMS7_MCLK1_DLY,
&LMS7_MCLK2_INV,
&LMS7_MCLK1_INV,
&LMS7_CMIX_GAIN_TXTSP_R3,
&LMS7_CMIX_GAIN_RXTSP_R3,
&LMS7_R5_LPF_BYP_TBB,
&LMS7_CG_IAMP_TBB_R3,
&LMS7_LOSS_LIN_TXPAD_R3,
&LMS7_LOSS_MAIN_TXPAD_R3,
&LMS7_C_CTL_PGA_RBB_R3,
&LMS7_G_PGA_RBB_R3,
&LMS7_G_LNA_RFE_R3,
&LMS7_G_TIA_RFE_R3,
&LMS7_RZ_CTRL,
&LMS7_CMPLO_CTRL_SX,
&LMS7_CMPLO_CTRL_CGEN_R3,
&LMS7_ISINK_SPIBUFF,
&LMS7_DCMODE,
&LMS7_PD_DCDAC_RXB,
&LMS7_PD_DCDAC_RXA,
&LMS7_PD_DCDAC_TXB,
&LMS7_PD_DCDAC_TXA,
&LMS7_PD_DCCMP_RXB,
&LMS7_PD_DCCMP_RXA,
&LMS7_PD_DCCMP_TXB,
&LMS7_PD_DCCMP_TXA,
&LMS7_DCWR_TXAI,
&LMS7_DCRD_TXAI,
&LMS7_DC_TXAI,
&LMS7_DCWR_TXAQ,
&LMS7_DCRD_TXAQ,
&LMS7_DC_TXAQ,
&LMS7_DCWR_TXBI,
&LMS7_DCRD_TXBI,
&LMS7_DC_TXBI,
&LMS7_DCWR_TXBQ,
&LMS7_DCRD_TXBQ,
&LMS7_DC_TXBQ,
&LMS7_DCWR_RXAI,
&LMS7_DCRD_RXAI,
&LMS7_DC_RXAI,
&LMS7_DCWR_RXAQ,
&LMS7_DCRD_RXAQ,
&LMS7_DC_RXAQ,
&LMS7_DCWR_RXBI,
&LMS7_DCRD_RXBI,
&LMS7_DC_RXBI,
&LMS7_DCWR_RXBQ,
&LMS7_DCRD_RXBQ,
&LMS7_DC_RXBQ,
&LMS7_DC_RXCDIV,
&LMS7_DC_TXCDIV,
&LMS7_HYSCMP_RXB,
&LMS7_HYSCMP_RXA,
&LMS7_HYSCMP_TXB,
&LMS7_HYSCMP_TXA,
&LMS7_DAC_CLKDIV,
&LMS7_RSSI_RSSIMODE,
&LMS7_RSSI_PD,
&LMS7_INTADC_CMPSTATUS_TEMPREF,
&LMS7_INTADC_CMPSTATUS_TEMPVPTAT,
&LMS7_INTADC_CMPSTATUS_RSSI2,
&LMS7_INTADC_CMPSTATUS_RSSI1,
&LMS7_INTADC_CMPSTATUS_PDET2,
&LMS7_INTADC_CMPSTATUS_PDET1,
&LMS7_RSSI_BIAS,
&LMS7_RSSI_HYSCMP,
&LMS7_INTADC_CMPCFG_TEMPREF,
&LMS7_INTADC_CMPCFG_TEMPVPTAT,
&LMS7_INTADC_CMPCFG_RSSI2,
&LMS7_INTADC_CMPCFG_RSSI1,
&LMS7_INTADC_CMPCFG_PDET2,
&LMS7_INTADC_CMPCFG_PDET1,
&LMS7_RSSI_DAC_VAL,
&LMS7_RSSI_PDET2_VAL,
&LMS7_RSSI_PDET1_VAL,
&LMS7_RSSI_RSSI2_VAL,
&LMS7_RSSI_RSSI1_VAL,
&LMS7_RSSI_TREF_VAL,
&LMS7_RSSI_TVPTAT_VAL,
&LMS7_RSSIDC_CMPSTATUS,
&LMS7_RSSIDC_RSEL,
&LMS7_RSSIDC_HYSCMP,
&LMS7_RSSIDC_PD,
&LMS7_RSSIDC_DCO2,
&LMS7_RSSIDC_DCO1,
&LMS7_DCLOOP_STOP,
};
