/*
 *
 * *** NT status and Win32 error code definitions. ***
 *
 *   Some of these definitions were written from scratch, based
 *   on the following specification:
 * 
 *   NT status codes are unsigned 32-bit hex values
 *
 *   STATUS_MORE_ENTRIES is 0x00000105
 *
 *   Win32 error codes are unsigned 32-bit decimal values
 *   These definitions were written from scratch from the following specification:
 *
 *   ERROR_SUCCESS is 0, equivalent to STATUS_SUCCESS
 *   ERROR_MORE_DATA is 234, similar to STATUS_MORE_ENTRIES
 *   ERROR_INVALID_LEVEL is 124, similar to ??
 *   ERROR_NO_NETWORK is ???, similar to ???
 *   ERROR_ACCESS_DENIED is 5, similar to STATUS_ACCESS_DENIED
 *   ERROR_INVALID_PARAMETER is 86, similar to STATUS_INVALID_PARAMETER
 *   ERROR_NO_SUCH_ALIAS is 1376, similar to ???
 *   ERROR_INVALID_MEMBER is 1388, similar to ???
 *   ERROR_MEMBER_IN_ALIAS is 1378, similar to ???
 *   ERROR_NO_SUCH_MEMBER is 1387, similar to ???
 *   ERROR_MEMBER_NOT_IN_ALIAS is 1377, similar to ???
 *   ERROR_ALIAS_EXISTS is 1379, similar to ???
 *   NERR_InvalidComputer is ???, similar to ???
 *   NERR_NotPrimary is ???, similar to ???
 *   NERR_BadPassword is ???, similar to ???
 *   NERR_GroupNotFound is ???, similar to ???
 *   NERR_UserNotFound is ???, similar to ???
 *   NERR_PasswordTooShort is ???, similar to ???
 *   NERR_LastAdmin is ???, similar to ???
 *   NERR_SpeGroupOp is ???, similar to ???
 *   NERR_GroupExists is ???, similar to ???
 *   NERR_UserExists is ???, similar to ???
 *   NERR_BufTooSmall is ???, similar to ???
 */

#ifdef __ERROR_NTSTATUS__
#include <inttypes.h>
#include <rpc/types.h>

#define STATUS_MORE_ENTRIES ((NTSTATUS) 0x00000105)
#define STATUS_SOME_UNMAPPED ((NTSTATUS) 0x00000107)

/* NTSTATUS codes generated from WireShark packet dumps */
/* Known error codes in range 0-1024 */
#define STATUS_ABIOS_INVALID_COMMAND ((NTSTATUS) 0xc0000113)
#define STATUS_ABIOS_INVALID_LID ((NTSTATUS) 0xc0000114)
#define STATUS_ABIOS_INVALID_SELECTOR ((NTSTATUS) 0xc0000116)
#define STATUS_ABIOS_LID_ALREADY_OWNED ((NTSTATUS) 0xc0000111)
#define STATUS_ABIOS_LID_NOT_EXIST ((NTSTATUS) 0xc0000110)
#define STATUS_ABIOS_NOT_LID_OWNER ((NTSTATUS) 0xc0000112)
#define STATUS_ABIOS_NOT_PRESENT ((NTSTATUS) 0xc000010f)
#define STATUS_ABIOS_SELECTOR_NOT_AVAILABLE ((NTSTATUS) 0xc0000115)
#define STATUS_ACCESS_DENIED ((NTSTATUS) 0xc0000022)
#define STATUS_ACCESS_VIOLATION ((NTSTATUS) 0xc0000005)
#define STATUS_ACCOUNT_DISABLED ((NTSTATUS) 0xc0000072)
#define STATUS_ACCOUNT_EXPIRED ((NTSTATUS) 0xc0000193)
#define STATUS_ACCOUNT_LOCKED_OUT ((NTSTATUS) 0xc0000234)
#define STATUS_ACCOUNT_RESTRICTION ((NTSTATUS) 0xc000006e)
#define STATUS_ADAPTER_HARDWARE_ERROR ((NTSTATUS) 0xc00000c2)
#define STATUS_ADDRESS_ALREADY_ASSOCIATED ((NTSTATUS) 0xc0000238)
#define STATUS_ADDRESS_ALREADY_EXISTS ((NTSTATUS) 0xc000020a)
#define STATUS_ADDRESS_CLOSED ((NTSTATUS) 0xc000020b)
#define STATUS_ADDRESS_NOT_ASSOCIATED ((NTSTATUS) 0xc0000239)
#define STATUS_AGENTS_EXHAUSTED ((NTSTATUS) 0xc0000085)
#define STATUS_ALIAS_EXISTS ((NTSTATUS) 0xc0000154)
#define STATUS_ALLOCATE_BUCKET ((NTSTATUS) 0xc000022f)
#define STATUS_ALLOTTED_SPACE_EXCEEDED ((NTSTATUS) 0xc0000099)
#define STATUS_ALREADY_COMMITTED ((NTSTATUS) 0xc0000021)
#define STATUS_APP_INIT_FAILURE ((NTSTATUS) 0xc0000145)
#define STATUS_ARRAY_BOUNDS_EXCEEDED ((NTSTATUS) 0xc000008c)
#define STATUS_AUDIT_FAILED ((NTSTATUS) 0xc0000244)
#define STATUS_BACKUP_CONTROLLER ((NTSTATUS) 0xc0000187)
#define STATUS_BAD_COMPRESSION_BUFFER ((NTSTATUS) 0xc0000242)
#define STATUS_BAD_DESCRIPTOR_FORMAT ((NTSTATUS) 0xc00000e7)
#define STATUS_BAD_DEVICE_TYPE ((NTSTATUS) 0xc00000cb)
#define STATUS_BAD_DLL_ENTRYPOINT ((NTSTATUS) 0xc0000251)
#define STATUS_BAD_FUNCTION_TABLE ((NTSTATUS) 0xc00000ff)
#define STATUS_BAD_IMPERSONATION_LEVEL ((NTSTATUS) 0xc00000a5)
#define STATUS_BAD_INHERITANCE_ACL ((NTSTATUS) 0xc000007d)
#define STATUS_BAD_INITIAL_PC ((NTSTATUS) 0xc000000a)
#define STATUS_BAD_INITIAL_STACK ((NTSTATUS) 0xc0000009)
#define STATUS_BAD_LOGON_SESSION_STATE ((NTSTATUS) 0xc0000104)
#define STATUS_BAD_MASTER_BOOT_RECORD ((NTSTATUS) 0xc00000a9)
#define STATUS_BAD_NETWORK_NAME ((NTSTATUS) 0xc00000cc)
#define STATUS_BAD_NETWORK_PATH ((NTSTATUS) 0xc00000be)
#define STATUS_BAD_REMOTE_ADAPTER ((NTSTATUS) 0xc00000c5)
#define STATUS_BAD_SERVICE_ENTRYPOINT ((NTSTATUS) 0xc0000252)
#define STATUS_BAD_STACK ((NTSTATUS) 0xc0000028)
#define STATUS_BAD_TOKEN_TYPE ((NTSTATUS) 0xc00000a8)
#define STATUS_BAD_VALIDATION_CLASS ((NTSTATUS) 0xc00000a7)
#define STATUS_BAD_WORKING_SET_LIMIT ((NTSTATUS) 0xc000004c)
#define STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT ((NTSTATUS) 0xc000016e)
#define STATUS_BUFFER_TOO_SMALL ((NTSTATUS) 0xc0000023)
#define STATUS_CANCELLED ((NTSTATUS) 0xc0000120)
#define STATUS_CANNOT_DELETE ((NTSTATUS) 0xc0000121)
#define STATUS_CANNOT_IMPERSONATE ((NTSTATUS) 0xc000010d)
#define STATUS_CANNOT_LOAD_REGISTRY_FILE ((NTSTATUS) 0xc0000218)
#define STATUS_CANT_ACCESS_DOMAIN_INFO ((NTSTATUS) 0xc00000da)
#define STATUS_CANT_DISABLE_MANDATORY ((NTSTATUS) 0xc000005d)
#define STATUS_CANT_ENABLE_DENY_ONLY ((NTSTATUS) 0xc00002b3)
#define STATUS_CANT_OPEN_ANONYMOUS ((NTSTATUS) 0xc00000a6)
#define STATUS_CANT_TERMINATE_SELF ((NTSTATUS) 0xc00000db)
#define STATUS_CANT_WAIT ((NTSTATUS) 0xc00000d8)
#define STATUS_CHILD_MUST_BE_VOLATILE ((NTSTATUS) 0xc0000181)
#define STATUS_CLIENT_SERVER_PARAMETERS_INVALID ((NTSTATUS) 0xc0000223)
#define STATUS_COMMITMENT_LIMIT ((NTSTATUS) 0xc000012d)
#define STATUS_COMMITMENT_MINIMUM ((NTSTATUS) 0xc00002c8)
#define STATUS_CONFLICTING_ADDRESSES ((NTSTATUS) 0xc0000018)
#define STATUS_CONNECTION_ABORTED ((NTSTATUS) 0xc0000241)
#define STATUS_CONNECTION_ACTIVE ((NTSTATUS) 0xc000023b)
#define STATUS_CONNECTION_COUNT_LIMIT ((NTSTATUS) 0xc0000246)
#define STATUS_CONNECTION_DISCONNECTED ((NTSTATUS) 0xc000020c)
#define STATUS_CONNECTION_IN_USE ((NTSTATUS) 0xc0000108)
#define STATUS_CONNECTION_INVALID ((NTSTATUS) 0xc000023a)
#define STATUS_CONNECTION_REFUSED ((NTSTATUS) 0xc0000236)
#define STATUS_CONNECTION_RESET ((NTSTATUS) 0xc000020d)
#define STATUS_CONTROL_C_EXIT ((NTSTATUS) 0xc000013a)
#define STATUS_CONVERT_TO_LARGE ((NTSTATUS) 0xc000022c)
#define STATUS_CORRUPT_SYSTEM_FILE ((NTSTATUS) 0xc00002c4)
#define STATUS_COULD_NOT_INTERPRET ((NTSTATUS) 0xc00000b9)
#define STATUS_CRC_ERROR ((NTSTATUS) 0xc000003f)
#define STATUS_CTL_FILE_NOT_SUPPORTED ((NTSTATUS) 0xc0000057)
#define STATUS_DATA_ERROR ((NTSTATUS) 0xc000003e)
#define STATUS_DATA_LATE_ERROR ((NTSTATUS) 0xc000003d)
#define STATUS_DATA_NOT_ACCEPTED ((NTSTATUS) 0xc000021b)
#define STATUS_DATA_OVERRUN ((NTSTATUS) 0xc000003c)
#define STATUS_DATATYPE_MISALIGNMENT_ERROR ((NTSTATUS) 0xc00002c5)
#define STATUS_DEBUG_ATTACH_FAILED ((NTSTATUS) 0xc0000219)
#define STATUS_DECRYPTION_FAILED ((NTSTATUS) 0xc000028b)
#define STATUS_DELETE_PENDING ((NTSTATUS) 0xc0000056)
#define STATUS_DESTINATION_ELEMENT_FULL ((NTSTATUS) 0xc0000284)
#define STATUS_DEVICE_ALREADY_ATTACHED ((NTSTATUS) 0xc0000038)
#define STATUS_DEVICE_CONFIGURATION_ERROR ((NTSTATUS) 0xc0000182)
#define STATUS_DEVICE_DATA_ERROR ((NTSTATUS) 0xc000009c)
#define STATUS_DEVICE_DOES_NOT_EXIST ((NTSTATUS) 0xc00000c0)
#define STATUS_DEVICE_NOT_CONNECTED ((NTSTATUS) 0xc000009d)
#define STATUS_DEVICE_NOT_PARTITIONED ((NTSTATUS) 0xc0000174)
#define STATUS_DEVICE_NOT_READY ((NTSTATUS) 0xc00000a3)
#define STATUS_DEVICE_POWER_FAILURE ((NTSTATUS) 0xc000009e)
#define STATUS_DEVICE_PROTOCOL_ERROR ((NTSTATUS) 0xc0000186)
#define STATUS_DEVICE_REMOVED ((NTSTATUS) 0xc00002b6)
#define STATUS_DFS_EXIT_PATH_FOUND ((NTSTATUS) 0xc000009b)
#define STATUS_DFS_UNAVAILABLE ((NTSTATUS) 0xc000026d)
#define STATUS_DIRECTORY_IS_A_REPARSE_POINT ((NTSTATUS) 0xc0000281)
#define STATUS_DIRECTORY_NOT_EMPTY ((NTSTATUS) 0xc0000101)
#define STATUS_DIRECTORY_SERVICE_REQUIRED ((NTSTATUS) 0xc00002b1)
#define STATUS_DISK_CORRUPT_ERROR ((NTSTATUS) 0xc0000032)
#define STATUS_DISK_FULL ((NTSTATUS) 0xc000007f)
#define STATUS_DISK_OPERATION_FAILED ((NTSTATUS) 0xc000016a)
#define STATUS_DISK_RECALIBRATE_FAILED ((NTSTATUS) 0xc0000169)
#define STATUS_DISK_RESET_FAILED ((NTSTATUS) 0xc000016b)
#define STATUS_DLL_INIT_FAILED_LOGOFF ((NTSTATUS) 0xc000026b)
#define STATUS_DLL_INIT_FAILED ((NTSTATUS) 0xc0000142)
#define STATUS_DLL_NOT_FOUND ((NTSTATUS) 0xc0000135)
#define STATUS_DOMAIN_CONTROLLER_NOT_FOUND ((NTSTATUS) 0xc0000233)
#define STATUS_DOMAIN_CTRLR_CONFIG_ERROR ((NTSTATUS) 0xc000015e)
#define STATUS_DOMAIN_EXISTS ((NTSTATUS) 0xc00000e0)
#define STATUS_DOMAIN_LIMIT_EXCEEDED ((NTSTATUS) 0xc00000e1)
#define STATUS_DOMAIN_TRUST_INCONSISTENT ((NTSTATUS) 0xc000019b)
#define STATUS_DRIVER_CANCEL_TIMEOUT ((NTSTATUS) 0xc000021e)
#define STATUS_DRIVER_ENTRYPOINT_NOT_FOUND ((NTSTATUS) 0xc0000263)
#define STATUS_DRIVER_FAILED_SLEEP ((NTSTATUS) 0xc00002c2)
#define STATUS_DRIVER_INTERNAL_ERROR ((NTSTATUS) 0xc0000183)
#define STATUS_DRIVER_ORDINAL_NOT_FOUND ((NTSTATUS) 0xc0000262)
#define STATUS_DRIVER_UNABLE_TO_LOAD ((NTSTATUS) 0xc000026c)
#define STATUS_DS_ADMIN_LIMIT_EXCEEDED ((NTSTATUS) 0xc00002c1)
#define STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS ((NTSTATUS) 0xc00002a4)
#define STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED ((NTSTATUS) 0xc00002a3)
#define STATUS_DS_BUSY ((NTSTATUS) 0xc00002a5)
#define STATUS_DS_CANT_MOD_OBJ_CLASS ((NTSTATUS) 0xc00002ae)
#define STATUS_DS_CANT_MOD_PRIMARYGROUPID ((NTSTATUS) 0xc00002d0)
#define STATUS_DS_CANT_ON_NON_LEAF ((NTSTATUS) 0xc00002ac)
#define STATUS_DS_CANT_ON_RDN ((NTSTATUS) 0xc00002ad)
#define STATUS_DS_CANT_START ((NTSTATUS) 0xc00002e1)
#define STATUS_DS_CROSS_DOM_MOVE_FAILED ((NTSTATUS) 0xc00002af)
#define STATUS_DS_GC_NOT_AVAILABLE ((NTSTATUS) 0xc00002b0)
#define STATUS_DS_GC_REQUIRED ((NTSTATUS) 0xc00002e4)
#define STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER ((NTSTATUS) 0xc00002da)
#define STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER ((NTSTATUS) 0xc00002d7)
#define STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER ((NTSTATUS) 0xc00002d8)
#define STATUS_DS_HAVE_PRIMARY_MEMBERS ((NTSTATUS) 0xc00002dc)
#define STATUS_DS_INCORRECT_ROLE_OWNER ((NTSTATUS) 0xc00002a9)
#define STATUS_DS_INIT_FAILURE ((NTSTATUS) 0xc00002e2)
#define STATUS_DS_INVALID_ATTRIBUTE_SYNTAX ((NTSTATUS) 0xc00002a2)
#define STATUS_DS_INVALID_GROUP_TYPE ((NTSTATUS) 0xc00002d4)
#define STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER ((NTSTATUS) 0xc00002db)
#define STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY ((NTSTATUS) 0xc00002e5)
#define STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED ((NTSTATUS) 0xc00002e7)
#define STATUS_DS_NO_ATTRIBUTE_OR_VALUE ((NTSTATUS) 0xc00002a1)
#define STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS ((NTSTATUS) 0xc00002e6)
#define STATUS_DS_NO_MORE_RIDS ((NTSTATUS) 0xc00002a8)
#define STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN ((NTSTATUS) 0xc00002d5)
#define STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN ((NTSTATUS) 0xc00002d6)
#define STATUS_DS_NO_RIDS_ALLOCATED ((NTSTATUS) 0xc00002a7)
#define STATUS_DS_OBJ_CLASS_VIOLATION ((NTSTATUS) 0xc00002ab)
#define STATUS_DS_RIDMGR_INIT_ERROR ((NTSTATUS) 0xc00002aa)
#define STATUS_DS_SAM_INIT_FAILURE ((NTSTATUS) 0xc00002cb)
#define STATUS_DS_SENSITIVE_GROUP_VIOLATION ((NTSTATUS) 0xc00002cd)
#define STATUS_DS_UNAVAILABLE ((NTSTATUS) 0xc00002a6)
#define STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER ((NTSTATUS) 0xc00002d9)
#define STATUS_DUPLICATE_NAME ((NTSTATUS) 0xc00000bd)
#define STATUS_DUPLICATE_OBJECTID ((NTSTATUS) 0xc000022a)
#define STATUS_EA_CORRUPT_ERROR ((NTSTATUS) 0xc0000053)
#define STATUS_EAS_NOT_SUPPORTED ((NTSTATUS) 0xc000004f)
#define STATUS_EA_TOO_LARGE ((NTSTATUS) 0xc0000050)
#define STATUS_ENCRYPTION_FAILED ((NTSTATUS) 0xc000028a)
#define STATUS_END_OF_FILE ((NTSTATUS) 0xc0000011)
#define STATUS_ENTRYPOINT_NOT_FOUND ((NTSTATUS) 0xc0000139)
#define STATUS_EOM_OVERFLOW ((NTSTATUS) 0xc0000177)
#define STATUS_EVALUATION_EXPIRATION ((NTSTATUS) 0xc0000268)
#define STATUS_EVENTLOG_CANT_START ((NTSTATUS) 0xc000018f)
#define STATUS_EVENTLOG_FILE_CHANGED ((NTSTATUS) 0xc0000197)
#define STATUS_EVENTLOG_FILE_CORRUPT ((NTSTATUS) 0xc000018e)
#define STATUS_FAIL_CHECK ((NTSTATUS) 0xc0000229)
#define STATUS_FILE_CLOSED ((NTSTATUS) 0xc0000128)
#define STATUS_FILE_CORRUPT_ERROR ((NTSTATUS) 0xc0000102)
#define STATUS_FILE_DELETED ((NTSTATUS) 0xc0000123)
#define STATUS_FILE_ENCRYPTED ((NTSTATUS) 0xc0000293)
#define STATUS_FILE_FORCED_CLOSED ((NTSTATUS) 0xc00000b6)
#define STATUS_FILE_INVALID ((NTSTATUS) 0xc0000098)
#define STATUS_FILE_IS_A_DIRECTORY ((NTSTATUS) 0xc00000ba)
#define STATUS_FILE_IS_OFFLINE ((NTSTATUS) 0xc0000267)
#define STATUS_FILE_LOCK_CONFLICT ((NTSTATUS) 0xc0000054)
#define STATUS_FILE_NOT_ENCRYPTED ((NTSTATUS) 0xc0000291)
#define STATUS_FILE_RENAMED ((NTSTATUS) 0xc00000d5)
#define STATUS_FILES_OPEN ((NTSTATUS) 0xc0000107)
#define STATUS_FLOAT_DENORMAL_OPERAND ((NTSTATUS) 0xc000008d)
#define STATUS_FLOAT_DIVIDE_BY_ZERO ((NTSTATUS) 0xc000008e)
#define STATUS_FLOAT_INEXACT_RESULT ((NTSTATUS) 0xc000008f)
#define STATUS_FLOAT_INVALID_OPERATION ((NTSTATUS) 0xc0000090)
#define STATUS_FLOAT_MULTIPLE_FAULTS ((NTSTATUS) 0xc00002b4)
#define STATUS_FLOAT_MULTIPLE_TRAPS ((NTSTATUS) 0xc00002b5)
#define STATUS_FLOAT_OVERFLOW ((NTSTATUS) 0xc0000091)
#define STATUS_FLOAT_STACK_CHECK ((NTSTATUS) 0xc0000092)
#define STATUS_FLOAT_UNDERFLOW ((NTSTATUS) 0xc0000093)
#define STATUS_FLOPPY_BAD_REGISTERS ((NTSTATUS) 0xc0000168)
#define STATUS_FLOPPY_ID_MARK_NOT_FOUND ((NTSTATUS) 0xc0000165)
#define STATUS_FLOPPY_UNKNOWN_ERROR ((NTSTATUS) 0xc0000167)
#define STATUS_FLOPPY_VOLUME ((NTSTATUS) 0xc0000164)
#define STATUS_FLOPPY_WRONG_CYLINDER ((NTSTATUS) 0xc0000166)
#define STATUS_FOUND_OUT_OF_SCOPE ((NTSTATUS) 0xc000022e)
#define STATUS_FREE_VM_NOT_AT_BASE ((NTSTATUS) 0xc000009f)
#define STATUS_FS_DRIVER_REQUIRED ((NTSTATUS) 0xc000019c)
#define STATUS_FT_MISSING_MEMBER ((NTSTATUS) 0xc000015f)
#define STATUS_FT_ORPHANING ((NTSTATUS) 0xc000016d)
#define STATUS_FULLSCREEN_MODE ((NTSTATUS) 0xc0000159)
#define STATUS_GENERIC_NOT_MAPPED ((NTSTATUS) 0xc00000e6)
#define STATUS_GRACEFUL_DISCONNECT ((NTSTATUS) 0xc0000237)
#define STATUS_GROUP_EXISTS ((NTSTATUS) 0xc0000065)
#define STATUS_GUIDS_EXHAUSTED ((NTSTATUS) 0xc0000083)
#define STATUS_HANDLE_NOT_CLOSABLE ((NTSTATUS) 0xc0000235)
#define STATUS_HOST_UNREACHABLE ((NTSTATUS) 0xc000023d)
#define STATUS_ILLEGAL_CHARACTER ((NTSTATUS) 0xc0000161)
#define STATUS_ILLEGAL_DLL_RELOCATION ((NTSTATUS) 0xc0000269)
#define STATUS_ILLEGAL_ELEMENT_ADDRESS ((NTSTATUS) 0xc0000285)
#define STATUS_ILLEGAL_FLOAT_CONTEXT ((NTSTATUS) 0xc000014a)
#define STATUS_ILLEGAL_FUNCTION ((NTSTATUS) 0xc00000af)
#define STATUS_ILLEGAL_INSTRUCTION ((NTSTATUS) 0xc000001d)
#define STATUS_ILL_FORMED_PASSWORD ((NTSTATUS) 0xc000006b)
#define STATUS_ILL_FORMED_SERVICE_ENTRY ((NTSTATUS) 0xc0000160)
#define STATUS_IMAGE_ALREADY_LOADED ((NTSTATUS) 0xc000010e)
#define STATUS_IMAGE_CHECKSUM_MISMATCH ((NTSTATUS) 0xc0000221)
#define STATUS_IMAGE_MP_UP_MISMATCH ((NTSTATUS) 0xc0000249)
#define STATUS_INCOMPATIBLE_FILE_MAP ((NTSTATUS) 0xc000004d)
#define STATUS_INFO_LENGTH_MISMATCH ((NTSTATUS) 0xc0000004)
#define STATUS_IN_PAGE_ERROR ((NTSTATUS) 0xc0000006)
#define STATUS_INSTANCE_NOT_AVAILABLE ((NTSTATUS) 0xc00000ab)
#define STATUS_INSTRUCTION_MISALIGNMENT ((NTSTATUS) 0xc00000aa)
#define STATUS_INSUFFICIENT_LOGON_INFO ((NTSTATUS) 0xc0000250)
#define STATUS_INSUFFICIENT_POWER ((NTSTATUS) 0xc00002de)
#define STATUS_INSUFFICIENT_RESOURCES ((NTSTATUS) 0xc000009a)
#define STATUS_INSUFF_SERVER_RESOURCES ((NTSTATUS) 0xc0000205)
#define STATUS_INTEGER_DIVIDE_BY_ZERO ((NTSTATUS) 0xc0000094)
#define STATUS_INTEGER_OVERFLOW ((NTSTATUS) 0xc0000095)
#define STATUS_INTERNAL_DB_CORRUPTION ((NTSTATUS) 0xc00000e4)
#define STATUS_INTERNAL_DB_ERROR ((NTSTATUS) 0xc0000158)
#define STATUS_INTERNAL_ERROR ((NTSTATUS) 0xc00000e5)
#define STATUS_INVALID_ACCOUNT_NAME ((NTSTATUS) 0xc0000062)
#define STATUS_INVALID_ACL ((NTSTATUS) 0xc0000077)
#define STATUS_INVALID_ADDRESS_COMPONENT ((NTSTATUS) 0xc0000207)
#define STATUS_INVALID_ADDRESS ((NTSTATUS) 0xc0000141)
#define STATUS_INVALID_ADDRESS_WILDCARD ((NTSTATUS) 0xc0000208)
#define STATUS_INVALID_BLOCK_LENGTH ((NTSTATUS) 0xc0000173)
#define STATUS_INVALID_BUFFER_SIZE ((NTSTATUS) 0xc0000206)
#define STATUS_INVALID_CID ((NTSTATUS) 0xc000000b)
#define STATUS_INVALID_COMPUTER_NAME ((NTSTATUS) 0xc0000122)
#define STATUS_INVALID_CONNECTION ((NTSTATUS) 0xc0000140)
#define STATUS_INVALID_DEVICE_REQUEST ((NTSTATUS) 0xc0000010)
#define STATUS_INVALID_DEVICE_STATE ((NTSTATUS) 0xc0000184)
#define STATUS_INVALID_DISPOSITION ((NTSTATUS) 0xc0000026)
#define STATUS_INVALID_DOMAIN_ROLE ((NTSTATUS) 0xc00000de)
#define STATUS_INVALID_DOMAIN_STATE ((NTSTATUS) 0xc00000dd)
#define STATUS_INVALID_FILE_FOR_SECTION ((NTSTATUS) 0xc0000020)
#define STATUS_INVALID_GROUP_ATTRIBUTES ((NTSTATUS) 0xc00000a4)
#define STATUS_INVALID_HANDLE ((NTSTATUS) 0xc0000008)
#define STATUS_INVALID_HW_PROFILE ((NTSTATUS) 0xc0000260)
#define STATUS_INVALID_ID_AUTHORITY ((NTSTATUS) 0xc0000084)
#define STATUS_INVALID_IMAGE_FORMAT ((NTSTATUS) 0xc000007b)
#define STATUS_INVALID_IMAGE_LE_FORMAT ((NTSTATUS) 0xc000012e)
#define STATUS_INVALID_IMAGE_NE_FORMAT ((NTSTATUS) 0xc000011b)
#define STATUS_INVALID_IMAGE_NOT_MZ ((NTSTATUS) 0xc000012f)
#define STATUS_INVALID_IMAGE_PROTECT ((NTSTATUS) 0xc0000130)
#define STATUS_INVALID_IMAGE_WIN_16 ((NTSTATUS) 0xc0000131)
#define STATUS_INVALID_INFO_CLASS ((NTSTATUS) 0xc0000003)
#define STATUS_INVALID_LDT_DESCRIPTOR ((NTSTATUS) 0xc000011a)
#define STATUS_INVALID_LDT_OFFSET ((NTSTATUS) 0xc0000119)
#define STATUS_INVALID_LDT_SIZE ((NTSTATUS) 0xc0000118)
#define STATUS_INVALID_LEVEL ((NTSTATUS) 0xc0000148)
#define STATUS_INVALID_LOCK_SEQUENCE ((NTSTATUS) 0xc000001e)
#define STATUS_INVALID_LOGON_HOURS ((NTSTATUS) 0xc000006f)
#define STATUS_INVALID_LOGON_TYPE ((NTSTATUS) 0xc000010b)
#define STATUS_INVALID_MEMBER ((NTSTATUS) 0xc000017b)
#define STATUS_INVALID_NETWORK_RESPONSE ((NTSTATUS) 0xc00000c3)
#define STATUS_INVALID_OPLOCK_PROTOCOL ((NTSTATUS) 0xc00000e3)
#define STATUS_INVALID_OWNER ((NTSTATUS) 0xc000005a)
#define STATUS_INVALID_PAGE_PROTECTION ((NTSTATUS) 0xc0000045)
#define STATUS_INVALID_PARAMETER_10 ((NTSTATUS) 0xc00000f8)
#define STATUS_INVALID_PARAMETER_11 ((NTSTATUS) 0xc00000f9)
#define STATUS_INVALID_PARAMETER_12 ((NTSTATUS) 0xc00000fa)
#define STATUS_INVALID_PARAMETER_1 ((NTSTATUS) 0xc00000ef)
#define STATUS_INVALID_PARAMETER_2 ((NTSTATUS) 0xc00000f0)
#define STATUS_INVALID_PARAMETER_3 ((NTSTATUS) 0xc00000f1)
#define STATUS_INVALID_PARAMETER_4 ((NTSTATUS) 0xc00000f2)
#define STATUS_INVALID_PARAMETER_5 ((NTSTATUS) 0xc00000f3)
#define STATUS_INVALID_PARAMETER_6 ((NTSTATUS) 0xc00000f4)
#define STATUS_INVALID_PARAMETER_7 ((NTSTATUS) 0xc00000f5)
#define STATUS_INVALID_PARAMETER_8 ((NTSTATUS) 0xc00000f6)
#define STATUS_INVALID_PARAMETER_9 ((NTSTATUS) 0xc00000f7)
#define STATUS_INVALID_PARAMETER_MIX ((NTSTATUS) 0xc0000030)
#define STATUS_INVALID_PARAMETER ((NTSTATUS) 0xc000000d)
#define STATUS_INVALID_PIPE_STATE ((NTSTATUS) 0xc00000ad)
#define STATUS_INVALID_PLUGPLAY_DEVICE_PATH ((NTSTATUS) 0xc0000261)
#define STATUS_INVALID_PORT_ATTRIBUTES ((NTSTATUS) 0xc000002e)
#define STATUS_INVALID_PORT_HANDLE ((NTSTATUS) 0xc0000042)
#define STATUS_INVALID_PRIMARY_GROUP ((NTSTATUS) 0xc000005b)
#define STATUS_INVALID_QUOTA_LOWER ((NTSTATUS) 0xc0000031)
#define STATUS_INVALID_READ_MODE ((NTSTATUS) 0xc00000b4)
#define STATUS_INVALID_SECURITY_DESCR ((NTSTATUS) 0xc0000079)
#define STATUS_INVALID_SERVER_STATE ((NTSTATUS) 0xc00000dc)
#define STATUS_INVALID_SID ((NTSTATUS) 0xc0000078)
#define STATUS_INVALID_SUB_AUTHORITY ((NTSTATUS) 0xc0000076)
#define STATUS_INVALID_SYSTEM_SERVICE ((NTSTATUS) 0xc000001c)
#define STATUS_INVALID_UNWIND_TARGET ((NTSTATUS) 0xc0000029)
#define STATUS_INVALID_USER_BUFFER ((NTSTATUS) 0xc00000e8)
#define STATUS_INVALID_VARIANT ((NTSTATUS) 0xc0000232)
#define STATUS_INVALID_VIEW_SIZE ((NTSTATUS) 0xc000001f)
#define STATUS_INVALID_VOLUME_LABEL ((NTSTATUS) 0xc0000086)
#define STATUS_INVALID_WORKSTATION ((NTSTATUS) 0xc0000070)
#define STATUS_IO_DEVICE_ERROR ((NTSTATUS) 0xc0000185)
#define STATUS_IO_PRIVILEGE_FAILED ((NTSTATUS) 0xc0000137)
#define STATUS_IO_REPARSE_DATA_INVALID ((NTSTATUS) 0xc0000278)
#define STATUS_IO_REPARSE_TAG_INVALID ((NTSTATUS) 0xc0000276)
#define STATUS_IO_REPARSE_TAG_MISMATCH ((NTSTATUS) 0xc0000277)
#define STATUS_IO_REPARSE_TAG_NOT_HANDLED ((NTSTATUS) 0xc0000279)
#define STATUS_IO_TIMEOUT ((NTSTATUS) 0xc00000b5)
#define STATUS_IP_ADDRESS_CONFLICT1 ((NTSTATUS) 0xc0000254)
#define STATUS_IP_ADDRESS_CONFLICT2 ((NTSTATUS) 0xc0000255)
#define STATUS_JOURNAL_DELETE_IN_PROGRESS ((NTSTATUS) 0xc00002b7)
#define STATUS_JOURNAL_ENTRY_DELETED ((NTSTATUS) 0xc00002cf)
#define STATUS_JOURNAL_NOT_ACTIVE ((NTSTATUS) 0xc00002b8)
#define STATUS_KEY_DELETED ((NTSTATUS) 0xc000017c)
#define STATUS_KEY_HAS_CHILDREN ((NTSTATUS) 0xc0000180)
#define STATUS_LAST_ADMIN ((NTSTATUS) 0xc0000069)
#define STATUS_LICENSE_QUOTA_EXCEEDED ((NTSTATUS) 0xc0000259)
#define STATUS_LICENSE_VIOLATION ((NTSTATUS) 0xc000026a)
#define STATUS_LINK_FAILED ((NTSTATUS) 0xc000013e)
#define STATUS_LINK_TIMEOUT ((NTSTATUS) 0xc000013f)
#define STATUS_LM_CROSS_ENCRYPTION_REQUIRED ((NTSTATUS) 0xc000017f)
#define STATUS_LOCAL_DISCONNECT ((NTSTATUS) 0xc000013b)
#define STATUS_LOCK_NOT_GRANTED ((NTSTATUS) 0xc0000055)
#define STATUS_LOG_FILE_FULL ((NTSTATUS) 0xc0000188)
#define STATUS_LOGIN_TIME_RESTRICTION ((NTSTATUS) 0xc0000247)
#define STATUS_LOGIN_WKSTA_RESTRICTION ((NTSTATUS) 0xc0000248)
#define STATUS_LOGON_FAILURE ((NTSTATUS) 0xc000006d)
#define STATUS_LOGON_NOT_GRANTED ((NTSTATUS) 0xc0000155)
#define STATUS_LOGON_SERVER_CONFLICT ((NTSTATUS) 0xc0000132)
#define STATUS_LOGON_SESSION_COLLISION ((NTSTATUS) 0xc0000105)
#define STATUS_LOGON_SESSION_EXISTS ((NTSTATUS) 0xc00000ee)
#define STATUS_LOGON_TYPE_NOT_GRANTED ((NTSTATUS) 0xc000015b)
#define STATUS_LOST_WRITEBEHIND_DATA ((NTSTATUS) 0xc0000222)
#define STATUS_LPC_REPLY_LOST ((NTSTATUS) 0xc0000253)
#define STATUS_LUIDS_EXHAUSTED ((NTSTATUS) 0xc0000075)
#define STATUS_MAGAZINE_NOT_PRESENT ((NTSTATUS) 0xc0000286)
#define STATUS_MAPPED_ALIGNMENT ((NTSTATUS) 0xc0000220)
#define STATUS_MAPPED_FILE_SIZE_ZERO ((NTSTATUS) 0xc000011e)
#define STATUS_MARSHALL_OVERFLOW ((NTSTATUS) 0xc0000231)
#define STATUS_MEDIA_WRITE_PROTECTED ((NTSTATUS) 0xc00000a2)
#define STATUS_MEMBER_IN_ALIAS ((NTSTATUS) 0xc0000153)
#define STATUS_MEMBER_IN_GROUP ((NTSTATUS) 0xc0000067)
#define STATUS_MEMBER_NOT_IN_ALIAS ((NTSTATUS) 0xc0000152)
#define STATUS_MEMBER_NOT_IN_GROUP ((NTSTATUS) 0xc0000068)
#define STATUS_MEMBERS_PRIMARY_GROUP ((NTSTATUS) 0xc0000127)
#define STATUS_MEMORY_NOT_ALLOCATED ((NTSTATUS) 0xc00000a0)
#define STATUS_MESSAGE_NOT_FOUND ((NTSTATUS) 0xc0000109)
#define STATUS_MISSING_SYSTEMFILE ((NTSTATUS) 0xc0000143)
#define STATUS_MORE_PROCESSING_REQUIRED ((NTSTATUS) 0xc0000016)
#define STATUS_MULTIPLE_FAULT_VIOLATION ((NTSTATUS) 0xc00002e8)
#define STATUS_MUTANT_LIMIT_EXCEEDED ((NTSTATUS) 0xc0000191)
#define STATUS_MUTANT_NOT_OWNED ((NTSTATUS) 0xc0000046)
#define STATUS_MUTUAL_AUTHENTICATION_FAILED ((NTSTATUS) 0xc00002c3)
#define STATUS_NAME_TOO_LONG ((NTSTATUS) 0xc0000106)
#define STATUS_NETLOGON_NOT_STARTED ((NTSTATUS) 0xc0000192)
#define STATUS_NETWORK_ACCESS_DENIED ((NTSTATUS) 0xc00000ca)
#define STATUS_NETWORK_BUSY ((NTSTATUS) 0xc00000bf)
#define STATUS_NETWORK_CREDENTIAL_CONFLICT ((NTSTATUS) 0xc0000195)
#define STATUS_NETWORK_UNREACHABLE ((NTSTATUS) 0xc000023c)
#define STATUS_NET_WRITE_FAULT ((NTSTATUS) 0xc00000d2)
#define STATUS_NO_BROWSER_SERVERS_FOUND ((NTSTATUS) 0xc000021c)
#define STATUS_NO_CALLBACK_ACTIVE ((NTSTATUS) 0xc0000258)
#define STATUS_NO_EAS_ON_FILE ((NTSTATUS) 0xc0000052)
#define STATUS_NO_EFS ((NTSTATUS) 0xc000028e)
#define STATUS_NO_EVENT_PAIR ((NTSTATUS) 0xc000014e)
#define STATUS_NO_GUID_TRANSLATION ((NTSTATUS) 0xc000010c)
#define STATUS_NO_IMPERSONATION_TOKEN ((NTSTATUS) 0xc000005c)
#define STATUS_NOINTERFACE ((NTSTATUS) 0xc00002b9)
#define STATUS_NO_LDT ((NTSTATUS) 0xc0000117)
#define STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT ((NTSTATUS) 0xc0000198)
#define STATUS_NO_LOGON_SERVERS ((NTSTATUS) 0xc000005e)
#define STATUS_NOLOGON_SERVER_TRUST_ACCOUNT ((NTSTATUS) 0xc000019a)
#define STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT ((NTSTATUS) 0xc0000199)
#define STATUS_NO_LOG_SPACE ((NTSTATUS) 0xc000017d)
#define STATUS_NO_MATCH ((NTSTATUS) 0xc0000272)
#define STATUS_NO_MEDIA_IN_DEVICE ((NTSTATUS) 0xc0000013)
#define STATUS_NO_MEDIA ((NTSTATUS) 0xc0000178)
#define STATUS_NO_MEMORY ((NTSTATUS) 0xc0000017)
#define STATUS_NO_MORE_MATCHES ((NTSTATUS) 0xc0000273)
#define STATUS_NONCONTINUABLE_EXCEPTION ((NTSTATUS) 0xc0000025)
#define STATUS_NONE_MAPPED ((NTSTATUS) 0xc0000073)
#define STATUS_NONEXISTENT_EA_ENTRY ((NTSTATUS) 0xc0000051)
#define STATUS_NONEXISTENT_SECTOR ((NTSTATUS) 0xc0000015)
#define STATUS_NO_PAGEFILE ((NTSTATUS) 0xc0000147)
#define STATUS_NO_RECOVERY_POLICY ((NTSTATUS) 0xc000028d)
#define STATUS_NO_SECURITY_ON_OBJECT ((NTSTATUS) 0xc00000d7)
#define STATUS_NO_SPOOL_SPACE ((NTSTATUS) 0xc00000c7)
#define STATUS_NO_SUCH_ALIAS ((NTSTATUS) 0xc0000151)
#define STATUS_NO_SUCH_DEVICE ((NTSTATUS) 0xc000000e)
#define STATUS_NO_SUCH_DOMAIN ((NTSTATUS) 0xc00000df)
#define STATUS_NO_SUCH_FILE ((NTSTATUS) 0xc000000f)
#define STATUS_NO_SUCH_GROUP ((NTSTATUS) 0xc0000066)
#define STATUS_NO_SUCH_LOGON_SESSION ((NTSTATUS) 0xc000005f)
#define STATUS_NO_SUCH_MEMBER ((NTSTATUS) 0xc000017a)
#define STATUS_NO_SUCH_PACKAGE ((NTSTATUS) 0xc00000fe)
#define STATUS_NO_SUCH_PRIVILEGE ((NTSTATUS) 0xc0000060)
#define STATUS_NO_SUCH_USER ((NTSTATUS) 0xc0000064)
#define STATUS_NOT_A_DIRECTORY ((NTSTATUS) 0xc0000103)
#define STATUS_NOT_A_REPARSE_POINT ((NTSTATUS) 0xc0000275)
#define STATUS_NOT_CLIENT_SESSION ((NTSTATUS) 0xc0000217)
#define STATUS_NOT_COMMITTED ((NTSTATUS) 0xc000002d)
#define STATUS_NOT_EXPORT_FORMAT ((NTSTATUS) 0xc0000292)
#define STATUS_NOT_FOUND ((NTSTATUS) 0xc0000225)
#define STATUS_NOT_IMPLEMENTED ((NTSTATUS) 0xc0000002)
#define STATUS_NOT_LOCKED ((NTSTATUS) 0xc000002a)
#define STATUS_NOT_LOGON_PROCESS ((NTSTATUS) 0xc00000ed)
#define STATUS_NOT_MAPPED_DATA ((NTSTATUS) 0xc0000088)
#define STATUS_NOT_MAPPED_VIEW ((NTSTATUS) 0xc0000019)
#define STATUS_NO_TOKEN ((NTSTATUS) 0xc000007c)
#define STATUS_NO_TRACKING_SERVICE ((NTSTATUS) 0xc000029f)
#define STATUS_NOT_REGISTRY_FILE ((NTSTATUS) 0xc000015c)
#define STATUS_NO_TRUST_LSA_SECRET ((NTSTATUS) 0xc000018a)
#define STATUS_NO_TRUST_SAM_ACCOUNT ((NTSTATUS) 0xc000018b)
#define STATUS_NOT_SAME_DEVICE ((NTSTATUS) 0xc00000d4)
#define STATUS_NOT_SERVER_SESSION ((NTSTATUS) 0xc0000216)
#define STATUS_NOT_SUPPORTED ((NTSTATUS) 0xc00000bb)
#define STATUS_NOT_SUPPORTED_ON_SBS ((NTSTATUS) 0xc0000300)
#define STATUS_NOT_TINY_STREAM ((NTSTATUS) 0xc0000226)
#define STATUS_NO_USER_KEYS ((NTSTATUS) 0xc0000290)
#define STATUS_NO_USER_SESSION_KEY ((NTSTATUS) 0xc0000202)
#define STATUS_NT_CROSS_ENCRYPTION_REQUIRED ((NTSTATUS) 0xc000015d)
#define STATUS_OBJECTID_EXISTS ((NTSTATUS) 0xc000022b)
#define STATUS_OBJECT_NAME_COLLISION ((NTSTATUS) 0xc0000035)
#define STATUS_OBJECT_NAME_INVALID ((NTSTATUS) 0xc0000033)
#define STATUS_OBJECT_NAME_NOT_FOUND ((NTSTATUS) 0xc0000034)
#define STATUS_OBJECT_PATH_INVALID ((NTSTATUS) 0xc0000039)
#define STATUS_OBJECT_PATH_NOT_FOUND ((NTSTATUS) 0xc000003a)
#define STATUS_OBJECT_PATH_SYNTAX_BAD ((NTSTATUS) 0xc000003b)
#define STATUS_OBJECT_TYPE_MISMATCH ((NTSTATUS) 0xc0000024)
#define STATUS_ONLY_IF_CONNECTED ((NTSTATUS) 0xc00002cc)
#define STATUS_OPEN_FAILED ((NTSTATUS) 0xc0000136)
#define STATUS_OPLOCK_NOT_GRANTED ((NTSTATUS) 0xc00000e2)
#define STATUS_ORDINAL_NOT_FOUND ((NTSTATUS) 0xc0000138)
#define STATUS_PAGEFILE_CREATE_FAILED ((NTSTATUS) 0xc0000146)
#define STATUS_PAGEFILE_QUOTA_EXCEEDED ((NTSTATUS) 0xc000012c)
#define STATUS_PAGEFILE_QUOTA ((NTSTATUS) 0xc0000007)
#define STATUS_PARITY_ERROR ((NTSTATUS) 0xc000002b)
#define STATUS_PARTITION_FAILURE ((NTSTATUS) 0xc0000172)
#define STATUS_PASSWORD_EXPIRED ((NTSTATUS) 0xc0000071)
#define STATUS_PASSWORD_MUST_CHANGE ((NTSTATUS) 0xc0000224)
#define STATUS_PASSWORD_RESTRICTION ((NTSTATUS) 0xc000006c)
#define STATUS_PATH_NOT_COVERED ((NTSTATUS) 0xc0000257)
#define STATUS_PIPE_BROKEN ((NTSTATUS) 0xc000014b)
#define STATUS_PIPE_BUSY ((NTSTATUS) 0xc00000ae)
#define STATUS_PIPE_CLOSING ((NTSTATUS) 0xc00000b1)
#define STATUS_PIPE_CONNECTED ((NTSTATUS) 0xc00000b2)
#define STATUS_PIPE_DISCONNECTED ((NTSTATUS) 0xc00000b0)
#define STATUS_PIPE_EMPTY ((NTSTATUS) 0xc00000d9)
#define STATUS_PIPE_LISTENING ((NTSTATUS) 0xc00000b3)
#define STATUS_PIPE_NOT_AVAILABLE ((NTSTATUS) 0xc00000ac)
#define STATUS_PLUGPLAY_NO_DEVICE ((NTSTATUS) 0xc000025e)
#define STATUS_PNP_REBOOT_REQUIRED ((NTSTATUS) 0xc00002d2)
#define STATUS_PNP_RESTART_ENUMERATION ((NTSTATUS) 0xc00002ce)
#define STATUS_POLICY_OBJECT_NOT_FOUND ((NTSTATUS) 0xc000029a)
#define STATUS_POLICY_ONLY_IN_DS ((NTSTATUS) 0xc000029b)
#define STATUS_PORT_ALREADY_SET ((NTSTATUS) 0xc0000048)
#define STATUS_PORT_CONNECTION_REFUSED ((NTSTATUS) 0xc0000041)
#define STATUS_PORT_DISCONNECTED ((NTSTATUS) 0xc0000037)
#define STATUS_PORT_MESSAGE_TOO_LONG ((NTSTATUS) 0xc000002f)
#define STATUS_PORT_UNREACHABLE ((NTSTATUS) 0xc000023f)
#define STATUS_POSSIBLE_DEADLOCK ((NTSTATUS) 0xc0000194)
#define STATUS_POWER_STATE_INVALID ((NTSTATUS) 0xc00002d3)
#define STATUS_PRINT_CANCELLED ((NTSTATUS) 0xc00000c8)
#define STATUS_PRINT_QUEUE_FULL ((NTSTATUS) 0xc00000c6)
#define STATUS_PRIVILEGED_INSTRUCTION ((NTSTATUS) 0xc0000096)
#define STATUS_PRIVILEGE_NOT_HELD ((NTSTATUS) 0xc0000061)
#define STATUS_PROCEDURE_NOT_FOUND ((NTSTATUS) 0xc000007a)
#define STATUS_PROCESS_IS_TERMINATING ((NTSTATUS) 0xc000010a)
#define STATUS_PROFILING_AT_LIMIT ((NTSTATUS) 0xc00000d3)
#define STATUS_PROFILING_NOT_STARTED ((NTSTATUS) 0xc00000b7)
#define STATUS_PROFILING_NOT_STOPPED ((NTSTATUS) 0xc00000b8)
#define STATUS_PROPSET_NOT_FOUND ((NTSTATUS) 0xc0000230)
#define STATUS_PROTOCOL_UNREACHABLE ((NTSTATUS) 0xc000023e)
#define STATUS_PWD_HISTORY_CONFLICT ((NTSTATUS) 0xc000025c)
#define STATUS_PWD_TOO_RECENT ((NTSTATUS) 0xc000025b)
#define STATUS_PWD_TOO_SHORT ((NTSTATUS) 0xc000025a)
#define STATUS_QUOTA_EXCEEDED ((NTSTATUS) 0xc0000044)
#define STATUS_QUOTA_LIST_INCONSISTENT ((NTSTATUS) 0xc0000266)
#define STATUS_RANGE_LIST_CONFLICT ((NTSTATUS) 0xc0000282)
#define STATUS_RANGE_NOT_FOUND ((NTSTATUS) 0xc000028c)
#define STATUS_RANGE_NOT_LOCKED ((NTSTATUS) 0xc000007e)
#define STATUS_RECOVERY_FAILURE ((NTSTATUS) 0xc0000227)
#define STATUS_REDIRECTOR_NOT_STARTED ((NTSTATUS) 0xc00000fb)
#define STATUS_REDIRECTOR_PAUSED ((NTSTATUS) 0xc00000d1)
#define STATUS_REDIRECTOR_STARTED ((NTSTATUS) 0xc00000fc)
#define STATUS_REGISTRY_CORRUPT ((NTSTATUS) 0xc000014c)
#define STATUS_REGISTRY_IO_FAILED ((NTSTATUS) 0xc000014d)
#define STATUS_REGISTRY_QUOTA_LIMIT ((NTSTATUS) 0xc0000256)
#define STATUS_REG_NAT_CONSUMPTION ((NTSTATUS) 0xc00002c9)
#define STATUS_REINITIALIZATION_NEEDED ((NTSTATUS) 0xc0000287)
#define STATUS_REMOTE_DISCONNECT ((NTSTATUS) 0xc000013c)
#define STATUS_REMOTE_NOT_LISTENING ((NTSTATUS) 0xc00000bc)
#define STATUS_REMOTE_RESOURCES ((NTSTATUS) 0xc000013d)
#define STATUS_REMOTE_SESSION_LIMIT ((NTSTATUS) 0xc0000196)
#define STATUS_REMOTE_STORAGE_MEDIA_ERROR ((NTSTATUS) 0xc000029e)
#define STATUS_REMOTE_STORAGE_NOT_ACTIVE ((NTSTATUS) 0xc000029d)
#define STATUS_REPARSE_ATTRIBUTE_CONFLICT ((NTSTATUS) 0xc00002b2)
#define STATUS_REPARSE_POINT_NOT_RESOLVED ((NTSTATUS) 0xc0000280)
#define STATUS_REPLY_MESSAGE_MISMATCH ((NTSTATUS) 0xc000021f)
#define STATUS_REQUEST_ABORTED ((NTSTATUS) 0xc0000240)
#define STATUS_REQUEST_NOT_ACCEPTED ((NTSTATUS) 0xc00000d0)
#define STATUS_RESOURCE_DATA_NOT_FOUND ((NTSTATUS) 0xc0000089)
#define STATUS_RESOURCE_LANG_NOT_FOUND ((NTSTATUS) 0xc0000204)
#define STATUS_RESOURCE_NAME_NOT_FOUND ((NTSTATUS) 0xc000008b)
#define STATUS_RESOURCE_NOT_OWNED ((NTSTATUS) 0xc0000264)
#define STATUS_RESOURCE_TYPE_NOT_FOUND ((NTSTATUS) 0xc000008a)
#define STATUS_REVISION_MISMATCH ((NTSTATUS) 0xc0000059)
#define STATUS_RXACT_COMMIT_FAILURE ((NTSTATUS) 0xc000011d)
#define STATUS_RXACT_INVALID_STATE ((NTSTATUS) 0xc000011c)
#define STATUS_SAM_INIT_FAILURE ((NTSTATUS) 0xc00002e3)
#define STATUS_SAM_NEED_BOOTKEY_FLOPPY ((NTSTATUS) 0xc00002e0)
#define STATUS_SAM_NEED_BOOTKEY_PASSWORD ((NTSTATUS) 0xc00002df)
#define STATUS_SECRET_TOO_LONG ((NTSTATUS) 0xc0000157)
#define STATUS_SECTION_NOT_EXTENDED ((NTSTATUS) 0xc0000087)
#define STATUS_SECTION_NOT_IMAGE ((NTSTATUS) 0xc0000049)
#define STATUS_SECTION_PROTECTION ((NTSTATUS) 0xc000004e)
#define STATUS_SECTION_TOO_BIG ((NTSTATUS) 0xc0000040)
#define STATUS_SEMAPHORE_LIMIT_EXCEEDED ((NTSTATUS) 0xc0000047)
#define STATUS_SERIAL_NO_DEVICE_INITED ((NTSTATUS) 0xc0000150)
#define STATUS_SERVER_DISABLED ((NTSTATUS) 0xc0000080)
#define STATUS_SERVER_NOT_DISABLED ((NTSTATUS) 0xc0000081)
#define STATUS_SERVER_SID_MISMATCH ((NTSTATUS) 0xc00002a0)
#define STATUS_SHARED_IRQ_BUSY ((NTSTATUS) 0xc000016c)
#define STATUS_SHARED_POLICY ((NTSTATUS) 0xc0000299)
#define STATUS_SHARING_PAUSED ((NTSTATUS) 0xc00000cf)
#define STATUS_SHARING_VIOLATION ((NTSTATUS) 0xc0000043)
#define STATUS_SOURCE_ELEMENT_EMPTY ((NTSTATUS) 0xc0000283)
#define STATUS_SPECIAL_ACCOUNT ((NTSTATUS) 0xc0000124)
#define STATUS_SPECIAL_GROUP ((NTSTATUS) 0xc0000125)
#define STATUS_SPECIAL_USER ((NTSTATUS) 0xc0000126)
#define STATUS_STACK_OVERFLOW ((NTSTATUS) 0xc00000fd)
#define STATUS_STACK_OVERFLOW_READ ((NTSTATUS) 0xc0000228)
#define STATUS_SUCCESS ((NTSTATUS) 0x00000000)
#define STATUS_SUSPEND_COUNT_EXCEEDED ((NTSTATUS) 0xc000004a)
#define STATUS_SYNCHRONIZATION_REQUIRED ((NTSTATUS) 0xc0000134)
#define STATUS_SYSTEM_IMAGE_BAD_SIGNATURE ((NTSTATUS) 0xc00002d1)
#define STATUS_SYSTEM_PROCESS_TERMINATED ((NTSTATUS) 0xc000021a)
#define STATUS_THREAD_IS_TERMINATING ((NTSTATUS) 0xc000004b)
#define STATUS_THREAD_NOT_IN_PROCESS ((NTSTATUS) 0xc000012a)
#define STATUS_TIME_DIFFERENCE_AT_DC ((NTSTATUS) 0xc0000133)
#define STATUS_TIMER_NOT_CANCELED ((NTSTATUS) 0xc000000c)
#define STATUS_TIMER_RESOLUTION_NOT_SET ((NTSTATUS) 0xc0000245)
#define STATUS_TOKEN_ALREADY_IN_USE ((NTSTATUS) 0xc000012b)
#define STATUS_TOO_LATE ((NTSTATUS) 0xc0000189)
#define STATUS_TOO_MANY_ADDRESSES ((NTSTATUS) 0xc0000209)
#define STATUS_TOO_MANY_COMMANDS ((NTSTATUS) 0xc00000c1)
#define STATUS_TOO_MANY_CONTEXT_IDS ((NTSTATUS) 0xc000015a)
#define STATUS_TOO_MANY_GUIDS_REQUESTED ((NTSTATUS) 0xc0000082)
#define STATUS_TOO_MANY_LINKS ((NTSTATUS) 0xc0000265)
#define STATUS_TOO_MANY_LUIDS_REQUESTED ((NTSTATUS) 0xc0000074)
#define STATUS_TOO_MANY_NAMES ((NTSTATUS) 0xc00000cd)
#define STATUS_TOO_MANY_NODES ((NTSTATUS) 0xc000020e)
#define STATUS_TOO_MANY_OPENED_FILES ((NTSTATUS) 0xc000011f)
#define STATUS_TOO_MANY_PAGING_FILES ((NTSTATUS) 0xc0000097)
#define STATUS_TOO_MANY_SECRETS ((NTSTATUS) 0xc0000156)
#define STATUS_TOO_MANY_SESSIONS ((NTSTATUS) 0xc00000ce)
#define STATUS_TOO_MANY_SIDS ((NTSTATUS) 0xc000017e)
#define STATUS_TOO_MANY_THREADS ((NTSTATUS) 0xc0000129)
#define STATUS_TRANSACTION_ABORTED ((NTSTATUS) 0xc000020f)
#define STATUS_TRANSACTION_INVALID_ID ((NTSTATUS) 0xc0000214)
#define STATUS_TRANSACTION_INVALID_TYPE ((NTSTATUS) 0xc0000215)
#define STATUS_TRANSACTION_NO_MATCH ((NTSTATUS) 0xc0000212)
#define STATUS_TRANSACTION_NO_RELEASE ((NTSTATUS) 0xc0000211)
#define STATUS_TRANSACTION_RESPONDED ((NTSTATUS) 0xc0000213)
#define STATUS_TRANSACTION_TIMED_OUT ((NTSTATUS) 0xc0000210)
#define STATUS_TRANSPORT_FULL ((NTSTATUS) 0xc00002ca)
#define STATUS_TRUSTED_DOMAIN_FAILURE ((NTSTATUS) 0xc000018c)
#define STATUS_TRUSTED_RELATIONSHIP_FAILURE ((NTSTATUS) 0xc000018d)
#define STATUS_TRUST_FAILURE ((NTSTATUS) 0xc0000190)
#define STATUS_UNABLE_TO_DECOMMIT_VM ((NTSTATUS) 0xc000002c)
#define STATUS_UNABLE_TO_DELETE_SECTION ((NTSTATUS) 0xc000001b)
#define STATUS_UNABLE_TO_FREE_VM ((NTSTATUS) 0xc000001a)
#define STATUS_UNABLE_TO_LOCK_MEDIA ((NTSTATUS) 0xc0000175)
#define STATUS_UNABLE_TO_UNLOAD_MEDIA ((NTSTATUS) 0xc0000176)
#define STATUS_UNDEFINED_CHARACTER ((NTSTATUS) 0xc0000163)
#define STATUS_UNEXPECTED_IO_ERROR ((NTSTATUS) 0xc00000e9)
#define STATUS_UNEXPECTED_MM_CREATE_ERR ((NTSTATUS) 0xc00000ea)
#define STATUS_UNEXPECTED_MM_EXTEND_ERR ((NTSTATUS) 0xc00000ec)
#define STATUS_UNEXPECTED_MM_MAP_ERROR ((NTSTATUS) 0xc00000eb)
#define STATUS_UNEXPECTED_NETWORK_ERROR ((NTSTATUS) 0xc00000c4)
#define STATUS_UNHANDLED_EXCEPTION ((NTSTATUS) 0xc0000144)
#define STATUS_UNKNOWN_REVISION ((NTSTATUS) 0xc0000058)
#define STATUS_UNMAPPABLE_CHARACTER ((NTSTATUS) 0xc0000162)
#define STATUS_UNRECOGNIZED_MEDIA ((NTSTATUS) 0xc0000014)
#define STATUS_UNRECOGNIZED_VOLUME ((NTSTATUS) 0xc000014f)
#define STATUS_UNSUCCESSFUL ((NTSTATUS) 0xc0000001)
#define STATUS_UNSUPPORTED_COMPRESSION ((NTSTATUS) 0xc000025f)
#define STATUS_UNWIND ((NTSTATUS) 0xc0000027)
#define STATUS_USER_EXISTS ((NTSTATUS) 0xc0000063)
#define STATUS_USER_MAPPED_FILE ((NTSTATUS) 0xc0000243)
#define STATUS_USER_SESSION_DELETED ((NTSTATUS) 0xc0000203)
#define STATUS_VALIDATE_CONTINUE ((NTSTATUS) 0xc0000271)
#define STATUS_VARIABLE_NOT_FOUND ((NTSTATUS) 0xc0000100)
#define STATUS_VDM_HARD_ERROR ((NTSTATUS) 0xc000021d)
#define STATUS_VIRTUAL_CIRCUIT_CLOSED ((NTSTATUS) 0xc00000d6)
#define STATUS_VOLUME_DISMOUNTED ((NTSTATUS) 0xc000026e)
#define STATUS_VOLUME_NOT_UPGRADED ((NTSTATUS) 0xc000029c)
#define STATUS_WMI_GUID_NOT_FOUND ((NTSTATUS) 0xc0000295)
#define STATUS_WMI_INSTANCE_NOT_FOUND ((NTSTATUS) 0xc0000296)
#define STATUS_WMI_ITEMID_NOT_FOUND ((NTSTATUS) 0xc0000297)
#define STATUS_WMI_NOT_SUPPORTED ((NTSTATUS) 0xc00002dd)
#define STATUS_WMI_READ_ONLY ((NTSTATUS) 0xc00002c6)
#define STATUS_WMI_SET_FAILURE ((NTSTATUS) 0xc00002c7)
#define STATUS_WMI_TRY_AGAIN ((NTSTATUS) 0xc0000298)
#define STATUS_WORKING_SET_QUOTA ((NTSTATUS) 0xc00000a1)
#define STATUS_WRONG_EFS ((NTSTATUS) 0xc000028f)
#define STATUS_WRONG_PASSWORD_CORE ((NTSTATUS) 0xc0000149)
#define STATUS_WRONG_PASSWORD ((NTSTATUS) 0xc000006a)
#define STATUS_WRONG_VOLUME ((NTSTATUS) 0xc0000012)
#define STATUS_WX86_FLOAT_STACK_CHECK ((NTSTATUS) 0xc0000270)
#define STATUS_WX86_INTERNAL_ERROR ((NTSTATUS) 0xc000026f)
/* End known error codes in range 0-1024 */


#endif /* __ERROR_NTSTATUS__ */

/* Win32 codes*/
#ifdef __ERROR_WIN32__
#define ERROR_SUCCESS              0
#define ERROR_INVALID_FUNCTION     1
#define ERROR_ACCESS_DENIED        5
#define ERROR_OUTOFMEMORY          14
#define ERROR_MORE_DATA            234
#define ERROR_INVALID_LEVEL        124
#define ERROR_INVALID_PARAMETER    87
#define ERROR_NO_SUCH_ALIAS        1376
#define ERROR_INVALID_MEMBER       1388
#define ERROR_MEMBER_IN_ALIAS      1378
#define ERROR_NO_SUCH_MEMBER       1387
#define ERROR_MEMBER_NOT_IN_ALIAS  1377
#define ERROR_NONE_MAPPED          1332
/* NetApi error codes */
#define NERR_AccountAlreadyExists  2224
#define NERR_SetupAlreadyJoined    2691
#define NERR_SetupNotJoined        2692

#define ERROR_DS_REFERRAL	      8235
#define ERROR_DS_UNWILLING_TO_PERFORM 8245
#endif

/* Equivalence table*/
#ifdef __ERROR_XMACRO__
#define S STATUS_CODE

S ( STATUS_SUCCESS,                ERROR_SUCCESS,             0      , "Success" )
S ( STATUS_MORE_ENTRIES,           ERROR_MORE_DATA,           EAGAIN , "More data available" )
S ( STATUS_NOT_IMPLEMENTED,        ERROR_INVALID_FUNCTION,    ENOTSUP, "" )
S ( STATUS_INVALID_INFO_CLASS,     -1,                        -1     , "" )
S ( STATUS_INVALID_PARAMETER,      ERROR_INVALID_PARAMETER,   EINVAL , "Invalid parameter passed" )
S ( STATUS_NO_MEMORY,              ERROR_OUTOFMEMORY,         ENOMEM , "Out of memory" )
S ( STATUS_INVALID_SID,            -1,                        EINVAL , "" )
S ( STATUS_INSUFFICIENT_RESOURCES, -1,                        ENOSPC , "" )
S ( STATUS_UNHANDLED_EXCEPTION,    -1,                        -1     , "" ) 
S ( STATUS_ACCESS_DENIED,          ERROR_ACCESS_DENIED,       EACCES , "Access denied" )
S ( STATUS_NONE_MAPPED,            ERROR_NONE_MAPPED,         -1     , "Specified account has no mapping to a valid SID" )
S ( STATUS_CONNECTION_REFUSED,     1225,                      111    , "" )
S ( STATUS_INVALID_ADDRESS,        59,                        EFAULT , "" )
S ( -1,                            NERR_SetupAlreadyJoined,   -1,    "The computer is already joined to domain")



/* Autogenerated from Windows program that prints error codes, then
   filled in by hand with Unix errno codes, descriptions */

S ( STATUS_SOURCE_ELEMENT_EMPTY, 1160, -1, "" )
S ( 0xC00001ef, 317, -1, "" )
S ( STATUS_WORKING_SET_QUOTA, 1453, -1, "" )
S ( 0xC000037b, 317, -1, "" )
S ( 0xC0000179, 317, -1, "" )
S ( 0xC00002f3, -2146893001, -1, "" )
S ( 0xC000032e, 317, -1, "" )
S ( 0xC00001a2, 317, -1, "" )
S ( 0xC0000301, 4207, -1, "" )
S ( STATUS_DISK_CORRUPT_ERROR, 1393, -1, "" )
S ( 0xC000033c, 317, -1, "" )
S ( 0xC00003ba, 317, -1, "" )
S ( STATUS_COULD_NOT_INTERPRET, 317, -1, "" )
S ( 0xC00003ac, 317, -1, "" )
S ( STATUS_FILE_CORRUPT_ERROR, 1392, -1, "" )
S ( 0xC00001f8, 317, -1, "" )
S ( STATUS_NOT_MAPPED_DATA, 487, -1, "" )
S ( 0xC000032d, 317, -1, "" )
S ( STATUS_COMMITMENT_LIMIT, 1455, -1, "" )
S ( STATUS_DLL_INIT_FAILED_LOGOFF, 317, -1, "" )
S ( STATUS_NO_TRUST_LSA_SECRET, 1786, -1, "" )
S ( STATUS_DS_ADMIN_LIMIT_EXCEEDED, 8228, -1, "" )
S ( 0xC0000369, 317, -1, "" )
S ( STATUS_BUFFER_TOO_SMALL, 122, -1, "" )
S ( 0xC0000171, 317, -1, "" )
S ( 0xC0000373, 317, -1, "" )
S ( STATUS_NETLOGON_NOT_STARTED, 1792, -1, "" )
S ( 0xC000032c, 317, -1, "" )
S ( STATUS_FT_ORPHANING, 1117, -1, "" )
S ( STATUS_UNHANDLED_EXCEPTION, 317, -1, "" )
S ( STATUS_DS_HAVE_PRIMARY_MEMBERS, 8521, -1, "" )
S ( STATUS_LUIDS_EXHAUSTED, 1334, -1, "" )
S ( STATUS_FLOAT_MULTIPLE_TRAPS, 317, -1, "" )
S ( 0xC00001bc, 317, -1, "" )
S ( 0xC000037a, 317, -1, "" )
S ( STATUS_PIPE_EMPTY, 232, -1, "" )
S ( STATUS_WMI_INSTANCE_NOT_FOUND, 4201, -1, "" )
S ( 0xC00001c7, 317, -1, "" )
S ( STATUS_FT_MISSING_MEMBER, 1117, -1, "" )
S ( STATUS_FS_DRIVER_REQUIRED, 317, -1, "" )
S ( 0xC00003b1, 317, -1, "" )
S ( STATUS_PROPSET_NOT_FOUND, 1170, -1, "" )
S ( STATUS_NO_MEDIA, 1112, -1, "" )
S ( STATUS_BAD_DEVICE_TYPE, 66, -1, "" )
S ( STATUS_INVALID_GROUP_ATTRIBUTES, 1345, -1, "" )
S ( STATUS_CANT_DISABLE_MANDATORY, 1310, -1, "" )
S ( 0xC00003ef, 317, -1, "" )
S ( 0xC00003fc, 317, -1, "" )
S ( STATUS_POLICY_ONLY_IN_DS, 8220, -1, "" )
S ( STATUS_VOLUME_NOT_UPGRADED, ERROR_INVALID_FUNCTION, -1, "" )
S ( 0xC00003b9, 317, -1, "" )
S ( STATUS_PASSWORD_EXPIRED, 1330, -1, "" )
S ( 0xC0000318, 317, -1, "" )
S ( STATUS_DISK_RESET_FAILED, 1128, -1, "" )
S ( STATUS_TRANSACTION_NO_RELEASE, 59, -1, "" )
S ( 0xC0000312, 317, -1, "" )
S ( STATUS_PNP_RESTART_ENUMERATION, 317, -1, "" )
S ( STATUS_INVALID_IMAGE_FORMAT, 193, -1, "" )
S ( 0xC00003fb, 317, -1, "" )
S ( 0xC00001de, 317, -1, "" )
S ( STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY, 8548, -1, "" )
S ( STATUS_INVALID_PARAMETER_10, 87, -1, "" )
S ( STATUS_NO_SUCH_GROUP, 1319, -1, "" )
S ( STATUS_INVALID_MEMBER, ERROR_INVALID_MEMBER, -1, "Requested member is invalid" )
S ( STATUS_INVALID_SECURITY_DESCR, 1338, -1, "" )
S ( 0xC000034f, 317, -1, "" )
S ( STATUS_OBJECT_PATH_SYNTAX_BAD, 161, -1, "" )
S ( 0xC00003d1, 317, -1, "" )
S ( STATUS_DOMAIN_CTRLR_CONFIG_ERROR, 317, -1, "" )
S ( STATUS_MEMORY_NOT_ALLOCATED, 487, -1, "" )
S ( STATUS_VIRTUAL_CIRCUIT_CLOSED, 240, -1, "" )
S ( STATUS_REQUEST_NOT_ACCEPTED, 71, -1, "" )
S ( STATUS_ABIOS_LID_NOT_EXIST, 317, -1, "" )
S ( 0xC00001ba, 317, -1, "" )
S ( STATUS_NO_MATCH, 1169, -1, "" )
S ( 0xC0000385, -2146435028, -1, "" )
S ( STATUS_REPLY_MESSAGE_MISMATCH, 317, -1, "" )
S ( STATUS_MUTANT_NOT_OWNED, 288, -1, "" )
S ( 0xC00003b4, 317, -1, "" )
S ( STATUS_REGISTRY_QUOTA_LIMIT, 317, -1, "" )
S ( 0xC000027b, 317, -1, "" )
S ( STATUS_UNEXPECTED_MM_CREATE_ERR, 317, -1, "" )
S ( 0xC00001e5, 317, -1, "" )
S ( STATUS_PROCEDURE_NOT_FOUND, 127, -1, "" )
S ( STATUS_UNRECOGNIZED_MEDIA, 1785, -1, "" )
S ( STATUS_INVALID_LDT_SIZE, 317, -1, "" )
S ( STATUS_INVALID_BLOCK_LENGTH, 1106, -1, "" )
S ( STATUS_GUIDS_EXHAUSTED, 259, -1, "" )
S ( 0xC00001d8, 317, -1, "" )
S ( STATUS_DS_NO_ATTRIBUTE_OR_VALUE, 8202, -1, "" )
S ( 0xC0000378, 317, -1, "" )
S ( STATUS_SHARED_POLICY, 8218, -1, "" )
S ( 0xC000037c, 317, -1, "" )
S ( 0xC0000365, 317, -1, "" )
S ( 0xC00001b5, 317, -1, "" )
S ( 0xC000031c, 317, -1, "" )
S ( STATUS_RESOURCE_NAME_NOT_FOUND, 1814, -1, "" )
S ( STATUS_INVALID_PARAMETER_8, 87, -1, "" )
S ( 0xC000034b, 317, -1, "" )
S ( STATUS_DS_CANT_MOD_PRIMARYGROUPID, 8506, -1, "" )
S ( STATUS_WMI_SET_FAILURE, 4214, -1, "" )
S ( 0xC0000323, 317, -1, "" )
S ( STATUS_INVALID_FILE_FOR_SECTION, 193, -1, "" )
S ( 0xC00003d7, 317, -1, "" )
S ( 0xC00003d2, 317, -1, "" )
S ( 0xC0000332, 317, -1, "" )
S ( STATUS_NO_SUCH_ALIAS, ERROR_NO_SUCH_ALIAS, -1, "Alias does not exist" )
S ( STATUS_NO_EFS, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_TOO_MANY_PAGING_FILES, 8, -1, "" )
S ( STATUS_SECTION_NOT_EXTENDED, ERROR_OUTOFMEMORY, -1, "" )
S ( 0xC0000376, 317, -1, "" )
S ( STATUS_NETWORK_UNREACHABLE, 1231, -1, "" )
S ( STATUS_POSSIBLE_DEADLOCK, 1131, -1, "" )
S ( STATUS_SECTION_TOO_BIG, 8, -1, "" )
S ( 0xC0000326, 317, -1, "" )
S ( STATUS_CONNECTION_COUNT_LIMIT, 1238, -1, "" )
S ( STATUS_DS_BUSY, 8206, -1, "" )
S ( 0xC0000362, 1260, -1, "" )
S ( 0xC000037d, 317, -1, "" )
S ( STATUS_UNABLE_TO_UNLOAD_MEDIA, 1109, -1, "" )
S ( STATUS_DS_INVALID_ATTRIBUTE_SYNTAX, 8203, -1, "" )
S ( STATUS_NO_SPOOL_SPACE, 62, -1, "" )
S ( STATUS_NOT_CLIENT_SESSION, 50, -1, "" )
S ( STATUS_INVALID_ACL, 1336, -1, "" )
S ( STATUS_NOT_LOCKED, 158, -1, "" )
S ( STATUS_LOGIN_TIME_RESTRICTION, 1239, -1, "" )
S ( STATUS_DEVICE_CONFIGURATION_ERROR, 87, -1, "" )
S ( 0xC00002f9, -2146892995, -1, "" )
S ( 0xC0000380, -2146434965, -1, "" )
S ( 0xC00002fb, -2146892992, -1, "" )
S ( 0xC00001c5, 317, -1, "" )
S ( STATUS_INSUFF_SERVER_RESOURCES, 1130, -1, "" )
S ( STATUS_FILE_RENAMED, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_UNSUPPORTED_COMPRESSION, 317, -1, "" )
S ( 0xC00003db, 317, -1, "" )
S ( STATUS_PROFILING_NOT_STARTED, 317, -1, "" )
S ( STATUS_REMOTE_SESSION_LIMIT, 1220, -1, "" )
S ( STATUS_BAD_INITIAL_STACK, 1001, -1, "" )
S ( 0xC00001a8, 317, -1, "" )
S ( 0xC00003f1, 317, -1, "" )
S ( STATUS_REINITIALIZATION_NEEDED, 1164, -1, "" )
S ( 0xC00003ca, 317, -1, "" )
S ( 0xC000033b, 317, -1, "" )
S ( STATUS_TOO_MANY_NODES, 68, -1, "" )
S ( 0xC0000314, 317, -1, "" )
S ( STATUS_INVALID_PARAMETER_11, 87, -1, "" )
S ( 0xC00001b2, 317, -1, "" )
S ( STATUS_REGISTRY_CORRUPT, 1009, -1, "" )
S ( STATUS_INVALID_PRIMARY_GROUP, 1308, -1, "" )
S ( 0xC00001a4, 317, -1, "" )
S ( 0xC0000386, -2146893802, -1, "" )
S ( STATUS_TRUST_FAILURE, 1790, -1, "" )
S ( STATUS_IO_DEVICE_ERROR, 1117, -1, "" )
S ( STATUS_FILE_IS_OFFLINE, 4350, -1, "" )
S ( STATUS_POWER_STATE_INVALID, 317, -1, "" )
S ( 0xC00001c2, 317, -1, "" )
S ( STATUS_RXACT_INVALID_STATE, 1369, -1, "" )
S ( STATUS_PWD_TOO_SHORT, 317, -1, "" )
S ( STATUS_DRIVER_CANCEL_TIMEOUT, 317, -1, "" )
S ( STATUS_PAGEFILE_CREATE_FAILED, 317, -1, "" )
S ( STATUS_INVALID_UNWIND_TARGET, 317, -1, "" )
S ( STATUS_TOKEN_ALREADY_IN_USE, 1375, -1, "" )
S ( STATUS_SYNCHRONIZATION_REQUIRED, 317, -1, "" )
S ( STATUS_CONVERT_TO_LARGE, 317, -1, "" )
S ( 0xC00002f7, -2146892997, -1, "" )
S ( STATUS_ABIOS_INVALID_SELECTOR, 317, -1, "" )
S ( 0xC000031f, 317, -1, "" )
S ( 0xC00003e1, 317, -1, "" )
S ( STATUS_DS_NO_RIDS_ALLOCATED, 8208, -1, "" )
S ( STATUS_NO_USER_SESSION_KEY, 1394, -1, "" )
S ( 0xC0000358, 8578, -1, "" )
S ( STATUS_NETWORK_ACCESS_DENIED, 65, -1, "" )
S ( 0xC00001e3, 317, -1, "" )
S ( STATUS_INVALID_NETWORK_RESPONSE, 58, -1, "" )
S ( STATUS_INVALID_QUOTA_LOWER, 317, -1, "" )
S ( 0xC00001ae, 317, -1, "" )
S ( STATUS_BAD_MASTER_BOOT_RECORD, 87, -1, "" )
S ( STATUS_IO_PRIVILEGE_FAILED, 317, -1, "" )
S ( 0xC00003d0, 317, -1, "" )
S ( STATUS_REDIRECTOR_STARTED, 1056, -1, "" )
S ( 0xC0000343, 317, -1, "" )
S ( STATUS_INVALID_OPLOCK_PROTOCOL, 301, -1, "" )
S ( 0xC000036b, 1275, -1, "" )
S ( 0xC0000288, 317, -1, "" )
S ( 0xC00001c4, 317, -1, "" )
S ( 0xC00003e4, 317, -1, "" )
S ( 0xC00002f5, -2146892999, -1, "" )
S ( STATUS_PASSWORD_RESTRICTION, 1325, -1, "" )
S ( STATUS_INSUFFICIENT_POWER, 317, -1, "" )
S ( 0xC0000384, -2146893811, -1, "" )
S ( STATUS_PRINT_QUEUE_FULL, 61, -1, "" )
S ( 0xC00002ff, 1255, -1, "" )
S ( STATUS_SHARING_PAUSED, 70, -1, "" )
S ( STATUS_LOGON_FAILURE, 1326, -1, "" )
S ( STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT, 1807, -1, "" )
S ( STATUS_PARTITION_FAILURE, 1105, -1, "" )
S ( 0xC00001ac, 317, -1, "" )
S ( 0xC00003f7, 317, -1, "" )
S ( STATUS_DS_SENSITIVE_GROUP_VIOLATION, 8505, -1, "" )
S ( STATUS_CONTROL_C_EXIT, 317, -1, "" )
S ( STATUS_INVALID_PARAMETER_1, 87, -1, "" )
S ( STATUS_CANCELLED, 995, -1, "" )
S ( 0xC00001aa, 317, -1, "" )
S ( 0xC00003a5, 317, -1, "" )
S ( STATUS_NO_TRACKING_SERVICE, 1172, -1, "" )
S ( 0xC000033a, 317, -1, "" )
S ( STATUS_ALLOCATE_BUCKET, 317, -1, "" )
S ( 0xC0000367, 317, -1, "" )
S ( 0xC00003f8, 317, -1, "" )
S ( 0xC0000317, 317, -1, "" )
S ( 0xC000032f, 317, -1, "" )
S ( 0xC0000327, 317, -1, "" )
S ( STATUS_MUTUAL_AUTHENTICATION_FAILED, 1397, -1, "" )
S ( STATUS_BACKUP_CONTROLLER, 317, -1, "" )
S ( 0xC000038b, 1268, -1, "" )
S ( 0xC0000289, 317, -1, "" )
S ( STATUS_RXACT_COMMIT_FAILURE, 1370, -1, "" )
S ( 0xC00001c9, 317, -1, "" )
S ( 0xC00001fe, 317, -1, "" )
S ( 0xC00003a2, 317, -1, "" )
S ( STATUS_ORDINAL_NOT_FOUND, 182, -1, "" )
S ( STATUS_NO_EVENT_PAIR, 317, -1, "" )
S ( STATUS_IMAGE_MP_UP_MISMATCH, 193, -1, "" )
S ( 0xC0000344, 317, -1, "" )
S ( STATUS_LOGON_SERVER_CONFLICT, 317, -1, "" )
S ( STATUS_NOT_COMMITTED, 487, -1, "" )
S ( 0xC00001b6, 317, -1, "" )
S ( STATUS_BAD_TOKEN_TYPE, 1349, -1, "" )
S ( 0xC00003eb, 317, -1, "" )
S ( STATUS_INVALID_PARAMETER_2, 87, -1, "" )
S ( 0xC00001a5, 317, -1, "" )
S ( 0xC0000390, 317, -1, "" )
S ( STATUS_INVALID_PARAMETER_7, 87, -1, "" )
S ( STATUS_NO_BROWSER_SERVERS_FOUND, 6118, -1, "" )
S ( STATUS_LPC_REPLY_LOST, 1359, -1, "" )
S ( 0xC00003bc, 317, -1, "" )
S ( 0xC00001f4, 317, -1, "" )
S ( 0xC000039b, 317, -1, "" )
S ( 0xC0000398, 317, -1, "" )
S ( 0xC0000302, 4212, -1, "" )
S ( STATUS_SHARED_IRQ_BUSY, 1119, -1, "" )
S ( STATUS_REMOTE_RESOURCES, 51, -1, "" )
S ( 0xC00003df, 317, -1, "" )
S ( STATUS_NO_TRUST_SAM_ACCOUNT, 1787, -1, "" )
S ( STATUS_SECTION_NOT_IMAGE, 87, -1, "" )
S ( 0xC00001f2, 317, -1, "" )
S ( STATUS_WMI_GUID_NOT_FOUND, 4200, -1, "" )
S ( 0xC00001d0, 317, -1, "" )
S ( 0xC00003b2, 317, -1, "" )
S ( STATUS_DISK_RECALIBRATE_FAILED, 1126, -1, "" )
S ( 0xC00003a0, 317, -1, "" )
S ( STATUS_INVALID_ADDRESS_WILDCARD, 1214, -1, "" )
S ( STATUS_VOLUME_DISMOUNTED, 21, -1, "" )
S ( 0xC00002fd, -2146892990, -1, "" )
S ( 0xC000039d, 317, -1, "" )
S ( STATUS_SERVER_NOT_DISABLED, 1342, -1, "" )
S ( STATUS_OPLOCK_NOT_GRANTED, 300, -1, "" )
S ( STATUS_BAD_LOGON_SESSION_STATE, 1365, -1, "" )
S ( 0xC000038f, 317, -1, "" )
S ( 0xC00003b8, 317, -1, "" )
S ( 0xC0000381, -2146434964, -1, "" )
S ( STATUS_NOT_SAME_DEVICE, 17, -1, "" )
S ( STATUS_DEVICE_DATA_ERROR, 23, -1, "" )
S ( STATUS_TOO_MANY_NAMES, 68, -1, "" )
S ( 0xC0000395, 317, -1, "" )
S ( 0xC0000370, 317, -1, "" )
S ( 0xC00003a6, 317, -1, "" )
S ( STATUS_NOLOGON_SERVER_TRUST_ACCOUNT, 1809, -1, "" )
S ( STATUS_REPARSE_ATTRIBUTE_CONFLICT, 4391, -1, "" )
S ( STATUS_PIPE_CLOSING, 232, -1, "" )
S ( STATUS_QUOTA_EXCEEDED, 1816, -1, "" )
S ( STATUS_SUSPEND_COUNT_EXCEEDED, 156, -1, "" )
S ( STATUS_DS_NO_MORE_RIDS, 8209, -1, "" )
S ( 0xC00001eb, 317, -1, "" )
S ( 0xC00001d2, 317, -1, "" )
S ( STATUS_FILE_ENCRYPTED, 6002, -1, "" )
S ( STATUS_EA_TOO_LARGE, 255, -1, "" )
S ( 0xC0000353, 317, -1, "" )
S ( STATUS_ACCOUNT_RESTRICTION, 1327, -1, "" )
S ( 0xC0000391, 317, -1, "" )
S ( 0xC0000342, 317, -1, "" )
S ( STATUS_INVALID_PARAMETER_12, 87, -1, "" )
S ( STATUS_ILLEGAL_ELEMENT_ADDRESS, 1162, -1, "" )
S ( 0xC0000294, 317, -1, "" )
S ( STATUS_INVALID_LDT_OFFSET, 317, -1, "" )
S ( STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER, 8516, -1, "" )
S ( 0xC000032a, 317, -1, "" )
S ( 0xC00003b0, 317, -1, "" )
S ( STATUS_JOURNAL_DELETE_IN_PROGRESS, 1178, -1, "" )
S ( 0xC0000200, 317, -1, "" )
S ( 0xC00001c8, 317, -1, "" )
S ( 0xC00003bf, 317, -1, "" )
S ( 0xC00003c6, 317, -1, "" )
S ( 0xC00003d8, 317, -1, "" )
S ( 0xC000037e, 317, -1, "" )
S ( STATUS_MUTANT_LIMIT_EXCEEDED, 317, -1, "" )
S ( STATUS_FLOPPY_UNKNOWN_ERROR, 1124, -1, "" )
S ( STATUS_INVALID_PLUGPLAY_DEVICE_PATH, 317, -1, "" )
S ( STATUS_ARRAY_BOUNDS_EXCEEDED, -1073741684, -1, "" )
S ( STATUS_INVALID_LEVEL, ERROR_INVALID_LEVEL, -1, "Unsupported level requested" )
S ( 0xC000030b, -2147286261, -1, "" )
S ( 0xC00003e2, 317, -1, "" )
S ( STATUS_NOT_REGISTRY_FILE, 1017, -1, "" )
S ( 0xC00002c0, 317, -1, "" )
S ( STATUS_WX86_INTERNAL_ERROR, 317, -1, "" )
S ( 0xC00002f4, -2146893000, -1, "" )
S ( STATUS_TIMER_NOT_CANCELED, 317, -1, "" )
S ( STATUS_PORT_DISCONNECTED, 6, -1, "" )
S ( STATUS_DATA_ERROR, 23, -1, "" )
S ( 0xC000033d, 317, -1, "" )
S ( STATUS_TIMER_RESOLUTION_NOT_SET, 317, -1, "" )
S ( STATUS_DISK_OPERATION_FAILED, 1127, -1, "" )
S ( STATUS_CLIENT_SERVER_PARAMETERS_INVALID, 317, -1, "" )
S ( 0xC00001bb, 317, -1, "" )
S ( STATUS_RANGE_NOT_FOUND, 317, -1, "" )
S ( 0xC00002bd, 317, -1, "" )
S ( STATUS_NETWORK_BUSY, 54, -1, "" )
S ( STATUS_ACCESS_VIOLATION, 998, -1, "" )
S ( STATUS_UNABLE_TO_DELETE_SECTION, 87, -1, "" )
S ( STATUS_BAD_INITIAL_PC, 193, -1, "" )
S ( STATUS_CANT_OPEN_ANONYMOUS, 1347, -1, "" )
S ( STATUS_INVALID_CID, 87, -1, "" )
S ( 0xC00001e9, 317, -1, "" )
S ( STATUS_NO_LOGON_SERVERS, 1311, -1, "" )
S ( 0xC00001b8, 317, -1, "" )
S ( 0xC0000339, 317, -1, "" )
S ( 0xC00003ed, 317, -1, "" )
S ( STATUS_BAD_WORKING_SET_LIMIT, 87, -1, "" )
S ( STATUS_PRIVILEGED_INSTRUCTION, -1073741674, -1, "" )
S ( STATUS_IO_REPARSE_TAG_INVALID, 4393, -1, "" )
S ( STATUS_APP_INIT_FAILURE, 317, -1, "" )
S ( STATUS_DEVICE_POWER_FAILURE, 21, -1, "" )
S ( STATUS_SERVER_DISABLED, 1341, -1, "" )
S ( 0xC00002bf, 317, -1, "" )
S ( 0xC000030f, 317, -1, "" )
S ( STATUS_CONNECTION_ABORTED, 1236, ETIMEDOUT, "The connection timed out." )
S ( STATUS_PORT_CONNECTION_REFUSED, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_WX86_FLOAT_STACK_CHECK, 317, -1, "" )
S ( 0xC00003de, 317, -1, "" )
S ( STATUS_DS_INVALID_GROUP_TYPE, 8513, -1, "" )
S ( STATUS_NAME_TOO_LONG, 206, -1, "" )
S ( STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER, 8518, -1, "" )
S ( 0xC00003a8, 317, -1, "" )
S ( STATUS_REG_NAT_CONSUMPTION, 1261, -1, "" )
S ( STATUS_ADDRESS_ALREADY_EXISTS, 52, -1, "" )
S ( STATUS_WMI_READ_ONLY, 4213, -1, "" )
S ( STATUS_ACCESS_DENIED, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_INVALID_DOMAIN_ROLE, 1354, -1, "" )
S ( STATUS_INVALID_IMAGE_WIN_16, 193, -1, "" )
S ( STATUS_END_OF_FILE, 38, -1, "" )
S ( STATUS_DUPLICATE_NAME, 52, -1, "" )
S ( 0xC0000319, 317, -1, "" )
S ( STATUS_NOT_SUPPORTED_ON_SBS, 1254, -1, "" )
S ( 0xC000030e, 317, -1, "" )
S ( STATUS_USER_MAPPED_FILE, 1224, -1, "" )
S ( 0xC00003a9, 317, -1, "" )
S ( 0xC0000357, 8572, -1, "" )
S ( 0xC00001c3, 317, -1, "" )
S ( STATUS_PARITY_ERROR, -1073741781, -1, "" )
S ( STATUS_DOMAIN_EXISTS, 1356, -1, "" )
S ( STATUS_FLOAT_INEXACT_RESULT, -1073741681, -1, "" )
S ( STATUS_INVALID_IMAGE_NOT_MZ, 193, -1, "" )
S ( 0xC0000349, 317, -1, "" )
S ( STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER, 8520, -1, "" )
S ( STATUS_FLOAT_INVALID_OPERATION, -1073741680, -1, "" )
S ( STATUS_IO_REPARSE_TAG_MISMATCH, 4394, -1, "" )
S ( 0xC00001e1, 317, -1, "" )
S ( 0xC0000356, -1073151999, -1, "" )
S ( STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED, 8557, -1, "" )
S ( 0xC000038a, 1267, -1, "" )
S ( STATUS_CANT_TERMINATE_SELF, 317, -1, "" )
S ( 0xC0000201, 317, -1, "" )
S ( STATUS_SECRET_TOO_LONG, 1382, -1, "" )
S ( 0xC00001d7, 317, -1, "" )
S ( STATUS_MAPPED_FILE_SIZE_ZERO, 1006, -1, "" )
S ( STATUS_TRANSACTION_TIMED_OUT, 59, -1, "" )
S ( 0xC0000389, 1266, -1, "" )
S ( STATUS_CANT_ENABLE_DENY_ONLY, 317, -1, "" )
S ( 0xC000019d, 317, -1, "" )
S ( STATUS_NO_SUCH_FILE, 2, ENOENT, "" )
S ( 0xC00003c1, 317, -1, "" )
S ( STATUS_INVALID_PARAMETER_3, 87, -1, "" )
S ( 0xC0000337, 317, -1, "" )
S ( STATUS_PROFILING_AT_LIMIT, 317, -1, "" )
S ( 0xC00001d9, 317, -1, "" )
S ( 0xC00003bb, 317, -1, "" )
S ( 0xC00001f9, 317, -1, "" )
S ( STATUS_NO_TOKEN, 1008, -1, "" )
S ( 0xC000032b, 317, -1, "" )
S ( STATUS_INVALID_VIEW_SIZE, ERROR_ACCESS_DENIED, -1, "" )
S ( 0xC000019f, 317, -1, "" )
S ( 0xC0000036, 317, -1, "" )
S ( 0xC000039f, 317, -1, "" )
S ( 0xC00001ee, 317, -1, "" )
S ( STATUS_REQUEST_ABORTED, 1235, -1, "" )
S ( STATUS_LOGON_TYPE_NOT_GRANTED, 1385, -1, "" )
S ( STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT, 317, -1, "" )
S ( STATUS_PNP_REBOOT_REQUIRED, 317, -1, "" )
S ( 0xC00001a9, 317, -1, "" )
S ( STATUS_NO_SECURITY_ON_OBJECT, 1350, -1, "" )
S ( 0xC00003bd, 317, -1, "" )
S ( 0xC00003c3, 317, -1, "" )
S ( STATUS_TRANSACTION_RESPONDED, 59, -1, "" )
S ( STATUS_ABIOS_NOT_PRESENT, 317, -1, "" )
S ( STATUS_DATA_LATE_ERROR, 1117, -1, "" )
S ( STATUS_POLICY_OBJECT_NOT_FOUND, 8219, -1, "" )
S ( STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER, 8517, -1, "" )
S ( 0xC00001be, 317, -1, "" )
S ( 0xC00003d5, 317, -1, "" )
S ( STATUS_ACCOUNT_LOCKED_OUT, 1909, -1, "" )
S ( STATUS_VDM_HARD_ERROR, 317, -1, "" )
S ( 0xC00002fa, -2146892994, -1, "" )
S ( STATUS_RESOURCE_DATA_NOT_FOUND, 1812, -1, "" )
S ( 0xC000024c, 317, -1, "" )
S ( STATUS_UNEXPECTED_IO_ERROR, 317, -1, "" )
S ( 0xC0000383, -2146435060, -1, "" )
S ( STATUS_FILE_INVALID, 1006, -1, "" )
S ( STATUS_NOT_LOGON_PROCESS, 1362, -1, "" )
S ( 0xC00002ee, -2146893005, -1, "" )
S ( 0xC00003aa, 317, -1, "" )
S ( STATUS_EAS_NOT_SUPPORTED, 282, -1, "" )
S ( STATUS_SPECIAL_GROUP, 1372, -1, "" )
S ( STATUS_TOO_LATE, 19, -1, "" )
S ( 0xC00003e0, 317, -1, "" )
S ( STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT, 1808, -1, "" )
S ( STATUS_WRONG_PASSWORD_CORE, ERROR_INVALID_PARAMETER, EINVAL, "" )
S ( STATUS_DS_CANT_MOD_OBJ_CLASS, 8215, -1, "" )
S ( STATUS_WRONG_VOLUME, 34, -1, "" )
S ( 0xC00001e8, 317, -1, "" )
S ( 0xC0000361, 1260, -1, "" )
S ( STATUS_CRC_ERROR, 23, -1, "" )
S ( STATUS_PORT_MESSAGE_TOO_LONG, 317, -1, "" )
S ( STATUS_DRIVER_UNABLE_TO_LOAD, 2001, -1, "" )
S ( 0xC00003d9, 317, -1, "" )
S ( 0xC00003f4, 317, -1, "" )
S ( STATUS_FLOPPY_WRONG_CYLINDER, 1123, -1, "" )
S ( STATUS_WMI_TRY_AGAIN, 4203, -1, "" )
S ( STATUS_TRUSTED_RELATIONSHIP_FAILURE, 1789, -1, "" )
S ( 0xC00001e4, 317, -1, "" )
S ( STATUS_INVALID_IMAGE_NE_FORMAT, 193, -1, "" )
S ( 0xC00001dc, 317, -1, "" )
S ( STATUS_LINK_FAILED, 59, -1, "" )
S ( STATUS_DLL_NOT_FOUND, 126, -1, "" )
S ( 0xC000038e, 317, -1, "" )
S ( STATUS_ILLEGAL_INSTRUCTION, -1073741795, -1, "" )
S ( STATUS_ONLY_IF_CONNECTED, 1251, -1, "" )
S ( STATUS_TRANSACTION_NO_MATCH, 59, -1, "" )
S ( STATUS_NO_MORE_MATCHES, 317, -1, "" )
S ( 0xC0000325, 317, -1, "" )
S ( STATUS_CONNECTION_INVALID, 1229, -1, "" )
S ( STATUS_UNABLE_TO_LOCK_MEDIA, 1108, -1, "" )
S ( 0xC00002f1, -2146893003, -1, "" )
S ( STATUS_BAD_COMPRESSION_BUFFER, 317, -1, "" )
S ( 0xC00001cd, 317, -1, "" )
S ( STATUS_MEMBER_NOT_IN_GROUP, 1321, -1, "" )
S ( 0xC00001cf, 317, -1, "" )
S ( 0xC00003a1, 317, -1, "" )
S ( STATUS_DEVICE_NOT_PARTITIONED, 1107, -1, "" )
S ( STATUS_INVALID_PORT_ATTRIBUTES, 317, -1, "" )
S ( STATUS_DRIVER_INTERNAL_ERROR, 1117, -1, "" )
S ( STATUS_IO_REPARSE_TAG_NOT_HANDLED, 1920, -1, "" )
S ( STATUS_LOCAL_DISCONNECT, 64, -1, "" )
S ( STATUS_WMI_ITEMID_NOT_FOUND, 4202, -1, "" )
S ( STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER, 8519, -1, "" )
S ( STATUS_SAM_INIT_FAILURE, 8541, -1, "" )
S ( STATUS_FILE_IS_A_DIRECTORY, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_INTEGER_OVERFLOW, 534, -1, "" )
S ( 0xC0000338, 317, -1, "" )
S ( 0xC00002ef, -2146893004, -1, "" )
S ( STATUS_CHILD_MUST_BE_VOLATILE, 1021, -1, "" )
S ( 0xC0000351, -2146892989, -1, "" )
S ( 0xC00003cc, 317, -1, "" )
S ( STATUS_REMOTE_STORAGE_MEDIA_ERROR, 4352, -1, "" )
S ( STATUS_ACCOUNT_DISABLED, 1331, -1, "" )
S ( STATUS_DRIVER_ORDINAL_NOT_FOUND, 182, -1, "" )
S ( 0xC000033f, 317, -1, "" )
S ( 0xC0000393, 317, -1, "" )
S ( STATUS_CANNOT_LOAD_REGISTRY_FILE, 317, -1, "" )
S ( STATUS_ILLEGAL_FLOAT_CONTEXT, 317, -1, "" )
S ( STATUS_HANDLE_NOT_CLOSABLE, 6, -1, "" )
S ( STATUS_CTL_FILE_NOT_SUPPORTED, 50, -1, "" )
S ( STATUS_DRIVER_FAILED_SLEEP, 317, -1, "" )
S ( 0xC00001e2, 317, -1, "" )
S ( STATUS_INVALID_IMAGE_PROTECT, 193, -1, "" )
S ( STATUS_CORRUPT_SYSTEM_FILE, 317, -1, "" )
S ( STATUS_RESOURCE_LANG_NOT_FOUND, 1815, -1, "" )
S ( STATUS_FLOAT_STACK_CHECK, -1073741678, -1, "" )
S ( STATUS_WMI_NOT_SUPPORTED, 50, -1, "" )
S ( 0xC000024e, 317, -1, "" )
S ( STATUS_ADDRESS_ALREADY_ASSOCIATED, 1227, -1, "" )
S ( 0xC00001d1, 317, -1, "" )
S ( 0xC00003fd, 317, -1, "" )
S ( STATUS_OBJECT_NAME_NOT_FOUND, 2, -1, "" )
S ( STATUS_BAD_NETWORK_PATH, 53, -1, "" )
S ( 0xC000035a, 193, -1, "" )
S ( STATUS_LM_CROSS_ENCRYPTION_REQUIRED, 1390, -1, "" )
S ( STATUS_UNABLE_TO_DECOMMIT_VM, 487, -1, "" )
S ( 0xC00001b9, 317, -1, "" )
S ( STATUS_TOO_MANY_OPENED_FILES, 4, -1, "" )
S ( 0xC000035f, 317, -1, "" )
S ( STATUS_FLOAT_UNDERFLOW, -1073741677, -1, "" )
S ( STATUS_PORT_UNREACHABLE, 1234, -1, "" )
S ( 0xC000035d, 317, -1, "" )
S ( STATUS_TOO_MANY_SIDS, 1389, -1, "" )
S ( 0xC00001ec, 317, -1, "" )
S ( STATUS_NONEXISTENT_SECTOR, 27, -1, "" )
S ( 0xC00002ed, 8562, -1, "" )
S ( STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED, 8204, -1, "" )
S ( STATUS_INVALID_INFO_CLASS, 87, -1, "" )
S ( STATUS_ILLEGAL_FUNCTION, ERROR_INVALID_FUNCTION, -1, "" )
S ( STATUS_ILLEGAL_DLL_RELOCATION, 317, -1, "" )
S ( STATUS_INVALID_PAGE_PROTECTION, 87, -1, "" )
S ( STATUS_CONFLICTING_ADDRESSES, 487, -1, "" )
S ( 0xC000035e, 317, -1, "" )
S ( STATUS_EA_CORRUPT_ERROR, 1392, -1, "" )
S ( 0xC00003c8, 317, -1, "" )
S ( STATUS_OBJECT_TYPE_MISMATCH, 6, -1, "" )
S ( STATUS_FLOPPY_ID_MARK_NOT_FOUND, 1122, -1, "" )
S ( 0xC0000170, 317, -1, "" )
S ( 0xC000031e, 317, -1, "" )
S ( STATUS_TOO_MANY_SESSIONS, 69, -1, "" )
S ( 0xC000024a, 317, -1, "" )
S ( STATUS_FILE_NOT_ENCRYPTED, 6007, -1, "" )
S ( STATUS_DS_CANT_ON_RDN, 8214, -1, "" )
S ( 0xC00002f8, -2146892996, -1, "" )
S ( STATUS_RESOURCE_TYPE_NOT_FOUND, 1813, -1, "" )
S ( STATUS_FLOAT_MULTIPLE_FAULTS, 317, -1, "" )
S ( STATUS_USER_SESSION_DELETED, 59, -1, "" )
S ( STATUS_NO_RECOVERY_POLICY, ERROR_ACCESS_DENIED, -1, "" )
S ( 0xC0000372, 317, -1, "" )
S ( 0xC00001a0, 317, -1, "" )
S ( 0xC0000341, 317, -1, "" )
S ( 0xC00001fd, 317, -1, "" )
S ( STATUS_FREE_VM_NOT_AT_BASE, 487, -1, "" )
S ( STATUS_TOO_MANY_ADDRESSES, 68, -1, "" )
S ( STATUS_KEY_HAS_CHILDREN, 1020, -1, "" )
S ( STATUS_REMOTE_STORAGE_NOT_ACTIVE, 4351, -1, "" )
S ( STATUS_NOT_A_DIRECTORY, 267, -1, "" )
S ( STATUS_NOT_SERVER_SESSION, 50, -1, "" )
S ( STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS, 8549, -1, "" )
S ( STATUS_SAM_NEED_BOOTKEY_PASSWORD, 8529, -1, "" )
S ( 0xC000033e, 317, -1, "" )
S ( STATUS_DECRYPTION_FAILED, ERROR_ACCESS_DENIED, -1, "" )
S ( 0xC0000322, -2146892984, -1, "" )
S ( 0xC00003be, 317, -1, "" )
S ( STATUS_DFS_EXIT_PATH_FOUND, 3, -1, "" )
S ( STATUS_TRANSPORT_FULL, 4328, -1, "" )
S ( 0xC000030a, -2147286262, -1, "" )
S ( STATUS_MEMBER_NOT_IN_ALIAS, ERROR_MEMBER_NOT_IN_ALIAS, -1, "Specified account is not an alias member" )
S ( 0xC00002bc, 317, -1, "" )
S ( 0xC0000320, 1263, -1, "" )
S ( STATUS_TOO_MANY_LINKS, 1142, -1, "" )
S ( STATUS_DIRECTORY_SERVICE_REQUIRED, 8478, -1, "" )
S ( STATUS_CONNECTION_IN_USE, 2404, -1, "" )
S ( STATUS_NO_SUCH_DEVICE, 2, -1, "" )
S ( STATUS_DS_UNAVAILABLE, 8207, -1, "" )
S ( STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS, 8205, -1, "" )
S ( STATUS_INVALID_LOCK_SEQUENCE, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_PRIVILEGE_NOT_HELD, 1314, -1, "" )
S ( STATUS_NT_CROSS_ENCRYPTION_REQUIRED, 1386, -1, "" )
S ( STATUS_EVENTLOG_FILE_CORRUPT, 1500, -1, "" )
S ( STATUS_UNDEFINED_CHARACTER, 317, -1, "" )
S ( STATUS_INVALID_HANDLE, 6, -1, "" )
S ( STATUS_LOG_FILE_FULL, 1502, -1, "" )
S ( STATUS_INVALID_CONNECTION, 59, -1, "" )
S ( STATUS_INVALID_DISPOSITION, -1073741786, -1, "" )
S ( 0xC000024b, 317, -1, "" )
S ( STATUS_INVALID_SID, 1337, -1, "" )
S ( STATUS_NONE_MAPPED, ERROR_NONE_MAPPED, -1, "" )
S ( STATUS_DATA_NOT_ACCEPTED, 317, -1, "" )
S ( STATUS_INVALID_BUFFER_SIZE, 1784, -1, "" )
S ( 0xC00002eb, 317, -1, "" )
S ( 0xC0000340, 317, -1, "" )
S ( 0xC0000363, 1260, -1, "" )
S ( STATUS_REDIRECTOR_NOT_STARTED, 3, -1, "" )
S ( 0xC00001b4, 317, -1, "" )
S ( STATUS_OBJECTID_EXISTS, -1073741269, -1, "" )
S ( 0xC000037f, 317, -1, "" )
S ( 0xC00001af, 317, -1, "" )
S ( 0xC00001cc, 317, -1, "" )
S ( STATUS_INVALID_HW_PROFILE, 317, -1, "" )
S ( STATUS_DS_CANT_START, 8531, -1, "" )
S ( STATUS_TOO_MANY_SECRETS, 1381, -1, "" )
S ( STATUS_BAD_DLL_ENTRYPOINT, 317, -1, "" )
S ( 0xC0000355, 317, -1, "" )
S ( 0xC0000331, 317, -1, "" )
S ( STATUS_FLOAT_OVERFLOW, -1073741679, -1, "" )
S ( STATUS_MISSING_SYSTEMFILE, 317, -1, "" )
S ( STATUS_MAGAZINE_NOT_PRESENT, 1163, -1, "" )
S ( 0xC00002fc, -2146892991, -1, "" )
S ( 0xC000019e, 317, -1, "" )
S ( 0xC00003c9, 317, -1, "" )
S ( 0xC000024f, 317, -1, "" )
S ( STATUS_INVALID_DEVICE_REQUEST, ERROR_INVALID_FUNCTION, -1, "" )
S ( STATUS_OBJECT_NAME_INVALID, 123, -1, "" )
S ( STATUS_NO_SUCH_PACKAGE, 1364, -1, "" )
S ( 0xC00002ba, 317, -1, "" )
S ( STATUS_IMAGE_CHECKSUM_MISMATCH, 193, -1, "" )
S ( STATUS_NOINTERFACE, 317, -1, "" )
S ( STATUS_REPARSE_POINT_NOT_RESOLVED, 1921, -1, "" )
S ( STATUS_LICENSE_VIOLATION, 7054, -1, "" )
S ( STATUS_THREAD_NOT_IN_PROCESS, 317, -1, "" )
S ( 0xC000031d, 317, -1, "" )
S ( STATUS_INVALID_LOGON_TYPE, 1367, -1, "" )
S ( 0xC00001f1, 317, -1, "" )
S ( STATUS_CONNECTION_ACTIVE, 1230, -1, "" )
S ( 0xC0000396, 317, -1, "" )
S ( 0xC00002e9, 1399, -1, "" )
S ( STATUS_SAM_NEED_BOOTKEY_FLOPPY, 8530, -1, "" )
S ( STATUS_INVALID_READ_MODE, 230, -1, "" )
S ( STATUS_INCOMPATIBLE_FILE_MAP, 87, -1, "" )
S ( STATUS_ACCOUNT_EXPIRED, 1793, -1, "" )
S ( STATUS_ILL_FORMED_PASSWORD, 1324, -1, "" )
S ( STATUS_RANGE_LIST_CONFLICT, 317, -1, "" )
S ( STATUS_PROTOCOL_UNREACHABLE, 1233, -1, "" )
S ( 0xC00003ea, 317, -1, "" )
S ( 0xC00001ff, 317, -1, "" )
S ( STATUS_PASSWORD_MUST_CHANGE, 1907, -1, "" )
S ( 0xC00001a3, 317, -1, "" )
S ( STATUS_NO_EAS_ON_FILE, 1392, -1, "" )
S ( STATUS_DS_GC_REQUIRED, 8547, -1, "" )
S ( STATUS_STACK_OVERFLOW_READ, 317, -1, "" )
S ( 0xC00001d3, 317, -1, "" )
S ( STATUS_INSTRUCTION_MISALIGNMENT, 317, -1, "" )
S ( STATUS_NO_CALLBACK_ACTIVE, 317, -1, "" )
S ( STATUS_NOT_MAPPED_VIEW, 487, -1, "" )
S ( 0xC000034a, 317, -1, "" )
S ( STATUS_PROFILING_NOT_STOPPED, 317, -1, "" )
S ( 0xC00001e7, 317, -1, "" )
S ( STATUS_INVALID_LOGON_HOURS, 1328, -1, "" )
S ( 0xC00001a6, 317, -1, "" )
S ( 0xC00001bf, 317, -1, "" )
S ( 0xC0000310, 317, -1, "" )
S ( 0xC0000304, 302, -1, "" )
S ( STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN, 8514, -1, "" )
S ( STATUS_MULTIPLE_FAULT_VIOLATION, 317, -1, "" )
S ( STATUS_INSUFFICIENT_RESOURCES, 1450, -1, "" )
S ( STATUS_NO_SUCH_MEMBER, ERROR_NO_SUCH_MEMBER, -1, "Specified account is not a member" )
S ( STATUS_REMOTE_NOT_LISTENING, 51, -1, "" )
S ( STATUS_SPECIAL_ACCOUNT, 1371, -1, "" )
S ( 0xC0000347, 317, -1, "" )
S ( 0xC0000329, 317, -1, "" )
S ( 0xC000039c, 317, -1, "" )
S ( 0xC00003d4, 317, -1, "" )
S ( 0xC0000303, 4206, -1, "" )
S ( 0xC000027a, 317, -1, "" )
S ( 0xC00003e7, 317, -1, "" )
S ( 0xC00001a7, 317, -1, "" )
S ( STATUS_HOST_UNREACHABLE, 1232, -1, "" )
S ( STATUS_THREAD_IS_TERMINATING, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_SEMAPHORE_LIMIT_EXCEEDED, 298, -1, "" )
S ( STATUS_LOST_WRITEBEHIND_DATA, 317, -1, "" )
S ( 0xC000036e, 317, -1, "" )
S ( 0xC00003d6, 317, -1, "" )
S ( STATUS_KEY_DELETED, 1018, -1, "" )
S ( STATUS_NO_USER_KEYS, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_INVALID_WORKSTATION, 1329, -1, "" )
S ( STATUS_SHARING_VIOLATION, 32, -1, "" )
S ( STATUS_DS_SAM_INIT_FAILURE, 8504, -1, "" )
S ( STATUS_SECTION_PROTECTION, 87, -1, "" )
S ( STATUS_COMMITMENT_MINIMUM, 317, -1, "" )
S ( 0xC00003e9, 317, -1, "" )
S ( STATUS_LOGON_SESSION_COLLISION, 1366, -1, "" )
S ( STATUS_ALIAS_EXISTS, 1379, -1, "" )
S ( STATUS_PIPE_NOT_AVAILABLE, 231, -1, "" )
S ( STATUS_DELETE_PENDING, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_REVISION_MISMATCH, 1306, -1, "" )
S ( STATUS_PIPE_DISCONNECTED, 233, -1, "" )
S ( STATUS_INVALID_ADDRESS_COMPONENT, 1214, -1, "" )
S ( STATUS_INTERNAL_DB_ERROR, 1383, -1, "" )
S ( STATUS_USER_EXISTS, 1316, -1, "" )
S ( STATUS_GENERIC_NOT_MAPPED, 1360, -1, "" )
S ( STATUS_DS_INIT_FAILURE, 8532, -1, "" )
S ( STATUS_DOMAIN_LIMIT_EXCEEDED, 1357, -1, "" )
S ( 0xC0000348, 317, -1, "" )
S ( STATUS_SERVER_SID_MISMATCH, 317, -1, "" )
S ( 0xC00003a4, 317, -1, "" )
S ( STATUS_INTERNAL_DB_CORRUPTION, 1358, -1, "" )
S ( 0xC0000306, -2147286266, -1, "" )
S ( STATUS_IMAGE_ALREADY_LOADED, 1056, -1, "" )
S ( 0xC00001c1, 317, -1, "" )
S ( 0xC00003e5, 317, -1, "" )
S ( STATUS_DOMAIN_TRUST_INCONSISTENT, 1810, -1, "" )
S ( STATUS_NO_SUCH_LOGON_SESSION, 1312, -1, "" )
S ( STATUS_OBJECT_PATH_INVALID, 161, -1, "" )
S ( STATUS_IN_PAGE_ERROR, 999, -1, "" )
S ( STATUS_INVALID_SYSTEM_SERVICE, ERROR_INVALID_FUNCTION, -1, "" )
S ( STATUS_ENTRYPOINT_NOT_FOUND, 127, -1, "" )
S ( STATUS_LICENSE_QUOTA_EXCEEDED, 1395, -1, "" )
S ( STATUS_DUPLICATE_OBJECTID, -1073741270, -1, "" )
S ( 0xC00003b6, 317, -1, "" )
S ( STATUS_JOURNAL_ENTRY_DELETED, 1181, -1, "" )
S ( STATUS_STACK_OVERFLOW, 1001, -1, "" )
S ( 0xC00003cf, 317, -1, "" )
S ( STATUS_INVALID_COMPUTER_NAME, 1210, -1, "" )
S ( STATUS_INVALID_PARAMETER_5, 87, -1, "" )
S ( STATUS_VARIABLE_NOT_FOUND, 203, -1, "" )
S ( STATUS_INVALID_IMAGE_LE_FORMAT, 193, -1, "" )
S ( STATUS_DS_CROSS_DOM_MOVE_FAILED, 8216, -1, "" )
S ( STATUS_JOURNAL_NOT_ACTIVE, 1179, -1, "" )
S ( STATUS_PATH_NOT_COVERED, 1232, -1, "" )
S ( 0xC000027d, 317, -1, "" )
S ( STATUS_INVALID_PARAMETER_MIX, 87, -1, "" )
S ( 0xC0000324, 317, -1, "" )
S ( 0xC00001bd, 317, -1, "" )
S ( STATUS_CANNOT_IMPERSONATE, 1368, -1, "" )
S ( STATUS_FILE_LOCK_CONFLICT, 33, -1, "" )
S ( 0xC0000374, 317, -1, "" )
S ( STATUS_OBJECT_PATH_NOT_FOUND, 3, -1, "" )
S ( STATUS_EVENTLOG_FILE_CHANGED, 1503, -1, "" )
S ( 0xC0000360, 317, -1, "" )
S ( STATUS_ABIOS_LID_ALREADY_OWNED, 317, -1, "" )
S ( STATUS_INVALID_PARAMETER_6, 87, -1, "" )
S ( STATUS_GRACEFUL_DISCONNECT, 1226, -1, "" )
S ( 0xC0000316, 317, -1, "" )
S ( 0xC0000335, 317, -1, "" )
S ( STATUS_BAD_DESCRIPTOR_FORMAT, 1361, -1, "" )
S ( 0xC0000274, 317, -1, "" )
S ( 0xC0000345, 317, -1, "" )
S ( STATUS_IP_ADDRESS_CONFLICT1, 317, -1, "" )
S ( STATUS_INVALID_OWNER, 1307, -1, "" )
S ( STATUS_UNMAPPABLE_CHARACTER, 1113, -1, "" )
S ( 0xC000030d, 317, -1, "" )
S ( 0xC00002f0, 2, -1, "" )
S ( STATUS_LAST_ADMIN, 1322, -1, "" )
S ( STATUS_NO_LOG_SPACE, 1019, -1, "" )
S ( STATUS_NO_LDT, 1444, -1, "" )
S ( STATUS_SYSTEM_IMAGE_BAD_SIGNATURE, 317, -1, "" )
S ( 0xC0000311, 317, -1, "" )
S ( 0xC0000308, -2147286264, -1, "" )
S ( STATUS_NO_IMPERSONATION_TOKEN, 1309, -1, "" )
S ( 0xC000025d, 317, -1, "" )
S ( STATUS_NO_PAGEFILE, 317, -1, "" )
S ( STATUS_DEVICE_ALREADY_ATTACHED, 317, -1, "" )
S ( STATUS_DEVICE_NOT_READY, 21, -1, "" )
S ( STATUS_UNKNOWN_REVISION, 1305, -1, "" )
S ( 0xC000035b, -2146892986, -1, "" )
S ( 0xC00001f7, 317, -1, "" )
S ( STATUS_INVALID_PIPE_STATE, 230, -1, "" )
S ( 0xC00003f6, 317, -1, "" )
S ( 0xC000036f, 1276, -1, "" )
S ( STATUS_NETWORK_CREDENTIAL_CONFLICT, 1219, -1, "" )
S ( 0xC00003c2, 317, -1, "" )
S ( 0xC00001d6, 317, -1, "" )
S ( 0xC0000392, 317, -1, "" )
S ( STATUS_DEVICE_REMOVED, 1617, -1, "" )
S ( STATUS_AGENTS_EXHAUSTED, 259, -1, "" )
S ( STATUS_DRIVER_ENTRYPOINT_NOT_FOUND, 127, -1, "" )
S ( 0xC00003dc, 317, -1, "" )
S ( STATUS_INSTANCE_NOT_AVAILABLE, 231, -1, "" )
S ( STATUS_ENCRYPTION_FAILED, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_BAD_SERVICE_ENTRYPOINT, 317, -1, "" )
S ( STATUS_DATATYPE_MISALIGNMENT_ERROR, 998, -1, "" )
S ( STATUS_NO_SUCH_PRIVILEGE, 1313, -1, "" )
S ( 0xC00003c5, 317, -1, "" )
S ( STATUS_INVALID_DOMAIN_STATE, 1353, -1, "" )
S ( 0xC00003da, 317, -1, "" )
S ( 0xC0000328, 317, -1, "" )
S ( 0xC00001c6, 317, -1, "" )
S ( 0xC00002f2, -2146893002, -1, "" )
S ( 0xC00002ea, 82, -1, "" )
S ( STATUS_LOCK_NOT_GRANTED, 33, -1, "" )
S ( 0xC00001f3, 317, -1, "" )
S ( 0xC00001da, 317, -1, "" )
S ( STATUS_BAD_STACK, 317, -1, "" )
S ( STATUS_ABIOS_INVALID_LID, 317, -1, "" )
S ( STATUS_DS_GC_NOT_AVAILABLE, 8217, -1, "" )
S ( STATUS_SPECIAL_USER, 1373, -1, "" )
S ( STATUS_UNEXPECTED_MM_MAP_ERROR, 317, -1, "" )
S ( STATUS_RECOVERY_FAILURE, 317, -1, "" )
S ( STATUS_NO_MEMORY, 8, -1, "" )
S ( STATUS_IO_TIMEOUT, 121, -1, "" )
S ( STATUS_DLL_INIT_FAILED, 1114, -1, "" )
S ( STATUS_FILE_CLOSED, 6, -1, "" )
S ( 0xC00001df, 317, -1, "" )
S ( 0xC00003dd, 317, -1, "" )
S ( STATUS_ALLOTTED_SPACE_EXCEEDED, 1344, -1, "" )
S ( STATUS_INTEGER_DIVIDE_BY_ZERO, -1073741676, -1, "" )
S ( STATUS_UNEXPECTED_MM_EXTEND_ERR, 317, -1, "" )
S ( 0xC00001f5, 317, -1, "" )
S ( STATUS_DS_RIDMGR_INIT_ERROR, 8211, -1, "" )
S ( STATUS_RESOURCE_NOT_OWNED, 288, -1, "" )
S ( STATUS_INTERNAL_ERROR, 1359, -1, "" )
S ( STATUS_TOO_MANY_CONTEXT_IDS, 1384, -1, "" )
S ( 0xC00003b3, 317, -1, "" )
S ( 0xC00001cb, 317, -1, "" )
S ( STATUS_UNWIND, 317, -1, "" )
S ( STATUS_NOT_A_REPARSE_POINT, 4390, -1, "" )
S ( STATUS_LOGIN_WKSTA_RESTRICTION, 1240, -1, "" )
S ( 0xC000036a, 317, -1, "" )
S ( 0xC000031a, 317, -1, "" )
S ( STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN, 8515, -1, "" )
S ( STATUS_PAGEFILE_QUOTA, 1454, -1, "" )
S ( 0xC0000309, -2147286263, -1, "" )
S ( STATUS_DOMAIN_CONTROLLER_NOT_FOUND, 1908, -1, "" )
S ( STATUS_INVALID_PARAMETER, 87, -1, "" )
S ( STATUS_LOGON_SESSION_EXISTS, 1363, -1, "" )
S ( STATUS_FILE_FORCED_CLOSED, 38, -1, "" )
S ( STATUS_EVENTLOG_CANT_START, 1501, -1, "" )
S ( 0xC0000371, 317, -1, "" )
S ( STATUS_UNEXPECTED_NETWORK_ERROR, 59, -1, "" )
S ( STATUS_BAD_INHERITANCE_ACL, 1340, -1, "" )
S ( 0xC00001fa, 317, -1, "" )
S ( 0xC00001b7, 317, -1, "" )
S ( 0xC00003c4, 317, -1, "" )
S ( STATUS_INVALID_USER_BUFFER, 1784, -1, "" )
S ( 0xC00001e6, 317, -1, "" )
S ( 0xC00001fc, 317, -1, "" )
S ( 0xC00003e3, 317, -1, "" )
S ( 0xC00003ee, 317, -1, "" )
S ( STATUS_PLUGPLAY_NO_DEVICE, 1058, -1, "" )
S ( STATUS_REGISTRY_IO_FAILED, 1016, -1, "" )
S ( STATUS_DEVICE_NOT_CONNECTED, 1167, -1, "" )
S ( 0xC0000307, -2147286265, -1, "" )
S ( 0xC000027e, 317, -1, "" )
S ( 0xC0000336, 317, -1, "" )
S ( 0xC000024d, 317, -1, "" )
S ( STATUS_MEMBER_IN_GROUP, 1320, -1, "" )
S ( STATUS_DS_INCORRECT_ROLE_OWNER, 8210, -1, "" )
S ( STATUS_INVALID_VOLUME_LABEL, 154, -1, "" )
S ( 0xC00003cb, 317, -1, "" )
S ( 0xC000034c, 317, -1, "" )
S ( STATUS_DISK_FULL, 112, -1, "" )
S ( STATUS_TIME_DIFFERENCE_AT_DC, 1398, -1, "" )
S ( 0xC000034d, 317, -1, "" )
S ( 0xC0000364, 1260, -1, "" )
S ( STATUS_CONNECTION_RESET, 64, -1, "" )
S ( 0xC00003cd, 317, -1, "" )
S ( STATUS_NOT_EXPORT_FORMAT, 6008, -1, "" )
S ( 0xC0000399, 317, -1, "" )
S ( 0xC00001db, 317, -1, "" )
S ( 0xC0000315, 317, -1, "" )
S ( 0xC00003ae, 317, -1, "" )
S ( STATUS_UNSUCCESSFUL, 31, -1, "" )
S ( STATUS_TOO_MANY_THREADS, 317, -1, "" )
S ( 0xC0000305, -2147286267, -1, "" )
S ( 0xC00003b7, 317, -1, "" )
S ( 0xC00003ab, 317, -1, "" )
S ( STATUS_DIRECTORY_NOT_EMPTY, 145, -1, "" )
S ( 0xC00003a3, 317, -1, "" )
S ( STATUS_FILE_DELETED, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_NONCONTINUABLE_EXCEPTION, -1073741787, -1, "" )
S ( 0xC00003d3, 317, -1, "" )
S ( 0xC00003a7, 317, -1, "" )
S ( STATUS_FILES_OPEN, 2401, -1, "" )
S ( STATUS_INVALID_VARIANT, 317, -1, "" )
S ( 0xC00003f2, 317, -1, "" )
S ( STATUS_INSUFFICIENT_LOGON_INFO, 317, -1, "" )
S ( STATUS_TRANSACTION_INVALID_TYPE, 59, -1, "" )
S ( STATUS_INVALID_SUB_AUTHORITY, 1335, -1, "" )
S ( 0xC00003f0, 317, -1, "" )
S ( 0xC00001f6, 317, -1, "" )
S ( STATUS_DATA_OVERRUN, 1117, -1, "" )
S ( 0xC0000313, 317, -1, "" )
S ( STATUS_TRANSACTION_INVALID_ID, 59, -1, "" )
S ( 0xC0000382, -2146434961, -1, "" )
S ( 0xC0000359, 193, -1, "" )
S ( 0xC0000397, 317, -1, "" )
S ( STATUS_CANNOT_DELETE, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_TOO_MANY_LUIDS_REQUESTED, 1333, -1, "" )
S ( STATUS_MEMBER_IN_ALIAS, ERROR_MEMBER_IN_ALIAS, -1, "Specified account is already alias member" )
S ( 0xC00002f6, -2146892998, -1, "" )
S ( STATUS_MAPPED_ALIGNMENT, 1132, -1, "" )
S ( STATUS_FLOPPY_VOLUME, 317, -1, "" )
S ( STATUS_WRONG_EFS, ERROR_ACCESS_DENIED, -1, "" )
S ( 0xC0000388, 1265, -1, "" )
S ( 0xC00003f9, 317, -1, "" )
S ( 0xC0000387, -2146435025, -1, "" )
S ( STATUS_PROCESS_IS_TERMINATING, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_DS_OBJ_CLASS_VIOLATION, 8212, -1, "" )
S ( STATUS_PIPE_CONNECTED, 535, -1, "" )
S ( 0xC0000379, 317, -1, "" )
S ( 0xC000038d, 1270, -1, "" )
S ( 0xC00002be, 317, -1, "" )
S ( 0xC00001fb, 317, -1, "" )
S ( 0xC0000346, 317, -1, "" )
S ( 0xC00001c0, 317, -1, "" )
S ( STATUS_TOO_MANY_COMMANDS, 56, -1, "" )
S ( STATUS_DS_CANT_ON_NON_LEAF, 8213, -1, "" )
S ( STATUS_PIPE_LISTENING, 536, -1, "" )
S ( STATUS_DESTINATION_ELEMENT_FULL, 1161, -1, "" )
S ( STATUS_PIPE_BROKEN, 109, -1, "" )
S ( STATUS_DIRECTORY_IS_A_REPARSE_POINT, 161, -1, "" )
S ( 0xC00001b0, 317, -1, "" )
S ( STATUS_EOM_OVERFLOW, 1129, -1, "" )
S ( STATUS_NO_MEDIA_IN_DEVICE, 21, -1, "" )
S ( STATUS_FAIL_CHECK, 87, -1, "" )
S ( STATUS_DFS_UNAVAILABLE, 1201, -1, "" )
S ( 0xC000038c, 1269, -1, "" )
S ( STATUS_TRUSTED_DOMAIN_FAILURE, 1788, -1, "" )
S ( 0xC00003c0, 317, -1, "" )
S ( STATUS_PWD_HISTORY_CONFLICT, 317, -1, "" )
S ( 0xC0000334, 317, -1, "" )
S ( STATUS_BAD_REMOTE_ADAPTER, 60, -1, "" )
S ( STATUS_LOGON_NOT_GRANTED, 1380, -1, "" )
S ( STATUS_FULLSCREEN_MODE, 1007, -1, "" )
S ( 0xC000039e, 317, -1, "" )
S ( STATUS_REMOTE_DISCONNECT, 64, -1, "" )
S ( STATUS_IP_ADDRESS_CONFLICT2, 317, -1, "" )
S ( 0xC00003f5, 317, -1, "" )
S ( STATUS_OPEN_FAILED, 2, -1, "" )
S ( 0xC00003e8, 317, -1, "" )
S ( 0xC000027c, 317, -1, "" )
S ( 0xC000027f, 317, -1, "" )
S ( STATUS_REDIRECTOR_PAUSED, 72, -1, "" )
S ( STATUS_NO_SUCH_USER, 1317, -1, "" )
S ( 0xC00003ff, 317, -1, "" )
S ( 0xC00001ed, 317, -1, "" )
S ( 0xC00003e6, 317, -1, "" )
S ( STATUS_MEMBERS_PRIMARY_GROUP, 1374, -1, "" )
S ( 0xC0000330, 317, -1, "" )
S ( STATUS_INVALID_PARAMETER_9, 87, -1, "" )
S ( STATUS_INFO_LENGTH_MISMATCH, 24, -1, "" )
S ( STATUS_EVALUATION_EXPIRATION, 317, -1, "" )
S ( 0xC0000368, 317, -1, "" )
S ( 0xC0000350, 1256, -1, "" )
S ( STATUS_LINK_TIMEOUT, 59, -1, "" )
S ( 0xC000034e, 317, -1, "" )
S ( STATUS_SYSTEM_PROCESS_TERMINATED, 317, -1, "" )
S ( STATUS_NONEXISTENT_EA_ENTRY, 1392, -1, "" )
S ( STATUS_MESSAGE_NOT_FOUND, 317, -1, "" )
S ( STATUS_FLOPPY_BAD_REGISTERS, 1125, -1, "" )
S ( STATUS_MARSHALL_OVERFLOW, 317, -1, "" )
S ( 0xC000036d, 317, -1, "" )
S ( 0xC00002bb, 317, -1, "" )
S ( 0xC00001ea, 317, -1, "" )
S ( 0xC00003fa, 317, -1, "" )
S ( STATUS_QUOTA_LIST_INCONSISTENT, 317, -1, "" )
S ( STATUS_NO_GUID_TRANSLATION, 317, -1, "" )
S ( 0xC00001e0, 317, -1, "" )
S ( 0xC0000321, 1264, -1, "" )
S ( STATUS_SERIAL_NO_DEVICE_INITED, 1118, -1, "" )
S ( STATUS_UNRECOGNIZED_VOLUME, 1005, -1, "" )
S ( STATUS_NOT_FOUND, 1168, -1, "" )
S ( STATUS_CANT_WAIT, 317, -1, "" )
S ( STATUS_IO_REPARSE_DATA_INVALID, 4392, -1, "" )
S ( STATUS_RANGE_NOT_LOCKED, 158, -1, "" )
S ( STATUS_AUDIT_FAILED, 317, -1, "" )
S ( STATUS_BAD_FUNCTION_TABLE, 317, -1, "" )
S ( STATUS_INVALID_PORT_HANDLE, 6, -1, "" )
S ( 0xC00003fe, 317, -1, "" )
S ( STATUS_BAD_IMPERSONATION_LEVEL, 1346, -1, "" )
S ( STATUS_INVALID_PARAMETER_4, 87, -1, "" )
S ( STATUS_ABIOS_SELECTOR_NOT_AVAILABLE, 317, -1, "" )
S ( 0xC0000352, 6013, -1, "" )
S ( 0xC0000394, 317, -1, "" )
S ( STATUS_BAD_NETWORK_NAME, 67, -1, "" )
S ( 0xC00001ad, 317, -1, "" )
S ( 0xC00001d4, 317, -1, "" )
S ( 0xC00003b5, 317, -1, "" )
S ( 0xC0000375, 317, -1, "" )
S ( 0xC00001dd, 317, -1, "" )
S ( STATUS_ABIOS_NOT_LID_OWNER, 317, -1, "" )
S ( STATUS_NOT_TINY_STREAM, 317, -1, "" )
S ( STATUS_PIPE_BUSY, 231, -1, "" )
S ( STATUS_INVALID_LDT_DESCRIPTOR, 317, -1, "" )
S ( STATUS_NO_SUCH_DOMAIN, 1355, -1, "" )
S ( STATUS_OBJECT_NAME_COLLISION, 80, -1, "" )
S ( 0xC00001a1, 317, -1, "" )
S ( 0xC00001ce, 317, -1, "" )
S ( 0xC00003ce, 317, -1, "" )
S ( STATUS_BAD_VALIDATION_CLASS, 1348, -1, "" )
S ( STATUS_PORT_ALREADY_SET, 87, -1, "" )
S ( STATUS_INVALID_ID_AUTHORITY, 1343, -1, "" )
S ( 0xC000031b, 317, -1, "" )
S ( 0xC00003ad, 317, -1, "" )
S ( STATUS_UNABLE_TO_FREE_VM, 87, -1, "" )
S ( 0xC00003c7, 317, -1, "" )
S ( 0xC00002fe, 1115, -1, "" )
S ( STATUS_CONNECTION_DISCONNECTED, 64, -1, "" )
S ( STATUS_DEBUG_ATTACH_FAILED, 317, -1, "" )
S ( 0xC00003ec, 317, -1, "" )
S ( STATUS_TOO_MANY_GUIDS_REQUESTED, 68, -1, "" )
S ( STATUS_VALIDATE_CONTINUE, 317, -1, "" )
S ( STATUS_INVALID_ACCOUNT_NAME, 1315, -1, "" )
S ( 0xC00002ec, 8561, -1, "" )
S ( 0xC000030c, 317, -1, "" )
S ( 0xC0000354, 317, -1, "" )
S ( STATUS_PWD_TOO_RECENT, 317, -1, "" )
S ( 0xC00001b3, 317, -1, "" )
S ( STATUS_FOUND_OUT_OF_SCOPE, 317, -1, "" )
S ( 0xC00001ca, 317, -1, "" )
S ( STATUS_PRINT_CANCELLED, 63, -1, "" )
S ( STATUS_MORE_PROCESSING_REQUIRED, 58, -1, "" )
S ( STATUS_ALREADY_COMMITTED, ERROR_ACCESS_DENIED, -1, "" )
S ( STATUS_ILL_FORMED_SERVICE_ENTRY, 317, -1, "" )
S ( STATUS_PAGEFILE_QUOTA_EXCEEDED, 317, -1, "" )
S ( 0xC00001d5, 317, -1, "" )
S ( STATUS_ILLEGAL_CHARACTER, 317, -1, "" )
S ( STATUS_FLOAT_DENORMAL_OPERAND, -1073741683, -1, "" )
S ( 0xC000016f, 317, -1, "" )
S ( STATUS_ADDRESS_CLOSED, 64, -1, "" )
S ( STATUS_GROUP_EXISTS, 1318, -1, "" )
S ( STATUS_INVALID_DEVICE_STATE, 22, -1, "" )
S ( STATUS_NOT_SUPPORTED, 50, -1, "" )
S ( 0xC0000377, 317, -1, "" )
S ( STATUS_ADAPTER_HARDWARE_ERROR, 57, -1, "" )
S ( 0xC0000333, 317, -1, "" )
S ( STATUS_ADDRESS_NOT_ASSOCIATED, 1228, -1, "" )
S ( 0xC00001f0, 317, -1, "" )
S ( 0xC000039a, 317, -1, "" )
S ( STATUS_INVALID_SERVER_STATE, 1352, -1, "" )
S ( STATUS_MEDIA_WRITE_PROTECTED, 19, -1, "" )
S ( 0xC00003af, 317, -1, "" )
S ( STATUS_NET_WRITE_FAULT, 88, -1, "" )
S ( STATUS_ABIOS_INVALID_COMMAND, 317, -1, "" )
S ( STATUS_DEVICE_DOES_NOT_EXIST, 55, -1, "" )
S ( STATUS_TRANSACTION_ABORTED, 59, -1, "" )
S ( STATUS_WRONG_PASSWORD, ERROR_INVALID_PARAMETER, EINVAL, "" )
S ( 0xC00003f3, 317, -1, "" )
S ( STATUS_FLOAT_DIVIDE_BY_ZERO, -1073741682, -1, "" )
S ( 0xC00001ab, 317, -1, "" )
S ( 0xC0000366, 317, -1, "" )
S ( 0xC000036c, 1275, -1, "" )
S ( STATUS_CANT_ACCESS_DOMAIN_INFO, 1351, -1, "" )
S ( 0xC00001b1, 317, -1, "" )
S ( 0xC0000000, 317, -1, "" )
S ( STATUS_DEVICE_PROTOCOL_ERROR, 1117, -1, "" )

/* End autogenerated portion */

#undef S
#endif
