/***********************************************************************************

    Copyright (C) 2007-2018 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIALOG_EXPORT_HEADER
#define LIFEOGRAPH_DIALOG_EXPORT_HEADER

// TODO: rename this file to cover all of its current functions


#include <gtkmm.h>

#include "diary.hpp"
#include "dialog_password.hpp"
#include "widget_entrytags.hpp"


namespace LIFEO
{

// FILE SAVE DIALOGS ===============================================================================
class DialogSaveGeneric : public Gtk::FileChooserDialog
{
    public:
                                    DialogSaveGeneric( const Glib::ustring& );
                                    DialogSaveGeneric( BaseObjectType*,
                                                       const Glib::RefPtr< Gtk::Builder >& );

        std::string                 get_filename( const std::string& = "" );
};

class DialogSaveDiary : public DialogSaveGeneric
{
	public:
                                    DialogSaveDiary( BaseObjectType*,
                                                     const Glib::RefPtr< Gtk::Builder >& );

        static int                  launch( std::string&, std::string& );

	protected:
        void                        handle_encryption_toggled();
        void                        handle_password_changed();

        static DialogSaveDiary*     ptr;

        Gtk::Frame*                 m_frame_encrypt;
        Gtk::Grid*                  m_grid_password;
        Gtk::CheckButton*           m_check_encrypt;
        Gtk::Entry*                 m_entry_password;
        Gtk::Entry*                 m_entry_confirm;
};

// FILE OPEN DIALOG ================================================================================
class DialogOpenDiary : public Gtk::FileChooserDialog
{
    public:
        static const int            RESPONSE_READ = 1000;
        static const int            RESPONSE_EDIT = 2000;

                                    DialogOpenDiary();

        // FILTERING
        static void                 init_filters();

        static Glib::RefPtr< Gtk::FileFilter >
                                    filter_any;
        static Glib::RefPtr< Gtk::FileFilter >
                                    filter_diary;

    protected:
        void                        handle_selection_changed();

        static bool                 flag_filters_created;
};

// IMPORT DIALOG ===================================================================================
class DialogImport : public DialogEvent
{
	public:
        DialogImport( BaseObjectType*,
                      const Glib::RefPtr< Gtk::Builder >& );

        void                        on_show();
        void                        on_response( int );

        void                        handle_diary_changed();
        void                        handle_parts_changed();

        void                        set_ready();
        void                        set_not_ready( const Glib::ustring& );

        bool                        is_options_ready();

    private:
        Gtk::FileChooserButton*     m_file_chooser_button;
        Gtk::Label*                 m_label_info;
        Gtk::Label*                 m_label_entries;
        Gtk::Label*                 m_label_tags;
        Gtk::Label*                 m_label_chapters;
        WidgetTagEdit*              m_tag_widget;
        Gtk::Entry*                 m_entry_password;

        Gtk::CheckButton*           m_checkbutton_import_entries;
        Gtk::CheckButton*           m_checkbutton_import_tags;
        Gtk::CheckButton*           m_checkbutton_import_chapters;

        DialogPassword*             m_dialog_password;

        Diary*                      m_diary;

        bool                        m_option_import_entries;
        bool                        m_option_import_tags;
        bool                        m_option_import_chapters;
        bool                        m_flag_diary_is_ready;

};

// EXPORTERS =======================================================================================
class Diarysaver
{
    public:
    typedef sigc::signal< void, bool >
                                    Signal_void_bool;

        virtual Gtk::Widget*        draw_options() = 0;
        virtual bool                is_ready() = 0;
        virtual Result              save( bool ) = 0;

        Glib::ustring               get_name()
        { return m_name; }

        Signal_void_bool            signal_updated()
        { return m_signal_updated; }

    protected:
                                    Diarysaver( const Glib::ustring&, Diary* );
        virtual                     ~Diarysaver() {}

        Glib::ustring               m_name;
        Diary*                      m_ptr2diary;

        Signal_void_bool            m_signal_updated;
};

class ExporterLifeograph : public Diarysaver
{
    public:
        explicit                    ExporterLifeograph( Diary* );
        Gtk::Widget*                draw_options();
        bool                        is_ready();
        Result                      save( bool );

//        void                        handle_passphrase_changed();
//        void                        handle_encryption_changed();

    private:
//        Gtk::CheckButton            *m_check_encrypt;
//        Gtk::Entry                  *m_entry_passphrase;
//        Gtk::Entry                  *m_entry_confirm;
//        std::string                 m_passphrase;

        bool                        m_flag_encrypted{ false };
};

class ExporterText : public Diarysaver
{
    public:
        explicit                    ExporterText( Diary* );
        Gtk::Widget*                draw_options()
        { return NULL; }

        bool                        is_ready()
        { return true; }

        Result                      save( bool );
};

// EXPORT DIALOG ===================================================================================
class DialogExport : public DialogEvent
{
    public:
                                    DialogExport( BaseObjectType*,
                                                  const Glib::RefPtr< Gtk::Builder >& );

        void                        add_saver( Diarysaver* );

    protected:
        virtual void                on_response( int );

        void                        handle_savetype_changed();
        void                        handle_saver_updated( bool );

        Gtk::ComboBoxText*          m_combo_type;
        Gtk::ComboBoxText*          m_combo_extent;
        Gtk::Button*                m_button_export;
        Gtk::Alignment*             m_align_options;
        Gtk::Frame*                 m_frame_options;
        Gtk::Widget*                m_ptr2widget_options;

        std::vector< Diarysaver* >  m_savers;
        Diarysaver*                 m_saver_cur;

        Diary*                      m_ptr2diary;
        bool                        m_flag_saverready;

    private:

};

} // end of namespace LIFEO

#endif
