#    Copyright (C) 2013 Ahmet Öztürk (aoz_2@yahoo.com)
#
#    This file is part of Lifeograph.
#
#    Lifeograph is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    Lifeograph is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.


include( ${CMAKE_SOURCE_DIR}/cmake/definitions.cmake )

# UNINSTALL FILE FUNCTION
function( UNINSTALL arg1 )
	message( STATUS "Uninstalling file \"${arg1}\"")
	if( EXISTS "${arg1}" )
		execute_process(
		    COMMAND ${CMAKE_COMMAND} -E remove "${arg1}"
		    OUTPUT_VARIABLE rm_out
		    RESULT_VARIABLE rm_retval )
		if( NOT ${rm_retval} EQUAL 0 )
		    message( FATAL_ERROR "Problem when removing \"${arg1}\"" )
		endif( NOT ${rm_retval} EQUAL 0 )
	else( EXISTS "${arg1}" )
		message( STATUS "File \"${arg1}\" does not exist." )
	endif( EXISTS "${arg1}" )
endfunction( UNINSTALL )

# UNINSTALL DIR FUNCTION
function( UNINSTALL_DIR arg1 )
	message( STATUS "Uninstalling directory \"${arg1}\"")
	if( EXISTS "${arg1}")
		execute_process(
		    COMMAND ${CMAKE_COMMAND} -E remove_directory "${arg1}"
		    OUTPUT_VARIABLE rm_out
		    RESULT_VARIABLE rm_retval )
		if( NOT ${rm_retval} EQUAL 0 )
		    message( FATAL_ERROR "Problem when removing \"${arg1}\"")
		endif( NOT ${rm_retval} EQUAL 0 )
	else( EXISTS "${arg1}" )
		message( STATUS "Folder \"${arg1}\" does not exist." )
	endif( EXISTS "${arg1}" )
endfunction( UNINSTALL_DIR )

# FILES
UNINSTALL( "${DESTDIR}/bin/${PACKAGE_NAME}" )

UNINSTALL( "${DESTDIR}/share/appdata/lifeograph.appdata.xml" )

UNINSTALL( "${DESTDIR}/share/pixmaps/lifeograph.png" )
UNINSTALL( "${DESTDIR}/share/icons/hicolor/48x48/apps/lifeograph.png" )
UNINSTALL( "${DESTDIR}/share/icons/hicolor/32x32/apps/lifeograph.png" )
UNINSTALL( "${DESTDIR}/share/icons/hicolor/24x24/apps/lifeograph.png" )
UNINSTALL( "${DESTDIR}/share/icons/hicolor/22x22/apps/lifeograph.png" )
UNINSTALL( "${DESTDIR}/share/icons/hicolor/16x16/apps/lifeograph.png" )
UNINSTALL( "${DESTDIR}/share/icons/hicolor/scalable/apps/lifeograph.svg" )

UNINSTALL_DIR( "${DESTDIR}/share/${PACKAGE_NAME}" )

# TRANSLATIONS
file( GLOB po_files ${po_dir}/*.po )
foreach( po_file ${po_files} )
    get_filename_component( lang ${po_file} NAME_WE )
    UNINSTALL( "${DESTDIR}/share/locale/${lang}/LC_MESSAGES/${PACKAGE_NAME}.mo" )
endforeach()

# XDG
find_program( XDG-MIME_EXE xdg-mime )
find_program( XDG-DESKTOP-MENU_EXE xdg-desktop-menu )
find_program( XDG-ICON_RES_EXE xdg-icon-resource )

execute_process( COMMAND ${XDG-MIME_EXE} uninstall ${CMAKE_SOURCE_DIR}/lifeograph.xml )
execute_process( COMMAND ${XDG-ICON_RES_EXE} uninstall --context mimetypes
                 --size 16 application-x-lifeographdiary )
execute_process( COMMAND ${XDG-ICON_RES_EXE} uninstall --context mimetypes
                 --size 32 application-x-lifeographdiary )
execute_process( COMMAND ${XDG-ICON_RES_EXE} uninstall --context mimetypes
                 --size 48 application-x-lifeographdiary )
execute_process( COMMAND ${XDG-ICON_RES_EXE} uninstall --context mimetypes
                 --size 64 application-x-lifeographdiary )
execute_process( COMMAND ${XDG-ICON_RES_EXE} uninstall --context mimetypes
                 --size 128 application-x-lifeographdiary )
execute_process( COMMAND ${XDG-DESKTOP-MENU_EXE} uninstall
                 ${CMAKE_SOURCE_DIR}/lifeograph.desktop )

