#    Copyright (C) 2013 Ahmet Öztürk (aoz_2@yahoo.com)
#
#    This file is part of Lifeograph.
#
#    Lifeograph is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    Lifeograph is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.


set( PACKAGE_NAME lifeograph )
set( Lifeograph_VERSION_MAJOR 1 )
set( Lifeograph_VERSION_MINOR 0 )

set( BUILD_DIR ${CMAKE_SOURCE_DIR}/build/bin )
set( MO_DIR ${CMAKE_SOURCE_DIR}/build/mo )
set( LOCAL_INCL_DIR ${CMAKE_SOURCE_DIR}/build/include )

# config.h DEFINITIONS
set( LOCALEDIR "${CMAKE_INSTALL_PREFIX}/share/locale" )
set( PIXMAPDIR "${CMAKE_INSTALL_PREFIX}/share/pixmaps" )
set( ICONDIR "${CMAKE_INSTALL_PREFIX}/share/${PACKAGE_NAME}/icons" )
set( UIDIR "${CMAKE_INSTALL_PREFIX}/share/${PACKAGE_NAME}/ui" )
set( DIARYDIR "${CMAKE_INSTALL_PREFIX}/share/${PACKAGE_NAME}/diaries" )

set( po_dir ${CMAKE_SOURCE_DIR}/po )
set( pot_file ${po_dir}/${PACKAGE_NAME}.pot )

set( desktop_file ${CMAKE_SOURCE_DIR}/${PACKAGE_NAME}.desktop )

set( SOURCE_FILES
     src/app_window.cpp src/dialog_export.cpp src/dialog_password.cpp
     src/dialog_preferences.cpp src/diary.cpp src/diarydata.cpp src/entry.cpp
     src/entry_parser.cpp src/helpers.cpp src/lifeograph.cpp src/main.cpp src/panel_diary.cpp
     src/panel_extra.cpp src/panel_main.cpp src/printing.cpp src/settings.cpp src/undo.cpp
     src/view_entry.cpp src/view_login.cpp src/views.cpp src/widget_chart.cpp
     src/widget_entrylist.cpp src/widget_tag_list.cpp src/widget_textview.cpp )
