/***********************************************************************************

    Copyright (C) 2007-2012 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_VIEW_LOGIN_HEADER
#define LIFEOGRAPH_VIEW_LOGIN_HEADER


namespace LIFEO
{

namespace STRING
{
const char      ENTER_PASSWORD[]
                            = N_( "Please enter password for selected diary..." );

const char      ENTER_PASSWORD_TIMEOUT[]
                            = N_( "Program logged out to protect your privacy. "
                                  "Please re-enter password..." );

const char      INCOMPATIBLE_DIARY[]
                            = N_( "Selected diary is not compatible with "
                                  "this version of Lifeograph. "
                                  "Please select another file..." );

const char      CORRUPT_DIARY[]
                            = N_( "Selected file is not a valid "
                                  "Lifeograph diary. "
                                  "Please select another file..." );

const char      DIARY_NOT_FOUND[]
                            = N_( "Selected file is not found. "
                                  "Please select another file..." );

const char      DIARY_NOT_READABLE[]
                            = N_( "Selected file is not readable. "
                                  "Please check file permissions or select another file..." );

const char      DIARY_LOCKED[]
                            = N_( "Selected file is locked which means either it is "
                                  "being edited by another instance of Lifeograph or "
                                  "the last session with it did not finish correctly. "
                                  "This file cannot be opened as long as the lock file (%1) "
                                  "is there." );

const char      UPGRADE_DIARY_CONFIRM[]
                            = N_( "You are about to open an old diary that "
                                  "has to be upgraded to the new format. \n\n"
                                  "It is STRONGLY recommended to back up any diary "
                                  "before upgrading.\n\n"
                                  "After you upgrade a diary, you won't be able to open it "
                                  "in a previous version of Lifeograph." );

const char      FAILED_TO_OPEN_DIARY[]
                            = N_( "Failed to open diary. "
                                  "Please select another file..." );

const char      DIARY_IS_NOT_ENCRYPTED[]
                            = N_( "Press Open to continue" );

const char      COLHEAD_BY_LAST_ACCESS[]
                            = N_( "Last Read" );
const char      COLHEAD_BY_LAST_SAVE[]
                            = N_( "Last Saved" );
}

class ViewLogin
{
        enum InfoResponse { RESP_OK = 10, RESP_UNDO = 20 };
        enum SortDateType { SDT_ACCESS, SDT_SAVE };

    public:
        class Colrec : public Gtk::TreeModel::ColumnRecord
        {
            public:
                Colrec()
                {
                    //add( icon );
                    add( name );
                    add( date );
                    add( path );
                }
                //Gtk::TreeModelColumn< Glib::RefPtr< Gdk::Pixbuf > >     icon;
                Gtk::TreeModelColumn< Glib::ustring >                   name;
                Gtk::TreeModelColumn< Glib::ustring >                   date;
                Gtk::TreeModelColumn< std::string >                     path;
        };
        static Colrec               *colrec;

                                    ViewLogin( void );

        void                        handle_start( void );
        void                        handle_logout( void );

        void                        populate_diaries( void );
        void                        sort_by_date( void );
        void                        sort_by_name( void );

        static std::string          m_path_cur;

    protected:
        // these two functions are to mask bool return type of open_selected_diary()
        // from signal connection system
        void                        handle_button_read( void )
        { open_selected_diary( true ); }
        void                        handle_button_edit( void )
        { open_selected_diary( false ); }
        Result                      open_selected_diary( bool );
        void                        open_activated_diary( void );
        void                        remove_selected_diary( void );

        void                        create_new_diary( void );
        void                        add_existing_diary( void );

        void                        show_info( Gtk::MessageType, const Glib::ustring&,
                                               const Glib::ustring& =  _( "OK" ),
                                               InfoResponse = RESP_OK );
        void                        handle_infobar_response( int );
        void                        hide_infobar( void );

        void                        handle_diary_selection_changed( void );
        void                        handle_diary_activated( const Gtk::TreePath&,
                                                            Gtk::TreeView::Column* );
        void                        handle_button_release( GdkEventButton* );
        void                        handle_key_release( GdkEventKey* );
        bool                        handle_diary_tooltip( int, int, bool,
                                                          const Glib::RefPtr<Gtk::Tooltip>& );

        void                        handle_dragged_file( const Glib::RefPtr<Gdk::DragContext>&,
                                                         int, int,
                                                         const Gtk::SelectionData&,
                                                         guint, guint );

        Gtk::TreeView               *m_treeview_diaries;
        Glib::RefPtr< Gtk::ListStore >
                                    m_treestore_diaries;
        Glib::RefPtr< Gtk::TreeSelection >
                                    m_treesel_diaries;

        Gtk::Grid                   *m_grid_login;
        Gtk::InfoBar                *m_infobar;
        Gtk::Label                  *m_label_info;
        Gtk::Button                 *m_button_info;
        Gtk::Button                 *m_button_edit_diary;
        Gtk::Button                 *m_button_read_diary;
        Gtk::Button                 *m_button_remove_diary;

        std::string                 m_path_removed;
        bool                        m_flag_info_is_visible;
        bool                        m_flag_diary_activated;
        int                         m_password_attempt_no;
        InfoResponse                m_resp_cur; // FIXME: a most unfortunate solution!!
        SortDateType                m_sort_date_type;
};

} // end of namespace LIFEO

#endif
