/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "lifeobase.hpp"
#include "widget_panel_exp.hpp"


using namespace LIFEO;


WidgetPanelExp::WidgetPanelExp( void )
:	m_flag_dragging( false ), m_theme_dragged( NULL )
{
	Gtk::CellRendererPixbuf *cellrenderer_icon( NULL );
	Gtk::CellRendererText *cellrenderer_name( NULL );
	Gtk::TreeView::Column *column_name_theme( NULL );

	try
	{
		Lifeobase::builder->get_widget( "expander_tags", m_expander_tags );
		Lifeobase::builder->get_widget( "expander_themes", m_expander_themes );
		Lifeobase::builder->get_widget( "scrolledwindow_all_tags", m_widget_tags );
		Lifeobase::builder->get_widget( "scrolledwindow_themes", m_widget_themes );
		Lifeobase::builder->get_widget( "arrow_tags", m_arrow_tags );
		Lifeobase::builder->get_widget( "arrow_themes", m_arrow_themes );

		Lifeobase::builder->get_widget( "treeview_themes", m_treeview_themes );

		cellrenderer_icon = Gtk::manage( new Gtk::CellRendererPixbuf );
		cellrenderer_name = Gtk::manage( new Gtk::CellRendererText );
		column_name_theme = Gtk::manage( new Gtk::TreeView::Column( "" ) );
	}
	catch( ... ) {} // TODO

	m_cur_widget = m_widget_tags;

	cellrenderer_name->property_ellipsize() = Pango::ELLIPSIZE_END;
	cellrenderer_name->property_scale() = .90;
	column_name_theme->pack_start( *cellrenderer_icon, Gtk::PACK_SHRINK );
	column_name_theme->pack_start( *cellrenderer_name );
	column_name_theme->add_attribute( cellrenderer_icon->property_pixbuf(),
							colrec_theme.m_icon );
	column_name_theme->add_attribute( cellrenderer_name->property_markup(),
							colrec_theme.m_name );

	m_liststore_themes = Gtk::ListStore::create( colrec_theme );

	// THEME LIST
	m_treeview_themes->set_model( m_liststore_themes );
	m_treeview_themes->append_column( *column_name_theme );
	m_treeview_themes->enable_model_drag_source( Lifeobase::base->drag_targets_theme );
	m_treeview_themes->override_background_color(
            Lifeobase::base->get_style_context()->get_background_color( Gtk::STATE_FLAG_NORMAL ),
            Gtk::STATE_FLAG_NORMAL );

	// SIGNALS
	//m_treeview_themes->signal_row_activated().connect(
			//sigc::mem_fun( *this, &WidgetPanelExp::handle_treeview_current_row_activated ) );

	m_treeview_themes->signal_button_press_event().connect_notify(
			sigc::mem_fun( *this, &WidgetPanelExp::handle_button_press_themes ) );

	m_treeview_themes->signal_button_release_event().connect_notify(
			sigc::mem_fun( *this, &WidgetPanelExp::handle_button_release_themes ) );

	m_treeview_themes->signal_drag_begin().connect_notify(
			sigc::mem_fun( *this, &WidgetPanelExp::handle_drag_begin ) );

	m_treeview_themes->signal_drag_data_get().connect_notify(
			sigc::mem_fun( *this, &WidgetPanelExp::handle_drag_data_get ) );

	m_expander_tags->signal_clicked().connect(
		sigc::bind( sigc::mem_fun( this, &WidgetPanelExp::show_widget ),
					m_widget_tags,
					m_arrow_tags ) );

	m_expander_themes->signal_clicked().connect(
		sigc::bind( sigc::mem_fun( this, &WidgetPanelExp::show_widget ),
					m_widget_themes,
					m_arrow_themes ) );
}

void
WidgetPanelExp::show_widget( Gtk::Widget *widget, Gtk::Arrow *arrow )
{
	if( widget->get_visible() )
	{
		widget->set_visible( false );
		arrow->property_arrow_type() = Gtk::ARROW_RIGHT;
	}
	else
	{
		widget->set_visible( true );
		arrow->property_arrow_type() = Gtk::ARROW_DOWN;
	}
}

void
WidgetPanelExp::populate_themes( void )
{
	m_liststore_themes->clear();

	for( PoolThemes::const_iterator iter = Diary::d->get_themes().begin();
		 iter != Diary::d->get_themes().end();
		 ++iter )
	{
	    add_theme_to_list( iter->second );
	}

    // system theme added back to m_themes:
    //add_theme_to_list( ThemeSystem::get() );
}

inline void
WidgetPanelExp::add_theme_to_list( Theme *theme )
{
    Gtk::TreeRow row = * m_liststore_themes->append();
    row[ colrec_theme.m_ptr ] = theme;
    row[ colrec_theme.m_name ] =
            theme == Diary::d->get_default_theme() ?
                    Glib::ustring::compose( "<b>%1</b>", theme->get_list_str() ) :
                    theme->get_list_str();
    //row[ colrec_theme.m_icon ] = Lifeobase::icons->theme_16;
}

void
WidgetPanelExp::handle_drag_begin( const Glib::RefPtr< Gdk::DragContext >& )
{
	m_flag_dragging = true;
	m_treeview_themes->get_selection()->unselect_all();
}

void
WidgetPanelExp::handle_drag_data_get( const Glib::RefPtr<Gdk::DragContext> &context,
									  Gtk::SelectionData &data,
									  guint info, guint time )
{
	if( m_theme_dragged )
		data.set( TARGET_ENTRY_THEME, m_theme_dragged->get_name() );
	else	// should never be the case
	{
		data.set( "N/A", "" );
		PRINT_DEBUG( "Nothing is selected at the drag source" );
	}
}

void
WidgetPanelExp::handle_button_press_themes( GdkEventButton *event )
{
	m_flag_dragging = false;

	Gtk::TreePath path;
	if( m_treeview_themes->get_path_at_pos( event->x, event->y, path ) )
	{
		Gtk::TreeRow row = * m_liststore_themes->get_iter( path );
		m_theme_dragged = row[ colrec_theme.m_ptr ];
	}
	else
		m_theme_dragged = NULL;
}

void
WidgetPanelExp::handle_button_release_themes( GdkEventButton *event )
{
	if( m_flag_dragging || event->button != 1 )
		return;

	Glib::RefPtr< Gtk::TreeSelection > selection = m_treeview_themes->get_selection();
	if( selection->count_selected_rows() > 0 )
	{
		Gtk::TreeRow row = ( *selection->get_selected() );
		Theme *theme = row[ colrec_theme.m_ptr ];
		if( theme )
			theme->show();
	}
	selection->unselect_all();
}
