/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_LISTITEMDIARY_HEADER
#define LIFEOGRAPH_LISTITEMDIARY_HEADER


#include "helpers.hpp"	// i18n headers
#include "entry.hpp"
#include "diary.hpp"
#include "views.hpp"
#include "widget_textview.hpp"


namespace LIFEO
{

class EntryView : public ElementShower< Entry >
{
    public:
								EntryView( void );

		void					sync( void );

		void					focus_tag( void );
		//bool					handle_hboxtagtools_enternotify( GdkEventCrossing * );

        Glib::ustring           get_title_str( void ) const
        {
            if( m_ptr2entry->get_date().is_ordinal() )
                return Glib::ustring::compose( "%1: %2",
                                               m_ptr2entry->get_date().format_string(),
                                               m_ptr2entry->m_name );
            else
                return Glib::ustring::compose( "%1, %2",
                                               m_ptr2entry->get_date().format_string(),
                                               m_ptr2entry->get_date().get_weekday_str() );
        }
        Glib::ustring           get_info_str( void ) const
        { return Glib::ustring::compose( "Entry last changed on %1",
                Date::format_string_do( m_ptr2entry->m_date_changed ) ); }
        Glib::ustring           get_tip_str( void ) const
        {
            return Glib::ustring::compose( "%1: <b>%2</b>\n%3: <b>%4</b>\nDEID:%5",
                    // TRANSLATORS: label of creation date
                    _( "Created"), m_ptr2entry->get_date_created_str(),
                    // TRANSLATORS: label of last change date
                    _( "Changed"), m_ptr2entry->get_date_changed_str(),
                    m_ptr2entry->get_id() );
        }

        bool                    is_title_editable( void ) const
        { return( ! m_ptr2entry->get_date().is_ordinal() ); }
        Glib::ustring           get_title_edit_str( void ) const
        { return( m_ptr2entry->get_date().format_string() ); }
        bool                    check_title_applicable( const Glib::ustring& ) const;
        bool                    apply_title( const Glib::ustring& );

		void					show( Entry& );

		Glib::RefPtr< Gdk::Pixbuf >&
		                        get_icon_32( void ) const;

        DiaryElement*           get_element( void )
        { return m_ptr2entry; }

		void					prepare_for_hiding( Entry& );
		void					update_formatting_toolbar( void );

		void					update_highlight_button( void );
        void                    toggle_comments( void );

	protected:
		enum TagOperation { TO_NONE, TO_ADD, TO_REMOVE, TO_CREATE_AND_ADD };

		void					populate_tags( void );
		void					remove_selected_tags( void );
		void					dismiss_entry( void );
		void                    print( void );
		void					toggle_favoredness( void );
		void					reset_theme( void );
        void                    hide( void );
        void                    hide_before( void );
        void                    hide_after( void );
        void                    handle_comments_toggled( void );

		void					handle_login( void );
		void					handle_textview_changed( void );
		void					handle_entry_tag_changed( void );
		void					handle_button_tag_clicked( void );
		void					handle_treeviewtags_buttonpress( GdkEventButton* );
		void					handle_drag_data_received(
										const Glib::RefPtr< Gdk::DragContext >&,
										int, int,
										const Gtk::SelectionData&,
										uint,
										guint );

		void					handle_iconview_tags_key_release( GdkEventKey* );
		void					handle_iconview_tags_button_press( GdkEventButton* );

		// WIDGETS
		Gtk::Button             *m_button_print;
		Gtk::ToggleButton		*m_button_toggle_favorite;
		Gtk::Button				*m_button_dismiss;
		Gtk::Button				*m_button_reset_theme;

		Gtk::Button				*m_button_bold;
		Gtk::Button				*m_button_italic;
		Gtk::Button				*m_button_strikethrough;
		Gtk::Button				*m_button_highlight;
		Gtk::Label				*m_label_highlight;
		Gtk::EventBox			*m_eventbox_highlight;		// necessary to change bg color!!
		Gtk::Button				*m_button_add_bullet;
		Gtk::Button				*m_button_add_checkbox;
        Gtk::ToggleButton       *m_button_toggle_comments;

		TextviewDiary			*m_textviewdiary;
		TagWidget				*m_tag_widget;
		Gtk::Button				*m_button_tag_operation;
		Gtk::Menu				*m_menu_tag;
		Gtk::IconView			*m_iconview_tags;
        Gtk::Box                *m_hbox_editing_toolbar;
		TagOperation			m_tag_operation_cur;

		Glib::RefPtr< Gtk::ListStore >
								m_liststore_tags;

		Entry					*m_ptr2entry;
		Entry                   *m_entry_sync;

		bool					m_flag_entrychanged;

	friend class Lifeograph;
};

} // end of namespace LIFEO

#endif
