/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_PANEL_MAIN_HEADER
#define LIFEOGRAPH_PANEL_MAIN_HEADER


#include <gtkmm.h>

#include "diarydata.hpp"


namespace LIFEO
{

static const int		BROWSING_HISTORY_SIZE = 5;


class PanelMain
{
	private:
		typedef DiaryElement* PtrDiaryElement;

	public:
								PanelMain( void );

        bool                    is_cur_elem( DiaryElement *elem )
        { return( elem == get_cur_elem() ); }

		void					show( ElementShowerProto* );
	
		void					go_back( void );
		//void					go_forward( void );

		void					remove_element_from_history( DiaryElement* );
		void					clear_history( void );

		PtrDiaryElement			get_cur_elem( void )
		{ return( m_browsing_history[ m_bhist_index ] ); }
		DiaryElement::Type		get_cur_elem_type( void )
		{
			return( m_browsing_history[ m_bhist_index ] == NULL ?
					DiaryElement::ET_NONE : m_browsing_history[ m_bhist_index ]->get_type() );
		}

        void                    set_icon( const Glib::RefPtr< Gdk::Pixbuf > icon )
        {
            m_image_gui_elem->set( icon );
        }
        void                    set_gelem_toolbar( Gtk::Widget* );

        void                    start_title_edit( void );
        void                    apply_title_edit( void );
        // for entries whose title is partly defined by contents of entry text editor:
        void                    handle_title_changed_outside( void )
        {
            m_label_gui_elem->set_text( m_cur_shower->get_title_str() );
        }

        bool                    handle_entry_title_focus_out( GdkEventFocus* );
        void                    handle_entry_title_changed( void );
        bool                    handle_entry_title_key_press( GdkEventKey* );
        void                    handle_entry_icon_release( Gtk::EntryIconPosition,
                                                           const GdkEventButton* );
        bool                    handle_title_click( GdkEventButton* );
        bool                    handle_title_hover( GdkEventCrossing* );
        bool                    handle_title_hover_out( GdkEventCrossing* );

		PtrDiaryElement			m_browsing_history[ BROWSING_HISTORY_SIZE ];
		unsigned int			m_bhist_index;	// browsing history index

		ElementShowerProto      *m_cur_shower;

		Gtk::Widget				*m_ptr2widget;
        Gtk::Box                *m_vbox_content;

        Gtk::Label              *m_label_gui_elem;
        Gtk::Label              *m_label_gelem_extra;
        Gtk::EventBox           *m_eventbox_gelem_title;
        Gtk::Entry              *m_entry_gelem_title;
        Gtk::Button             *m_button_gui_elem;
        Gtk::Image              *m_image_gui_elem;
        Gtk::Alignment          *m_align_gelem_toolbar;
        Gtk::Alignment          *m_align_gelem_title;
        Gtk::Widget             *m_current_gelem_toolbar;

        Glib::RefPtr< Gtk::Action > m_action_previous_browsing;

        bool                    m_flag_index_locked;
        bool                    m_flag_title_edit_in_progress;
        bool                    m_flag_title_editable;
        bool                    m_flag_title_applicable;
};


} // end of namespace LIFEO

#endif
